/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.filter.convolve;

import boofcv.abst.filter.convolve.ImageConvolveSparse;
import boofcv.alg.filter.convolve.ConvolveWithBorderSparse;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.core.image.border.ImageBorder_F32;
import boofcv.core.image.border.ImageBorder_S32;
import boofcv.struct.convolve.Kernel1D;
import boofcv.struct.convolve.Kernel1D_F32;
import boofcv.struct.convolve.Kernel1D_I32;
import boofcv.struct.convolve.Kernel2D;
import boofcv.struct.convolve.Kernel2D_F32;
import boofcv.struct.convolve.Kernel2D_I32;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageInteger;
import boofcv.struct.image.ImageSingleBand;

public class FactoryConvolveSparse {
    public static <T extends ImageSingleBand, K extends Kernel2D> ImageConvolveSparse<T, K> convolve2D(Class<T> imageType, K kernel) {
        if (GeneralizedImageOps.isFloatingPoint(imageType)) {
            return new Convolve2D_F32((Kernel2D_F32)kernel);
        }
        return new Convolve2D_I32((Kernel2D_I32)kernel);
    }

    public static <T extends ImageSingleBand, K extends Kernel1D> ImageConvolveSparse<T, K> vertical1D(Class<T> imageType, K kernel) {
        if (GeneralizedImageOps.isFloatingPoint(imageType)) {
            return new Vertical1D_F32((Kernel1D_F32)kernel);
        }
        return new Vertical1D_I32((Kernel1D_I32)kernel);
    }

    public static <T extends ImageSingleBand, K extends Kernel1D> ImageConvolveSparse<T, K> horizontal1D(Class<T> imageType, K kernel) {
        if (GeneralizedImageOps.isFloatingPoint(imageType)) {
            return new Horizontal1D_F32((Kernel1D_F32)kernel);
        }
        return new Horizontal1D_I32((Kernel1D_I32)kernel);
    }

    public static class Vertical1D_I32
    extends ImageConvolveSparse<ImageFloat32, Kernel1D_I32> {
        public Vertical1D_I32(Kernel1D_I32 kernel) {
            super(kernel);
        }

        @Override
        public double compute(int x, int y) {
            return ConvolveWithBorderSparse.vertical((Kernel1D_I32)this.kernel, (ImageBorder_S32)this.image, x, y);
        }
    }

    public static class Vertical1D_F32
    extends ImageConvolveSparse<ImageFloat32, Kernel1D_F32> {
        public Vertical1D_F32(Kernel1D_F32 kernel) {
            super(kernel);
        }

        @Override
        public double compute(int x, int y) {
            return ConvolveWithBorderSparse.vertical((Kernel1D_F32)this.kernel, (ImageBorder_F32)this.image, x, y);
        }
    }

    public static class Horizontal1D_I32
    extends ImageConvolveSparse<ImageFloat32, Kernel1D_I32> {
        public Horizontal1D_I32(Kernel1D_I32 kernel) {
            super(kernel);
        }

        @Override
        public double compute(int x, int y) {
            return ConvolveWithBorderSparse.horizontal((Kernel1D_I32)this.kernel, (ImageBorder_S32)this.image, x, y);
        }
    }

    public static class Horizontal1D_F32
    extends ImageConvolveSparse<ImageFloat32, Kernel1D_F32> {
        public Horizontal1D_F32(Kernel1D_F32 kernel) {
            super(kernel);
        }

        @Override
        public double compute(int x, int y) {
            return ConvolveWithBorderSparse.horizontal((Kernel1D_F32)this.kernel, (ImageBorder_F32)this.image, x, y);
        }
    }

    public static class Convolve2D_I32
    extends ImageConvolveSparse<ImageInteger, Kernel2D_I32> {
        public Convolve2D_I32(Kernel2D_I32 kernel) {
            super(kernel);
        }

        @Override
        public double compute(int x, int y) {
            return ConvolveWithBorderSparse.convolve((Kernel2D_I32)this.kernel, (ImageBorder_S32)this.image, x, y);
        }
    }

    public static class Convolve2D_F32
    extends ImageConvolveSparse<ImageFloat32, Kernel2D_F32> {
        public Convolve2D_F32(Kernel2D_F32 kernel) {
            super(kernel);
        }

        @Override
        public double compute(int x, int y) {
            return ConvolveWithBorderSparse.convolve((Kernel2D_F32)this.kernel, (ImageBorder_F32)this.image, x, y);
        }
    }
}

