/*
 * Copyright (c) 2011-2015, Peter Abeles. All Rights Reserved.
 *
 * This file is part of BoofCV (http://boofcv.org).
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package boofcv.alg.transform.pyramid.impl;

import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageUInt8;

/**
 * <p>
 * Image type specific implementations of functions in {@link boofcv.alg.transform.pyramid.PyramidOps}.
 * </p>
 *
 * <p>
 * WARNING: Do not modify.  Automatically generated by {@link boofcv.alg.transform.pyramid.impl.GenerateImplPyramidOps}.
 * </p>
 *
 * @author Peter Abeles
 */
public class ImplPyramidOps {

	/**
	 * Scales an image up using interpolation
	 */
	public static void scaleImageUp(ImageFloat32 input , ImageFloat32 output , int scale ,
					  InterpolatePixelS<ImageFloat32> interp ) {
		output.reshape(input.width*scale,input.height*scale);

		float fdiv = 1/(float)scale;
		interp.setImage(input);

		for (int y = 0; y < output.height; y++) {
			float inputY = y*fdiv;
			int indexOutput = output.getIndex(0,y);

			for (int x = 0; x < output.width; x++) {
				float inputX = x*fdiv;

				output.data[indexOutput++] = interp.get(inputX,inputY);
			}
		}
	}

	/**
	 * Scales down the input by a factor of 2.  Every other pixel along both axises is skipped.
	 */
	public static void scaleDown2( ImageFloat32 input , ImageFloat32 output ) {
		
		output.reshape(input.width / 2, input.height / 2);

		for (int y = 0; y < output.height; y++) {
			int indexInput = 2*y*input.stride;
			int indexOutput = y*output.stride;
			for (int x = 0; x < output.width; x++,indexInput+=2) {
				output.data[indexOutput++] = input.data[indexInput];
			}
		}
	}

	/**
	 * Scales an image up using interpolation
	 */
	public static void scaleImageUp(ImageUInt8 input , ImageUInt8 output , int scale ,
					  InterpolatePixelS<ImageUInt8> interp ) {
		output.reshape(input.width*scale,input.height*scale);

		float fdiv = 1/(float)scale;
		interp.setImage(input);

		for (int y = 0; y < output.height; y++) {
			float inputY = y*fdiv;
			int indexOutput = output.getIndex(0,y);

			for (int x = 0; x < output.width; x++) {
				float inputX = x*fdiv;

				output.data[indexOutput++] = (byte)interp.get(inputX,inputY);
			}
		}
	}

	/**
	 * Scales down the input by a factor of 2.  Every other pixel along both axises is skipped.
	 */
	public static void scaleDown2( ImageUInt8 input , ImageUInt8 output ) {
		
		output.reshape(input.width / 2, input.height / 2);

		for (int y = 0; y < output.height; y++) {
			int indexInput = 2*y*input.stride;
			int indexOutput = y*output.stride;
			for (int x = 0; x < output.width; x++,indexInput+=2) {
				output.data[indexOutput++] = input.data[indexInput];
			}
		}
	}


}
