/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.filter.binary;

import boofcv.abst.filter.binary.InputToBinary;
import boofcv.alg.filter.binary.GThresholdImageOps;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.ImageUInt8;

public class LocalSquareBinaryFilter<T extends ImageSingleBand>
implements InputToBinary<T> {
    ImageType<T> inputType;
    T work1;
    ImageSingleBand work2;
    int radius;
    double scale;
    boolean down;

    public LocalSquareBinaryFilter(int radius, double scale, boolean down, ImageType<T> inputType) {
        this.radius = radius;
        this.scale = scale;
        this.down = down;
        this.inputType = inputType;
        this.work1 = (ImageSingleBand)inputType.createImage(1, 1);
        this.work2 = (ImageSingleBand)inputType.createImage(1, 1);
    }

    @Override
    public void process(T input, ImageUInt8 output) {
        ((ImageSingleBand)this.work1).reshape(((ImageSingleBand)input).width, ((ImageSingleBand)input).height);
        this.work2.reshape(((ImageSingleBand)input).width, ((ImageSingleBand)input).height);
        GThresholdImageOps.localSquare(input, output, this.radius, this.scale, this.down, this.work1, this.work2);
    }

    @Override
    public int getHorizontalBorder() {
        return 0;
    }

    @Override
    public int getVerticalBorder() {
        return 0;
    }

    @Override
    public ImageType<T> getInputType() {
        return this.inputType;
    }

    @Override
    public ImageType<ImageUInt8> getOutputType() {
        return ImageType.single(ImageUInt8.class);
    }
}

