/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.filter.derivative;

import boofcv.abst.filter.convolve.ConvolveInterface;
import boofcv.alg.filter.kernel.GKernelMath;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.core.image.border.BorderType;
import boofcv.factory.filter.convolve.FactoryConvolve;
import boofcv.struct.BoofDefaults;
import boofcv.struct.convolve.Kernel1D;
import boofcv.struct.convolve.Kernel2D;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageSingleBand;

public class AnyImageDerivative<I extends ImageSingleBand, D extends ImageSingleBand> {
    private ConvolveInterface<I, D> derivX;
    private ConvolveInterface<I, D> derivY;
    private ConvolveInterface<D, D> derivDerivX;
    private ConvolveInterface<D, D> derivDerivY;
    private BorderType borderDeriv = BoofDefaults.DERIV_BORDER_TYPE;
    private I inputImage;
    private D[][] derivatives;
    private boolean[][] stale;
    private Class<D> derivType;

    public AnyImageDerivative(Kernel1D deriv, Class<I> inputType, Class<D> derivType) {
        this.derivType = derivType;
        this.derivX = FactoryConvolve.convolve(deriv, inputType, derivType, this.borderDeriv, true);
        this.derivY = FactoryConvolve.convolve(deriv, inputType, derivType, this.borderDeriv, false);
        this.derivDerivX = FactoryConvolve.convolve(deriv, derivType, derivType, this.borderDeriv, true);
        this.derivDerivY = FactoryConvolve.convolve(deriv, derivType, derivType, this.borderDeriv, false);
    }

    public AnyImageDerivative(Kernel2D derivX, Class<I> inputType, Class<D> derivType) {
        this.derivType = derivType;
        Kernel2D derivY = GKernelMath.transpose(derivX);
        this.derivX = FactoryConvolve.convolve(derivX, inputType, derivType, this.borderDeriv);
        this.derivY = FactoryConvolve.convolve(derivY, inputType, derivType, this.borderDeriv);
        this.derivDerivX = FactoryConvolve.convolve(derivX, derivType, derivType, this.borderDeriv);
        this.derivDerivY = FactoryConvolve.convolve(derivY, derivType, derivType, this.borderDeriv);
    }

    public AnyImageDerivative(ConvolveInterface<I, D> derivX, ConvolveInterface<I, D> derivY, ConvolveInterface<D, D> derivXX, ConvolveInterface<D, D> derivYY, Class<I> inputType, Class<D> derivType) {
        this.derivType = derivType;
        this.derivX = derivX;
        this.derivY = derivY;
        this.derivDerivX = derivXX;
        this.derivDerivY = derivYY;
    }

    public void setInput(I input) {
        this.inputImage = input;
        if (this.stale != null) {
            for (int i = 0; i < this.stale.length; ++i) {
                boolean[] a = this.stale[i];
                for (int j = 0; j < a.length; ++j) {
                    a[j] = true;
                }
            }
        }
    }

    public D getDerivative(boolean ... isX) {
        if (this.derivatives == null) {
            this.declareTree(isX.length);
        } else if (isX.length > this.stale.length) {
            this.growTree(isX.length);
        }
        int index = 0;
        int prevIndex = 0;
        for (int level = 0; level < isX.length; ++level) {
            if (this.stale[level][index |= isX[level] ? 0 : 1 << level]) {
                this.stale[level][index] = false;
                ((ImageSingleBand)this.derivatives[level][index]).reshape(((ImageBase)this.inputImage).getWidth(), ((ImageBase)this.inputImage).getHeight());
                if (level == 0) {
                    if (isX[level]) {
                        this.derivX.process(this.inputImage, this.derivatives[level][index]);
                    } else {
                        this.derivY.process(this.inputImage, this.derivatives[level][index]);
                    }
                } else {
                    D prev = this.derivatives[level - 1][prevIndex];
                    if (isX[level]) {
                        this.derivDerivX.process(prev, this.derivatives[level][index]);
                    } else {
                        this.derivDerivY.process(prev, this.derivatives[level][index]);
                    }
                }
            }
            prevIndex = index;
        }
        return this.derivatives[isX.length - 1][index];
    }

    private void declareTree(int maxDerivativeOrder) {
        this.derivatives = new ImageSingleBand[maxDerivativeOrder][];
        this.stale = new boolean[maxDerivativeOrder][];
        for (int i = 0; i < maxDerivativeOrder; ++i) {
            int N = (int)Math.pow(2.0, i + 1);
            this.derivatives[i] = new ImageSingleBand[N];
            this.stale[i] = new boolean[N];
            for (int j = 0; j < N; ++j) {
                this.stale[i][j] = true;
                this.derivatives[i][j] = GeneralizedImageOps.createSingleBand(this.derivType, 1, 1);
            }
        }
    }

    private void growTree(int maxDerivativeOrder) {
        D[][] oldDerives = this.derivatives;
        boolean[][] oldStale = this.stale;
        this.declareTree(maxDerivativeOrder);
        int N = oldStale.length;
        for (int i = 0; i < N; ++i) {
            int M = oldStale[i].length;
            for (int j = 0; j < M; ++j) {
                this.derivatives[i][j] = oldDerives[i][j];
                this.stale[i][j] = oldStale[i][j];
            }
        }
    }
}

