/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.filter.derivative;

import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.core.image.border.BorderType;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.MultiSpectral;

public class ImageGradient_MS<T extends ImageSingleBand, D extends ImageSingleBand>
implements ImageGradient<MultiSpectral<T>, MultiSpectral<D>> {
    ImageGradient<T, D> bandGradient;
    ImageType<MultiSpectral<D>> derivType;

    public ImageGradient_MS(ImageGradient<T, D> bandGradient, int numBands) {
        this.bandGradient = bandGradient;
        this.derivType = ImageType.ms(numBands, bandGradient.getDerivativeType().getImageClass());
    }

    @Override
    public void process(MultiSpectral<T> inputImage, MultiSpectral<D> derivX, MultiSpectral<D> derivY) {
        for (int i = 0; i < inputImage.getNumBands(); ++i) {
            this.bandGradient.process(inputImage.getBand(i), derivX.getBand(i), derivY.getBand(i));
        }
    }

    @Override
    public void setBorderType(BorderType type) {
        this.bandGradient.setBorderType(type);
    }

    @Override
    public BorderType getBorderType() {
        return this.bandGradient.getBorderType();
    }

    @Override
    public int getBorder() {
        return this.bandGradient.getBorder();
    }

    @Override
    public ImageType<MultiSpectral<D>> getDerivativeType() {
        return this.derivType;
    }
}

