/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.color;

import boofcv.alg.InputSanityCheck;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.MultiSpectral;

public class ColorHsv {
    public static final double d60_F64 = 1.0471975511965976;
    public static final float d60_F32 = 1.0471976f;
    public static final double PI2_F64 = Math.PI * 2;
    public static final float PI2_F32 = (float)Math.PI * 2;

    public static void hsvToRgb(double h, double s, double v, double[] rgb) {
        if (s == 0.0) {
            rgb[0] = v;
            rgb[1] = v;
            rgb[2] = v;
            return;
        }
        int h_int = (int)(h /= 1.0471975511965976);
        double remainder = h - (double)h_int;
        double p = v * (1.0 - s);
        double q = v * (1.0 - s * remainder);
        double t = v * (1.0 - s * (1.0 - remainder));
        if (h_int < 1) {
            rgb[0] = v;
            rgb[1] = t;
            rgb[2] = p;
        } else if (h_int < 2) {
            rgb[0] = q;
            rgb[1] = v;
            rgb[2] = p;
        } else if (h_int < 3) {
            rgb[0] = p;
            rgb[1] = v;
            rgb[2] = t;
        } else if (h_int < 4) {
            rgb[0] = p;
            rgb[1] = q;
            rgb[2] = v;
        } else if (h_int < 5) {
            rgb[0] = t;
            rgb[1] = p;
            rgb[2] = v;
        } else {
            rgb[0] = v;
            rgb[1] = p;
            rgb[2] = q;
        }
    }

    public static void hsvToRgb(float h, float s, float v, float[] rgb) {
        if (s == 0.0f) {
            rgb[0] = v;
            rgb[1] = v;
            rgb[2] = v;
            return;
        }
        int h_int = (int)(h /= 1.0471976f);
        float remainder = h - (float)h_int;
        float p = v * (1.0f - s);
        float q = v * (1.0f - s * remainder);
        float t = v * (1.0f - s * (1.0f - remainder));
        if (h_int < 1) {
            rgb[0] = v;
            rgb[1] = t;
            rgb[2] = p;
        } else if (h_int < 2) {
            rgb[0] = q;
            rgb[1] = v;
            rgb[2] = p;
        } else if (h_int < 3) {
            rgb[0] = p;
            rgb[1] = v;
            rgb[2] = t;
        } else if (h_int < 4) {
            rgb[0] = p;
            rgb[1] = q;
            rgb[2] = v;
        } else if (h_int < 5) {
            rgb[0] = t;
            rgb[1] = p;
            rgb[2] = v;
        } else {
            rgb[0] = v;
            rgb[1] = p;
            rgb[2] = q;
        }
    }

    public static void rgbToHsv(double r, double g, double b, double[] hsv) {
        double max;
        double d = r > g ? (r > b ? r : b) : (max = g > b ? g : b);
        double min = r < g ? (r < b ? r : b) : (g < b ? g : b);
        double delta = max - min;
        hsv[2] = max;
        if (max == 0.0) {
            hsv[0] = Double.NaN;
            hsv[1] = 0.0;
            return;
        }
        hsv[1] = delta / max;
        double h = r == max ? (g - b) / delta : (g == max ? 2.0 + (b - r) / delta : 4.0 + (r - g) / delta);
        h *= 1.0471975511965976;
        if (h < 0.0) {
            h += Math.PI * 2;
        }
        hsv[0] = h;
    }

    public static void rgbToHsv(float r, float g, float b, float[] hsv) {
        float max;
        float f = r > g ? (r > b ? r : b) : (max = g > b ? g : b);
        float min = r < g ? (r < b ? r : b) : (g < b ? g : b);
        float delta = max - min;
        hsv[2] = max;
        if (max == 0.0f) {
            hsv[0] = Float.NaN;
            hsv[1] = 0.0f;
            return;
        }
        hsv[1] = delta / max;
        float h = r == max ? (g - b) / delta : (g == max ? 2.0f + (b - r) / delta : 4.0f + (r - g) / delta);
        h *= 1.0471976f;
        if (h < 0.0f) {
            h += (float)Math.PI * 2;
        }
        hsv[0] = h;
    }

    public static void hsvToRgb_F32(MultiSpectral<ImageFloat32> hsv, MultiSpectral<ImageFloat32> rgb) {
        InputSanityCheck.checkSameShape(hsv, rgb);
        ImageFloat32 H = hsv.getBand(0);
        ImageFloat32 S = hsv.getBand(1);
        ImageFloat32 V = hsv.getBand(2);
        ImageFloat32 R = rgb.getBand(0);
        ImageFloat32 G = rgb.getBand(1);
        ImageFloat32 B = rgb.getBand(2);
        for (int row = 0; row < hsv.height; ++row) {
            int indexHsv = hsv.startIndex + row * hsv.stride;
            int indexRgb = rgb.startIndex + row * rgb.stride;
            int col = 0;
            while (col < hsv.width) {
                float h = H.data[indexHsv];
                float s = S.data[indexHsv];
                float v = V.data[indexHsv];
                if (s == 0.0f) {
                    R.data[indexRgb] = v;
                    G.data[indexRgb] = v;
                    B.data[indexRgb] = v;
                } else {
                    int h_int = (int)(h /= 1.0471976f);
                    float remainder = h - (float)h_int;
                    float p = v * (1.0f - s);
                    float q = v * (1.0f - s * remainder);
                    float t = v * (1.0f - s * (1.0f - remainder));
                    if (h_int < 1) {
                        R.data[indexRgb] = v;
                        G.data[indexRgb] = t;
                        B.data[indexRgb] = p;
                    } else if (h_int < 2) {
                        R.data[indexRgb] = q;
                        G.data[indexRgb] = v;
                        B.data[indexRgb] = p;
                    } else if (h_int < 3) {
                        R.data[indexRgb] = p;
                        G.data[indexRgb] = v;
                        B.data[indexRgb] = t;
                    } else if (h_int < 4) {
                        R.data[indexRgb] = p;
                        G.data[indexRgb] = q;
                        B.data[indexRgb] = v;
                    } else if (h_int < 5) {
                        R.data[indexRgb] = t;
                        G.data[indexRgb] = p;
                        B.data[indexRgb] = v;
                    } else {
                        R.data[indexRgb] = v;
                        G.data[indexRgb] = p;
                        B.data[indexRgb] = q;
                    }
                }
                ++col;
                ++indexHsv;
                ++indexRgb;
            }
        }
    }

    public static void rgbToHsv_F32(MultiSpectral<ImageFloat32> rgb, MultiSpectral<ImageFloat32> hsv) {
        InputSanityCheck.checkSameShape(rgb, hsv);
        ImageFloat32 R = rgb.getBand(0);
        ImageFloat32 G = rgb.getBand(1);
        ImageFloat32 B = rgb.getBand(2);
        ImageFloat32 H = hsv.getBand(0);
        ImageFloat32 S = hsv.getBand(1);
        ImageFloat32 V = hsv.getBand(2);
        for (int row = 0; row < hsv.height; ++row) {
            int indexRgb = rgb.startIndex + row * rgb.stride;
            int indexHsv = hsv.startIndex + row * hsv.stride;
            int col = 0;
            while (col < hsv.width) {
                float max;
                float r = R.data[indexRgb];
                float g = G.data[indexRgb];
                float b = B.data[indexRgb];
                float f = r > g ? (r > b ? r : b) : (max = g > b ? g : b);
                float min = r < g ? (r < b ? r : b) : (g < b ? g : b);
                float delta = max - min;
                V.data[indexHsv] = max;
                if (max == 0.0f) {
                    H.data[indexHsv] = Float.NaN;
                    S.data[indexHsv] = 0.0f;
                } else {
                    S.data[indexHsv] = delta / max;
                    float h = r == max ? (g - b) / delta : (g == max ? 2.0f + (b - r) / delta : 4.0f + (r - g) / delta);
                    h *= 1.0471976f;
                    if (h < 0.0f) {
                        h += (float)Math.PI * 2;
                    }
                    H.data[indexHsv] = h;
                }
                ++col;
                ++indexHsv;
                ++indexRgb;
            }
        }
    }
}

