/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort;

import boofcv.alg.distort.ImageDistort;
import boofcv.alg.distort.PixelTransformAffine_F32;
import boofcv.alg.distort.PointToPixelTransform_F32;
import boofcv.alg.distort.impl.DistortSupport;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.alg.interpolate.TypeInterpolate;
import boofcv.core.image.border.BorderType;
import boofcv.factory.distort.FactoryDistort;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.struct.ImageRectangle_F32;
import boofcv.struct.ImageRectangle_F64;
import boofcv.struct.distort.PixelTransform_F32;
import boofcv.struct.distort.PixelTransform_F64;
import boofcv.struct.distort.PointTransform_F32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.MultiSpectral;
import georegression.struct.affine.Affine2D_F32;
import georegression.struct.shapes.RectangleLength2D_F32;
import georegression.struct.shapes.RectangleLength2D_F64;
import georegression.struct.shapes.RectangleLength2D_I32;

public class DistortImageOps {
    @Deprecated
    public static <T extends ImageBase> void affine(T input, T output, BorderType borderType, TypeInterpolate interpType, double a11, double a12, double a21, double a22, double dx, double dy) {
        Affine2D_F32 m = new Affine2D_F32();
        m.a11 = (float)a11;
        m.a12 = (float)a12;
        m.a21 = (float)a21;
        m.a22 = (float)a22;
        m.tx = (float)dx;
        m.ty = (float)dy;
        m = m.invert(null);
        PixelTransformAffine_F32 model = new PixelTransformAffine_F32(m);
        if (input instanceof ImageSingleBand) {
            DistortImageOps.distortSingle((ImageSingleBand)input, (ImageSingleBand)output, model, interpType, borderType);
        } else if (input instanceof MultiSpectral) {
            DistortImageOps.distortMS((MultiSpectral)input, (MultiSpectral)output, model, borderType, interpType);
        }
    }

    public static <Input extends ImageSingleBand, Output extends ImageSingleBand> void distortSingle(Input input, Output output, PixelTransform_F32 transform, TypeInterpolate interpType, BorderType borderType) {
        boolean skip;
        boolean bl = skip = borderType == BorderType.SKIP;
        if (skip) {
            borderType = BorderType.EXTENDED;
        }
        Class<?> inputType = input.getClass();
        Class<?> outputType = input.getClass();
        InterpolatePixelS<?> interp = FactoryInterpolation.createPixelS(0.0, 255.0, interpType, borderType, inputType);
        ImageDistort<?, ?> distorter = FactoryDistort.distortSB(false, interp, outputType);
        distorter.setRenderAll(!skip);
        distorter.setModel(transform);
        distorter.apply(input, output);
    }

    public static <Input extends ImageSingleBand, Output extends ImageSingleBand> void distortSingle(Input input, Output output, boolean renderAll, PixelTransform_F32 transform, InterpolatePixelS<Input> interp) {
        Class<?> inputType = input.getClass();
        ImageDistort<Input, ?> distorter = FactoryDistort.distortSB(false, interp, inputType);
        distorter.setRenderAll(renderAll);
        distorter.setModel(transform);
        distorter.apply(input, output);
    }

    public static <Input extends ImageSingleBand, Output extends ImageSingleBand, M extends MultiSpectral<Input>, N extends MultiSpectral<Output>> void distortMS(M input, N output, PixelTransform_F32 transform, BorderType borderType, TypeInterpolate interpType) {
        Class<Input> inputBandType = input.getBandType();
        Class<Output> outputBandType = output.getBandType();
        InterpolatePixelS<Input> interp = FactoryInterpolation.createPixelS(0.0, 255.0, interpType, borderType, inputBandType);
        ImageDistort<Input, Output> distorter = FactoryDistort.distortSB(false, interp, outputBandType);
        distorter.setModel(transform);
        DistortImageOps.distortMS(input, output, distorter);
    }

    public static <Input extends ImageSingleBand, Output extends ImageSingleBand> ImageDistort<Input, Output> createImageDistort(PointTransform_F32 transform, TypeInterpolate interpType, BorderType borderType, Class<Input> inputType, Class<Output> outputType) {
        InterpolatePixelS<Input> interp = FactoryInterpolation.createPixelS(0.0, 255.0, interpType, borderType, inputType);
        ImageDistort<Input, Output> distorter = FactoryDistort.distortSB(true, interp, outputType);
        distorter.setModel(new PointToPixelTransform_F32(transform));
        return distorter;
    }

    @Deprecated
    public static <T extends ImageBase> void scale(T input, T output, BorderType borderType, TypeInterpolate interpType) {
        PixelTransformAffine_F32 model = DistortSupport.transformScale(output, input, null);
        if (input instanceof ImageSingleBand) {
            DistortImageOps.distortSingle((ImageSingleBand)input, (ImageSingleBand)output, model, interpType, borderType);
        } else if (input instanceof MultiSpectral) {
            DistortImageOps.distortMS((MultiSpectral)input, (MultiSpectral)output, model, borderType, interpType);
        }
    }

    @Deprecated
    public static <T extends ImageBase> void rotate(T input, T output, BorderType borderType, TypeInterpolate interpType, float angleInputToOutput) {
        float offX = 0.0f;
        float offY = 0.0f;
        PixelTransformAffine_F32 model = DistortSupport.transformRotate(input.width / 2, input.height / 2, (float)(output.width / 2) - offX, (float)(output.height / 2) - offY, angleInputToOutput);
        if (input instanceof ImageSingleBand) {
            DistortImageOps.distortSingle((ImageSingleBand)input, (ImageSingleBand)output, model, interpType, borderType);
        } else if (input instanceof MultiSpectral) {
            DistortImageOps.distortMS((MultiSpectral)input, (MultiSpectral)output, model, borderType, interpType);
        }
    }

    public static <Input extends ImageSingleBand, Output extends ImageSingleBand> void distortMS(MultiSpectral<Input> input, MultiSpectral<Output> output, ImageDistort<Input, Output> distortion) {
        for (int band = 0; band < input.getNumBands(); ++band) {
            distortion.apply(input.getBand(band), output.getBand(band));
        }
    }

    public static RectangleLength2D_I32 boundBox(int srcWidth, int srcHeight, int dstWidth, int dstHeight, PixelTransform_F32 transform) {
        RectangleLength2D_I32 ret = DistortImageOps.boundBox(srcWidth, srcHeight, transform);
        int x0 = ret.x0;
        int y0 = ret.y0;
        int x1 = ret.x0 + ret.width;
        int y1 = ret.y0 + ret.height;
        if (x0 < 0) {
            x0 = 0;
        }
        if (x1 > dstWidth) {
            x1 = dstWidth;
        }
        if (y0 < 0) {
            y0 = 0;
        }
        if (y1 > dstHeight) {
            y1 = dstHeight;
        }
        return new RectangleLength2D_I32(x0, y0, x1 - x0, y1 - y0);
    }

    public static RectangleLength2D_I32 boundBox(int srcWidth, int srcHeight, PixelTransform_F32 transform) {
        int y1;
        int x1;
        transform.compute(0, 0);
        int x0 = x1 = (int)transform.distX;
        int y0 = y1 = (int)transform.distY;
        for (int i = 1; i < 4; ++i) {
            if (i == 1) {
                transform.compute(srcWidth, 0);
            } else if (i == 2) {
                transform.compute(0, srcHeight);
            } else if (i == 3) {
                transform.compute(srcWidth - 1, srcHeight);
            }
            if (transform.distX < (float)x0) {
                x0 = (int)transform.distX;
            } else if (transform.distX > (float)x1) {
                x1 = (int)transform.distX;
            }
            if (transform.distY < (float)y0) {
                y0 = (int)transform.distY;
                continue;
            }
            if (!(transform.distY > (float)y1)) continue;
            y1 = (int)transform.distY;
        }
        return new RectangleLength2D_I32(x0, y0, x1 - x0, y1 - y0);
    }

    public static RectangleLength2D_F32 boundBox_F32(int srcWidth, int srcHeight, PixelTransform_F32 transform) {
        ImageRectangle_F32 r = new ImageRectangle_F32();
        r.y0 = Float.MAX_VALUE;
        r.x0 = Float.MAX_VALUE;
        r.y1 = -3.4028235E38f;
        r.x1 = -3.4028235E38f;
        for (int y = 0; y < srcHeight; ++y) {
            transform.compute(0, y);
            DistortImageOps.updateBoundBox(transform, r);
            transform.compute(srcWidth, y);
            DistortImageOps.updateBoundBox(transform, r);
        }
        for (int x = 0; x < srcWidth; ++x) {
            transform.compute(x, 0);
            DistortImageOps.updateBoundBox(transform, r);
            transform.compute(x, srcHeight);
            DistortImageOps.updateBoundBox(transform, r);
        }
        return new RectangleLength2D_F32(r.x0, r.y0, r.x1 - r.x0, r.y1 - r.y0);
    }

    private static void updateBoundBox(PixelTransform_F32 transform, ImageRectangle_F32 r) {
        if (transform.distX < r.x0) {
            r.x0 = transform.distX;
        } else if (transform.distX > r.x1) {
            r.x1 = transform.distX;
        }
        if (transform.distY < r.y0) {
            r.y0 = transform.distY;
        } else if (transform.distY > r.y1) {
            r.y1 = transform.distY;
        }
    }

    public static RectangleLength2D_F64 boundBox_F64(int srcWidth, int srcHeight, PixelTransform_F64 transform) {
        ImageRectangle_F64 r = new ImageRectangle_F64();
        r.y0 = Double.MAX_VALUE;
        r.x0 = Double.MAX_VALUE;
        r.y1 = -1.7976931348623157E308;
        r.x1 = -1.7976931348623157E308;
        for (int y = 0; y < srcHeight; ++y) {
            transform.compute(0, y);
            DistortImageOps.updateBoundBox(transform, r);
            transform.compute(srcWidth, y);
            DistortImageOps.updateBoundBox(transform, r);
        }
        for (int x = 0; x < srcWidth; ++x) {
            transform.compute(x, 0);
            DistortImageOps.updateBoundBox(transform, r);
            transform.compute(x, srcHeight);
            DistortImageOps.updateBoundBox(transform, r);
        }
        return new RectangleLength2D_F64(r.x0, r.y0, r.x1 - r.x0, r.y1 - r.y0);
    }

    private static void updateBoundBox(PixelTransform_F64 transform, ImageRectangle_F64 r) {
        if (transform.distX < r.x0) {
            r.x0 = transform.distX;
        } else if (transform.distX > r.x1) {
            r.x1 = transform.distX;
        }
        if (transform.distY < r.y0) {
            r.y0 = transform.distY;
        } else if (transform.distY > r.y1) {
            r.y1 = transform.distY;
        }
    }
}

