/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort;

import boofcv.alg.distort.ImageDistortBasic;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.struct.image.ImageSingleBand;

public abstract class ImageDistortBasic_SB<Input extends ImageSingleBand, Output extends ImageSingleBand>
extends ImageDistortBasic<Input, Output, InterpolatePixelS<Input>> {
    public ImageDistortBasic_SB(InterpolatePixelS<Input> interp) {
        super(interp);
    }

    @Override
    public void applyAll() {
        for (int y = this.y0; y < this.y1; ++y) {
            int indexDst = ((ImageSingleBand)this.dstImg).startIndex + ((ImageSingleBand)this.dstImg).stride * y + this.x0;
            int x = this.x0;
            while (x < this.x1) {
                this.dstToSrc.compute(x, y);
                this.assign(indexDst, ((InterpolatePixelS)this.interp).get(this.dstToSrc.distX, this.dstToSrc.distY));
                ++x;
                ++indexDst;
            }
        }
    }

    @Override
    public void applyOnlyInside() {
        float maxWidth = ((ImageSingleBand)this.srcImg).getWidth() - 1;
        float maxHeight = ((ImageSingleBand)this.srcImg).getHeight() - 1;
        for (int y = this.y0; y < this.y1; ++y) {
            int indexDst = ((ImageSingleBand)this.dstImg).startIndex + ((ImageSingleBand)this.dstImg).stride * y + this.x0;
            int x = this.x0;
            while (x < this.x1) {
                this.dstToSrc.compute(x, y);
                if (this.dstToSrc.distX >= 0.0f && this.dstToSrc.distX <= maxWidth && this.dstToSrc.distY >= 0.0f && this.dstToSrc.distY <= maxHeight) {
                    this.assign(indexDst, ((InterpolatePixelS)this.interp).get(this.dstToSrc.distX, this.dstToSrc.distY));
                }
                ++x;
                ++indexDst;
            }
        }
    }

    protected abstract void assign(int var1, float var2);
}

