/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.binary;

import boofcv.abst.filter.binary.LocalSquareBlockMinMaxBinaryFilter;
import boofcv.alg.filter.binary.ThresholdImageOps;
import boofcv.alg.filter.binary.impl.ThresholdSauvola;
import boofcv.alg.misc.GImageStatistics;
import boofcv.core.image.GConvertImage;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageFloat64;
import boofcv.struct.image.ImageSInt16;
import boofcv.struct.image.ImageSInt32;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageUInt16;
import boofcv.struct.image.ImageUInt8;

public class GThresholdImageOps {
    public static int computeOtsu(ImageSingleBand input, int minValue, int maxValue) {
        int range = 1 + maxValue - minValue;
        int[] histogram = new int[range];
        GImageStatistics.histogram(input, minValue, histogram);
        int total = input.width * input.height;
        return GThresholdImageOps.computeOtsu(histogram, range, total) + minValue;
    }

    public static int computeOtsu(int[] histogram, int length, int totalPixels) {
        double dlength = length;
        double sum = 0.0;
        for (int i = 0; i < length; ++i) {
            sum += (double)i / dlength * (double)histogram[i];
        }
        double sumB = 0.0;
        int wB = 0;
        double varMax = 0.0;
        int threshold = 0;
        for (int i = 0; i < length; ++i) {
            double mF;
            double varBetween;
            if ((wB += histogram[i]) == 0) continue;
            int wF = totalPixels - wB;
            if (wF == 0) break;
            double mB = (sumB += (double)i / dlength * (double)histogram[i]) / (double)wB;
            if (!((varBetween = (double)wB * (double)wF * (mB - (mF = (sum - sumB) / (double)wF)) * (mB - mF)) > varMax)) continue;
            varMax = varBetween;
            threshold = i;
        }
        return threshold;
    }

    public static int computeEntropy(ImageSingleBand input, int minValue, int maxValue) {
        int range = 1 + maxValue - minValue;
        int[] histogram = new int[range];
        GImageStatistics.histogram(input, minValue, histogram);
        int total = input.width * input.height;
        return GThresholdImageOps.computeEntropy(histogram, range, total) + minValue;
    }

    public static int computeEntropy(int[] histogram, int length, int totalPixels) {
        double[] p = new double[length];
        for (int i = 0; i < length; ++i) {
            int h = histogram[i];
            if (h == 0) {
                p[i] = 0.0;
                continue;
            }
            p[i] = (double)h / (double)totalPixels;
            int n = i;
            p[n] = p[n] * Math.log(p[i]);
        }
        double bestScore = 0.0;
        int bestIndex = 0;
        int countF = 0;
        for (int i = 0; i < length; ++i) {
            double sumF = (double)(countF += histogram[i]) / (double)totalPixels;
            if (sumF == 0.0 || sumF == 1.0) continue;
            double sumB = 1.0 - sumF;
            double HA = 0.0;
            for (int j = 0; j <= i; ++j) {
                HA += p[j];
            }
            HA /= sumF;
            double HB = 0.0;
            for (int j = i + 1; j < length; ++j) {
                HB += p[j];
            }
            HB /= sumB;
            double entropy = Math.log(sumF) + Math.log(sumB) - HA - HB;
            if (!(entropy > bestScore)) continue;
            bestScore = entropy;
            bestIndex = i;
        }
        return bestIndex;
    }

    public static <T extends ImageSingleBand> ImageUInt8 threshold(T input, ImageUInt8 output, double threshold, boolean down) {
        if (input instanceof ImageFloat32) {
            return ThresholdImageOps.threshold((ImageFloat32)input, output, (float)threshold, down);
        }
        if (input instanceof ImageUInt8) {
            return ThresholdImageOps.threshold((ImageUInt8)input, output, (int)threshold, down);
        }
        if (input instanceof ImageUInt16) {
            return ThresholdImageOps.threshold((ImageUInt16)input, output, (int)threshold, down);
        }
        if (input instanceof ImageSInt16) {
            return ThresholdImageOps.threshold((ImageSInt16)input, output, (int)threshold, down);
        }
        if (input instanceof ImageSInt32) {
            return ThresholdImageOps.threshold((ImageSInt32)input, output, (int)threshold, down);
        }
        if (input instanceof ImageFloat64) {
            return ThresholdImageOps.threshold((ImageFloat64)input, output, threshold, down);
        }
        throw new IllegalArgumentException("Unknown image type: " + input.getClass().getSimpleName());
    }

    public static <T extends ImageSingleBand> ImageUInt8 localSquare(T input, ImageUInt8 output, int radius, double scale, boolean down, T work1, T work2) {
        if (input instanceof ImageFloat32) {
            return ThresholdImageOps.localSquare((ImageFloat32)input, output, radius, (float)scale, down, (ImageFloat32)work1, (ImageFloat32)work2);
        }
        if (input instanceof ImageUInt8) {
            return ThresholdImageOps.localSquare((ImageUInt8)input, output, radius, (float)scale, down, (ImageUInt8)work1, (ImageUInt8)work2);
        }
        throw new IllegalArgumentException("Unknown image type: " + input.getClass().getSimpleName());
    }

    public static <T extends ImageSingleBand> ImageUInt8 localGaussian(T input, ImageUInt8 output, int radius, double scale, boolean down, T work1, ImageSingleBand work2) {
        if (input instanceof ImageFloat32) {
            return ThresholdImageOps.localGaussian((ImageFloat32)input, output, radius, (float)scale, down, (ImageFloat32)work1, (ImageFloat32)work2);
        }
        if (input instanceof ImageUInt8) {
            return ThresholdImageOps.localGaussian((ImageUInt8)input, output, radius, (float)scale, down, (ImageUInt8)work1, (ImageUInt8)work2);
        }
        throw new IllegalArgumentException("Unknown image type: " + input.getClass().getSimpleName());
    }

    public static <T extends ImageSingleBand> ImageUInt8 localSauvola(T input, ImageUInt8 output, int radius, float k, boolean down) {
        ThresholdSauvola alg = new ThresholdSauvola(radius, k, down);
        if (output == null) {
            output = new ImageUInt8(input.width, input.height);
        }
        if (input instanceof ImageFloat32) {
            alg.process((ImageFloat32)input, output);
        } else {
            ImageFloat32 conv = new ImageFloat32(input.width, input.height);
            GConvertImage.convert(input, conv);
            alg.process(conv, output);
        }
        return output;
    }

    public static <T extends ImageSingleBand> ImageUInt8 localBlockMinMax(T input, ImageUInt8 output, int radius, double scale, boolean down, double textureThreshold) {
        LocalSquareBlockMinMaxBinaryFilter alg = new LocalSquareBlockMinMaxBinaryFilter(textureThreshold, radius * 2 + 1, scale, down, input.getClass());
        if (output == null) {
            output = new ImageUInt8(input.width, input.height);
        }
        alg.process(input, output);
        return output;
    }
}

