/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.binary;

import boofcv.alg.InputSanityCheck;
import boofcv.struct.image.ImageInterleaved;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageUInt8;

public abstract class ThresholdSquareBlockMinMax<T extends ImageSingleBand, I extends ImageInterleaved> {
    protected I minmax;
    protected double minimumSpread;
    protected int requestedBlockWidth;
    protected int blockWidth;
    protected int blockHeight;

    public ThresholdSquareBlockMinMax(double minimumSpread, int requestedBlockWidth) {
        this.minimumSpread = minimumSpread;
        this.requestedBlockWidth = requestedBlockWidth;
    }

    public void process(T input, ImageUInt8 output) {
        InputSanityCheck.checkSameShape(input, output);
        if (((ImageSingleBand)input).width < this.requestedBlockWidth || ((ImageSingleBand)input).height < this.requestedBlockWidth) {
            throw new IllegalArgumentException("Image is smaller than block size");
        }
        this.selectBlockSize(((ImageSingleBand)input).width, ((ImageSingleBand)input).height);
        ((ImageInterleaved)this.minmax).reshape(((ImageSingleBand)input).width / this.blockWidth, ((ImageSingleBand)input).height / this.blockHeight);
        int innerWidth = ((ImageSingleBand)input).width % this.blockWidth == 0 ? ((ImageSingleBand)input).width : ((ImageSingleBand)input).width - this.blockWidth - ((ImageSingleBand)input).width % this.blockWidth;
        int innerHeight = ((ImageSingleBand)input).height % this.blockHeight == 0 ? ((ImageSingleBand)input).height : ((ImageSingleBand)input).height - this.blockHeight - ((ImageSingleBand)input).height % this.blockHeight;
        this.computeMinMax(input, innerWidth, innerHeight);
        this.applyThreshold(input, output);
    }

    void selectBlockSize(int width, int height) {
        int rows = height / this.requestedBlockWidth;
        int cols = width / this.requestedBlockWidth;
        this.blockHeight = height / rows;
        this.blockWidth = width / cols;
    }

    private void computeMinMax(T input, int innerWidth, int innerHeight) {
        int y;
        int indexMinMax = 0;
        for (y = 0; y < innerHeight; y += this.blockHeight) {
            int x = 0;
            while (x < innerWidth) {
                this.computeMinMaxBlock(x, y, this.blockWidth, this.blockHeight, indexMinMax, input);
                x += this.blockWidth;
                indexMinMax += 2;
            }
            if (innerWidth == ((ImageSingleBand)input).width) continue;
            this.computeMinMaxBlock(innerWidth, y, ((ImageSingleBand)input).width - innerWidth, this.blockHeight, indexMinMax, input);
            indexMinMax += 2;
        }
        if (innerHeight != ((ImageSingleBand)input).height) {
            y = innerHeight;
            int blockHeight = ((ImageSingleBand)input).height - innerHeight;
            int x = 0;
            while (x < innerWidth) {
                this.computeMinMaxBlock(x, y, this.blockWidth, blockHeight, indexMinMax, input);
                x += this.blockWidth;
                indexMinMax += 2;
            }
            if (innerWidth != ((ImageSingleBand)input).width) {
                this.computeMinMaxBlock(innerWidth, y, ((ImageSingleBand)input).width - innerWidth, blockHeight, indexMinMax, input);
            }
        }
    }

    private void applyThreshold(T input, ImageUInt8 output) {
        for (int blockY = 0; blockY < ((ImageInterleaved)this.minmax).height; ++blockY) {
            for (int blockX = 0; blockX < ((ImageInterleaved)this.minmax).width; ++blockX) {
                this.thresholdBlock(blockX, blockY, input, output);
            }
        }
    }

    protected abstract void thresholdBlock(int var1, int var2, T var3, ImageUInt8 var4);

    protected abstract void computeMinMaxBlock(int var1, int var2, int var3, int var4, int var5, T var6);
}

