/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.derivative;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.filter.convolve.border.ConvolveJustBorder_General;
import boofcv.alg.filter.derivative.impl.GradientPrewitt_Shared;
import boofcv.core.image.border.ImageBorder_F32;
import boofcv.core.image.border.ImageBorder_S32;
import boofcv.struct.convolve.Kernel2D;
import boofcv.struct.convolve.Kernel2D_F32;
import boofcv.struct.convolve.Kernel2D_I32;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageSInt16;
import boofcv.struct.image.ImageUInt8;

public class GradientPrewitt {
    public static Kernel2D_I32 kernelDerivX_I32 = new Kernel2D_I32(3, new int[]{-1, 0, 1, -1, 0, 1, -1, 0, 1});
    public static Kernel2D_I32 kernelDerivY_I32 = new Kernel2D_I32(3, new int[]{-1, -1, -1, 0, 0, 0, 1, 1, 1});
    public static Kernel2D_F32 kernelDerivX_F32 = new Kernel2D_F32(3, new float[]{-1.0f, 0.0f, 1.0f, -1.0f, 0.0f, 1.0f, -1.0f, 0.0f, 1.0f});
    public static Kernel2D_F32 kernelDerivY_F32 = new Kernel2D_F32(3, new float[]{-1.0f, -1.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f});

    public static Kernel2D getKernelX(boolean isInteger) {
        if (isInteger) {
            return kernelDerivX_I32;
        }
        return kernelDerivX_F32;
    }

    public static void process(ImageUInt8 orig, ImageSInt16 derivX, ImageSInt16 derivY, ImageBorder_S32 border) {
        InputSanityCheck.checkSameShape(orig, derivX, derivY);
        GradientPrewitt_Shared.process(orig, derivX, derivY);
        if (border != null) {
            border.setImage(orig);
            ConvolveJustBorder_General.convolve(kernelDerivX_I32, border, derivX);
            ConvolveJustBorder_General.convolve(kernelDerivY_I32, border, derivY);
        }
    }

    public static void process(ImageSInt16 orig, ImageSInt16 derivX, ImageSInt16 derivY, ImageBorder_S32 border) {
        InputSanityCheck.checkSameShape(orig, derivX, derivY);
        GradientPrewitt_Shared.process(orig, derivX, derivY);
        if (border != null) {
            border.setImage(orig);
            ConvolveJustBorder_General.convolve(kernelDerivX_I32, border, derivX);
            ConvolveJustBorder_General.convolve(kernelDerivY_I32, border, derivY);
        }
    }

    public static void process(ImageFloat32 orig, ImageFloat32 derivX, ImageFloat32 derivY, ImageBorder_F32 border) {
        InputSanityCheck.checkSameShape(orig, derivX, derivY);
        GradientPrewitt_Shared.process(orig, derivX, derivY);
        if (border != null) {
            border.setImage(orig);
            ConvolveJustBorder_General.convolve(kernelDerivX_F32, border, derivX);
            ConvolveJustBorder_General.convolve(kernelDerivY_F32, border, derivY);
        }
    }
}

