/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.derivative.impl;

import boofcv.core.image.border.ImageBorder_F32;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.sparse.GradientValue_F32;
import boofcv.struct.sparse.SparseImageGradient;

public class GradientSparseTwo0_F32
implements SparseImageGradient<ImageFloat32, GradientValue_F32> {
    ImageFloat32 input;
    ImageBorder_F32 border;
    GradientValue_F32 gradient = new GradientValue_F32();

    public GradientSparseTwo0_F32(ImageBorder_F32 border) {
        this.border = border;
    }

    @Override
    public GradientValue_F32 compute(int x, int y) {
        float a01;
        float a10;
        float a00;
        if (x >= 0 && y >= 0 && x < this.input.width - 1 && y < this.input.height - 1) {
            int s = this.input.stride;
            int tl = this.input.startIndex + this.input.stride * y + x;
            a00 = this.input.data[tl];
            a10 = this.input.data[tl + s];
            a01 = this.input.data[tl + 1];
        } else {
            a00 = this.border.get(x, y);
            a10 = this.border.get(x, y + 1);
            a01 = this.border.get(x + 1, y);
        }
        this.gradient.y = a10 - a00;
        this.gradient.x = a01 - a00;
        return this.gradient;
    }

    @Override
    public Class<GradientValue_F32> getGradientType() {
        return GradientValue_F32.class;
    }

    @Override
    public void setImage(ImageFloat32 input) {
        this.input = input;
        if (this.border != null) {
            this.border.setImage(input);
        }
    }

    @Override
    public boolean isInBounds(int x, int y) {
        return this.border != null || x >= 0 && y >= 0 && x < this.input.width - 1 && y < this.input.height - 1;
    }
}

