/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.derivative.impl;

import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageSInt16;
import boofcv.struct.image.ImageUInt8;

public class GradientTwo0_Standard {
    public static void process(ImageFloat32 orig, ImageFloat32 derivX, ImageFloat32 derivY) {
        float[] data = orig.data;
        float[] imgX = derivX.data;
        float[] imgY = derivY.data;
        int width = orig.getWidth();
        int height = orig.getHeight() - 1;
        int stride = orig.stride;
        for (int y = 0; y < height; ++y) {
            int indexSrc;
            int indexX = derivX.startIndex + derivX.stride * y;
            int indexY = derivY.startIndex + derivY.stride * y;
            int endX = indexSrc + width - 1;
            for (indexSrc = orig.startIndex + orig.stride * y; indexSrc < endX; ++indexSrc) {
                float val = data[indexSrc];
                imgX[indexX++] = data[indexSrc + 1] - val;
                imgY[indexY++] = data[indexSrc + stride] - val;
            }
        }
    }

    public static void process(ImageUInt8 orig, ImageSInt16 derivX, ImageSInt16 derivY) {
        byte[] data = orig.data;
        short[] imgX = derivX.data;
        short[] imgY = derivY.data;
        int width = orig.getWidth();
        int height = orig.getHeight() - 1;
        int stride = orig.stride;
        for (int y = 0; y < height; ++y) {
            int indexSrc;
            int indexX = derivX.startIndex + derivX.stride * y;
            int indexY = derivY.startIndex + derivY.stride * y;
            int endX = indexSrc + width - 1;
            for (indexSrc = orig.startIndex + stride * y; indexSrc < endX; ++indexSrc) {
                int val = data[indexSrc] & 0xFF;
                imgX[indexX++] = (short)((data[indexSrc + 1] & 0xFF) - val);
                imgY[indexY++] = (short)((data[indexSrc + stride] & 0xFF) - val);
            }
        }
    }

    public static void process(ImageSInt16 orig, ImageSInt16 derivX, ImageSInt16 derivY) {
        short[] data = orig.data;
        short[] imgX = derivX.data;
        short[] imgY = derivY.data;
        int width = orig.getWidth();
        int height = orig.getHeight() - 1;
        int stride = orig.stride;
        for (int y = 0; y < height; ++y) {
            int indexSrc;
            int indexX = derivX.startIndex + derivX.stride * y;
            int indexY = derivY.startIndex + derivY.stride * y;
            int endX = indexSrc + width - 1;
            for (indexSrc = orig.startIndex + stride * y; indexSrc < endX; ++indexSrc) {
                short val = data[indexSrc];
                imgX[indexX++] = (short)(data[indexSrc + 1] - val);
                imgY[indexY++] = (short)(data[indexSrc + stride] - val);
            }
        }
    }
}

