/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.misc;

import boofcv.alg.misc.PixelMath;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageFloat64;
import boofcv.struct.image.ImageInt16;
import boofcv.struct.image.ImageInterleaved;
import boofcv.struct.image.ImageSInt16;
import boofcv.struct.image.ImageSInt32;
import boofcv.struct.image.ImageSInt64;
import boofcv.struct.image.ImageSInt8;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageUInt16;
import boofcv.struct.image.ImageUInt8;
import boofcv.struct.image.InterleavedF32;
import boofcv.struct.image.InterleavedF64;
import boofcv.struct.image.InterleavedS16;
import boofcv.struct.image.InterleavedS32;
import boofcv.struct.image.InterleavedS64;
import boofcv.struct.image.InterleavedS8;
import boofcv.struct.image.InterleavedU16;
import boofcv.struct.image.InterleavedU8;
import boofcv.struct.image.MultiSpectral;

public class GPixelMath {
    public static <T extends ImageBase> void abs(T input, T output) {
        block3: {
            block8: {
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    block1: {
                                        block7: {
                                            block6: {
                                                block5: {
                                                    block4: {
                                                        block2: {
                                                            if (!(input instanceof ImageSingleBand)) break block1;
                                                            if (ImageSInt8.class != input.getClass()) break block2;
                                                            PixelMath.abs((ImageSInt8)input, (ImageSInt8)output);
                                                            break block3;
                                                        }
                                                        if (ImageSInt16.class != input.getClass()) break block4;
                                                        PixelMath.abs((ImageSInt16)input, (ImageSInt16)output);
                                                        break block3;
                                                    }
                                                    if (ImageSInt32.class != input.getClass()) break block5;
                                                    PixelMath.abs((ImageSInt32)input, (ImageSInt32)output);
                                                    break block3;
                                                }
                                                if (ImageSInt64.class != input.getClass()) break block6;
                                                PixelMath.abs((ImageSInt64)input, (ImageSInt64)output);
                                                break block3;
                                            }
                                            if (ImageFloat32.class != input.getClass()) break block7;
                                            PixelMath.abs((ImageFloat32)input, (ImageFloat32)output);
                                            break block3;
                                        }
                                        if (ImageFloat64.class != input.getClass()) break block3;
                                        PixelMath.abs((ImageFloat64)input, (ImageFloat64)output);
                                        break block3;
                                    }
                                    if (!(input instanceof ImageInterleaved)) break block8;
                                    if (InterleavedS8.class != input.getClass()) break block9;
                                    PixelMath.abs((InterleavedS8)input, (InterleavedS8)output);
                                    break block3;
                                }
                                if (InterleavedS16.class != input.getClass()) break block10;
                                PixelMath.abs((InterleavedS16)input, (InterleavedS16)output);
                                break block3;
                            }
                            if (InterleavedS32.class != input.getClass()) break block11;
                            PixelMath.abs((InterleavedS32)input, (InterleavedS32)output);
                            break block3;
                        }
                        if (InterleavedS64.class != input.getClass()) break block12;
                        PixelMath.abs((InterleavedS64)input, (InterleavedS64)output);
                        break block3;
                    }
                    if (InterleavedF32.class != input.getClass()) break block13;
                    PixelMath.abs((InterleavedF32)input, (InterleavedF32)output);
                    break block3;
                }
                if (InterleavedF64.class != input.getClass()) break block3;
                PixelMath.abs((InterleavedF64)input, (InterleavedF64)output);
                break block3;
            }
            MultiSpectral in = (MultiSpectral)input;
            MultiSpectral out = (MultiSpectral)output;
            for (int i = 0; i < in.getNumBands(); ++i) {
                GPixelMath.abs(in.getBand(i), out.getBand(i));
            }
        }
    }

    public static <T extends ImageBase> void invert(T input, T output) {
        block3: {
            block8: {
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    block1: {
                                        block7: {
                                            block6: {
                                                block5: {
                                                    block4: {
                                                        block2: {
                                                            if (!(input instanceof ImageSingleBand)) break block1;
                                                            if (ImageSInt8.class != input.getClass()) break block2;
                                                            PixelMath.invert((ImageSInt8)input, (ImageSInt8)output);
                                                            break block3;
                                                        }
                                                        if (ImageSInt16.class != input.getClass()) break block4;
                                                        PixelMath.invert((ImageSInt16)input, (ImageSInt16)output);
                                                        break block3;
                                                    }
                                                    if (ImageSInt32.class != input.getClass()) break block5;
                                                    PixelMath.invert((ImageSInt32)input, (ImageSInt32)output);
                                                    break block3;
                                                }
                                                if (ImageSInt64.class != input.getClass()) break block6;
                                                PixelMath.invert((ImageSInt64)input, (ImageSInt64)output);
                                                break block3;
                                            }
                                            if (ImageFloat32.class != input.getClass()) break block7;
                                            PixelMath.invert((ImageFloat32)input, (ImageFloat32)output);
                                            break block3;
                                        }
                                        if (ImageFloat64.class != input.getClass()) break block3;
                                        PixelMath.invert((ImageFloat64)input, (ImageFloat64)output);
                                        break block3;
                                    }
                                    if (!(input instanceof ImageInterleaved)) break block8;
                                    if (InterleavedS8.class != input.getClass()) break block9;
                                    PixelMath.invert((InterleavedS8)input, (InterleavedS8)output);
                                    break block3;
                                }
                                if (InterleavedS16.class != input.getClass()) break block10;
                                PixelMath.invert((InterleavedS16)input, (InterleavedS16)output);
                                break block3;
                            }
                            if (InterleavedS32.class != input.getClass()) break block11;
                            PixelMath.invert((InterleavedS32)input, (InterleavedS32)output);
                            break block3;
                        }
                        if (InterleavedS64.class != input.getClass()) break block12;
                        PixelMath.invert((InterleavedS64)input, (InterleavedS64)output);
                        break block3;
                    }
                    if (InterleavedF32.class != input.getClass()) break block13;
                    PixelMath.invert((InterleavedF32)input, (InterleavedF32)output);
                    break block3;
                }
                if (InterleavedF64.class != input.getClass()) break block3;
                PixelMath.invert((InterleavedF64)input, (InterleavedF64)output);
                break block3;
            }
            MultiSpectral in = (MultiSpectral)input;
            MultiSpectral out = (MultiSpectral)output;
            for (int i = 0; i < in.getNumBands(); ++i) {
                GPixelMath.invert(in.getBand(i), out.getBand(i));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T extends ImageBase> void divide(T input, double denominator, T output) {
        if (input instanceof ImageSingleBand) {
            if (ImageUInt8.class == input.getClass()) {
                PixelMath.divide((ImageUInt8)input, denominator, (ImageUInt8)output);
                return;
            } else if (ImageSInt8.class == input.getClass()) {
                PixelMath.divide((ImageSInt8)input, denominator, (ImageSInt8)output);
                return;
            } else if (ImageUInt16.class == input.getClass()) {
                PixelMath.divide((ImageUInt16)input, denominator, (ImageUInt16)output);
                return;
            } else if (ImageSInt16.class == input.getClass()) {
                PixelMath.divide((ImageSInt16)input, denominator, (ImageSInt16)output);
                return;
            } else if (ImageSInt32.class == input.getClass()) {
                PixelMath.divide((ImageSInt32)input, denominator, (ImageSInt32)output);
                return;
            } else if (ImageSInt64.class == input.getClass()) {
                PixelMath.divide((ImageSInt64)input, denominator, (ImageSInt64)output);
                return;
            } else if (ImageFloat32.class == input.getClass()) {
                PixelMath.divide((ImageFloat32)input, (float)denominator, (ImageFloat32)output);
                return;
            } else {
                if (ImageFloat64.class != input.getClass()) throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
                PixelMath.divide((ImageFloat64)input, denominator, (ImageFloat64)output);
            }
            return;
        } else if (input instanceof ImageInterleaved) {
            if (InterleavedU8.class == input.getClass()) {
                PixelMath.divide((InterleavedU8)input, denominator, (InterleavedU8)output);
                return;
            } else if (InterleavedS8.class == input.getClass()) {
                PixelMath.divide((InterleavedS8)input, denominator, (InterleavedS8)output);
                return;
            } else if (InterleavedU16.class == input.getClass()) {
                PixelMath.divide((InterleavedU16)input, denominator, (InterleavedU16)output);
                return;
            } else if (InterleavedS16.class == input.getClass()) {
                PixelMath.divide((InterleavedS16)input, denominator, (InterleavedS16)output);
                return;
            } else if (InterleavedS32.class == input.getClass()) {
                PixelMath.divide((InterleavedS32)input, denominator, (InterleavedS32)output);
                return;
            } else if (InterleavedS64.class == input.getClass()) {
                PixelMath.divide((InterleavedS64)input, denominator, (InterleavedS64)output);
                return;
            } else if (InterleavedF32.class == input.getClass()) {
                PixelMath.divide((InterleavedF32)input, (float)denominator, (InterleavedF32)output);
                return;
            } else {
                if (InterleavedF64.class != input.getClass()) throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
                PixelMath.divide((InterleavedF64)input, denominator, (InterleavedF64)output);
            }
            return;
        } else {
            MultiSpectral in = (MultiSpectral)input;
            MultiSpectral out = (MultiSpectral)output;
            for (int i = 0; i < in.getNumBands(); ++i) {
                GPixelMath.divide(in.getBand(i), denominator, out.getBand(i));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T extends ImageBase> void divide(T input, double denominator, double lower, double upper, T output) {
        if (input instanceof ImageSingleBand) {
            if (ImageUInt8.class == input.getClass()) {
                PixelMath.divide((ImageUInt8)input, denominator, (int)lower, (int)upper, (ImageUInt8)output);
                return;
            } else if (ImageSInt8.class == input.getClass()) {
                PixelMath.divide((ImageSInt8)input, denominator, (int)lower, (int)upper, (ImageSInt8)output);
                return;
            } else if (ImageUInt16.class == input.getClass()) {
                PixelMath.divide((ImageUInt16)input, denominator, (int)lower, (int)upper, (ImageUInt16)output);
                return;
            } else if (ImageSInt16.class == input.getClass()) {
                PixelMath.divide((ImageSInt16)input, denominator, (int)lower, (int)upper, (ImageSInt16)output);
                return;
            } else if (ImageSInt32.class == input.getClass()) {
                PixelMath.divide((ImageSInt32)input, denominator, (int)lower, (int)upper, (ImageSInt32)output);
                return;
            } else if (ImageSInt64.class == input.getClass()) {
                PixelMath.divide((ImageSInt64)input, denominator, (long)lower, (long)upper, (ImageSInt64)output);
                return;
            } else if (ImageFloat32.class == input.getClass()) {
                PixelMath.divide((ImageFloat32)input, (float)denominator, (float)lower, (float)upper, (ImageFloat32)output);
                return;
            } else {
                if (ImageFloat64.class != input.getClass()) throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
                PixelMath.divide((ImageFloat64)input, denominator, lower, upper, (ImageFloat64)output);
            }
            return;
        } else if (input instanceof ImageInterleaved) {
            if (InterleavedU8.class == input.getClass()) {
                PixelMath.divide((InterleavedU8)input, denominator, (int)lower, (int)upper, (InterleavedU8)output);
                return;
            } else if (InterleavedS8.class == input.getClass()) {
                PixelMath.divide((InterleavedS8)input, denominator, (int)lower, (int)upper, (InterleavedS8)output);
                return;
            } else if (InterleavedU16.class == input.getClass()) {
                PixelMath.divide((InterleavedU16)input, denominator, (int)lower, (int)upper, (InterleavedU16)output);
                return;
            } else if (InterleavedS16.class == input.getClass()) {
                PixelMath.divide((InterleavedS16)input, denominator, (int)lower, (int)upper, (InterleavedS16)output);
                return;
            } else if (InterleavedS32.class == input.getClass()) {
                PixelMath.divide((InterleavedS32)input, denominator, (int)lower, (int)upper, (InterleavedS32)output);
                return;
            } else if (InterleavedS64.class == input.getClass()) {
                PixelMath.divide((InterleavedS64)input, denominator, (long)lower, (long)upper, (InterleavedS64)output);
                return;
            } else if (InterleavedF32.class == input.getClass()) {
                PixelMath.divide((InterleavedF32)input, (float)denominator, (float)lower, (float)upper, (InterleavedF32)output);
                return;
            } else {
                if (InterleavedF64.class != input.getClass()) throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
                PixelMath.divide((InterleavedF64)input, denominator, lower, upper, (InterleavedF64)output);
            }
            return;
        } else {
            MultiSpectral in = (MultiSpectral)input;
            MultiSpectral out = (MultiSpectral)output;
            for (int i = 0; i < in.getNumBands(); ++i) {
                GPixelMath.divide(in.getBand(i), denominator, lower, upper, out.getBand(i));
            }
        }
    }

    public static <T extends ImageSingleBand> void divide(T imgA, T imgB, T output) {
        if (ImageFloat32.class == imgA.getClass()) {
            PixelMath.divide((ImageFloat32)imgA, (ImageFloat32)imgB, (ImageFloat32)output);
        } else if (ImageFloat64.class == imgA.getClass()) {
            PixelMath.divide((ImageFloat64)imgA, (ImageFloat64)imgB, (ImageFloat64)output);
        } else {
            throw new IllegalArgumentException("Unknown image Type: " + imgA.getClass().getSimpleName());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T extends ImageBase> void multiply(T input, double value, T output) {
        if (input instanceof ImageSingleBand) {
            if (ImageUInt8.class == input.getClass()) {
                PixelMath.multiply((ImageUInt8)input, value, (ImageUInt8)output);
                return;
            } else if (ImageSInt8.class == input.getClass()) {
                PixelMath.multiply((ImageSInt8)input, value, (ImageSInt8)output);
                return;
            } else if (ImageUInt16.class == input.getClass()) {
                PixelMath.multiply((ImageUInt16)input, value, (ImageUInt16)output);
                return;
            } else if (ImageSInt16.class == input.getClass()) {
                PixelMath.multiply((ImageSInt16)input, value, (ImageSInt16)output);
                return;
            } else if (ImageSInt32.class == input.getClass()) {
                PixelMath.multiply((ImageSInt32)input, value, (ImageSInt32)output);
                return;
            } else if (ImageSInt64.class == input.getClass()) {
                PixelMath.multiply((ImageSInt64)input, value, (ImageSInt64)output);
                return;
            } else if (ImageFloat32.class == input.getClass()) {
                PixelMath.multiply((ImageFloat32)input, (float)value, (ImageFloat32)output);
                return;
            } else {
                if (ImageFloat64.class != input.getClass()) throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
                PixelMath.multiply((ImageFloat64)input, value, (ImageFloat64)output);
            }
            return;
        } else if (input instanceof ImageInterleaved) {
            if (InterleavedU8.class == input.getClass()) {
                PixelMath.multiply((InterleavedU8)input, value, (InterleavedU8)output);
                return;
            } else if (InterleavedS8.class == input.getClass()) {
                PixelMath.multiply((InterleavedS8)input, value, (InterleavedS8)output);
                return;
            } else if (InterleavedU16.class == input.getClass()) {
                PixelMath.multiply((InterleavedU16)input, value, (InterleavedU16)output);
                return;
            } else if (InterleavedS16.class == input.getClass()) {
                PixelMath.multiply((InterleavedS16)input, value, (InterleavedS16)output);
                return;
            } else if (InterleavedS32.class == input.getClass()) {
                PixelMath.multiply((InterleavedS32)input, value, (InterleavedS32)output);
                return;
            } else if (InterleavedS64.class == input.getClass()) {
                PixelMath.multiply((InterleavedS64)input, value, (InterleavedS64)output);
                return;
            } else if (InterleavedF32.class == input.getClass()) {
                PixelMath.multiply((InterleavedF32)input, (float)value, (InterleavedF32)output);
                return;
            } else {
                if (InterleavedF64.class != input.getClass()) throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
                PixelMath.multiply((InterleavedF64)input, value, (InterleavedF64)output);
            }
            return;
        } else {
            MultiSpectral in = (MultiSpectral)input;
            MultiSpectral out = (MultiSpectral)output;
            for (int i = 0; i < in.getNumBands(); ++i) {
                GPixelMath.multiply(in.getBand(i), value, out.getBand(i));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T extends ImageBase> void multiply(T input, double value, double lower, double upper, T output) {
        if (input instanceof ImageSingleBand) {
            if (ImageUInt8.class == input.getClass()) {
                PixelMath.multiply((ImageUInt8)input, value, (int)lower, (int)upper, (ImageUInt8)output);
                return;
            } else if (ImageSInt8.class == input.getClass()) {
                PixelMath.multiply((ImageSInt8)input, value, (int)lower, (int)upper, (ImageSInt8)output);
                return;
            } else if (ImageUInt16.class == input.getClass()) {
                PixelMath.multiply((ImageUInt16)input, value, (int)lower, (int)upper, (ImageUInt16)output);
                return;
            } else if (ImageSInt16.class == input.getClass()) {
                PixelMath.multiply((ImageSInt16)input, value, (int)lower, (int)upper, (ImageSInt16)output);
                return;
            } else if (ImageSInt32.class == input.getClass()) {
                PixelMath.multiply((ImageSInt32)input, value, (int)lower, (int)upper, (ImageSInt32)output);
                return;
            } else if (ImageSInt64.class == input.getClass()) {
                PixelMath.multiply((ImageSInt64)input, value, (long)lower, (long)upper, (ImageSInt64)output);
                return;
            } else if (ImageFloat32.class == input.getClass()) {
                PixelMath.multiply((ImageFloat32)input, (float)value, (float)lower, (float)upper, (ImageFloat32)output);
                return;
            } else {
                if (ImageFloat64.class != input.getClass()) throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
                PixelMath.multiply((ImageFloat64)input, value, lower, upper, (ImageFloat64)output);
            }
            return;
        } else if (input instanceof ImageInterleaved) {
            if (InterleavedU8.class == input.getClass()) {
                PixelMath.multiply((InterleavedU8)input, value, (int)lower, (int)upper, (InterleavedU8)output);
                return;
            } else if (InterleavedS8.class == input.getClass()) {
                PixelMath.multiply((InterleavedS8)input, value, (int)lower, (int)upper, (InterleavedS8)output);
                return;
            } else if (InterleavedU16.class == input.getClass()) {
                PixelMath.multiply((InterleavedU16)input, value, (int)lower, (int)upper, (InterleavedU16)output);
                return;
            } else if (InterleavedS16.class == input.getClass()) {
                PixelMath.multiply((InterleavedS16)input, value, (int)lower, (int)upper, (InterleavedS16)output);
                return;
            } else if (InterleavedS32.class == input.getClass()) {
                PixelMath.multiply((InterleavedS32)input, value, (int)lower, (int)upper, (InterleavedS32)output);
                return;
            } else if (InterleavedS64.class == input.getClass()) {
                PixelMath.multiply((InterleavedS64)input, value, (long)lower, (long)upper, (InterleavedS64)output);
                return;
            } else if (InterleavedF32.class == input.getClass()) {
                PixelMath.multiply((InterleavedF32)input, (float)value, (float)lower, (float)upper, (InterleavedF32)output);
                return;
            } else {
                if (InterleavedF64.class != input.getClass()) throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
                PixelMath.multiply((InterleavedF64)input, value, lower, upper, (InterleavedF64)output);
            }
            return;
        } else {
            MultiSpectral in = (MultiSpectral)input;
            MultiSpectral out = (MultiSpectral)output;
            for (int i = 0; i < in.getNumBands(); ++i) {
                GPixelMath.multiply(in.getBand(i), value, lower, upper, out.getBand(i));
            }
        }
    }

    public static <T extends ImageSingleBand> void multiply(T imgA, T imgB, T output) {
        if (ImageFloat32.class == imgA.getClass()) {
            PixelMath.multiply((ImageFloat32)imgA, (ImageFloat32)imgB, (ImageFloat32)output);
        } else if (ImageFloat64.class == imgA.getClass()) {
            PixelMath.multiply((ImageFloat64)imgA, (ImageFloat64)imgB, (ImageFloat64)output);
        } else {
            throw new IllegalArgumentException("Unknown image Type: " + imgA.getClass().getSimpleName());
        }
    }

    public static <T extends ImageSingleBand> void log(T input, T output) {
        if (ImageFloat32.class == input.getClass()) {
            PixelMath.log((ImageFloat32)input, (ImageFloat32)output);
        } else if (ImageFloat64.class == input.getClass()) {
            PixelMath.log((ImageFloat64)input, (ImageFloat64)output);
        } else {
            throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
        }
    }

    public static <T extends ImageSingleBand> void pow2(T input, T output) {
        if (ImageFloat32.class == input.getClass()) {
            PixelMath.pow2((ImageFloat32)input, (ImageFloat32)output);
        } else if (ImageFloat64.class == input.getClass()) {
            PixelMath.pow2((ImageFloat64)input, (ImageFloat64)output);
        } else {
            throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
        }
    }

    public static <T extends ImageSingleBand> void sqrt(T input, T output) {
        if (ImageFloat32.class == input.getClass()) {
            PixelMath.sqrt((ImageFloat32)input, (ImageFloat32)output);
        } else if (ImageFloat64.class == input.getClass()) {
            PixelMath.sqrt((ImageFloat64)input, (ImageFloat64)output);
        } else {
            throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T extends ImageBase> void plus(T input, double value, T output) {
        if (input instanceof ImageSingleBand) {
            if (ImageUInt8.class == input.getClass()) {
                PixelMath.plus((ImageUInt8)input, (int)value, (ImageUInt8)output);
                return;
            } else if (ImageSInt8.class == input.getClass()) {
                PixelMath.plus((ImageSInt8)input, (int)value, (ImageSInt8)output);
                return;
            } else if (ImageUInt16.class == input.getClass()) {
                PixelMath.plus((ImageUInt16)input, (int)value, (ImageUInt16)output);
                return;
            } else if (ImageSInt16.class == input.getClass()) {
                PixelMath.plus((ImageSInt16)input, (int)value, (ImageSInt16)output);
                return;
            } else if (ImageSInt32.class == input.getClass()) {
                PixelMath.plus((ImageSInt32)input, (int)value, (ImageSInt32)output);
                return;
            } else if (ImageSInt64.class == input.getClass()) {
                PixelMath.plus((ImageSInt64)input, (long)value, (ImageSInt64)output);
                return;
            } else if (ImageFloat32.class == input.getClass()) {
                PixelMath.plus((ImageFloat32)input, (float)value, (ImageFloat32)output);
                return;
            } else {
                if (ImageFloat64.class != input.getClass()) throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
                PixelMath.plus((ImageFloat64)input, value, (ImageFloat64)output);
            }
            return;
        } else if (input instanceof ImageInterleaved) {
            if (InterleavedU8.class == input.getClass()) {
                PixelMath.plus((InterleavedU8)input, (int)value, (InterleavedU8)output);
                return;
            } else if (InterleavedS8.class == input.getClass()) {
                PixelMath.plus((InterleavedS8)input, (int)value, (InterleavedS8)output);
                return;
            } else if (InterleavedU16.class == input.getClass()) {
                PixelMath.plus((InterleavedU16)input, (int)value, (InterleavedU16)output);
                return;
            } else if (InterleavedS16.class == input.getClass()) {
                PixelMath.plus((InterleavedS16)input, (int)value, (InterleavedS16)output);
                return;
            } else if (InterleavedS32.class == input.getClass()) {
                PixelMath.plus((InterleavedS32)input, (int)value, (InterleavedS32)output);
                return;
            } else if (InterleavedS64.class == input.getClass()) {
                PixelMath.plus((InterleavedS64)input, (long)value, (InterleavedS64)output);
                return;
            } else if (InterleavedF32.class == input.getClass()) {
                PixelMath.plus((InterleavedF32)input, (float)value, (InterleavedF32)output);
                return;
            } else {
                if (InterleavedF64.class != input.getClass()) throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
                PixelMath.plus((InterleavedF64)input, value, (InterleavedF64)output);
            }
            return;
        } else {
            MultiSpectral in = (MultiSpectral)input;
            MultiSpectral out = (MultiSpectral)output;
            for (int i = 0; i < in.getNumBands(); ++i) {
                GPixelMath.plus(in.getBand(i), value, out.getBand(i));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T extends ImageBase> void plus(T input, double value, double lower, double upper, T output) {
        if (input instanceof ImageSingleBand) {
            if (ImageUInt8.class == input.getClass()) {
                PixelMath.plus((ImageUInt8)input, (int)value, (int)lower, (int)upper, (ImageUInt8)output);
                return;
            } else if (ImageSInt8.class == input.getClass()) {
                PixelMath.plus((ImageSInt8)input, (int)value, (int)lower, (int)upper, (ImageSInt8)output);
                return;
            } else if (ImageUInt16.class == input.getClass()) {
                PixelMath.plus((ImageUInt16)input, (int)value, (int)lower, (int)upper, (ImageUInt16)output);
                return;
            } else if (ImageSInt16.class == input.getClass()) {
                PixelMath.plus((ImageSInt16)input, (int)value, (int)lower, (int)upper, (ImageSInt16)output);
                return;
            } else if (ImageSInt32.class == input.getClass()) {
                PixelMath.plus((ImageSInt32)input, (int)value, (int)lower, (int)upper, (ImageSInt32)output);
                return;
            } else if (ImageSInt64.class == input.getClass()) {
                PixelMath.plus((ImageSInt64)input, (long)value, (long)lower, (long)upper, (ImageSInt64)output);
                return;
            } else if (ImageFloat32.class == input.getClass()) {
                PixelMath.plus((ImageFloat32)input, (float)value, (float)lower, (float)upper, (ImageFloat32)output);
                return;
            } else {
                if (ImageFloat64.class != input.getClass()) throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
                PixelMath.plus((ImageFloat64)input, value, lower, upper, (ImageFloat64)output);
            }
            return;
        } else if (input instanceof ImageInterleaved) {
            if (InterleavedU8.class == input.getClass()) {
                PixelMath.plus((InterleavedU8)input, (int)value, (int)lower, (int)upper, (InterleavedU8)output);
                return;
            } else if (InterleavedS8.class == input.getClass()) {
                PixelMath.plus((InterleavedS8)input, (int)value, (int)lower, (int)upper, (InterleavedS8)output);
                return;
            } else if (InterleavedU16.class == input.getClass()) {
                PixelMath.plus((InterleavedU16)input, (int)value, (int)lower, (int)upper, (InterleavedU16)output);
                return;
            } else if (InterleavedS16.class == input.getClass()) {
                PixelMath.plus((InterleavedS16)input, (int)value, (int)lower, (int)upper, (InterleavedS16)output);
                return;
            } else if (InterleavedS32.class == input.getClass()) {
                PixelMath.plus((InterleavedS32)input, (int)value, (int)lower, (int)upper, (InterleavedS32)output);
                return;
            } else if (InterleavedS64.class == input.getClass()) {
                PixelMath.plus((InterleavedS64)input, (long)value, (long)lower, (long)upper, (InterleavedS64)output);
                return;
            } else if (InterleavedF32.class == input.getClass()) {
                PixelMath.plus((InterleavedF32)input, (float)value, (float)lower, (float)upper, (InterleavedF32)output);
                return;
            } else {
                if (InterleavedF64.class != input.getClass()) throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
                PixelMath.plus((InterleavedF64)input, value, lower, upper, (InterleavedF64)output);
            }
            return;
        } else {
            MultiSpectral in = (MultiSpectral)input;
            MultiSpectral out = (MultiSpectral)output;
            for (int i = 0; i < in.getNumBands(); ++i) {
                GPixelMath.plus(in.getBand(i), value, lower, upper, out.getBand(i));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T extends ImageBase> void minus(T input, double value, T output) {
        if (input instanceof ImageSingleBand) {
            if (ImageUInt8.class == input.getClass()) {
                PixelMath.minus((ImageUInt8)input, (int)value, (ImageUInt8)output);
                return;
            } else if (ImageSInt8.class == input.getClass()) {
                PixelMath.minus((ImageSInt8)input, (int)value, (ImageSInt8)output);
                return;
            } else if (ImageUInt16.class == input.getClass()) {
                PixelMath.minus((ImageUInt16)input, (int)value, (ImageUInt16)output);
                return;
            } else if (ImageSInt16.class == input.getClass()) {
                PixelMath.minus((ImageSInt16)input, (int)value, (ImageSInt16)output);
                return;
            } else if (ImageSInt32.class == input.getClass()) {
                PixelMath.minus((ImageSInt32)input, (int)value, (ImageSInt32)output);
                return;
            } else if (ImageSInt64.class == input.getClass()) {
                PixelMath.minus((ImageSInt64)input, (long)value, (ImageSInt64)output);
                return;
            } else if (ImageFloat32.class == input.getClass()) {
                PixelMath.minus((ImageFloat32)input, (float)value, (ImageFloat32)output);
                return;
            } else {
                if (ImageFloat64.class != input.getClass()) throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
                PixelMath.minus((ImageFloat64)input, value, (ImageFloat64)output);
            }
            return;
        } else if (input instanceof ImageInterleaved) {
            if (InterleavedU8.class == input.getClass()) {
                PixelMath.minus((InterleavedU8)input, (int)value, (InterleavedU8)output);
                return;
            } else if (InterleavedS8.class == input.getClass()) {
                PixelMath.minus((InterleavedS8)input, (int)value, (InterleavedS8)output);
                return;
            } else if (InterleavedU16.class == input.getClass()) {
                PixelMath.minus((InterleavedU16)input, (int)value, (InterleavedU16)output);
                return;
            } else if (InterleavedS16.class == input.getClass()) {
                PixelMath.minus((InterleavedS16)input, (int)value, (InterleavedS16)output);
                return;
            } else if (InterleavedS32.class == input.getClass()) {
                PixelMath.minus((InterleavedS32)input, (int)value, (InterleavedS32)output);
                return;
            } else if (InterleavedS64.class == input.getClass()) {
                PixelMath.minus((InterleavedS64)input, (long)value, (InterleavedS64)output);
                return;
            } else if (InterleavedF32.class == input.getClass()) {
                PixelMath.minus((InterleavedF32)input, (float)value, (InterleavedF32)output);
                return;
            } else {
                if (InterleavedF64.class != input.getClass()) throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
                PixelMath.minus((InterleavedF64)input, value, (InterleavedF64)output);
            }
            return;
        } else {
            MultiSpectral in = (MultiSpectral)input;
            MultiSpectral out = (MultiSpectral)output;
            for (int i = 0; i < in.getNumBands(); ++i) {
                GPixelMath.minus(in.getBand(i), value, out.getBand(i));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T extends ImageBase> void minus(double value, T input, T output) {
        if (input instanceof ImageSingleBand) {
            if (ImageUInt8.class == input.getClass()) {
                PixelMath.minus((int)value, (ImageUInt8)input, (ImageUInt8)output);
                return;
            } else if (ImageSInt8.class == input.getClass()) {
                PixelMath.minus((int)value, (ImageSInt8)input, (ImageSInt8)output);
                return;
            } else if (ImageUInt16.class == input.getClass()) {
                PixelMath.minus((int)value, (ImageUInt16)input, (ImageUInt16)output);
                return;
            } else if (ImageSInt16.class == input.getClass()) {
                PixelMath.minus((int)value, (ImageSInt16)input, (ImageSInt16)output);
                return;
            } else if (ImageSInt32.class == input.getClass()) {
                PixelMath.minus((int)value, (ImageSInt32)input, (ImageSInt32)output);
                return;
            } else if (ImageSInt64.class == input.getClass()) {
                PixelMath.minus((long)value, (ImageSInt64)input, (ImageSInt64)output);
                return;
            } else if (ImageFloat32.class == input.getClass()) {
                PixelMath.minus((float)value, (ImageFloat32)input, (ImageFloat32)output);
                return;
            } else {
                if (ImageFloat64.class != input.getClass()) throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
                PixelMath.minus(value, (ImageFloat64)input, (ImageFloat64)output);
            }
            return;
        } else if (input instanceof ImageInterleaved) {
            if (InterleavedU8.class == input.getClass()) {
                PixelMath.minus((int)value, (InterleavedU8)input, (InterleavedU8)output);
                return;
            } else if (InterleavedS8.class == input.getClass()) {
                PixelMath.minus((int)value, (InterleavedS8)input, (InterleavedS8)output);
                return;
            } else if (InterleavedU16.class == input.getClass()) {
                PixelMath.minus((int)value, (InterleavedU16)input, (InterleavedU16)output);
                return;
            } else if (InterleavedS16.class == input.getClass()) {
                PixelMath.minus((int)value, (InterleavedS16)input, (InterleavedS16)output);
                return;
            } else if (InterleavedS32.class == input.getClass()) {
                PixelMath.minus((int)value, (InterleavedS32)input, (InterleavedS32)output);
                return;
            } else if (InterleavedS64.class == input.getClass()) {
                PixelMath.minus((long)value, (InterleavedS64)input, (InterleavedS64)output);
                return;
            } else if (InterleavedF32.class == input.getClass()) {
                PixelMath.minus((float)value, (InterleavedF32)input, (InterleavedF32)output);
                return;
            } else {
                if (InterleavedF64.class != input.getClass()) throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
                PixelMath.minus(value, (InterleavedF64)input, (InterleavedF64)output);
            }
            return;
        } else {
            MultiSpectral in = (MultiSpectral)input;
            MultiSpectral out = (MultiSpectral)output;
            for (int i = 0; i < in.getNumBands(); ++i) {
                GPixelMath.minus(value, in.getBand(i), out.getBand(i));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T extends ImageBase> void minus(T input, double value, double lower, double upper, T output) {
        if (input instanceof ImageSingleBand) {
            if (ImageUInt8.class == input.getClass()) {
                PixelMath.minus((ImageUInt8)input, (int)value, (int)lower, (int)upper, (ImageUInt8)output);
                return;
            } else if (ImageSInt8.class == input.getClass()) {
                PixelMath.minus((ImageSInt8)input, (int)value, (int)lower, (int)upper, (ImageSInt8)output);
                return;
            } else if (ImageUInt16.class == input.getClass()) {
                PixelMath.minus((ImageUInt16)input, (int)value, (int)lower, (int)upper, (ImageUInt16)output);
                return;
            } else if (ImageSInt16.class == input.getClass()) {
                PixelMath.minus((ImageSInt16)input, (int)value, (int)lower, (int)upper, (ImageSInt16)output);
                return;
            } else if (ImageSInt32.class == input.getClass()) {
                PixelMath.minus((ImageSInt32)input, (int)value, (int)lower, (int)upper, (ImageSInt32)output);
                return;
            } else if (ImageSInt64.class == input.getClass()) {
                PixelMath.minus((ImageSInt64)input, (long)value, (long)lower, (long)upper, (ImageSInt64)output);
                return;
            } else if (ImageFloat32.class == input.getClass()) {
                PixelMath.minus((ImageFloat32)input, (float)value, (float)lower, (float)upper, (ImageFloat32)output);
                return;
            } else {
                if (ImageFloat64.class != input.getClass()) throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
                PixelMath.minus((ImageFloat64)input, value, lower, upper, (ImageFloat64)output);
            }
            return;
        } else if (input instanceof ImageInterleaved) {
            if (InterleavedU8.class == input.getClass()) {
                PixelMath.minus((InterleavedU8)input, (int)value, (int)lower, (int)upper, (InterleavedU8)output);
                return;
            } else if (InterleavedS8.class == input.getClass()) {
                PixelMath.minus((InterleavedS8)input, (int)value, (int)lower, (int)upper, (InterleavedS8)output);
                return;
            } else if (InterleavedU16.class == input.getClass()) {
                PixelMath.minus((InterleavedU16)input, (int)value, (int)lower, (int)upper, (InterleavedU16)output);
                return;
            } else if (InterleavedS16.class == input.getClass()) {
                PixelMath.minus((InterleavedS16)input, (int)value, (int)lower, (int)upper, (InterleavedS16)output);
                return;
            } else if (InterleavedS32.class == input.getClass()) {
                PixelMath.minus((InterleavedS32)input, (int)value, (int)lower, (int)upper, (InterleavedS32)output);
                return;
            } else if (InterleavedS64.class == input.getClass()) {
                PixelMath.minus((InterleavedS64)input, (long)value, (long)lower, (long)upper, (InterleavedS64)output);
                return;
            } else if (InterleavedF32.class == input.getClass()) {
                PixelMath.minus((InterleavedF32)input, (float)value, (float)lower, (float)upper, (InterleavedF32)output);
                return;
            } else {
                if (InterleavedF64.class != input.getClass()) throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
                PixelMath.minus((InterleavedF64)input, value, lower, upper, (InterleavedF64)output);
            }
            return;
        } else {
            MultiSpectral in = (MultiSpectral)input;
            MultiSpectral out = (MultiSpectral)output;
            for (int i = 0; i < in.getNumBands(); ++i) {
                GPixelMath.minus(in.getBand(i), value, lower, upper, out.getBand(i));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T extends ImageBase> void minus(double value, T input, double lower, double upper, T output) {
        if (input instanceof ImageSingleBand) {
            if (ImageUInt8.class == input.getClass()) {
                PixelMath.minus((int)value, (ImageUInt8)input, (int)lower, (int)upper, (ImageUInt8)output);
                return;
            } else if (ImageSInt8.class == input.getClass()) {
                PixelMath.minus((int)value, (ImageSInt8)input, (int)lower, (int)upper, (ImageSInt8)output);
                return;
            } else if (ImageUInt16.class == input.getClass()) {
                PixelMath.minus((int)value, (ImageUInt16)input, (int)lower, (int)upper, (ImageUInt16)output);
                return;
            } else if (ImageSInt16.class == input.getClass()) {
                PixelMath.minus((int)value, (ImageSInt16)input, (int)lower, (int)upper, (ImageSInt16)output);
                return;
            } else if (ImageSInt32.class == input.getClass()) {
                PixelMath.minus((int)value, (ImageSInt32)input, (int)lower, (int)upper, (ImageSInt32)output);
                return;
            } else if (ImageSInt64.class == input.getClass()) {
                PixelMath.minus((long)value, (ImageSInt64)input, (long)lower, (long)upper, (ImageSInt64)output);
                return;
            } else if (ImageFloat32.class == input.getClass()) {
                PixelMath.minus((float)value, (ImageFloat32)input, (float)lower, (float)upper, (ImageFloat32)output);
                return;
            } else {
                if (ImageFloat64.class != input.getClass()) throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
                PixelMath.minus(value, (ImageFloat64)input, lower, upper, (ImageFloat64)output);
            }
            return;
        } else if (input instanceof ImageInterleaved) {
            if (InterleavedU8.class == input.getClass()) {
                PixelMath.minus((int)value, (InterleavedU8)input, (int)lower, (int)upper, (InterleavedU8)output);
                return;
            } else if (InterleavedS8.class == input.getClass()) {
                PixelMath.minus((int)value, (InterleavedS8)input, (int)lower, (int)upper, (InterleavedS8)output);
                return;
            } else if (InterleavedU16.class == input.getClass()) {
                PixelMath.minus((int)value, (InterleavedU16)input, (int)lower, (int)upper, (InterleavedU16)output);
                return;
            } else if (InterleavedS16.class == input.getClass()) {
                PixelMath.minus((int)value, (InterleavedS16)input, (int)lower, (int)upper, (InterleavedS16)output);
                return;
            } else if (InterleavedS32.class == input.getClass()) {
                PixelMath.minus((int)value, (InterleavedS32)input, (int)lower, (int)upper, (InterleavedS32)output);
                return;
            } else if (InterleavedS64.class == input.getClass()) {
                PixelMath.minus((long)value, (InterleavedS64)input, (long)lower, (long)upper, (InterleavedS64)output);
                return;
            } else if (InterleavedF32.class == input.getClass()) {
                PixelMath.minus((float)value, (InterleavedF32)input, (float)lower, (float)upper, (InterleavedF32)output);
                return;
            } else {
                if (InterleavedF64.class != input.getClass()) throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
                PixelMath.minus(value, (InterleavedF64)input, lower, upper, (InterleavedF64)output);
            }
            return;
        } else {
            MultiSpectral in = (MultiSpectral)input;
            MultiSpectral out = (MultiSpectral)output;
            for (int i = 0; i < in.getNumBands(); ++i) {
                GPixelMath.minus(value, in.getBand(i), lower, upper, out.getBand(i));
            }
        }
    }

    public static <T extends ImageSingleBand, O extends ImageSingleBand> void add(T inputA, T inputB, O output) {
        if (ImageUInt8.class == inputA.getClass()) {
            PixelMath.add((ImageUInt8)inputA, (ImageUInt8)inputB, (ImageUInt16)output);
        } else if (ImageSInt8.class == inputA.getClass()) {
            PixelMath.add((ImageSInt8)inputA, (ImageSInt8)inputB, (ImageSInt16)output);
        } else if (ImageUInt16.class == inputA.getClass()) {
            PixelMath.add((ImageUInt16)inputA, (ImageUInt16)inputB, (ImageSInt32)output);
        } else if (ImageSInt16.class == inputA.getClass()) {
            PixelMath.add((ImageSInt16)inputA, (ImageSInt16)inputB, (ImageSInt32)output);
        } else if (ImageSInt32.class == inputA.getClass()) {
            PixelMath.add((ImageSInt32)inputA, (ImageSInt32)inputB, (ImageSInt32)output);
        } else if (ImageSInt64.class == inputA.getClass()) {
            PixelMath.add((ImageSInt64)inputA, (ImageSInt64)inputB, (ImageSInt64)output);
        } else if (ImageFloat32.class == inputA.getClass()) {
            PixelMath.add((ImageFloat32)inputA, (ImageFloat32)inputB, (ImageFloat32)output);
        } else if (ImageFloat64.class == inputA.getClass()) {
            PixelMath.add((ImageFloat64)inputA, (ImageFloat64)inputB, (ImageFloat64)output);
        } else {
            throw new IllegalArgumentException("Unknown image Type: " + inputA.getClass().getSimpleName());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T extends ImageBase, O extends ImageBase> void subtract(T inputA, T inputB, O output) {
        if (!(inputA instanceof ImageSingleBand)) throw new IllegalArgumentException("Unknown image Type: " + inputA.getClass().getSimpleName());
        if (ImageUInt8.class == inputA.getClass()) {
            PixelMath.subtract((ImageUInt8)inputA, (ImageUInt8)inputB, (ImageInt16)output);
            return;
        } else if (ImageSInt8.class == inputA.getClass()) {
            PixelMath.subtract((ImageSInt8)inputA, (ImageSInt8)inputB, (ImageSInt16)output);
            return;
        } else if (ImageUInt16.class == inputA.getClass()) {
            PixelMath.subtract((ImageUInt16)inputA, (ImageUInt16)inputB, (ImageSInt32)output);
            return;
        } else if (ImageSInt16.class == inputA.getClass()) {
            PixelMath.subtract((ImageSInt16)inputA, (ImageSInt16)inputB, (ImageSInt32)output);
            return;
        } else if (ImageSInt32.class == inputA.getClass()) {
            PixelMath.subtract((ImageSInt32)inputA, (ImageSInt32)inputB, (ImageSInt32)output);
            return;
        } else if (ImageSInt64.class == inputA.getClass()) {
            PixelMath.subtract((ImageSInt64)inputA, (ImageSInt64)inputB, (ImageSInt64)output);
            return;
        } else if (ImageFloat32.class == inputA.getClass()) {
            PixelMath.subtract((ImageFloat32)inputA, (ImageFloat32)inputB, (ImageFloat32)output);
            return;
        } else {
            if (ImageFloat64.class != inputA.getClass()) throw new IllegalArgumentException("Unknown image Type: " + inputA.getClass().getSimpleName());
            PixelMath.subtract((ImageFloat64)inputA, (ImageFloat64)inputB, (ImageFloat64)output);
        }
    }

    public static <T extends ImageSingleBand> void boundImage(T input, double min, double max) {
        if (ImageUInt8.class == input.getClass()) {
            PixelMath.boundImage((ImageUInt8)input, (int)min, (int)max);
        } else if (ImageSInt8.class == input.getClass()) {
            PixelMath.boundImage((ImageSInt8)input, (int)min, (int)max);
        } else if (ImageUInt16.class == input.getClass()) {
            PixelMath.boundImage((ImageUInt16)input, (int)min, (int)max);
        } else if (ImageSInt16.class == input.getClass()) {
            PixelMath.boundImage((ImageSInt16)input, (int)min, (int)max);
        } else if (ImageSInt32.class == input.getClass()) {
            PixelMath.boundImage((ImageSInt32)input, (int)min, (int)max);
        } else if (ImageSInt64.class == input.getClass()) {
            PixelMath.boundImage((ImageSInt64)input, (long)min, (long)max);
        } else if (ImageFloat32.class == input.getClass()) {
            PixelMath.boundImage((ImageFloat32)input, (float)min, (float)max);
        } else if (ImageFloat64.class == input.getClass()) {
            PixelMath.boundImage((ImageFloat64)input, min, max);
        } else {
            throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
        }
    }

    public static <T extends ImageSingleBand> void diffAbs(T inputA, T inputB, T output) {
        if (ImageUInt8.class == inputA.getClass()) {
            PixelMath.diffAbs((ImageUInt8)inputA, (ImageUInt8)inputB, (ImageUInt8)output);
        } else if (ImageSInt8.class == inputA.getClass()) {
            PixelMath.diffAbs((ImageSInt8)inputA, (ImageSInt8)inputB, (ImageSInt8)output);
        } else if (ImageUInt16.class == inputA.getClass()) {
            PixelMath.diffAbs((ImageUInt16)inputA, (ImageUInt16)inputB, (ImageUInt16)output);
        } else if (ImageSInt16.class == inputA.getClass()) {
            PixelMath.diffAbs((ImageSInt16)inputA, (ImageSInt16)inputB, (ImageSInt16)output);
        } else if (ImageSInt32.class == inputA.getClass()) {
            PixelMath.diffAbs((ImageSInt32)inputA, (ImageSInt32)inputB, (ImageSInt32)output);
        } else if (ImageSInt64.class == inputA.getClass()) {
            PixelMath.diffAbs((ImageSInt64)inputA, (ImageSInt64)inputB, (ImageSInt64)output);
        } else if (ImageFloat32.class == inputA.getClass()) {
            PixelMath.diffAbs((ImageFloat32)inputA, (ImageFloat32)inputB, (ImageFloat32)output);
        } else if (ImageFloat64.class == inputA.getClass()) {
            PixelMath.diffAbs((ImageFloat64)inputA, (ImageFloat64)inputB, (ImageFloat64)output);
        } else {
            throw new IllegalArgumentException("Unknown image Type: " + inputA.getClass().getSimpleName());
        }
    }

    public static <T extends ImageSingleBand> void averageBand(MultiSpectral<T> input, T output) {
        if (ImageUInt8.class == input.getBandType()) {
            PixelMath.averageBand(input, (ImageUInt8)output);
        } else if (ImageSInt8.class == input.getBandType()) {
            PixelMath.averageBand(input, (ImageSInt8)output);
        } else if (ImageUInt16.class == input.getBandType()) {
            PixelMath.averageBand(input, (ImageUInt16)output);
        } else if (ImageSInt16.class == input.getBandType()) {
            PixelMath.averageBand(input, (ImageSInt16)output);
        } else if (ImageSInt32.class == input.getBandType()) {
            PixelMath.averageBand(input, (ImageSInt32)output);
        } else if (ImageSInt64.class == input.getBandType()) {
            PixelMath.averageBand(input, (ImageSInt64)output);
        } else if (ImageFloat32.class == input.getBandType()) {
            PixelMath.averageBand(input, (ImageFloat32)output);
        } else if (ImageFloat64.class == input.getBandType()) {
            PixelMath.averageBand(input, (ImageFloat64)output);
        } else {
            throw new IllegalArgumentException("Unknown image Type: " + input.getBandType().getSimpleName());
        }
    }
}

