/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.transform.pyramid;

import boofcv.abst.filter.FilterImageInterface;
import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.abst.filter.derivative.ImageHessian;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.alg.transform.pyramid.impl.ImplPyramidOps;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageUInt8;
import boofcv.struct.pyramid.ImagePyramid;
import java.lang.reflect.Array;

public class PyramidOps {
    public static <O extends ImageSingleBand> O[] declareOutput(ImagePyramid<?> pyramid, Class<O> outputType) {
        ImageSingleBand[] ret = (ImageSingleBand[])Array.newInstance(outputType, pyramid.getNumLayers());
        for (int i = 0; i < ret.length; ++i) {
            int w = pyramid.getWidth(i);
            int h = pyramid.getHeight(i);
            ret[i] = GeneralizedImageOps.createSingleBand(outputType, w, h);
        }
        return ret;
    }

    public static <O extends ImageSingleBand> void reshapeOutput(ImagePyramid<?> pyramid, O[] output) {
        for (int i = 0; i < output.length; ++i) {
            int w = pyramid.getWidth(i);
            int h = pyramid.getHeight(i);
            ((ImageSingleBand)output[i]).reshape(w, h);
        }
    }

    public static <I extends ImageSingleBand, O extends ImageSingleBand> void filter(ImagePyramid<I> input, FilterImageInterface<I, O> filter, O[] output) {
        for (int i = 0; i < input.getNumLayers(); ++i) {
            ImageSingleBand imageIn = (ImageSingleBand)input.getLayer(i);
            filter.process(imageIn, output[i]);
        }
    }

    public static <I extends ImageSingleBand, O extends ImageSingleBand> void gradient(ImagePyramid<I> input, ImageGradient<I, O> gradient, O[] derivX, O[] derivY) {
        for (int i = 0; i < input.getNumLayers(); ++i) {
            ImageSingleBand imageIn = (ImageSingleBand)input.getLayer(i);
            gradient.process(imageIn, derivX[i], derivY[i]);
        }
    }

    public static <I extends ImageSingleBand, O extends ImageSingleBand> void hessian(O[] derivX, O[] derivY, ImageHessian<O> hessian, O[] derivXX, O[] derivYY, O[] derivXY) {
        for (int i = 0; i < derivX.length; ++i) {
            hessian.process(derivX[i], derivY[i], derivXX[i], derivYY[i], derivXY[i]);
        }
    }

    public static <T extends ImageSingleBand> void scaleDown2(T input, T output) {
        if (input instanceof ImageFloat32) {
            ImplPyramidOps.scaleDown2((ImageFloat32)input, (ImageFloat32)output);
        } else if (input instanceof ImageUInt8) {
            ImplPyramidOps.scaleDown2((ImageUInt8)input, (ImageUInt8)output);
        } else {
            throw new IllegalArgumentException("Image type not yet supported");
        }
    }

    public static <T extends ImageSingleBand> void scaleImageUp(T input, T output, int scale, InterpolatePixelS<T> interp) {
        if (scale <= 1) {
            throw new IllegalArgumentException("Scale must be >= 2");
        }
        if (input instanceof ImageFloat32) {
            ImplPyramidOps.scaleImageUp((ImageFloat32)input, (ImageFloat32)output, scale, interp);
        } else if (input instanceof ImageUInt8) {
            ImplPyramidOps.scaleImageUp((ImageUInt8)input, (ImageUInt8)output, scale, interp);
        } else {
            throw new IllegalArgumentException("Image type not yet supported");
        }
    }
}

