/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.transform.wavelet.impl;

import boofcv.alg.transform.wavelet.UtilWavelet;
import boofcv.core.image.border.BorderIndex1D;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageInteger;
import boofcv.struct.wavelet.WlBorderCoef;
import boofcv.struct.wavelet.WlCoef_F32;
import boofcv.struct.wavelet.WlCoef_I32;

public class ImplWaveletTransformNaive {
    public static void horizontal(BorderIndex1D border, WlCoef_F32 coefficients, ImageFloat32 input, ImageFloat32 output) {
        UtilWavelet.checkShape(input, output);
        int offsetA = coefficients.offsetScaling;
        int offsetB = coefficients.offsetWavelet;
        float[] alpha = coefficients.scaling;
        float[] beta = coefficients.wavelet;
        border.setLength(input.width + input.width % 2);
        boolean isLarger = output.width > input.width;
        for (int y = 0; y < input.height; ++y) {
            for (int x = 0; x < input.width; x += 2) {
                int xx;
                int i;
                float scale = 0.0f;
                float wavelet = 0.0f;
                for (i = 0; i < alpha.length; ++i) {
                    xx = border.getIndex(x + i + offsetA);
                    if (isLarger && xx >= input.width) continue;
                    scale += input.get(xx, y) * alpha[i];
                }
                for (i = 0; i < beta.length; ++i) {
                    xx = border.getIndex(x + i + offsetB);
                    if (isLarger && xx >= input.width) continue;
                    wavelet += input.get(xx, y) * beta[i];
                }
                int outX = x / 2;
                output.set(outX, y, scale);
                output.set(output.width / 2 + outX, y, wavelet);
            }
        }
    }

    public static void vertical(BorderIndex1D border, WlCoef_F32 coefficients, ImageFloat32 input, ImageFloat32 output) {
        UtilWavelet.checkShape(input, output);
        int offsetA = coefficients.offsetScaling;
        int offsetB = coefficients.offsetWavelet;
        float[] alpha = coefficients.scaling;
        float[] beta = coefficients.wavelet;
        border.setLength(input.height + input.height % 2);
        boolean isLarger = output.height > input.height;
        for (int x = 0; x < input.width; ++x) {
            for (int y = 0; y < input.height; y += 2) {
                int yy;
                int i;
                float scale = 0.0f;
                float wavelet = 0.0f;
                for (i = 0; i < alpha.length; ++i) {
                    yy = border.getIndex(y + i + offsetA);
                    if (isLarger && yy >= input.height) continue;
                    scale += input.get(x, yy) * alpha[i];
                }
                for (i = 0; i < beta.length; ++i) {
                    yy = border.getIndex(y + i + offsetB);
                    if (isLarger && yy >= input.height) continue;
                    wavelet += input.get(x, yy) * beta[i];
                }
                int outY = y / 2;
                output.set(x, outY, scale);
                output.set(x, output.height / 2 + outY, wavelet);
            }
        }
    }

    public static void horizontalInverse(BorderIndex1D border, WlBorderCoef<WlCoef_F32> inverseCoef, ImageFloat32 input, ImageFloat32 output) {
        UtilWavelet.checkShape(output, input);
        float[] trends = new float[output.width];
        float[] details = new float[output.width];
        boolean isLarger = input.width >= output.width;
        int paddedWidth = output.width + output.width % 2;
        int lowerBorder = inverseCoef.getLowerLength() * 2;
        int upperBorder = output.width - inverseCoef.getUpperLength() * 2;
        border.setLength(output.width + output.width % 2);
        for (int y = 0; y < output.height; ++y) {
            int x;
            for (int i = 0; i < details.length; ++i) {
                details[i] = 0.0f;
                trends[i] = 0.0f;
            }
            for (x = 0; x < output.width; x += 2) {
                int xx;
                int i;
                float a = input.get(x / 2, y);
                float d = input.get(input.width / 2 + x / 2, y);
                WlCoef_F32 coefficients = x < lowerBorder ? inverseCoef.getBorderCoefficients(x) : (x >= upperBorder ? inverseCoef.getBorderCoefficients(x - paddedWidth) : inverseCoef.getInnerCoefficients());
                int offsetA = coefficients.offsetScaling;
                int offsetB = coefficients.offsetWavelet;
                float[] alpha = coefficients.scaling;
                float[] beta = coefficients.wavelet;
                for (i = 0; i < alpha.length; ++i) {
                    xx = border.getIndex(x + offsetA + i);
                    if (isLarger && xx >= output.width) continue;
                    int n = xx;
                    trends[n] = trends[n] + a * alpha[i];
                }
                for (i = 0; i < beta.length; ++i) {
                    xx = border.getIndex(x + offsetB + i);
                    if (isLarger && xx >= output.width) continue;
                    int n = xx;
                    details[n] = details[n] + d * beta[i];
                }
            }
            for (x = 0; x < output.width; ++x) {
                output.set(x, y, trends[x] + details[x]);
            }
        }
    }

    public static void verticalInverse(BorderIndex1D border, WlBorderCoef<WlCoef_F32> inverseCoef, ImageFloat32 input, ImageFloat32 output) {
        UtilWavelet.checkShape(output, input);
        float[] trends = new float[output.height];
        float[] details = new float[output.height];
        boolean isLarger = input.height > output.height;
        int paddedHeight = output.height + output.height % 2;
        int lowerBorder = inverseCoef.getLowerLength() * 2;
        int upperBorder = output.height - inverseCoef.getUpperLength() * 2;
        border.setLength(output.height + output.height % 2);
        for (int x = 0; x < output.width; ++x) {
            int y;
            for (int i = 0; i < details.length; ++i) {
                details[i] = 0.0f;
                trends[i] = 0.0f;
            }
            for (y = 0; y < output.height; y += 2) {
                int yy;
                int i;
                float a = input.get(x, y / 2);
                float d = input.get(x, y / 2 + input.height / 2);
                WlCoef_F32 coefficients = y < lowerBorder ? inverseCoef.getBorderCoefficients(y) : (y >= upperBorder ? inverseCoef.getBorderCoefficients(y - paddedHeight) : inverseCoef.getInnerCoefficients());
                int offsetA = coefficients.offsetScaling;
                int offsetB = coefficients.offsetWavelet;
                float[] alpha = coefficients.scaling;
                float[] beta = coefficients.wavelet;
                for (i = 0; i < alpha.length; ++i) {
                    yy = border.getIndex(y + offsetA + i);
                    if (isLarger && yy >= output.height) continue;
                    int n = yy;
                    trends[n] = trends[n] + a * alpha[i];
                }
                for (i = 0; i < beta.length; ++i) {
                    yy = border.getIndex(y + offsetB + i);
                    if (isLarger && yy >= output.height) continue;
                    int n = yy;
                    details[n] = details[n] + d * beta[i];
                }
            }
            for (y = 0; y < output.height; ++y) {
                output.set(x, y, trends[y] + details[y]);
            }
        }
    }

    public static void horizontal(BorderIndex1D border, WlCoef_I32 coefficients, ImageInteger input, ImageInteger output) {
        UtilWavelet.checkShape(input, output);
        int offsetA = coefficients.offsetScaling;
        int offsetB = coefficients.offsetWavelet;
        int[] alpha = coefficients.scaling;
        int[] beta = coefficients.wavelet;
        border.setLength(input.width + input.width % 2);
        boolean isLarger = output.width > input.width;
        for (int y = 0; y < input.height; ++y) {
            for (int x = 0; x < input.width; x += 2) {
                int xx;
                int i;
                int scale = 0;
                int wavelet = 0;
                for (i = 0; i < alpha.length; ++i) {
                    xx = border.getIndex(x + i + offsetA);
                    if (isLarger && xx >= input.width) continue;
                    scale += input.get(xx, y) * alpha[i];
                }
                for (i = 0; i < beta.length; ++i) {
                    xx = border.getIndex(x + i + offsetB);
                    if (isLarger && xx >= input.width) continue;
                    wavelet += input.get(xx, y) * beta[i];
                }
                int outX = x / 2;
                scale = 2 * scale / coefficients.denominatorScaling;
                wavelet = 2 * wavelet / coefficients.denominatorWavelet;
                output.set(outX, y, scale);
                output.set(output.width / 2 + outX, y, wavelet);
            }
        }
    }

    public static void vertical(BorderIndex1D border, WlCoef_I32 coefficients, ImageInteger input, ImageInteger output) {
        UtilWavelet.checkShape(input, output);
        int offsetA = coefficients.offsetScaling;
        int offsetB = coefficients.offsetWavelet;
        int[] alpha = coefficients.scaling;
        int[] beta = coefficients.wavelet;
        border.setLength(input.height + input.height % 2);
        boolean isLarger = output.height > input.height;
        for (int x = 0; x < input.width; ++x) {
            for (int y = 0; y < input.height; y += 2) {
                int yy;
                int i;
                int scale = 0;
                int wavelet = 0;
                for (i = 0; i < alpha.length; ++i) {
                    yy = border.getIndex(y + i + offsetA);
                    if (isLarger && yy >= input.height) continue;
                    scale += input.get(x, yy) * alpha[i];
                }
                for (i = 0; i < beta.length; ++i) {
                    yy = border.getIndex(y + i + offsetB);
                    if (isLarger && yy >= input.height) continue;
                    wavelet += input.get(x, yy) * beta[i];
                }
                int outY = y / 2;
                scale = 2 * scale / coefficients.denominatorScaling;
                wavelet = 2 * wavelet / coefficients.denominatorWavelet;
                output.set(x, outY, scale);
                output.set(x, output.height / 2 + outY, wavelet);
            }
        }
    }

    public static void horizontalInverse(BorderIndex1D border, WlBorderCoef<WlCoef_I32> inverseCoef, ImageInteger input, ImageInteger output) {
        UtilWavelet.checkShape(output, input);
        int[] trends = new int[output.width];
        int[] details = new int[output.width];
        boolean isLarger = input.width >= output.width;
        int paddedWidth = output.width + output.width % 2;
        int lowerBorder = inverseCoef.getLowerLength() * 2;
        int upperBorder = output.width - inverseCoef.getUpperLength() * 2;
        border.setLength(output.width + output.width % 2);
        WlCoef_I32 coefficients = inverseCoef.getInnerCoefficients();
        int e = coefficients.denominatorScaling * 2;
        int f = coefficients.denominatorWavelet * 2;
        int ef = e * f;
        int ef2 = ef / 2;
        for (int y = 0; y < output.height; ++y) {
            int x;
            for (int i = 0; i < details.length; ++i) {
                details[i] = 0;
                trends[i] = 0;
            }
            for (x = 0; x < output.width; x += 2) {
                int xx;
                int i;
                int a = input.get(x / 2, y);
                int d = input.get(input.width / 2 + x / 2, y);
                coefficients = x < lowerBorder ? inverseCoef.getBorderCoefficients(x) : (x >= upperBorder ? inverseCoef.getBorderCoefficients(x - paddedWidth) : inverseCoef.getInnerCoefficients());
                int offsetA = coefficients.offsetScaling;
                int offsetB = coefficients.offsetWavelet;
                int[] alpha = coefficients.scaling;
                int[] beta = coefficients.wavelet;
                for (i = 0; i < alpha.length; ++i) {
                    xx = border.getIndex(x + offsetA + i);
                    if (isLarger && xx >= output.width) continue;
                    int n = xx;
                    trends[n] = trends[n] + a * alpha[i];
                }
                for (i = 0; i < beta.length; ++i) {
                    xx = border.getIndex(x + offsetB + i);
                    if (isLarger && xx >= output.width) continue;
                    int n = xx;
                    details[n] = details[n] + d * beta[i];
                }
            }
            for (x = 0; x < output.width; ++x) {
                output.set(x, y, UtilWavelet.round(trends[x] * f + details[x] * e, ef2, ef));
            }
        }
    }

    public static void verticalInverse(BorderIndex1D border, WlBorderCoef<WlCoef_I32> inverseCoef, ImageInteger input, ImageInteger output) {
        UtilWavelet.checkShape(output, input);
        int[] trends = new int[output.height];
        int[] details = new int[output.height];
        boolean isLarger = input.height > output.height;
        int paddedHeight = output.height + output.height % 2;
        int lowerBorder = inverseCoef.getLowerLength() * 2;
        int upperBorder = output.height - inverseCoef.getUpperLength() * 2;
        border.setLength(output.height + output.height % 2);
        WlCoef_I32 coefficients = inverseCoef.getInnerCoefficients();
        int e = coefficients.denominatorScaling * 2;
        int f = coefficients.denominatorWavelet * 2;
        int ef = e * f;
        int ef2 = ef / 2;
        for (int x = 0; x < output.width; ++x) {
            int y;
            for (int i = 0; i < details.length; ++i) {
                details[i] = 0;
                trends[i] = 0;
            }
            for (y = 0; y < output.height; y += 2) {
                int yy;
                int i;
                int a = input.get(x, y / 2);
                int d = input.get(x, y / 2 + input.height / 2);
                coefficients = y < lowerBorder ? inverseCoef.getBorderCoefficients(y) : (y >= upperBorder ? inverseCoef.getBorderCoefficients(y - paddedHeight) : inverseCoef.getInnerCoefficients());
                int offsetA = coefficients.offsetScaling;
                int offsetB = coefficients.offsetWavelet;
                int[] alpha = coefficients.scaling;
                int[] beta = coefficients.wavelet;
                for (i = 0; i < alpha.length; ++i) {
                    yy = border.getIndex(y + offsetA + i);
                    if (isLarger && yy >= output.height) continue;
                    int n = yy;
                    trends[n] = trends[n] + a * alpha[i];
                }
                for (i = 0; i < beta.length; ++i) {
                    yy = border.getIndex(y + offsetB + i);
                    if (isLarger && yy >= output.height) continue;
                    int n = yy;
                    details[n] = details[n] + d * beta[i];
                }
            }
            for (y = 0; y < output.height; ++y) {
                output.set(x, y, UtilWavelet.round(trends[y] * f + details[y] * e, ef2, ef));
            }
        }
    }
}

