/*
 * Decompiled with CFR 0.152.
 */
package boofcv.core.encoding;

import boofcv.core.encoding.ImplConvertNV21;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageInterleaved;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageUInt8;
import boofcv.struct.image.InterleavedF32;
import boofcv.struct.image.InterleavedU8;
import boofcv.struct.image.MultiSpectral;

public class ConvertNV21 {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void nv21ToBoof(byte[] data, int width, int height, ImageBase output) {
        if (output instanceof MultiSpectral) {
            MultiSpectral ms = (MultiSpectral)output;
            if (ms.getBandType() == ImageUInt8.class) {
                ConvertNV21.nv21ToMsRgb_U8(data, width, height, ms);
                return;
            } else {
                if (ms.getBandType() != ImageFloat32.class) throw new IllegalArgumentException("Unsupported output band format");
                ConvertNV21.nv21ToMsRgb_F32(data, width, height, ms);
            }
            return;
        } else if (output instanceof ImageSingleBand) {
            if (output.getClass() == ImageUInt8.class) {
                ConvertNV21.nv21ToGray(data, width, height, (ImageUInt8)output);
                return;
            } else {
                if (output.getClass() != ImageFloat32.class) throw new IllegalArgumentException("Unsupported output type");
                ConvertNV21.nv21ToGray(data, width, height, (ImageFloat32)output);
            }
            return;
        } else {
            if (!(output instanceof ImageInterleaved)) throw new IllegalArgumentException("Boofcv image type not yet supported");
            if (output.getClass() == InterleavedU8.class) {
                ConvertNV21.nv21ToInterleaved(data, width, height, (InterleavedU8)output);
                return;
            } else {
                if (output.getClass() != InterleavedF32.class) throw new IllegalArgumentException("Unsupported output type");
                ConvertNV21.nv21ToInterleaved(data, width, height, (InterleavedF32)output);
            }
        }
    }

    public static <T extends ImageSingleBand> T nv21ToGray(byte[] data, int width, int height, T output, Class<T> outputType) {
        if (outputType == ImageUInt8.class) {
            return (T)ConvertNV21.nv21ToGray(data, width, height, (ImageUInt8)output);
        }
        if (outputType == ImageFloat32.class) {
            return (T)ConvertNV21.nv21ToGray(data, width, height, (ImageFloat32)output);
        }
        throw new IllegalArgumentException("Unsupported BoofCV Image Type " + outputType.getSimpleName());
    }

    public static ImageUInt8 nv21ToGray(byte[] data, int width, int height, ImageUInt8 output) {
        if (output != null) {
            if (output.width != width || output.height != height) {
                throw new IllegalArgumentException("output width and height must be " + width + " " + height);
            }
        } else {
            output = new ImageUInt8(width, height);
        }
        ImplConvertNV21.nv21ToGray(data, output);
        return output;
    }

    public static ImageFloat32 nv21ToGray(byte[] data, int width, int height, ImageFloat32 output) {
        if (output != null) {
            if (output.width != width || output.height != height) {
                throw new IllegalArgumentException("output width and height must be " + width + " " + height);
            }
        } else {
            output = new ImageFloat32(width, height);
        }
        ImplConvertNV21.nv21ToGray(data, output);
        return output;
    }

    public static <T extends ImageSingleBand> MultiSpectral<T> nv21ToMsYuv(byte[] data, int width, int height, MultiSpectral<T> output, Class<T> outputType) {
        if (outputType == ImageUInt8.class) {
            return ConvertNV21.nv21ToMsYuv_U8(data, width, height, output);
        }
        if (outputType == ImageFloat32.class) {
            return ConvertNV21.nv21ToMsYuv_F32(data, width, height, output);
        }
        throw new IllegalArgumentException("Unsupported BoofCV Image Type " + outputType.getSimpleName());
    }

    public static MultiSpectral<ImageUInt8> nv21ToMsYuv_U8(byte[] data, int width, int height, MultiSpectral<ImageUInt8> output) {
        if (output == null) {
            output = new MultiSpectral<ImageUInt8>(ImageUInt8.class, width, height, 3);
        } else {
            if (output.width != width || output.height != height) {
                throw new IllegalArgumentException("output width and height must be " + width + " " + height);
            }
            if (output.getNumBands() != 3) {
                throw new IllegalArgumentException("three bands expected");
            }
        }
        ImplConvertNV21.nv21ToMultiYuv_U8(data, output);
        return output;
    }

    public static MultiSpectral<ImageUInt8> nv21ToMsRgb_U8(byte[] data, int width, int height, MultiSpectral<ImageUInt8> output) {
        if (output == null) {
            output = new MultiSpectral<ImageUInt8>(ImageUInt8.class, width, height, 3);
        } else {
            if (output.width != width || output.height != height) {
                throw new IllegalArgumentException("output width and height must be " + width + " " + height);
            }
            if (output.getNumBands() != 3) {
                throw new IllegalArgumentException("three bands expected");
            }
        }
        ImplConvertNV21.nv21ToMultiRgb_U8(data, output);
        return output;
    }

    public static InterleavedU8 nv21ToInterleaved(byte[] data, int width, int height, InterleavedU8 output) {
        if (output == null) {
            output = new InterleavedU8(width, height, 3);
        } else {
            if (output.width != width || output.height != height) {
                throw new IllegalArgumentException("output width and height must be " + width + " " + height);
            }
            if (output.getNumBands() != 3) {
                throw new IllegalArgumentException("three bands expected");
            }
        }
        ImplConvertNV21.nv21ToInterleaved_U8(data, output);
        return output;
    }

    public static MultiSpectral<ImageFloat32> nv21ToMsYuv_F32(byte[] data, int width, int height, MultiSpectral<ImageFloat32> output) {
        if (output == null) {
            output = new MultiSpectral<ImageFloat32>(ImageFloat32.class, width, height, 3);
        } else {
            if (output.width != width || output.height != height) {
                throw new IllegalArgumentException("output width and height must be " + width + " " + height);
            }
            if (output.getNumBands() != 3) {
                throw new IllegalArgumentException("three bands expected");
            }
        }
        ImplConvertNV21.nv21ToMultiYuv_F32(data, output);
        return output;
    }

    public static MultiSpectral<ImageFloat32> nv21ToMsRgb_F32(byte[] data, int width, int height, MultiSpectral<ImageFloat32> output) {
        if (output == null) {
            output = new MultiSpectral<ImageFloat32>(ImageFloat32.class, width, height, 3);
        } else {
            if (output.width != width || output.height != height) {
                throw new IllegalArgumentException("output width and height must be " + width + " " + height);
            }
            if (output.getNumBands() != 3) {
                throw new IllegalArgumentException("three bands expected");
            }
        }
        ImplConvertNV21.nv21ToMultiRgb_F32(data, output);
        return output;
    }

    public static InterleavedF32 nv21ToInterleaved(byte[] data, int width, int height, InterleavedF32 output) {
        if (output == null) {
            output = new InterleavedF32(width, height, 3);
        } else {
            if (output.width != width || output.height != height) {
                throw new IllegalArgumentException("output width and height must be " + width + " " + height);
            }
            if (output.getNumBands() != 3) {
                throw new IllegalArgumentException("three bands expected");
            }
        }
        ImplConvertNV21.nv21ToInterleaved_F32(data, output);
        return output;
    }
}

