/*
 * Decompiled with CFR 0.152.
 */
package boofcv.core.encoding;

import boofcv.core.encoding.ImplConvertNV21;
import boofcv.core.encoding.ImplConvertYV12;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageInterleaved;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageUInt8;
import boofcv.struct.image.InterleavedF32;
import boofcv.struct.image.InterleavedU8;
import boofcv.struct.image.MultiSpectral;

public class ConvertYV12 {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void yu12ToBoof(byte[] data, int width, int height, ImageBase output) {
        if (output instanceof MultiSpectral) {
            MultiSpectral ms = (MultiSpectral)output;
            if (ms.getBandType() == ImageUInt8.class) {
                ImplConvertYV12.yv12ToMultiRgb_U8(data, ms);
                return;
            } else {
                if (ms.getBandType() != ImageFloat32.class) throw new IllegalArgumentException("Unsupported output band format");
                ImplConvertYV12.yv12ToMultiRgb_F32(data, ms);
            }
            return;
        } else if (output instanceof ImageSingleBand) {
            if (output.getClass() == ImageUInt8.class) {
                ConvertYV12.yu12ToGray(data, width, height, (ImageUInt8)output);
                return;
            } else {
                if (output.getClass() != ImageFloat32.class) throw new IllegalArgumentException("Unsupported output type");
                ConvertYV12.yu12ToGray(data, width, height, (ImageFloat32)output);
            }
            return;
        } else {
            if (!(output instanceof ImageInterleaved)) throw new IllegalArgumentException("Boofcv image type not yet supported");
            if (output.getClass() == InterleavedU8.class) {
                ImplConvertYV12.yv12ToInterleaved(data, (InterleavedU8)output);
                return;
            } else {
                if (output.getClass() != InterleavedF32.class) throw new IllegalArgumentException("Unsupported output type");
                ImplConvertYV12.yv12ToInterleaved(data, (InterleavedF32)output);
            }
        }
    }

    public static ImageUInt8 yu12ToGray(byte[] data, int width, int height, ImageUInt8 output) {
        if (output != null) {
            if (output.width != width || output.height != height) {
                throw new IllegalArgumentException("output width and height must be " + width + " " + height);
            }
        } else {
            output = new ImageUInt8(width, height);
        }
        ImplConvertNV21.nv21ToGray(data, output);
        return output;
    }

    public static ImageFloat32 yu12ToGray(byte[] data, int width, int height, ImageFloat32 output) {
        if (output != null) {
            if (output.width != width || output.height != height) {
                throw new IllegalArgumentException("output width and height must be " + width + " " + height);
            }
        } else {
            output = new ImageFloat32(width, height);
        }
        ImplConvertNV21.nv21ToGray(data, output);
        return output;
    }
}

