/*
 * Decompiled with CFR 0.152.
 */
package boofcv.core.encoding;

import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageUInt8;
import boofcv.struct.image.InterleavedF32;
import boofcv.struct.image.InterleavedU8;
import boofcv.struct.image.MultiSpectral;

public class ImplConvertYV12 {
    public static void yv12ToMultiRgb_U8(byte[] dataYV, MultiSpectral<ImageUInt8> output) {
        ImageUInt8 R = output.getBand(0);
        ImageUInt8 G = output.getBand(1);
        ImageUInt8 B = output.getBand(2);
        int yStride = output.width;
        int uvStride = output.width / 2;
        int startU = yStride * output.height;
        int offsetV = uvStride * (output.height / 2);
        for (int row = 0; row < output.height; ++row) {
            int indexY = row * yStride;
            int indexU = startU + row / 2 * uvStride;
            int indexOut = output.startIndex + row * output.stride;
            int col = 0;
            while (col < output.width) {
                int y = 1191 * ((dataYV[indexY++] & 0xFF) - 16);
                int cb = (dataYV[indexU] & 0xFF) - 128;
                int cr = (dataYV[indexU + offsetV] & 0xFF) - 128;
                if (y < 0) {
                    y = 0;
                }
                int r = y + 1836 * cr >> 10;
                int g = y - 547 * cr - 218 * cb >> 10;
                int b = y + 2165 * cb >> 10;
                if (r < 0) {
                    r = 0;
                } else if (r > 255) {
                    r = 255;
                }
                if (g < 0) {
                    g = 0;
                } else if (g > 255) {
                    g = 255;
                }
                if (b < 0) {
                    b = 0;
                } else if (b > 255) {
                    b = 255;
                }
                R.data[indexOut] = (byte)r;
                G.data[indexOut] = (byte)g;
                B.data[indexOut] = (byte)b;
                indexU += col & 1;
                ++col;
                ++indexOut;
            }
        }
    }

    public static void yv12ToInterleaved(byte[] dataYV, InterleavedU8 output) {
        int yStride = output.width;
        int uvStride = output.width / 2;
        int startU = yStride * output.height;
        int offsetV = uvStride * (output.height / 2);
        for (int row = 0; row < output.height; ++row) {
            int indexY = row * yStride;
            int indexU = startU + row / 2 * uvStride;
            int indexOut = output.startIndex + row * output.stride;
            for (int col = 0; col < output.width; ++col) {
                int y = 1191 * ((dataYV[indexY++] & 0xFF) - 16);
                int cb = (dataYV[indexU] & 0xFF) - 128;
                int cr = (dataYV[indexU + offsetV] & 0xFF) - 128;
                if (y < 0) {
                    y = 0;
                }
                int r = y + 1836 * cr >> 10;
                int g = y - 547 * cr - 218 * cb >> 10;
                int b = y + 2165 * cb >> 10;
                if (r < 0) {
                    r = 0;
                } else if (r > 255) {
                    r = 255;
                }
                if (g < 0) {
                    g = 0;
                } else if (g > 255) {
                    g = 255;
                }
                if (b < 0) {
                    b = 0;
                } else if (b > 255) {
                    b = 255;
                }
                output.data[indexOut++] = (byte)r;
                output.data[indexOut++] = (byte)g;
                output.data[indexOut++] = (byte)b;
                indexU += col & 1;
            }
        }
    }

    public static void yv12ToMultiRgb_F32(byte[] dataYV, MultiSpectral<ImageFloat32> output) {
        ImageFloat32 R = output.getBand(0);
        ImageFloat32 G = output.getBand(1);
        ImageFloat32 B = output.getBand(2);
        int yStride = output.width;
        int uvStride = output.width / 2;
        int startU = yStride * output.height;
        int offsetV = uvStride * (output.height / 2);
        for (int row = 0; row < output.height; ++row) {
            int indexY = row * yStride;
            int indexU = startU + row / 2 * uvStride;
            int indexOut = output.startIndex + row * output.stride;
            int col = 0;
            while (col < output.width) {
                int y = 1191 * ((dataYV[indexY++] & 0xFF) - 16);
                int cb = (dataYV[indexU] & 0xFF) - 128;
                int cr = (dataYV[indexU + offsetV] & 0xFF) - 128;
                if (y < 0) {
                    y = 0;
                }
                int r = y + 1836 * cr >> 10;
                int g = y - 547 * cr - 218 * cb >> 10;
                int b = y + 2165 * cb >> 10;
                if (r < 0) {
                    r = 0;
                } else if (r > 255) {
                    r = 255;
                }
                if (g < 0) {
                    g = 0;
                } else if (g > 255) {
                    g = 255;
                }
                if (b < 0) {
                    b = 0;
                } else if (b > 255) {
                    b = 255;
                }
                R.data[indexOut] = r;
                G.data[indexOut] = g;
                B.data[indexOut] = b;
                indexU += col & 1;
                ++col;
                ++indexOut;
            }
        }
    }

    public static void yv12ToInterleaved(byte[] dataYV, InterleavedF32 output) {
        int yStride = output.width;
        int uvStride = output.width / 2;
        int startU = yStride * output.height;
        int offsetV = uvStride * (output.height / 2);
        for (int row = 0; row < output.height; ++row) {
            int indexY = row * yStride;
            int indexU = startU + row / 2 * uvStride;
            int indexOut = output.startIndex + row * output.stride;
            for (int col = 0; col < output.width; ++col) {
                int y = 1191 * ((dataYV[indexY++] & 0xFF) - 16);
                int cb = (dataYV[indexU] & 0xFF) - 128;
                int cr = (dataYV[indexU + offsetV] & 0xFF) - 128;
                if (y < 0) {
                    y = 0;
                }
                int r = y + 1836 * cr >> 10;
                int g = y - 547 * cr - 218 * cb >> 10;
                int b = y + 2165 * cb >> 10;
                if (r < 0) {
                    r = 0;
                } else if (r > 255) {
                    r = 255;
                }
                if (g < 0) {
                    g = 0;
                } else if (g > 255) {
                    g = 255;
                }
                if (b < 0) {
                    b = 0;
                } else if (b > 255) {
                    b = 255;
                }
                output.data[indexOut++] = r;
                output.data[indexOut++] = g;
                output.data[indexOut++] = b;
                indexU += col & 1;
            }
        }
    }
}

