/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.distort;

import boofcv.alg.distort.ImageDistort;
import boofcv.alg.distort.impl.ImplImageDistortCache_F32;
import boofcv.alg.distort.impl.ImplImageDistortCache_I16;
import boofcv.alg.distort.impl.ImplImageDistortCache_I8;
import boofcv.alg.distort.impl.ImplImageDistortCache_S32;
import boofcv.alg.distort.impl.ImplImageDistort_F32;
import boofcv.alg.distort.impl.ImplImageDistort_I16;
import boofcv.alg.distort.impl.ImplImageDistort_I8;
import boofcv.alg.distort.impl.ImplImageDistort_IL_F32;
import boofcv.alg.distort.impl.ImplImageDistort_IL_U8;
import boofcv.alg.distort.impl.ImplImageDistort_MS;
import boofcv.alg.distort.impl.ImplImageDistort_S32;
import boofcv.alg.interpolate.InterpolatePixel;
import boofcv.alg.interpolate.InterpolatePixelMB;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageInt16;
import boofcv.struct.image.ImageInt8;
import boofcv.struct.image.ImageInterleaved;
import boofcv.struct.image.ImageSInt32;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.InterleavedU8;
import boofcv.struct.image.MultiSpectral;

public class FactoryDistort {
    public static <Input extends ImageBase, Output extends ImageBase> ImageDistort<Input, Output> distort(boolean cached, InterpolatePixel<Input> interp, ImageType<Output> outputType) {
        switch (outputType.getFamily()) {
            case SINGLE_BAND: {
                return FactoryDistort.distortSB(cached, (InterpolatePixelS)interp, outputType.getImageClass());
            }
            case MULTI_SPECTRAL: {
                return FactoryDistort.distortMS(cached, (InterpolatePixelS)interp, outputType.getImageClass());
            }
            case INTERLEAVED: {
                return FactoryDistort.distortIL(cached, (InterpolatePixelMB)interp, outputType);
            }
        }
        throw new IllegalArgumentException("Unknown image family " + (Object)((Object)outputType.getFamily()));
    }

    public static <Input extends ImageSingleBand, Output extends ImageSingleBand> ImageDistort<Input, Output> distortSB(boolean cached, InterpolatePixelS<Input> interp, Class<Output> outputType) {
        if (cached) {
            if (outputType == ImageFloat32.class) {
                return new ImplImageDistortCache_F32<Input>(interp);
            }
            if (ImageSInt32.class.isAssignableFrom(outputType)) {
                return new ImplImageDistortCache_S32<Input>(interp);
            }
            if (ImageInt16.class.isAssignableFrom(outputType)) {
                return new ImplImageDistortCache_I16(interp);
            }
            if (ImageInt8.class.isAssignableFrom(outputType)) {
                return new ImplImageDistortCache_I8(interp);
            }
            throw new IllegalArgumentException("Output type not supported: " + outputType.getSimpleName());
        }
        if (outputType == ImageFloat32.class) {
            return new ImplImageDistort_F32<Input>(interp);
        }
        if (ImageSInt32.class.isAssignableFrom(outputType)) {
            return new ImplImageDistort_S32<Input>(interp);
        }
        if (ImageInt16.class.isAssignableFrom(outputType)) {
            return new ImplImageDistort_I16(interp);
        }
        if (ImageInt8.class.isAssignableFrom(outputType)) {
            return new ImplImageDistort_I8(interp);
        }
        throw new IllegalArgumentException("Output type not supported: " + outputType.getSimpleName());
    }

    public static <Input extends ImageSingleBand, Output extends ImageSingleBand> ImageDistort<MultiSpectral<Input>, MultiSpectral<Output>> distortMS(boolean cached, InterpolatePixelS<Input> interp, Class<Output> outputType) {
        ImageDistort<Input, Output> distortSingle = FactoryDistort.distortSB(cached, interp, outputType);
        return new ImplImageDistort_MS<Input, Output>(distortSingle);
    }

    public static <Input extends ImageInterleaved, Output extends ImageInterleaved> ImageDistort<Input, Output> distortIL(boolean cached, InterpolatePixelMB<Input> interp, ImageType<Output> outputType) {
        if (cached) {
            throw new IllegalArgumentException("Cached not supported yet");
        }
        switch (outputType.getDataType()) {
            case F32: {
                return new ImplImageDistort_IL_F32(interp);
            }
            case U8: {
                return new ImplImageDistort_IL_U8((InterpolatePixelMB<InterleavedU8>)interp);
            }
        }
        throw new IllegalArgumentException("Not supported yet");
    }
}

