/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.image;

import boofcv.core.image.GeneralizedImageOps;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageDataType;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageFloat64;
import boofcv.struct.image.ImageInt16;
import boofcv.struct.image.ImageInt8;
import boofcv.struct.image.ImageInterleaved;
import boofcv.struct.image.ImageSInt16;
import boofcv.struct.image.ImageSInt32;
import boofcv.struct.image.ImageSInt64;
import boofcv.struct.image.ImageSInt8;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageUInt16;
import boofcv.struct.image.ImageUInt8;
import boofcv.struct.image.InterleavedF32;
import boofcv.struct.image.InterleavedF64;
import boofcv.struct.image.InterleavedI16;
import boofcv.struct.image.InterleavedI8;
import boofcv.struct.image.InterleavedS16;
import boofcv.struct.image.InterleavedS32;
import boofcv.struct.image.InterleavedS64;
import boofcv.struct.image.InterleavedS8;
import boofcv.struct.image.InterleavedU16;
import boofcv.struct.image.InterleavedU8;
import boofcv.struct.image.MultiSpectral;
import java.io.Serializable;
import java.lang.reflect.Array;

public class ImageType<T extends ImageBase>
implements Serializable {
    Family family;
    ImageDataType dataType;
    int numBands;

    public ImageType(Family family, ImageDataType dataType, int numBands) {
        this.family = family;
        this.dataType = dataType;
        this.numBands = numBands;
    }

    public static <I extends ImageSingleBand> ImageType<I> single(Class<I> imageType) {
        return new ImageType(Family.SINGLE_BAND, ImageDataType.classToType(imageType), 1);
    }

    public static <I extends ImageSingleBand> ImageType<I> single(ImageDataType type) {
        return new ImageType(Family.SINGLE_BAND, type, 1);
    }

    public static <I extends ImageSingleBand> ImageType<MultiSpectral<I>> ms(int numBands, Class<I> imageType) {
        return new ImageType<MultiSpectral<I>>(Family.MULTI_SPECTRAL, ImageDataType.classToType(imageType), numBands);
    }

    public static <I extends ImageSingleBand> ImageType<MultiSpectral<I>> ms(int numBands, ImageDataType type) {
        return new ImageType<MultiSpectral<I>>(Family.MULTI_SPECTRAL, type, numBands);
    }

    public static <I extends ImageInterleaved> ImageType<I> il(int numBands, Class<I> imageType) {
        return new ImageType(Family.INTERLEAVED, ImageDataType.classToType(imageType), numBands);
    }

    public static <I extends ImageInterleaved> ImageType<I> il(int numBands, ImageDataType type) {
        return new ImageType(Family.INTERLEAVED, type, numBands);
    }

    public ImageDataType getDataType() {
        return this.dataType;
    }

    public T createImage(int width, int height) {
        switch (this.family) {
            case SINGLE_BAND: {
                return GeneralizedImageOps.createSingleBand(this.getImageClass(), width, height);
            }
            case INTERLEAVED: {
                return GeneralizedImageOps.createInterleaved(this.getImageClass(), width, height, this.numBands);
            }
            case MULTI_SPECTRAL: {
                return (T)new MultiSpectral(this.getImageClass(), width, height, this.numBands);
            }
        }
        throw new IllegalArgumentException("Type not yet supported");
    }

    public T[] createArray(int length) {
        switch (this.family) {
            case SINGLE_BAND: 
            case INTERLEAVED: {
                return (ImageBase[])Array.newInstance(this.getImageClass(), length);
            }
            case MULTI_SPECTRAL: {
                return new MultiSpectral[length];
            }
        }
        throw new IllegalArgumentException("Type not yet supported");
    }

    public int getNumBands() {
        return this.numBands;
    }

    public Family getFamily() {
        return this.family;
    }

    public Class getImageClass() {
        return ImageType.getImageClass(this.family, this.dataType);
    }

    public static Class getImageClass(Family family, ImageDataType dataType) {
        switch (family) {
            case SINGLE_BAND: 
            case MULTI_SPECTRAL: {
                switch (dataType) {
                    case F32: {
                        return ImageFloat32.class;
                    }
                    case F64: {
                        return ImageFloat64.class;
                    }
                    case U8: {
                        return ImageUInt8.class;
                    }
                    case S8: {
                        return ImageSInt8.class;
                    }
                    case U16: {
                        return ImageUInt16.class;
                    }
                    case S16: {
                        return ImageSInt16.class;
                    }
                    case S32: {
                        return ImageSInt32.class;
                    }
                    case S64: {
                        return ImageSInt64.class;
                    }
                    case I8: {
                        return ImageInt8.class;
                    }
                    case I16: {
                        return ImageInt16.class;
                    }
                }
                break;
            }
            case INTERLEAVED: {
                switch (dataType) {
                    case F32: {
                        return InterleavedF32.class;
                    }
                    case F64: {
                        return InterleavedF64.class;
                    }
                    case U8: {
                        return InterleavedU8.class;
                    }
                    case S8: {
                        return InterleavedS8.class;
                    }
                    case U16: {
                        return InterleavedU16.class;
                    }
                    case S16: {
                        return InterleavedS16.class;
                    }
                    case S32: {
                        return InterleavedS32.class;
                    }
                    case S64: {
                        return InterleavedS64.class;
                    }
                    case I8: {
                        return InterleavedI8.class;
                    }
                    case I16: {
                        return InterleavedI16.class;
                    }
                }
            }
        }
        throw new RuntimeException("Support this image type thing");
    }

    public String toString() {
        return "ImageType( " + (Object)((Object)this.family) + " " + (Object)((Object)this.dataType) + " " + this.numBands + " )";
    }

    public static enum Family {
        SINGLE_BAND,
        MULTI_SPECTRAL,
        INTERLEAVED;

    }
}

