/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.filter.blur;

import boofcv.abst.filter.blur.BlurFilter;
import boofcv.alg.filter.blur.GBlurImageOps;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;

public class BlurStorageFilter<T extends ImageGray>
implements BlurFilter<T> {
    private BlurOperation operation;
    private double sigma;
    private int radius;
    private ImageGray storage;
    Class<T> inputType;

    public BlurStorageFilter(String functionName, Class<T> inputType, int radius) {
        this(functionName, inputType, -1.0, radius);
    }

    public BlurStorageFilter(String functionName, Class<T> inputType, double sigma, int radius) {
        this.radius = radius;
        this.sigma = sigma;
        this.inputType = inputType;
        if (functionName.equals("mean")) {
            this.operation = new MeanOperation();
            this.storage = GeneralizedImageOps.createSingleBand(inputType, 1, 1);
        } else if (functionName.equals("gaussian")) {
            this.operation = new GaussianOperation();
            this.storage = GeneralizedImageOps.createSingleBand(inputType, 1, 1);
        } else if (functionName.equals("median")) {
            this.operation = new MedianOperator();
        } else {
            throw new IllegalArgumentException("Unknown function " + functionName);
        }
    }

    @Override
    public int getRadius() {
        return this.radius;
    }

    @Override
    public void setRadius(int radius) {
        this.radius = radius;
    }

    @Override
    public void process(T input, T output) {
        if (this.storage != null) {
            this.storage.reshape(((ImageGray)output).width, ((ImageGray)output).height);
        }
        this.operation.process((ImageBase)input, (ImageBase)output);
    }

    @Override
    public int getHorizontalBorder() {
        return 0;
    }

    @Override
    public int getVerticalBorder() {
        return 0;
    }

    @Override
    public ImageType<T> getInputType() {
        return ImageType.single(this.inputType);
    }

    @Override
    public ImageType<T> getOutputType() {
        return ImageType.single(this.inputType);
    }

    private class MedianOperator
    implements BlurOperation {
        private MedianOperator() {
        }

        @Override
        public void process(ImageBase input, ImageBase output) {
            GBlurImageOps.median(input, output, BlurStorageFilter.this.radius);
        }
    }

    private class GaussianOperation
    implements BlurOperation {
        private GaussianOperation() {
        }

        @Override
        public void process(ImageBase input, ImageBase output) {
            GBlurImageOps.gaussian(input, output, BlurStorageFilter.this.sigma, BlurStorageFilter.this.radius, BlurStorageFilter.this.storage);
        }
    }

    private class MeanOperation
    implements BlurOperation {
        private MeanOperation() {
        }

        @Override
        public void process(ImageBase input, ImageBase output) {
            GBlurImageOps.mean(input, output, BlurStorageFilter.this.radius, BlurStorageFilter.this.storage);
        }
    }

    private static interface BlurOperation {
        public void process(ImageBase var1, ImageBase var2);
    }
}

