/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.filter.derivative;

import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.core.image.border.BorderType;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.Planar;

public class ImageGradient_PL<T extends ImageGray, D extends ImageGray>
implements ImageGradient<Planar<T>, Planar<D>> {
    ImageGradient<T, D> bandGradient;
    ImageType<Planar<D>> derivType;

    public ImageGradient_PL(ImageGradient<T, D> bandGradient, int numBands) {
        this.bandGradient = bandGradient;
        this.derivType = ImageType.pl(numBands, bandGradient.getDerivativeType().getImageClass());
    }

    @Override
    public void process(Planar<T> inputImage, Planar<D> derivX, Planar<D> derivY) {
        for (int i = 0; i < inputImage.getNumBands(); ++i) {
            this.bandGradient.process(inputImage.getBand(i), derivX.getBand(i), derivY.getBand(i));
        }
    }

    @Override
    public void setBorderType(BorderType type) {
        this.bandGradient.setBorderType(type);
    }

    @Override
    public BorderType getBorderType() {
        return this.bandGradient.getBorderType();
    }

    @Override
    public int getBorder() {
        return this.bandGradient.getBorder();
    }

    @Override
    public ImageType<Planar<D>> getDerivativeType() {
        return this.derivType;
    }
}

