/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.image;

import boofcv.struct.image.GrayI;
import boofcv.struct.image.ImageAccessException;
import boofcv.struct.image.ImageDataType;

public class GrayS32
extends GrayI<GrayS32> {
    public int[] data;

    public GrayS32(int width, int height) {
        super(width, height);
    }

    public GrayS32() {
    }

    @Override
    public void unsafe_set(int x, int y, int value) {
        this.data[this.getIndex((int)x, (int)y)] = value;
    }

    @Override
    public int unsafe_get(int x, int y) {
        return this.data[this.getIndex(x, y)];
    }

    @Override
    public void set(int x, int y, int value) {
        if (!this.isInBounds(x, y)) {
            throw new ImageAccessException("Requested pixel is out of bounds");
        }
        this.data[this.getIndex((int)x, (int)y)] = value;
    }

    @Override
    public ImageDataType getDataType() {
        return ImageDataType.S32;
    }

    @Override
    protected Object _getData() {
        return this.data;
    }

    @Override
    protected void _setData(Object data) {
        this.data = (int[])data;
    }

    @Override
    public GrayS32 createNew(int imgWidth, int imgHeight) {
        if (imgWidth == -1 || imgHeight == -1) {
            return new GrayS32();
        }
        return new GrayS32(imgWidth, imgHeight);
    }

    public int[] getData() {
        return this.data;
    }

    public void setData(int[] data) {
        this.data = data;
    }
}

