/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.filter.convolve;

import boofcv.abst.filter.convolve.ConvolveInterface;
import boofcv.core.image.border.BorderType;
import boofcv.core.image.border.FactoryImageBorder;
import boofcv.core.image.border.ImageBorder;
import boofcv.struct.convolve.KernelBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class GenericConvolve<Input extends ImageGray, Output extends ImageGray>
implements ConvolveInterface<Input, Output> {
    Method m;
    KernelBase kernel;
    BorderType type;
    ImageBorder borderRule;
    Class<Input> inputType;
    Class<Output> outputType;

    public GenericConvolve(Method m, KernelBase kernel, BorderType type, Class<Input> inputType, Class<Output> outputType) {
        this.m = m;
        this.kernel = kernel;
        this.type = type;
        this.inputType = inputType;
        this.outputType = outputType;
        Class<?>[] params = m.getParameterTypes();
        this.borderRule = type == BorderType.SKIP || type == BorderType.NORMALIZED ? null : FactoryImageBorder.single(params[1], type);
    }

    @Override
    public void process(Input input, Output output) {
        try {
            if (this.kernel.getDimension() == 1) {
                switch (this.type) {
                    case SKIP: {
                        this.m.invoke(null, this.kernel, input, output);
                        break;
                    }
                    case NORMALIZED: {
                        this.m.invoke(null, this.kernel, input, output);
                        break;
                    }
                    default: {
                        this.m.invoke(null, this.kernel, input, output, this.borderRule);
                        break;
                    }
                }
            } else {
                switch (this.type) {
                    case SKIP: 
                    case NORMALIZED: {
                        this.m.invoke(null, this.kernel, input, output);
                        break;
                    }
                    default: {
                        this.m.invoke(null, this.kernel, input, output, this.borderRule);
                    }
                }
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getHorizontalBorder() {
        if (this.type == BorderType.SKIP) {
            return this.kernel.getRadius();
        }
        return 0;
    }

    @Override
    public BorderType getBorderType() {
        return this.type;
    }

    @Override
    public int getVerticalBorder() {
        return this.getHorizontalBorder();
    }

    @Override
    public ImageType<Input> getInputType() {
        return ImageType.single(this.inputType);
    }

    @Override
    public ImageType<Output> getOutputType() {
        return ImageType.single(this.outputType);
    }
}

