/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.misc;

import boofcv.alg.InputSanityCheck;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayF64;
import boofcv.struct.image.GrayI16;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayS64;
import boofcv.struct.image.GrayS8;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.InterleavedF32;
import boofcv.struct.image.InterleavedF64;
import boofcv.struct.image.InterleavedS16;
import boofcv.struct.image.InterleavedS32;
import boofcv.struct.image.InterleavedS64;
import boofcv.struct.image.InterleavedS8;
import boofcv.struct.image.InterleavedU16;
import boofcv.struct.image.InterleavedU8;
import boofcv.struct.image.Planar;

public class PixelMath {
    public static void abs(GrayS8 input, GrayS8 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.abs(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void abs(InterleavedS8 input, InterleavedS8 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width * input.numBands;
        PixelMath.abs(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void abs(byte[] input, int inputStart, int inputStride, byte[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                output[indexDst] = (byte)Math.abs(input[indexSrc]);
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void abs(GrayS16 input, GrayS16 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.abs(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void abs(InterleavedS16 input, InterleavedS16 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width * input.numBands;
        PixelMath.abs(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void abs(short[] input, int inputStart, int inputStride, short[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                output[indexDst] = (short)Math.abs(input[indexSrc]);
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void abs(GrayS32 input, GrayS32 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.abs(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void abs(InterleavedS32 input, InterleavedS32 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width * input.numBands;
        PixelMath.abs(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void abs(int[] input, int inputStart, int inputStride, int[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                output[indexDst] = Math.abs(input[indexSrc]);
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void abs(GrayS64 input, GrayS64 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.abs(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void abs(InterleavedS64 input, InterleavedS64 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width * input.numBands;
        PixelMath.abs(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void abs(long[] input, int inputStart, int inputStride, long[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                output[indexDst] = Math.abs(input[indexSrc]);
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void abs(GrayF32 input, GrayF32 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.abs(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void abs(InterleavedF32 input, InterleavedF32 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width * input.numBands;
        PixelMath.abs(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void abs(float[] input, int inputStart, int inputStride, float[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                output[indexDst] = Math.abs(input[indexSrc]);
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void abs(GrayF64 input, GrayF64 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.abs(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void abs(InterleavedF64 input, InterleavedF64 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width * input.numBands;
        PixelMath.abs(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void abs(double[] input, int inputStart, int inputStride, double[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                output[indexDst] = Math.abs(input[indexSrc]);
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void invert(GrayS8 input, GrayS8 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.invert(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void invert(InterleavedS8 input, InterleavedS8 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width * input.numBands;
        PixelMath.invert(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void invert(byte[] input, int inputStart, int inputStride, byte[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                output[indexDst] = -input[indexSrc];
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void invert(GrayS16 input, GrayS16 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.invert(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void invert(InterleavedS16 input, InterleavedS16 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width * input.numBands;
        PixelMath.invert(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void invert(short[] input, int inputStart, int inputStride, short[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                output[indexDst] = -input[indexSrc];
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void invert(GrayS32 input, GrayS32 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.invert(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void invert(InterleavedS32 input, InterleavedS32 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width * input.numBands;
        PixelMath.invert(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void invert(int[] input, int inputStart, int inputStride, int[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                output[indexDst] = -input[indexSrc];
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void invert(GrayS64 input, GrayS64 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.invert(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void invert(InterleavedS64 input, InterleavedS64 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width * input.numBands;
        PixelMath.invert(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void invert(long[] input, int inputStart, int inputStride, long[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                output[indexDst] = -input[indexSrc];
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void invert(GrayF32 input, GrayF32 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.invert(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void invert(InterleavedF32 input, InterleavedF32 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width * input.numBands;
        PixelMath.invert(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void invert(float[] input, int inputStart, int inputStride, float[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                output[indexDst] = -input[indexSrc];
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void invert(GrayF64 input, GrayF64 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.invert(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void invert(InterleavedF64 input, InterleavedF64 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width * input.numBands;
        PixelMath.invert(input.data, input.startIndex, input.stride, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void invert(double[] input, int inputStart, int inputStride, double[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                output[indexDst] = -input[indexSrc];
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void multiply(GrayU8 input, double value, GrayU8 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.multiplyU_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void multiply(InterleavedU8 input, double value, InterleavedU8 output) {
        InputSanityCheck.checkSameShapeB(input, output);
        int columns = input.width * input.numBands;
        PixelMath.multiplyU_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void multiplyU_A(byte[] input, int inputStart, int inputStride, double value, byte[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                output[indexDst] = (byte)Math.round((double)(input[indexSrc] & 0xFF) * value);
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void multiply(GrayS8 input, double value, GrayS8 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.multiply_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void multiply(InterleavedS8 input, double value, InterleavedS8 output) {
        InputSanityCheck.checkSameShapeB(input, output);
        int columns = input.width * input.numBands;
        PixelMath.multiply_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void multiply_A(byte[] input, int inputStart, int inputStride, double value, byte[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                output[indexDst] = (byte)Math.round((double)input[indexSrc] * value);
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void multiply(GrayU16 input, double value, GrayU16 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.multiplyU_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void multiply(InterleavedU16 input, double value, InterleavedU16 output) {
        InputSanityCheck.checkSameShapeB(input, output);
        int columns = input.width * input.numBands;
        PixelMath.multiplyU_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void multiplyU_A(short[] input, int inputStart, int inputStride, double value, short[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                output[indexDst] = (short)Math.round((double)(input[indexSrc] & 0xFFFF) * value);
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void multiply(GrayS16 input, double value, GrayS16 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.multiply_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void multiply(InterleavedS16 input, double value, InterleavedS16 output) {
        InputSanityCheck.checkSameShapeB(input, output);
        int columns = input.width * input.numBands;
        PixelMath.multiply_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void multiply_A(short[] input, int inputStart, int inputStride, double value, short[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                output[indexDst] = (short)Math.round((double)input[indexSrc] * value);
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void multiply(GrayS32 input, double value, GrayS32 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.multiply_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void multiply(InterleavedS32 input, double value, InterleavedS32 output) {
        InputSanityCheck.checkSameShapeB(input, output);
        int columns = input.width * input.numBands;
        PixelMath.multiply_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void multiply_A(int[] input, int inputStart, int inputStride, double value, int[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                output[indexDst] = (int)Math.round((double)input[indexSrc] * value);
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void multiply(GrayS64 input, double value, GrayS64 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.multiply_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void multiply(InterleavedS64 input, double value, InterleavedS64 output) {
        InputSanityCheck.checkSameShapeB(input, output);
        int columns = input.width * input.numBands;
        PixelMath.multiply_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void multiply_A(long[] input, int inputStart, int inputStride, double value, long[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                output[indexDst] = Math.round((double)input[indexSrc] * value);
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void multiply(GrayF32 input, float value, GrayF32 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.multiply_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void multiply(InterleavedF32 input, float value, InterleavedF32 output) {
        InputSanityCheck.checkSameShapeB(input, output);
        int columns = input.width * input.numBands;
        PixelMath.multiply_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void multiply_A(float[] input, int inputStart, int inputStride, float value, float[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                output[indexDst] = input[indexSrc] * value;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void multiply(GrayF64 input, double value, GrayF64 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.multiply_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void multiply(InterleavedF64 input, double value, InterleavedF64 output) {
        InputSanityCheck.checkSameShapeB(input, output);
        int columns = input.width * input.numBands;
        PixelMath.multiply_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void multiply_A(double[] input, int inputStart, int inputStride, double value, double[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                output[indexDst] = input[indexSrc] * value;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void multiply(GrayU8 input, double value, int lower, int upper, GrayU8 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.multiplyU_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void multiply(InterleavedU8 input, double value, int lower, int upper, InterleavedU8 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width * input.numBands;
        PixelMath.multiplyU_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void multiplyU_A(byte[] input, int inputStart, int inputStride, double value, int lower, int upper, byte[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                int val = (int)Math.round((double)(input[indexSrc] & 0xFF) * value);
                if (val < lower) {
                    val = lower;
                }
                if (val > upper) {
                    val = upper;
                }
                output[indexDst] = (byte)val;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void multiply(GrayS8 input, double value, int lower, int upper, GrayS8 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.multiply_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void multiply(InterleavedS8 input, double value, int lower, int upper, InterleavedS8 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width * input.numBands;
        PixelMath.multiply_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void multiply_A(byte[] input, int inputStart, int inputStride, double value, int lower, int upper, byte[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                int val = (int)Math.round((double)input[indexSrc] * value);
                if (val < lower) {
                    val = lower;
                }
                if (val > upper) {
                    val = upper;
                }
                output[indexDst] = (byte)val;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void multiply(GrayU16 input, double value, int lower, int upper, GrayU16 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.multiplyU_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void multiply(InterleavedU16 input, double value, int lower, int upper, InterleavedU16 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width * input.numBands;
        PixelMath.multiplyU_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void multiplyU_A(short[] input, int inputStart, int inputStride, double value, int lower, int upper, short[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                int val = (int)Math.round((double)(input[indexSrc] & 0xFFFF) * value);
                if (val < lower) {
                    val = lower;
                }
                if (val > upper) {
                    val = upper;
                }
                output[indexDst] = (short)val;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void multiply(GrayS16 input, double value, int lower, int upper, GrayS16 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.multiply_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void multiply(InterleavedS16 input, double value, int lower, int upper, InterleavedS16 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width * input.numBands;
        PixelMath.multiply_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void multiply_A(short[] input, int inputStart, int inputStride, double value, int lower, int upper, short[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                int val = (int)Math.round((double)input[indexSrc] * value);
                if (val < lower) {
                    val = lower;
                }
                if (val > upper) {
                    val = upper;
                }
                output[indexDst] = (short)val;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void multiply(GrayS32 input, double value, int lower, int upper, GrayS32 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.multiply_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void multiply(InterleavedS32 input, double value, int lower, int upper, InterleavedS32 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width * input.numBands;
        PixelMath.multiply_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void multiply_A(int[] input, int inputStart, int inputStride, double value, int lower, int upper, int[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                int val = (int)Math.round((double)input[indexSrc] * value);
                if (val < lower) {
                    val = lower;
                }
                if (val > upper) {
                    val = upper;
                }
                output[indexDst] = val;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void multiply(GrayS64 input, double value, long lower, long upper, GrayS64 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.multiply_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void multiply(InterleavedS64 input, double value, long lower, long upper, InterleavedS64 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width * input.numBands;
        PixelMath.multiply_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void multiply_A(long[] input, int inputStart, int inputStride, double value, long lower, long upper, long[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                long val = Math.round((double)input[indexSrc] * value);
                if (val < lower) {
                    val = lower;
                }
                if (val > upper) {
                    val = upper;
                }
                output[indexDst] = val;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void multiply(GrayF32 input, float value, float lower, float upper, GrayF32 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.multiply_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void multiply(InterleavedF32 input, float value, float lower, float upper, InterleavedF32 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width * input.numBands;
        PixelMath.multiply_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void multiply_A(float[] input, int inputStart, int inputStride, float value, float lower, float upper, float[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                float val = input[indexSrc] * value;
                if (val < lower) {
                    val = lower;
                }
                if (val > upper) {
                    val = upper;
                }
                output[indexDst] = val;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void multiply(GrayF64 input, double value, double lower, double upper, GrayF64 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.multiply_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void multiply(InterleavedF64 input, double value, double lower, double upper, InterleavedF64 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width * input.numBands;
        PixelMath.multiply_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void multiply_A(double[] input, int inputStart, int inputStride, double value, double lower, double upper, double[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                double val = input[indexSrc] * value;
                if (val < lower) {
                    val = lower;
                }
                if (val > upper) {
                    val = upper;
                }
                output[indexDst] = val;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void divide(GrayU8 input, double denominator, GrayU8 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.divideU_A(input.data, input.startIndex, input.stride, denominator, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void divide(InterleavedU8 input, double denominator, InterleavedU8 output) {
        InputSanityCheck.checkSameShapeB(input, output);
        int columns = input.width * input.numBands;
        PixelMath.divideU_A(input.data, input.startIndex, input.stride, denominator, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void divideU_A(byte[] input, int inputStart, int inputStride, double denominator, byte[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                output[indexDst] = (byte)Math.round((double)(input[indexSrc] & 0xFF) / denominator);
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void divide(GrayS8 input, double denominator, GrayS8 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.divide_A(input.data, input.startIndex, input.stride, denominator, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void divide(InterleavedS8 input, double denominator, InterleavedS8 output) {
        InputSanityCheck.checkSameShapeB(input, output);
        int columns = input.width * input.numBands;
        PixelMath.divide_A(input.data, input.startIndex, input.stride, denominator, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void divide_A(byte[] input, int inputStart, int inputStride, double denominator, byte[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                output[indexDst] = (byte)Math.round((double)input[indexSrc] / denominator);
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void divide(GrayU16 input, double denominator, GrayU16 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.divideU_A(input.data, input.startIndex, input.stride, denominator, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void divide(InterleavedU16 input, double denominator, InterleavedU16 output) {
        InputSanityCheck.checkSameShapeB(input, output);
        int columns = input.width * input.numBands;
        PixelMath.divideU_A(input.data, input.startIndex, input.stride, denominator, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void divideU_A(short[] input, int inputStart, int inputStride, double denominator, short[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                output[indexDst] = (short)Math.round((double)(input[indexSrc] & 0xFFFF) / denominator);
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void divide(GrayS16 input, double denominator, GrayS16 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.divide_A(input.data, input.startIndex, input.stride, denominator, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void divide(InterleavedS16 input, double denominator, InterleavedS16 output) {
        InputSanityCheck.checkSameShapeB(input, output);
        int columns = input.width * input.numBands;
        PixelMath.divide_A(input.data, input.startIndex, input.stride, denominator, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void divide_A(short[] input, int inputStart, int inputStride, double denominator, short[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                output[indexDst] = (short)Math.round((double)input[indexSrc] / denominator);
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void divide(GrayS32 input, double denominator, GrayS32 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.divide_A(input.data, input.startIndex, input.stride, denominator, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void divide(InterleavedS32 input, double denominator, InterleavedS32 output) {
        InputSanityCheck.checkSameShapeB(input, output);
        int columns = input.width * input.numBands;
        PixelMath.divide_A(input.data, input.startIndex, input.stride, denominator, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void divide_A(int[] input, int inputStart, int inputStride, double denominator, int[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                output[indexDst] = (int)Math.round((double)input[indexSrc] / denominator);
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void divide(GrayS64 input, double denominator, GrayS64 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.divide_A(input.data, input.startIndex, input.stride, denominator, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void divide(InterleavedS64 input, double denominator, InterleavedS64 output) {
        InputSanityCheck.checkSameShapeB(input, output);
        int columns = input.width * input.numBands;
        PixelMath.divide_A(input.data, input.startIndex, input.stride, denominator, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void divide_A(long[] input, int inputStart, int inputStride, double denominator, long[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                output[indexDst] = Math.round((double)input[indexSrc] / denominator);
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void divide(GrayF32 input, float denominator, GrayF32 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.divide_A(input.data, input.startIndex, input.stride, denominator, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void divide(InterleavedF32 input, float denominator, InterleavedF32 output) {
        InputSanityCheck.checkSameShapeB(input, output);
        int columns = input.width * input.numBands;
        PixelMath.divide_A(input.data, input.startIndex, input.stride, denominator, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void divide_A(float[] input, int inputStart, int inputStride, float denominator, float[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                output[indexDst] = input[indexSrc] / denominator;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void divide(GrayF64 input, double denominator, GrayF64 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.divide_A(input.data, input.startIndex, input.stride, denominator, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void divide(InterleavedF64 input, double denominator, InterleavedF64 output) {
        InputSanityCheck.checkSameShapeB(input, output);
        int columns = input.width * input.numBands;
        PixelMath.divide_A(input.data, input.startIndex, input.stride, denominator, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void divide_A(double[] input, int inputStart, int inputStride, double denominator, double[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                output[indexDst] = input[indexSrc] / denominator;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void divide(GrayU8 input, double denominator, int lower, int upper, GrayU8 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.divideU_A(input.data, input.startIndex, input.stride, denominator, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void divide(InterleavedU8 input, double denominator, int lower, int upper, InterleavedU8 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width * input.numBands;
        PixelMath.divideU_A(input.data, input.startIndex, input.stride, denominator, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void divideU_A(byte[] input, int inputStart, int inputStride, double denominator, int lower, int upper, byte[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                int val = (int)Math.round((double)(input[indexSrc] & 0xFF) / denominator);
                if (val < lower) {
                    val = lower;
                }
                if (val > upper) {
                    val = upper;
                }
                output[indexDst] = (byte)val;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void divide(GrayS8 input, double denominator, int lower, int upper, GrayS8 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.divide_A(input.data, input.startIndex, input.stride, denominator, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void divide(InterleavedS8 input, double denominator, int lower, int upper, InterleavedS8 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width * input.numBands;
        PixelMath.divide_A(input.data, input.startIndex, input.stride, denominator, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void divide_A(byte[] input, int inputStart, int inputStride, double denominator, int lower, int upper, byte[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                int val = (int)Math.round((double)input[indexSrc] / denominator);
                if (val < lower) {
                    val = lower;
                }
                if (val > upper) {
                    val = upper;
                }
                output[indexDst] = (byte)val;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void divide(GrayU16 input, double denominator, int lower, int upper, GrayU16 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.divideU_A(input.data, input.startIndex, input.stride, denominator, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void divide(InterleavedU16 input, double denominator, int lower, int upper, InterleavedU16 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width * input.numBands;
        PixelMath.divideU_A(input.data, input.startIndex, input.stride, denominator, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void divideU_A(short[] input, int inputStart, int inputStride, double denominator, int lower, int upper, short[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                int val = (int)Math.round((double)(input[indexSrc] & 0xFFFF) / denominator);
                if (val < lower) {
                    val = lower;
                }
                if (val > upper) {
                    val = upper;
                }
                output[indexDst] = (short)val;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void divide(GrayS16 input, double denominator, int lower, int upper, GrayS16 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.divide_A(input.data, input.startIndex, input.stride, denominator, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void divide(InterleavedS16 input, double denominator, int lower, int upper, InterleavedS16 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width * input.numBands;
        PixelMath.divide_A(input.data, input.startIndex, input.stride, denominator, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void divide_A(short[] input, int inputStart, int inputStride, double denominator, int lower, int upper, short[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                int val = (int)Math.round((double)input[indexSrc] / denominator);
                if (val < lower) {
                    val = lower;
                }
                if (val > upper) {
                    val = upper;
                }
                output[indexDst] = (short)val;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void divide(GrayS32 input, double denominator, int lower, int upper, GrayS32 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.divide_A(input.data, input.startIndex, input.stride, denominator, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void divide(InterleavedS32 input, double denominator, int lower, int upper, InterleavedS32 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width * input.numBands;
        PixelMath.divide_A(input.data, input.startIndex, input.stride, denominator, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void divide_A(int[] input, int inputStart, int inputStride, double denominator, int lower, int upper, int[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                int val = (int)Math.round((double)input[indexSrc] / denominator);
                if (val < lower) {
                    val = lower;
                }
                if (val > upper) {
                    val = upper;
                }
                output[indexDst] = val;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void divide(GrayS64 input, double denominator, long lower, long upper, GrayS64 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.divide_A(input.data, input.startIndex, input.stride, denominator, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void divide(InterleavedS64 input, double denominator, long lower, long upper, InterleavedS64 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width * input.numBands;
        PixelMath.divide_A(input.data, input.startIndex, input.stride, denominator, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void divide_A(long[] input, int inputStart, int inputStride, double denominator, long lower, long upper, long[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                long val = Math.round((double)input[indexSrc] / denominator);
                if (val < lower) {
                    val = lower;
                }
                if (val > upper) {
                    val = upper;
                }
                output[indexDst] = val;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void divide(GrayF32 input, float denominator, float lower, float upper, GrayF32 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.divide_A(input.data, input.startIndex, input.stride, denominator, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void divide(InterleavedF32 input, float denominator, float lower, float upper, InterleavedF32 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width * input.numBands;
        PixelMath.divide_A(input.data, input.startIndex, input.stride, denominator, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void divide_A(float[] input, int inputStart, int inputStride, float denominator, float lower, float upper, float[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                float val = input[indexSrc] / denominator;
                if (val < lower) {
                    val = lower;
                }
                if (val > upper) {
                    val = upper;
                }
                output[indexDst] = val;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void divide(GrayF64 input, double denominator, double lower, double upper, GrayF64 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.divide_A(input.data, input.startIndex, input.stride, denominator, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void divide(InterleavedF64 input, double denominator, double lower, double upper, InterleavedF64 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width * input.numBands;
        PixelMath.divide_A(input.data, input.startIndex, input.stride, denominator, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void divide_A(double[] input, int inputStart, int inputStride, double denominator, double lower, double upper, double[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                double val = input[indexSrc] / denominator;
                if (val < lower) {
                    val = lower;
                }
                if (val > upper) {
                    val = upper;
                }
                output[indexDst] = val;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void plus(GrayU8 input, int value, GrayU8 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.plusU_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void plus(InterleavedU8 input, int value, InterleavedU8 output) {
        InputSanityCheck.checkSameShapeB(input, output);
        int columns = input.width * input.numBands;
        PixelMath.plusU_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void plusU_A(byte[] input, int inputStart, int inputStride, int value, byte[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                output[indexDst] = (byte)((input[indexSrc] & 0xFF) + value);
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void plus(GrayS8 input, int value, GrayS8 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.plus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void plus(InterleavedS8 input, int value, InterleavedS8 output) {
        InputSanityCheck.checkSameShapeB(input, output);
        int columns = input.width * input.numBands;
        PixelMath.plus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void plus_A(byte[] input, int inputStart, int inputStride, int value, byte[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                output[indexDst] = (byte)(input[indexSrc] + value);
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void plus(GrayU16 input, int value, GrayU16 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.plusU_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void plus(InterleavedU16 input, int value, InterleavedU16 output) {
        InputSanityCheck.checkSameShapeB(input, output);
        int columns = input.width * input.numBands;
        PixelMath.plusU_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void plusU_A(short[] input, int inputStart, int inputStride, int value, short[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                output[indexDst] = (short)((input[indexSrc] & 0xFFFF) + value);
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void plus(GrayS16 input, int value, GrayS16 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.plus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void plus(InterleavedS16 input, int value, InterleavedS16 output) {
        InputSanityCheck.checkSameShapeB(input, output);
        int columns = input.width * input.numBands;
        PixelMath.plus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void plus_A(short[] input, int inputStart, int inputStride, int value, short[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                output[indexDst] = (short)(input[indexSrc] + value);
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void plus(GrayS32 input, int value, GrayS32 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.plus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void plus(InterleavedS32 input, int value, InterleavedS32 output) {
        InputSanityCheck.checkSameShapeB(input, output);
        int columns = input.width * input.numBands;
        PixelMath.plus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void plus_A(int[] input, int inputStart, int inputStride, int value, int[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                output[indexDst] = input[indexSrc] + value;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void plus(GrayS64 input, long value, GrayS64 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.plus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void plus(InterleavedS64 input, long value, InterleavedS64 output) {
        InputSanityCheck.checkSameShapeB(input, output);
        int columns = input.width * input.numBands;
        PixelMath.plus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void plus_A(long[] input, int inputStart, int inputStride, long value, long[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                output[indexDst] = input[indexSrc] + value;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void plus(GrayF32 input, float value, GrayF32 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.plus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void plus(InterleavedF32 input, float value, InterleavedF32 output) {
        InputSanityCheck.checkSameShapeB(input, output);
        int columns = input.width * input.numBands;
        PixelMath.plus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void plus_A(float[] input, int inputStart, int inputStride, float value, float[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                output[indexDst] = input[indexSrc] + value;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void plus(GrayF64 input, double value, GrayF64 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.plus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void plus(InterleavedF64 input, double value, InterleavedF64 output) {
        InputSanityCheck.checkSameShapeB(input, output);
        int columns = input.width * input.numBands;
        PixelMath.plus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void plus_A(double[] input, int inputStart, int inputStride, double value, double[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                output[indexDst] = input[indexSrc] + value;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void plus(GrayU8 input, int value, int lower, int upper, GrayU8 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.plusU_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void plus(InterleavedU8 input, int value, int lower, int upper, InterleavedU8 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width * input.numBands;
        PixelMath.plusU_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void plusU_A(byte[] input, int inputStart, int inputStride, int value, int lower, int upper, byte[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                int val = (input[indexSrc] & 0xFF) + value;
                if (val < lower) {
                    val = lower;
                }
                if (val > upper) {
                    val = upper;
                }
                output[indexDst] = (byte)val;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void plus(GrayS8 input, int value, int lower, int upper, GrayS8 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.plus_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void plus(InterleavedS8 input, int value, int lower, int upper, InterleavedS8 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width * input.numBands;
        PixelMath.plus_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void plus_A(byte[] input, int inputStart, int inputStride, int value, int lower, int upper, byte[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                int val = input[indexSrc] + value;
                if (val < lower) {
                    val = lower;
                }
                if (val > upper) {
                    val = upper;
                }
                output[indexDst] = (byte)val;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void plus(GrayU16 input, int value, int lower, int upper, GrayU16 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.plusU_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void plus(InterleavedU16 input, int value, int lower, int upper, InterleavedU16 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width * input.numBands;
        PixelMath.plusU_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void plusU_A(short[] input, int inputStart, int inputStride, int value, int lower, int upper, short[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                int val = (input[indexSrc] & 0xFFFF) + value;
                if (val < lower) {
                    val = lower;
                }
                if (val > upper) {
                    val = upper;
                }
                output[indexDst] = (short)val;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void plus(GrayS16 input, int value, int lower, int upper, GrayS16 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.plus_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void plus(InterleavedS16 input, int value, int lower, int upper, InterleavedS16 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width * input.numBands;
        PixelMath.plus_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void plus_A(short[] input, int inputStart, int inputStride, int value, int lower, int upper, short[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                int val = input[indexSrc] + value;
                if (val < lower) {
                    val = lower;
                }
                if (val > upper) {
                    val = upper;
                }
                output[indexDst] = (short)val;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void plus(GrayS32 input, int value, int lower, int upper, GrayS32 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.plus_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void plus(InterleavedS32 input, int value, int lower, int upper, InterleavedS32 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width * input.numBands;
        PixelMath.plus_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void plus_A(int[] input, int inputStart, int inputStride, int value, int lower, int upper, int[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                int val = input[indexSrc] + value;
                if (val < lower) {
                    val = lower;
                }
                if (val > upper) {
                    val = upper;
                }
                output[indexDst] = val;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void plus(GrayS64 input, long value, long lower, long upper, GrayS64 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.plus_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void plus(InterleavedS64 input, long value, long lower, long upper, InterleavedS64 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width * input.numBands;
        PixelMath.plus_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void plus_A(long[] input, int inputStart, int inputStride, long value, long lower, long upper, long[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                long val = input[indexSrc] + value;
                if (val < lower) {
                    val = lower;
                }
                if (val > upper) {
                    val = upper;
                }
                output[indexDst] = val;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void plus(GrayF32 input, float value, float lower, float upper, GrayF32 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.plus_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void plus(InterleavedF32 input, float value, float lower, float upper, InterleavedF32 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width * input.numBands;
        PixelMath.plus_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void plus_A(float[] input, int inputStart, int inputStride, float value, float lower, float upper, float[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                float val = input[indexSrc] + value;
                if (val < lower) {
                    val = lower;
                }
                if (val > upper) {
                    val = upper;
                }
                output[indexDst] = val;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void plus(GrayF64 input, double value, double lower, double upper, GrayF64 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.plus_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void plus(InterleavedF64 input, double value, double lower, double upper, InterleavedF64 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width * input.numBands;
        PixelMath.plus_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void plus_A(double[] input, int inputStart, int inputStride, double value, double lower, double upper, double[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                double val = input[indexSrc] + value;
                if (val < lower) {
                    val = lower;
                }
                if (val > upper) {
                    val = upper;
                }
                output[indexDst] = val;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void minus(GrayU8 input, int value, GrayU8 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.minusU_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void minus(InterleavedU8 input, int value, InterleavedU8 output) {
        InputSanityCheck.checkSameShapeB(input, output);
        int columns = input.width * input.numBands;
        PixelMath.minusU_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void minusU_A(byte[] input, int inputStart, int inputStride, int value, byte[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                output[indexDst] = (byte)((input[indexSrc] & 0xFF) - value);
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void minus(GrayS8 input, int value, GrayS8 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.minus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void minus(InterleavedS8 input, int value, InterleavedS8 output) {
        InputSanityCheck.checkSameShapeB(input, output);
        int columns = input.width * input.numBands;
        PixelMath.minus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void minus_A(byte[] input, int inputStart, int inputStride, int value, byte[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                output[indexDst] = (byte)(input[indexSrc] - value);
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void minus(GrayU16 input, int value, GrayU16 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.minusU_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void minus(InterleavedU16 input, int value, InterleavedU16 output) {
        InputSanityCheck.checkSameShapeB(input, output);
        int columns = input.width * input.numBands;
        PixelMath.minusU_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void minusU_A(short[] input, int inputStart, int inputStride, int value, short[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                output[indexDst] = (short)((input[indexSrc] & 0xFFFF) - value);
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void minus(GrayS16 input, int value, GrayS16 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.minus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void minus(InterleavedS16 input, int value, InterleavedS16 output) {
        InputSanityCheck.checkSameShapeB(input, output);
        int columns = input.width * input.numBands;
        PixelMath.minus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void minus_A(short[] input, int inputStart, int inputStride, int value, short[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                output[indexDst] = (short)(input[indexSrc] - value);
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void minus(GrayS32 input, int value, GrayS32 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.minus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void minus(InterleavedS32 input, int value, InterleavedS32 output) {
        InputSanityCheck.checkSameShapeB(input, output);
        int columns = input.width * input.numBands;
        PixelMath.minus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void minus_A(int[] input, int inputStart, int inputStride, int value, int[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                output[indexDst] = input[indexSrc] - value;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void minus(GrayS64 input, long value, GrayS64 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.minus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void minus(InterleavedS64 input, long value, InterleavedS64 output) {
        InputSanityCheck.checkSameShapeB(input, output);
        int columns = input.width * input.numBands;
        PixelMath.minus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void minus_A(long[] input, int inputStart, int inputStride, long value, long[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                output[indexDst] = input[indexSrc] - value;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void minus(GrayF32 input, float value, GrayF32 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.minus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void minus(InterleavedF32 input, float value, InterleavedF32 output) {
        InputSanityCheck.checkSameShapeB(input, output);
        int columns = input.width * input.numBands;
        PixelMath.minus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void minus_A(float[] input, int inputStart, int inputStride, float value, float[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                output[indexDst] = input[indexSrc] - value;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void minus(GrayF64 input, double value, GrayF64 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.minus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void minus(InterleavedF64 input, double value, InterleavedF64 output) {
        InputSanityCheck.checkSameShapeB(input, output);
        int columns = input.width * input.numBands;
        PixelMath.minus_A(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void minus_A(double[] input, int inputStart, int inputStride, double value, double[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                output[indexDst] = input[indexSrc] - value;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void minus(GrayU8 input, int value, int lower, int upper, GrayU8 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.minusU_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void minus(InterleavedU8 input, int value, int lower, int upper, InterleavedU8 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width * input.numBands;
        PixelMath.minusU_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void minusU_A(byte[] input, int inputStart, int inputStride, int value, int lower, int upper, byte[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                int val = (input[indexSrc] & 0xFF) - value;
                if (val < lower) {
                    val = lower;
                }
                if (val > upper) {
                    val = upper;
                }
                output[indexDst] = (byte)val;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void minus(GrayS8 input, int value, int lower, int upper, GrayS8 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.minus_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void minus(InterleavedS8 input, int value, int lower, int upper, InterleavedS8 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width * input.numBands;
        PixelMath.minus_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void minus_A(byte[] input, int inputStart, int inputStride, int value, int lower, int upper, byte[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                int val = input[indexSrc] - value;
                if (val < lower) {
                    val = lower;
                }
                if (val > upper) {
                    val = upper;
                }
                output[indexDst] = (byte)val;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void minus(GrayU16 input, int value, int lower, int upper, GrayU16 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.minusU_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void minus(InterleavedU16 input, int value, int lower, int upper, InterleavedU16 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width * input.numBands;
        PixelMath.minusU_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void minusU_A(short[] input, int inputStart, int inputStride, int value, int lower, int upper, short[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                int val = (input[indexSrc] & 0xFFFF) - value;
                if (val < lower) {
                    val = lower;
                }
                if (val > upper) {
                    val = upper;
                }
                output[indexDst] = (short)val;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void minus(GrayS16 input, int value, int lower, int upper, GrayS16 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.minus_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void minus(InterleavedS16 input, int value, int lower, int upper, InterleavedS16 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width * input.numBands;
        PixelMath.minus_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void minus_A(short[] input, int inputStart, int inputStride, int value, int lower, int upper, short[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                int val = input[indexSrc] - value;
                if (val < lower) {
                    val = lower;
                }
                if (val > upper) {
                    val = upper;
                }
                output[indexDst] = (short)val;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void minus(GrayS32 input, int value, int lower, int upper, GrayS32 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.minus_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void minus(InterleavedS32 input, int value, int lower, int upper, InterleavedS32 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width * input.numBands;
        PixelMath.minus_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void minus_A(int[] input, int inputStart, int inputStride, int value, int lower, int upper, int[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                int val = input[indexSrc] - value;
                if (val < lower) {
                    val = lower;
                }
                if (val > upper) {
                    val = upper;
                }
                output[indexDst] = val;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void minus(GrayS64 input, long value, long lower, long upper, GrayS64 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.minus_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void minus(InterleavedS64 input, long value, long lower, long upper, InterleavedS64 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width * input.numBands;
        PixelMath.minus_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void minus_A(long[] input, int inputStart, int inputStride, long value, long lower, long upper, long[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                long val = input[indexSrc] - value;
                if (val < lower) {
                    val = lower;
                }
                if (val > upper) {
                    val = upper;
                }
                output[indexDst] = val;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void minus(GrayF32 input, float value, float lower, float upper, GrayF32 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.minus_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void minus(InterleavedF32 input, float value, float lower, float upper, InterleavedF32 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width * input.numBands;
        PixelMath.minus_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void minus_A(float[] input, int inputStart, int inputStride, float value, float lower, float upper, float[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                float val = input[indexSrc] - value;
                if (val < lower) {
                    val = lower;
                }
                if (val > upper) {
                    val = upper;
                }
                output[indexDst] = val;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void minus(GrayF64 input, double value, double lower, double upper, GrayF64 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.minus_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void minus(InterleavedF64 input, double value, double lower, double upper, InterleavedF64 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width * input.numBands;
        PixelMath.minus_A(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void minus_A(double[] input, int inputStart, int inputStride, double value, double lower, double upper, double[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                double val = input[indexSrc] - value;
                if (val < lower) {
                    val = lower;
                }
                if (val > upper) {
                    val = upper;
                }
                output[indexDst] = val;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void minus(int value, GrayU8 input, GrayU8 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.minusU_B(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void minus(int value, InterleavedU8 input, InterleavedU8 output) {
        InputSanityCheck.checkSameShapeB(input, output);
        int columns = input.width * input.numBands;
        PixelMath.minusU_B(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void minusU_B(byte[] input, int inputStart, int inputStride, int value, byte[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                output[indexDst] = (byte)(value - (input[indexSrc] & 0xFF));
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void minus(int value, GrayS8 input, GrayS8 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.minus_B(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void minus(int value, InterleavedS8 input, InterleavedS8 output) {
        InputSanityCheck.checkSameShapeB(input, output);
        int columns = input.width * input.numBands;
        PixelMath.minus_B(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void minus_B(byte[] input, int inputStart, int inputStride, int value, byte[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                output[indexDst] = (byte)(value - input[indexSrc]);
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void minus(int value, GrayU16 input, GrayU16 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.minusU_B(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void minus(int value, InterleavedU16 input, InterleavedU16 output) {
        InputSanityCheck.checkSameShapeB(input, output);
        int columns = input.width * input.numBands;
        PixelMath.minusU_B(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void minusU_B(short[] input, int inputStart, int inputStride, int value, short[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                output[indexDst] = (short)(value - (input[indexSrc] & 0xFFFF));
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void minus(int value, GrayS16 input, GrayS16 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.minus_B(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void minus(int value, InterleavedS16 input, InterleavedS16 output) {
        InputSanityCheck.checkSameShapeB(input, output);
        int columns = input.width * input.numBands;
        PixelMath.minus_B(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void minus_B(short[] input, int inputStart, int inputStride, int value, short[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                output[indexDst] = (short)(value - input[indexSrc]);
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void minus(int value, GrayS32 input, GrayS32 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.minus_B(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void minus(int value, InterleavedS32 input, InterleavedS32 output) {
        InputSanityCheck.checkSameShapeB(input, output);
        int columns = input.width * input.numBands;
        PixelMath.minus_B(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void minus_B(int[] input, int inputStart, int inputStride, int value, int[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                output[indexDst] = value - input[indexSrc];
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void minus(long value, GrayS64 input, GrayS64 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.minus_B(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void minus(long value, InterleavedS64 input, InterleavedS64 output) {
        InputSanityCheck.checkSameShapeB(input, output);
        int columns = input.width * input.numBands;
        PixelMath.minus_B(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void minus_B(long[] input, int inputStart, int inputStride, long value, long[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                output[indexDst] = value - input[indexSrc];
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void minus(float value, GrayF32 input, GrayF32 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.minus_B(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void minus(float value, InterleavedF32 input, InterleavedF32 output) {
        InputSanityCheck.checkSameShapeB(input, output);
        int columns = input.width * input.numBands;
        PixelMath.minus_B(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void minus_B(float[] input, int inputStart, int inputStride, float value, float[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                output[indexDst] = value - input[indexSrc];
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void minus(double value, GrayF64 input, GrayF64 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.minus_B(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void minus(double value, InterleavedF64 input, InterleavedF64 output) {
        InputSanityCheck.checkSameShapeB(input, output);
        int columns = input.width * input.numBands;
        PixelMath.minus_B(input.data, input.startIndex, input.stride, value, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void minus_B(double[] input, int inputStart, int inputStride, double value, double[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                output[indexDst] = value - input[indexSrc];
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void minus(int value, GrayU8 input, int lower, int upper, GrayU8 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.minusU_B(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void minus(int value, InterleavedU8 input, int lower, int upper, InterleavedU8 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width * input.numBands;
        PixelMath.minusU_B(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void minusU_B(byte[] input, int inputStart, int inputStride, int value, int lower, int upper, byte[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                int val = value - (input[indexSrc] & 0xFF);
                if (val < lower) {
                    val = lower;
                }
                if (val > upper) {
                    val = upper;
                }
                output[indexDst] = (byte)val;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void minus(int value, GrayS8 input, int lower, int upper, GrayS8 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.minus_B(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void minus(int value, InterleavedS8 input, int lower, int upper, InterleavedS8 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width * input.numBands;
        PixelMath.minus_B(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void minus_B(byte[] input, int inputStart, int inputStride, int value, int lower, int upper, byte[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                int val = value - input[indexSrc];
                if (val < lower) {
                    val = lower;
                }
                if (val > upper) {
                    val = upper;
                }
                output[indexDst] = (byte)val;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void minus(int value, GrayU16 input, int lower, int upper, GrayU16 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.minusU_B(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void minus(int value, InterleavedU16 input, int lower, int upper, InterleavedU16 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width * input.numBands;
        PixelMath.minusU_B(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void minusU_B(short[] input, int inputStart, int inputStride, int value, int lower, int upper, short[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                int val = value - (input[indexSrc] & 0xFFFF);
                if (val < lower) {
                    val = lower;
                }
                if (val > upper) {
                    val = upper;
                }
                output[indexDst] = (short)val;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void minus(int value, GrayS16 input, int lower, int upper, GrayS16 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.minus_B(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void minus(int value, InterleavedS16 input, int lower, int upper, InterleavedS16 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width * input.numBands;
        PixelMath.minus_B(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void minus_B(short[] input, int inputStart, int inputStride, int value, int lower, int upper, short[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                int val = value - input[indexSrc];
                if (val < lower) {
                    val = lower;
                }
                if (val > upper) {
                    val = upper;
                }
                output[indexDst] = (short)val;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void minus(int value, GrayS32 input, int lower, int upper, GrayS32 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.minus_B(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void minus(int value, InterleavedS32 input, int lower, int upper, InterleavedS32 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width * input.numBands;
        PixelMath.minus_B(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void minus_B(int[] input, int inputStart, int inputStride, int value, int lower, int upper, int[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                int val = value - input[indexSrc];
                if (val < lower) {
                    val = lower;
                }
                if (val > upper) {
                    val = upper;
                }
                output[indexDst] = val;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void minus(long value, GrayS64 input, long lower, long upper, GrayS64 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.minus_B(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void minus(long value, InterleavedS64 input, long lower, long upper, InterleavedS64 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width * input.numBands;
        PixelMath.minus_B(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void minus_B(long[] input, int inputStart, int inputStride, long value, long lower, long upper, long[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                long val = value - input[indexSrc];
                if (val < lower) {
                    val = lower;
                }
                if (val > upper) {
                    val = upper;
                }
                output[indexDst] = val;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void minus(float value, GrayF32 input, float lower, float upper, GrayF32 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.minus_B(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void minus(float value, InterleavedF32 input, float lower, float upper, InterleavedF32 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width * input.numBands;
        PixelMath.minus_B(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void minus_B(float[] input, int inputStart, int inputStride, float value, float lower, float upper, float[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                float val = value - input[indexSrc];
                if (val < lower) {
                    val = lower;
                }
                if (val > upper) {
                    val = upper;
                }
                output[indexDst] = val;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void minus(double value, GrayF64 input, double lower, double upper, GrayF64 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width;
        PixelMath.minus_B(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    public static void minus(double value, InterleavedF64 input, double lower, double upper, InterleavedF64 output) {
        InputSanityCheck.checkSameShape(input, output);
        int columns = input.width * input.numBands;
        PixelMath.minus_B(input.data, input.startIndex, input.stride, value, lower, upper, output.data, output.startIndex, output.stride, input.height, columns);
    }

    private static void minus_B(double[] input, int inputStart, int inputStride, double value, double lower, double upper, double[] output, int outputStart, int outputStride, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            int indexSrc = inputStart + y * inputStride;
            int indexDst = outputStart + y * outputStride;
            int end = indexSrc + cols;
            while (indexSrc < end) {
                double val = value - input[indexSrc];
                if (val < lower) {
                    val = lower;
                }
                if (val > upper) {
                    val = upper;
                }
                output[indexDst] = val;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void boundImage(GrayU8 img, int min, int max) {
        int h = img.getHeight();
        int w = img.getWidth();
        byte[] data = img.data;
        for (int y = 0; y < h; ++y) {
            int index;
            int indexEnd = index + w;
            for (index = img.getStartIndex() + y * img.getStride(); index < indexEnd; ++index) {
                int value = data[index] & 0xFF;
                if (value < min) {
                    data[index] = (byte)min;
                    continue;
                }
                if (value <= max) continue;
                data[index] = (byte)max;
            }
        }
    }

    public static void diffAbs(GrayU8 imgA, GrayU8 imgB, GrayU8 diff) {
        InputSanityCheck.checkSameShape(imgA, imgB, diff);
        int h = imgA.getHeight();
        int w = imgA.getWidth();
        for (int y = 0; y < h; ++y) {
            int indexA = imgA.getStartIndex() + y * imgA.getStride();
            int indexB = imgB.getStartIndex() + y * imgB.getStride();
            int indexDiff = diff.getStartIndex() + y * diff.getStride();
            int indexEnd = indexA + w;
            while (indexA < indexEnd) {
                diff.data[indexDiff] = (byte)Math.abs((imgA.data[indexA] & 0xFF) - (imgB.data[indexB] & 0xFF));
                ++indexA;
                ++indexB;
                ++indexDiff;
            }
        }
    }

    public static void averageBand(Planar<GrayU8> input, GrayU8 output) {
        int h = input.getHeight();
        int w = input.getWidth();
        GrayU8[] bands = (GrayU8[])input.bands;
        for (int y = 0; y < h; ++y) {
            int indexInput = input.getStartIndex() + y * input.getStride();
            int indexOutput = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexInput + w;
            while (indexInput < indexEnd) {
                int total = 0;
                for (int i = 0; i < bands.length; ++i) {
                    total += bands[i].data[indexInput] & 0xFF;
                }
                output.data[indexOutput] = (byte)(total / bands.length);
                ++indexInput;
                ++indexOutput;
            }
        }
    }

    public static void boundImage(GrayS8 img, int min, int max) {
        int h = img.getHeight();
        int w = img.getWidth();
        byte[] data = img.data;
        for (int y = 0; y < h; ++y) {
            int index;
            int indexEnd = index + w;
            for (index = img.getStartIndex() + y * img.getStride(); index < indexEnd; ++index) {
                byte value = data[index];
                if (value < min) {
                    data[index] = (byte)min;
                    continue;
                }
                if (value <= max) continue;
                data[index] = (byte)max;
            }
        }
    }

    public static void diffAbs(GrayS8 imgA, GrayS8 imgB, GrayS8 diff) {
        InputSanityCheck.checkSameShape(imgA, imgB, diff);
        int h = imgA.getHeight();
        int w = imgA.getWidth();
        for (int y = 0; y < h; ++y) {
            int indexA = imgA.getStartIndex() + y * imgA.getStride();
            int indexB = imgB.getStartIndex() + y * imgB.getStride();
            int indexDiff = diff.getStartIndex() + y * diff.getStride();
            int indexEnd = indexA + w;
            while (indexA < indexEnd) {
                diff.data[indexDiff] = (byte)Math.abs(imgA.data[indexA] - imgB.data[indexB]);
                ++indexA;
                ++indexB;
                ++indexDiff;
            }
        }
    }

    public static void averageBand(Planar<GrayS8> input, GrayS8 output) {
        int h = input.getHeight();
        int w = input.getWidth();
        GrayS8[] bands = (GrayS8[])input.bands;
        for (int y = 0; y < h; ++y) {
            int indexInput = input.getStartIndex() + y * input.getStride();
            int indexOutput = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexInput + w;
            while (indexInput < indexEnd) {
                int total = 0;
                for (int i = 0; i < bands.length; ++i) {
                    total += bands[i].data[indexInput];
                }
                output.data[indexOutput] = (byte)(total / bands.length);
                ++indexInput;
                ++indexOutput;
            }
        }
    }

    public static void boundImage(GrayU16 img, int min, int max) {
        int h = img.getHeight();
        int w = img.getWidth();
        short[] data = img.data;
        for (int y = 0; y < h; ++y) {
            int index;
            int indexEnd = index + w;
            for (index = img.getStartIndex() + y * img.getStride(); index < indexEnd; ++index) {
                int value = data[index] & 0xFFFF;
                if (value < min) {
                    data[index] = (short)min;
                    continue;
                }
                if (value <= max) continue;
                data[index] = (short)max;
            }
        }
    }

    public static void diffAbs(GrayU16 imgA, GrayU16 imgB, GrayU16 diff) {
        InputSanityCheck.checkSameShape(imgA, imgB, diff);
        int h = imgA.getHeight();
        int w = imgA.getWidth();
        for (int y = 0; y < h; ++y) {
            int indexA = imgA.getStartIndex() + y * imgA.getStride();
            int indexB = imgB.getStartIndex() + y * imgB.getStride();
            int indexDiff = diff.getStartIndex() + y * diff.getStride();
            int indexEnd = indexA + w;
            while (indexA < indexEnd) {
                diff.data[indexDiff] = (short)Math.abs((imgA.data[indexA] & 0xFFFF) - (imgB.data[indexB] & 0xFFFF));
                ++indexA;
                ++indexB;
                ++indexDiff;
            }
        }
    }

    public static void averageBand(Planar<GrayU16> input, GrayU16 output) {
        int h = input.getHeight();
        int w = input.getWidth();
        GrayU16[] bands = (GrayU16[])input.bands;
        for (int y = 0; y < h; ++y) {
            int indexInput = input.getStartIndex() + y * input.getStride();
            int indexOutput = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexInput + w;
            while (indexInput < indexEnd) {
                int total = 0;
                for (int i = 0; i < bands.length; ++i) {
                    total += bands[i].data[indexInput] & 0xFFFF;
                }
                output.data[indexOutput] = (short)(total / bands.length);
                ++indexInput;
                ++indexOutput;
            }
        }
    }

    public static void boundImage(GrayS16 img, int min, int max) {
        int h = img.getHeight();
        int w = img.getWidth();
        short[] data = img.data;
        for (int y = 0; y < h; ++y) {
            int index;
            int indexEnd = index + w;
            for (index = img.getStartIndex() + y * img.getStride(); index < indexEnd; ++index) {
                short value = data[index];
                if (value < min) {
                    data[index] = (short)min;
                    continue;
                }
                if (value <= max) continue;
                data[index] = (short)max;
            }
        }
    }

    public static void diffAbs(GrayS16 imgA, GrayS16 imgB, GrayS16 diff) {
        InputSanityCheck.checkSameShape(imgA, imgB, diff);
        int h = imgA.getHeight();
        int w = imgA.getWidth();
        for (int y = 0; y < h; ++y) {
            int indexA = imgA.getStartIndex() + y * imgA.getStride();
            int indexB = imgB.getStartIndex() + y * imgB.getStride();
            int indexDiff = diff.getStartIndex() + y * diff.getStride();
            int indexEnd = indexA + w;
            while (indexA < indexEnd) {
                diff.data[indexDiff] = (short)Math.abs(imgA.data[indexA] - imgB.data[indexB]);
                ++indexA;
                ++indexB;
                ++indexDiff;
            }
        }
    }

    public static void averageBand(Planar<GrayS16> input, GrayS16 output) {
        int h = input.getHeight();
        int w = input.getWidth();
        GrayS16[] bands = (GrayS16[])input.bands;
        for (int y = 0; y < h; ++y) {
            int indexInput = input.getStartIndex() + y * input.getStride();
            int indexOutput = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexInput + w;
            while (indexInput < indexEnd) {
                int total = 0;
                for (int i = 0; i < bands.length; ++i) {
                    total += bands[i].data[indexInput];
                }
                output.data[indexOutput] = (short)(total / bands.length);
                ++indexInput;
                ++indexOutput;
            }
        }
    }

    public static void boundImage(GrayS32 img, int min, int max) {
        int h = img.getHeight();
        int w = img.getWidth();
        int[] data = img.data;
        for (int y = 0; y < h; ++y) {
            int index;
            int indexEnd = index + w;
            for (index = img.getStartIndex() + y * img.getStride(); index < indexEnd; ++index) {
                int value = data[index];
                if (value < min) {
                    data[index] = min;
                    continue;
                }
                if (value <= max) continue;
                data[index] = max;
            }
        }
    }

    public static void diffAbs(GrayS32 imgA, GrayS32 imgB, GrayS32 diff) {
        InputSanityCheck.checkSameShape(imgA, imgB, diff);
        int h = imgA.getHeight();
        int w = imgA.getWidth();
        for (int y = 0; y < h; ++y) {
            int indexA = imgA.getStartIndex() + y * imgA.getStride();
            int indexB = imgB.getStartIndex() + y * imgB.getStride();
            int indexDiff = diff.getStartIndex() + y * diff.getStride();
            int indexEnd = indexA + w;
            while (indexA < indexEnd) {
                diff.data[indexDiff] = Math.abs(imgA.data[indexA] - imgB.data[indexB]);
                ++indexA;
                ++indexB;
                ++indexDiff;
            }
        }
    }

    public static void averageBand(Planar<GrayS32> input, GrayS32 output) {
        int h = input.getHeight();
        int w = input.getWidth();
        GrayS32[] bands = (GrayS32[])input.bands;
        for (int y = 0; y < h; ++y) {
            int indexInput = input.getStartIndex() + y * input.getStride();
            int indexOutput = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexInput + w;
            while (indexInput < indexEnd) {
                int total = 0;
                for (int i = 0; i < bands.length; ++i) {
                    total += bands[i].data[indexInput];
                }
                output.data[indexOutput] = total / bands.length;
                ++indexInput;
                ++indexOutput;
            }
        }
    }

    public static void boundImage(GrayS64 img, long min, long max) {
        int h = img.getHeight();
        int w = img.getWidth();
        long[] data = img.data;
        for (int y = 0; y < h; ++y) {
            int index;
            int indexEnd = index + w;
            for (index = img.getStartIndex() + y * img.getStride(); index < indexEnd; ++index) {
                long value = data[index];
                if (value < min) {
                    data[index] = min;
                    continue;
                }
                if (value <= max) continue;
                data[index] = max;
            }
        }
    }

    public static void diffAbs(GrayS64 imgA, GrayS64 imgB, GrayS64 diff) {
        InputSanityCheck.checkSameShape(imgA, imgB, diff);
        int h = imgA.getHeight();
        int w = imgA.getWidth();
        for (int y = 0; y < h; ++y) {
            int indexA = imgA.getStartIndex() + y * imgA.getStride();
            int indexB = imgB.getStartIndex() + y * imgB.getStride();
            int indexDiff = diff.getStartIndex() + y * diff.getStride();
            int indexEnd = indexA + w;
            while (indexA < indexEnd) {
                diff.data[indexDiff] = Math.abs(imgA.data[indexA] - imgB.data[indexB]);
                ++indexA;
                ++indexB;
                ++indexDiff;
            }
        }
    }

    public static void averageBand(Planar<GrayS64> input, GrayS64 output) {
        int h = input.getHeight();
        int w = input.getWidth();
        GrayS64[] bands = (GrayS64[])input.bands;
        for (int y = 0; y < h; ++y) {
            int indexInput = input.getStartIndex() + y * input.getStride();
            int indexOutput = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexInput + w;
            while (indexInput < indexEnd) {
                long total = 0L;
                for (int i = 0; i < bands.length; ++i) {
                    total += bands[i].data[indexInput];
                }
                output.data[indexOutput] = total / (long)bands.length;
                ++indexInput;
                ++indexOutput;
            }
        }
    }

    public static void boundImage(GrayF32 img, float min, float max) {
        int h = img.getHeight();
        int w = img.getWidth();
        float[] data = img.data;
        for (int y = 0; y < h; ++y) {
            int index;
            int indexEnd = index + w;
            for (index = img.getStartIndex() + y * img.getStride(); index < indexEnd; ++index) {
                float value = data[index];
                if (value < min) {
                    data[index] = min;
                    continue;
                }
                if (!(value > max)) continue;
                data[index] = max;
            }
        }
    }

    public static void diffAbs(GrayF32 imgA, GrayF32 imgB, GrayF32 diff) {
        InputSanityCheck.checkSameShape(imgA, imgB, diff);
        int h = imgA.getHeight();
        int w = imgA.getWidth();
        for (int y = 0; y < h; ++y) {
            int indexA = imgA.getStartIndex() + y * imgA.getStride();
            int indexB = imgB.getStartIndex() + y * imgB.getStride();
            int indexDiff = diff.getStartIndex() + y * diff.getStride();
            int indexEnd = indexA + w;
            while (indexA < indexEnd) {
                diff.data[indexDiff] = Math.abs(imgA.data[indexA] - imgB.data[indexB]);
                ++indexA;
                ++indexB;
                ++indexDiff;
            }
        }
    }

    public static void averageBand(Planar<GrayF32> input, GrayF32 output) {
        int h = input.getHeight();
        int w = input.getWidth();
        GrayF32[] bands = (GrayF32[])input.bands;
        for (int y = 0; y < h; ++y) {
            int indexInput = input.getStartIndex() + y * input.getStride();
            int indexOutput = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexInput + w;
            while (indexInput < indexEnd) {
                float total = 0.0f;
                for (int i = 0; i < bands.length; ++i) {
                    total += bands[i].data[indexInput];
                }
                output.data[indexOutput] = total / (float)bands.length;
                ++indexInput;
                ++indexOutput;
            }
        }
    }

    public static void boundImage(GrayF64 img, double min, double max) {
        int h = img.getHeight();
        int w = img.getWidth();
        double[] data = img.data;
        for (int y = 0; y < h; ++y) {
            int index;
            int indexEnd = index + w;
            for (index = img.getStartIndex() + y * img.getStride(); index < indexEnd; ++index) {
                double value = data[index];
                if (value < min) {
                    data[index] = min;
                    continue;
                }
                if (!(value > max)) continue;
                data[index] = max;
            }
        }
    }

    public static void diffAbs(GrayF64 imgA, GrayF64 imgB, GrayF64 diff) {
        InputSanityCheck.checkSameShape(imgA, imgB, diff);
        int h = imgA.getHeight();
        int w = imgA.getWidth();
        for (int y = 0; y < h; ++y) {
            int indexA = imgA.getStartIndex() + y * imgA.getStride();
            int indexB = imgB.getStartIndex() + y * imgB.getStride();
            int indexDiff = diff.getStartIndex() + y * diff.getStride();
            int indexEnd = indexA + w;
            while (indexA < indexEnd) {
                diff.data[indexDiff] = Math.abs(imgA.data[indexA] - imgB.data[indexB]);
                ++indexA;
                ++indexB;
                ++indexDiff;
            }
        }
    }

    public static void averageBand(Planar<GrayF64> input, GrayF64 output) {
        int h = input.getHeight();
        int w = input.getWidth();
        GrayF64[] bands = (GrayF64[])input.bands;
        for (int y = 0; y < h; ++y) {
            int indexInput = input.getStartIndex() + y * input.getStride();
            int indexOutput = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexInput + w;
            while (indexInput < indexEnd) {
                double total = 0.0;
                for (int i = 0; i < bands.length; ++i) {
                    total += bands[i].data[indexInput];
                }
                output.data[indexOutput] = total / (double)bands.length;
                ++indexInput;
                ++indexOutput;
            }
        }
    }

    public static void add(GrayU8 imgA, GrayU8 imgB, GrayU16 output) {
        InputSanityCheck.checkSameShape(imgA, imgB, output);
        int h = imgA.getHeight();
        int w = imgA.getWidth();
        for (int y = 0; y < h; ++y) {
            int indexA = imgA.getStartIndex() + y * imgA.getStride();
            int indexB = imgB.getStartIndex() + y * imgB.getStride();
            int indexOut = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexA + w;
            while (indexA < indexEnd) {
                output.data[indexOut] = (short)((imgA.data[indexA] & 0xFF) + (imgB.data[indexB] & 0xFF));
                ++indexA;
                ++indexB;
                ++indexOut;
            }
        }
    }

    public static void subtract(GrayU8 imgA, GrayU8 imgB, GrayI16 output) {
        InputSanityCheck.checkSameShape(imgA, imgB, output);
        int h = imgA.getHeight();
        int w = imgA.getWidth();
        for (int y = 0; y < h; ++y) {
            int indexA = imgA.getStartIndex() + y * imgA.getStride();
            int indexB = imgB.getStartIndex() + y * imgB.getStride();
            int indexOut = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexA + w;
            while (indexA < indexEnd) {
                output.data[indexOut] = (short)((imgA.data[indexA] & 0xFF) - (imgB.data[indexB] & 0xFF));
                ++indexA;
                ++indexB;
                ++indexOut;
            }
        }
    }

    public static void add(GrayS8 imgA, GrayS8 imgB, GrayS16 output) {
        InputSanityCheck.checkSameShape(imgA, imgB, output);
        int h = imgA.getHeight();
        int w = imgA.getWidth();
        for (int y = 0; y < h; ++y) {
            int indexA = imgA.getStartIndex() + y * imgA.getStride();
            int indexB = imgB.getStartIndex() + y * imgB.getStride();
            int indexOut = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexA + w;
            while (indexA < indexEnd) {
                output.data[indexOut] = (short)(imgA.data[indexA] + imgB.data[indexB]);
                ++indexA;
                ++indexB;
                ++indexOut;
            }
        }
    }

    public static void subtract(GrayS8 imgA, GrayS8 imgB, GrayS16 output) {
        InputSanityCheck.checkSameShape(imgA, imgB, output);
        int h = imgA.getHeight();
        int w = imgA.getWidth();
        for (int y = 0; y < h; ++y) {
            int indexA = imgA.getStartIndex() + y * imgA.getStride();
            int indexB = imgB.getStartIndex() + y * imgB.getStride();
            int indexOut = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexA + w;
            while (indexA < indexEnd) {
                output.data[indexOut] = (short)(imgA.data[indexA] - imgB.data[indexB]);
                ++indexA;
                ++indexB;
                ++indexOut;
            }
        }
    }

    public static void add(GrayU16 imgA, GrayU16 imgB, GrayS32 output) {
        InputSanityCheck.checkSameShape(imgA, imgB, output);
        int h = imgA.getHeight();
        int w = imgA.getWidth();
        for (int y = 0; y < h; ++y) {
            int indexA = imgA.getStartIndex() + y * imgA.getStride();
            int indexB = imgB.getStartIndex() + y * imgB.getStride();
            int indexOut = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexA + w;
            while (indexA < indexEnd) {
                output.data[indexOut] = (imgA.data[indexA] & 0xFFFF) + (imgB.data[indexB] & 0xFFFF);
                ++indexA;
                ++indexB;
                ++indexOut;
            }
        }
    }

    public static void subtract(GrayU16 imgA, GrayU16 imgB, GrayS32 output) {
        InputSanityCheck.checkSameShape(imgA, imgB, output);
        int h = imgA.getHeight();
        int w = imgA.getWidth();
        for (int y = 0; y < h; ++y) {
            int indexA = imgA.getStartIndex() + y * imgA.getStride();
            int indexB = imgB.getStartIndex() + y * imgB.getStride();
            int indexOut = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexA + w;
            while (indexA < indexEnd) {
                output.data[indexOut] = (imgA.data[indexA] & 0xFFFF) - (imgB.data[indexB] & 0xFFFF);
                ++indexA;
                ++indexB;
                ++indexOut;
            }
        }
    }

    public static void add(GrayS16 imgA, GrayS16 imgB, GrayS32 output) {
        InputSanityCheck.checkSameShape(imgA, imgB, output);
        int h = imgA.getHeight();
        int w = imgA.getWidth();
        for (int y = 0; y < h; ++y) {
            int indexA = imgA.getStartIndex() + y * imgA.getStride();
            int indexB = imgB.getStartIndex() + y * imgB.getStride();
            int indexOut = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexA + w;
            while (indexA < indexEnd) {
                output.data[indexOut] = imgA.data[indexA] + imgB.data[indexB];
                ++indexA;
                ++indexB;
                ++indexOut;
            }
        }
    }

    public static void subtract(GrayS16 imgA, GrayS16 imgB, GrayS32 output) {
        InputSanityCheck.checkSameShape(imgA, imgB, output);
        int h = imgA.getHeight();
        int w = imgA.getWidth();
        for (int y = 0; y < h; ++y) {
            int indexA = imgA.getStartIndex() + y * imgA.getStride();
            int indexB = imgB.getStartIndex() + y * imgB.getStride();
            int indexOut = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexA + w;
            while (indexA < indexEnd) {
                output.data[indexOut] = imgA.data[indexA] - imgB.data[indexB];
                ++indexA;
                ++indexB;
                ++indexOut;
            }
        }
    }

    public static void add(GrayS32 imgA, GrayS32 imgB, GrayS32 output) {
        InputSanityCheck.checkSameShape(imgA, imgB, output);
        int h = imgA.getHeight();
        int w = imgA.getWidth();
        for (int y = 0; y < h; ++y) {
            int indexA = imgA.getStartIndex() + y * imgA.getStride();
            int indexB = imgB.getStartIndex() + y * imgB.getStride();
            int indexOut = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexA + w;
            while (indexA < indexEnd) {
                output.data[indexOut] = imgA.data[indexA] + imgB.data[indexB];
                ++indexA;
                ++indexB;
                ++indexOut;
            }
        }
    }

    public static void subtract(GrayS32 imgA, GrayS32 imgB, GrayS32 output) {
        InputSanityCheck.checkSameShape(imgA, imgB, output);
        int h = imgA.getHeight();
        int w = imgA.getWidth();
        for (int y = 0; y < h; ++y) {
            int indexA = imgA.getStartIndex() + y * imgA.getStride();
            int indexB = imgB.getStartIndex() + y * imgB.getStride();
            int indexOut = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexA + w;
            while (indexA < indexEnd) {
                output.data[indexOut] = imgA.data[indexA] - imgB.data[indexB];
                ++indexA;
                ++indexB;
                ++indexOut;
            }
        }
    }

    public static void add(GrayS64 imgA, GrayS64 imgB, GrayS64 output) {
        InputSanityCheck.checkSameShape(imgA, imgB, output);
        int h = imgA.getHeight();
        int w = imgA.getWidth();
        for (int y = 0; y < h; ++y) {
            int indexA = imgA.getStartIndex() + y * imgA.getStride();
            int indexB = imgB.getStartIndex() + y * imgB.getStride();
            int indexOut = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexA + w;
            while (indexA < indexEnd) {
                output.data[indexOut] = imgA.data[indexA] + imgB.data[indexB];
                ++indexA;
                ++indexB;
                ++indexOut;
            }
        }
    }

    public static void subtract(GrayS64 imgA, GrayS64 imgB, GrayS64 output) {
        InputSanityCheck.checkSameShape(imgA, imgB, output);
        int h = imgA.getHeight();
        int w = imgA.getWidth();
        for (int y = 0; y < h; ++y) {
            int indexA = imgA.getStartIndex() + y * imgA.getStride();
            int indexB = imgB.getStartIndex() + y * imgB.getStride();
            int indexOut = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexA + w;
            while (indexA < indexEnd) {
                output.data[indexOut] = imgA.data[indexA] - imgB.data[indexB];
                ++indexA;
                ++indexB;
                ++indexOut;
            }
        }
    }

    public static void add(GrayF32 imgA, GrayF32 imgB, GrayF32 output) {
        InputSanityCheck.checkSameShape(imgA, imgB, output);
        int h = imgA.getHeight();
        int w = imgA.getWidth();
        for (int y = 0; y < h; ++y) {
            int indexA = imgA.getStartIndex() + y * imgA.getStride();
            int indexB = imgB.getStartIndex() + y * imgB.getStride();
            int indexOut = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexA + w;
            while (indexA < indexEnd) {
                output.data[indexOut] = imgA.data[indexA] + imgB.data[indexB];
                ++indexA;
                ++indexB;
                ++indexOut;
            }
        }
    }

    public static void subtract(GrayF32 imgA, GrayF32 imgB, GrayF32 output) {
        InputSanityCheck.checkSameShape(imgA, imgB, output);
        int h = imgA.getHeight();
        int w = imgA.getWidth();
        for (int y = 0; y < h; ++y) {
            int indexA = imgA.getStartIndex() + y * imgA.getStride();
            int indexB = imgB.getStartIndex() + y * imgB.getStride();
            int indexOut = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexA + w;
            while (indexA < indexEnd) {
                output.data[indexOut] = imgA.data[indexA] - imgB.data[indexB];
                ++indexA;
                ++indexB;
                ++indexOut;
            }
        }
    }

    public static void multiply(GrayF32 imgA, GrayF32 imgB, GrayF32 output) {
        InputSanityCheck.checkSameShape(imgA, imgB, output);
        int h = imgA.getHeight();
        int w = imgA.getWidth();
        for (int y = 0; y < h; ++y) {
            int indexA = imgA.getStartIndex() + y * imgA.getStride();
            int indexB = imgB.getStartIndex() + y * imgB.getStride();
            int indexOut = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexA + w;
            while (indexA < indexEnd) {
                output.data[indexOut] = imgA.data[indexA] * imgB.data[indexB];
                ++indexA;
                ++indexB;
                ++indexOut;
            }
        }
    }

    public static void divide(GrayF32 imgA, GrayF32 imgB, GrayF32 output) {
        InputSanityCheck.checkSameShape(imgA, imgB, output);
        int h = imgA.getHeight();
        int w = imgA.getWidth();
        for (int y = 0; y < h; ++y) {
            int indexA = imgA.getStartIndex() + y * imgA.getStride();
            int indexB = imgB.getStartIndex() + y * imgB.getStride();
            int indexOut = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexA + w;
            while (indexA < indexEnd) {
                output.data[indexOut] = imgA.data[indexA] / imgB.data[indexB];
                ++indexA;
                ++indexB;
                ++indexOut;
            }
        }
    }

    public static void log(GrayF32 input, GrayF32 output) {
        InputSanityCheck.checkSameShape(input, output);
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            int indexDst = output.startIndex + y * output.stride;
            int end = indexSrc + input.width;
            while (indexSrc < end) {
                output.data[indexDst] = (float)Math.log(1.0f + input.data[indexSrc]);
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void pow2(GrayF32 input, GrayF32 output) {
        InputSanityCheck.checkSameShape(input, output);
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            int indexDst = output.startIndex + y * output.stride;
            int end = indexSrc + input.width;
            while (indexSrc < end) {
                float v = input.data[indexSrc];
                output.data[indexDst] = v * v;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void sqrt(GrayF32 input, GrayF32 output) {
        InputSanityCheck.checkSameShape(input, output);
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            int indexDst = output.startIndex + y * output.stride;
            int end = indexSrc + input.width;
            while (indexSrc < end) {
                output.data[indexDst] = (float)Math.sqrt(input.data[indexSrc]);
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void add(GrayF64 imgA, GrayF64 imgB, GrayF64 output) {
        InputSanityCheck.checkSameShape(imgA, imgB, output);
        int h = imgA.getHeight();
        int w = imgA.getWidth();
        for (int y = 0; y < h; ++y) {
            int indexA = imgA.getStartIndex() + y * imgA.getStride();
            int indexB = imgB.getStartIndex() + y * imgB.getStride();
            int indexOut = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexA + w;
            while (indexA < indexEnd) {
                output.data[indexOut] = imgA.data[indexA] + imgB.data[indexB];
                ++indexA;
                ++indexB;
                ++indexOut;
            }
        }
    }

    public static void subtract(GrayF64 imgA, GrayF64 imgB, GrayF64 output) {
        InputSanityCheck.checkSameShape(imgA, imgB, output);
        int h = imgA.getHeight();
        int w = imgA.getWidth();
        for (int y = 0; y < h; ++y) {
            int indexA = imgA.getStartIndex() + y * imgA.getStride();
            int indexB = imgB.getStartIndex() + y * imgB.getStride();
            int indexOut = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexA + w;
            while (indexA < indexEnd) {
                output.data[indexOut] = imgA.data[indexA] - imgB.data[indexB];
                ++indexA;
                ++indexB;
                ++indexOut;
            }
        }
    }

    public static void multiply(GrayF64 imgA, GrayF64 imgB, GrayF64 output) {
        InputSanityCheck.checkSameShape(imgA, imgB, output);
        int h = imgA.getHeight();
        int w = imgA.getWidth();
        for (int y = 0; y < h; ++y) {
            int indexA = imgA.getStartIndex() + y * imgA.getStride();
            int indexB = imgB.getStartIndex() + y * imgB.getStride();
            int indexOut = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexA + w;
            while (indexA < indexEnd) {
                output.data[indexOut] = imgA.data[indexA] * imgB.data[indexB];
                ++indexA;
                ++indexB;
                ++indexOut;
            }
        }
    }

    public static void divide(GrayF64 imgA, GrayF64 imgB, GrayF64 output) {
        InputSanityCheck.checkSameShape(imgA, imgB, output);
        int h = imgA.getHeight();
        int w = imgA.getWidth();
        for (int y = 0; y < h; ++y) {
            int indexA = imgA.getStartIndex() + y * imgA.getStride();
            int indexB = imgB.getStartIndex() + y * imgB.getStride();
            int indexOut = output.getStartIndex() + y * output.getStride();
            int indexEnd = indexA + w;
            while (indexA < indexEnd) {
                output.data[indexOut] = imgA.data[indexA] / imgB.data[indexB];
                ++indexA;
                ++indexB;
                ++indexOut;
            }
        }
    }

    public static void log(GrayF64 input, GrayF64 output) {
        InputSanityCheck.checkSameShape(input, output);
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            int indexDst = output.startIndex + y * output.stride;
            int end = indexSrc + input.width;
            while (indexSrc < end) {
                output.data[indexDst] = Math.log(1.0 + input.data[indexSrc]);
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void pow2(GrayF64 input, GrayF64 output) {
        InputSanityCheck.checkSameShape(input, output);
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            int indexDst = output.startIndex + y * output.stride;
            int end = indexSrc + input.width;
            while (indexSrc < end) {
                double v = input.data[indexSrc];
                output.data[indexDst] = v * v;
                ++indexSrc;
                ++indexDst;
            }
        }
    }

    public static void sqrt(GrayF64 input, GrayF64 output) {
        InputSanityCheck.checkSameShape(input, output);
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            int indexDst = output.startIndex + y * output.stride;
            int end = indexSrc + input.width;
            while (indexSrc < end) {
                output.data[indexDst] = Math.sqrt(input.data[indexSrc]);
                ++indexSrc;
                ++indexDst;
            }
        }
    }
}

