/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.distort;

import boofcv.alg.distort.ImageDistort;
import boofcv.alg.distort.impl.ImplImageDistortCache_F32;
import boofcv.alg.distort.impl.ImplImageDistortCache_I16;
import boofcv.alg.distort.impl.ImplImageDistortCache_I8;
import boofcv.alg.distort.impl.ImplImageDistortCache_S32;
import boofcv.alg.distort.impl.ImplImageDistort_F32;
import boofcv.alg.distort.impl.ImplImageDistort_I16;
import boofcv.alg.distort.impl.ImplImageDistort_I8;
import boofcv.alg.distort.impl.ImplImageDistort_IL_F32;
import boofcv.alg.distort.impl.ImplImageDistort_IL_U8;
import boofcv.alg.distort.impl.ImplImageDistort_PL;
import boofcv.alg.distort.impl.ImplImageDistort_S32;
import boofcv.alg.interpolate.InterpolatePixel;
import boofcv.alg.interpolate.InterpolatePixelMB;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.alg.interpolate.InterpolationType;
import boofcv.core.image.border.BorderType;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayI16;
import boofcv.struct.image.GrayI8;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageInterleaved;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.InterleavedU8;
import boofcv.struct.image.Planar;

public class FactoryDistort {
    public static <Input extends ImageBase, Output extends ImageBase> ImageDistort<Input, Output> distort(boolean cached, InterpolationType interpolationType, BorderType borderType, ImageType<Input> inputType, ImageType<Output> outputType) {
        InterpolatePixel<Input> interp = FactoryInterpolation.createPixel(0.0, 255.0, interpolationType, borderType, inputType);
        return FactoryDistort.distort(cached, interp, outputType);
    }

    public static <Input extends ImageBase, Output extends ImageBase> ImageDistort<Input, Output> distort(boolean cached, InterpolatePixel<Input> interp, ImageType<Output> outputType) {
        switch (outputType.getFamily()) {
            case GRAY: {
                return FactoryDistort.distortSB(cached, (InterpolatePixelS)interp, outputType.getImageClass());
            }
            case PLANAR: {
                return FactoryDistort.distortPL(cached, (InterpolatePixelS)interp, outputType.getImageClass());
            }
            case INTERLEAVED: {
                if (interp instanceof InterpolatePixelS) {
                    throw new IllegalArgumentException("Interpolation function for single band images was passed in for an interleaved image");
                }
                return FactoryDistort.distortIL(cached, (InterpolatePixelMB)interp, outputType);
            }
        }
        throw new IllegalArgumentException("Unknown image family " + (Object)((Object)outputType.getFamily()));
    }

    public static <Input extends ImageGray, Output extends ImageGray> ImageDistort<Input, Output> distortSB(boolean cached, InterpolatePixelS<Input> interp, Class<Output> outputType) {
        if (cached) {
            if (outputType == GrayF32.class) {
                return new ImplImageDistortCache_F32<Input>(interp);
            }
            if (GrayS32.class.isAssignableFrom(outputType)) {
                return new ImplImageDistortCache_S32<Input>(interp);
            }
            if (GrayI16.class.isAssignableFrom(outputType)) {
                return new ImplImageDistortCache_I16(interp);
            }
            if (GrayI8.class.isAssignableFrom(outputType)) {
                return new ImplImageDistortCache_I8(interp);
            }
            throw new IllegalArgumentException("Output type not supported: " + outputType.getSimpleName());
        }
        if (outputType == GrayF32.class) {
            return new ImplImageDistort_F32<Input>(interp);
        }
        if (GrayS32.class.isAssignableFrom(outputType)) {
            return new ImplImageDistort_S32<Input>(interp);
        }
        if (GrayI16.class.isAssignableFrom(outputType)) {
            return new ImplImageDistort_I16(interp);
        }
        if (GrayI8.class.isAssignableFrom(outputType)) {
            return new ImplImageDistort_I8(interp);
        }
        throw new IllegalArgumentException("Output type not supported: " + outputType.getSimpleName());
    }

    public static <Input extends ImageGray, Output extends ImageGray> ImageDistort<Planar<Input>, Planar<Output>> distortPL(boolean cached, InterpolatePixelS<Input> interp, Class<Output> outputType) {
        ImageDistort<Input, Output> distortSingle = FactoryDistort.distortSB(cached, interp, outputType);
        return new ImplImageDistort_PL<Input, Output>(distortSingle);
    }

    public static <Input extends ImageInterleaved, Output extends ImageInterleaved> ImageDistort<Input, Output> distortIL(boolean cached, InterpolatePixelMB<Input> interp, ImageType<Output> outputType) {
        if (cached) {
            throw new IllegalArgumentException("Cached not supported yet");
        }
        switch (outputType.getDataType()) {
            case F32: {
                return new ImplImageDistort_IL_F32(interp);
            }
            case U8: {
                return new ImplImageDistort_IL_U8((InterpolatePixelMB<InterleavedU8>)interp);
            }
        }
        throw new IllegalArgumentException("Not supported yet");
    }
}

