/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io.wrapper.xuggler;

import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.image.SimpleImageSequence;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import com.xuggle.xuggler.ICodec;
import com.xuggle.xuggler.IContainer;
import com.xuggle.xuggler.IPacket;
import com.xuggle.xuggler.IPixelFormat;
import com.xuggle.xuggler.IStream;
import com.xuggle.xuggler.IStreamCoder;
import com.xuggle.xuggler.IVideoPicture;
import com.xuggle.xuggler.IVideoResampler;
import com.xuggle.xuggler.video.IConverter;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class XugglerSimplified<T extends ImageBase>
implements SimpleImageSequence<T> {
    IContainer container;
    IStreamCoder videoCoder;
    IPacket packet;
    int videoStreamId;
    IVideoResampler resampler;
    IConverter converter;
    T image;
    ImageType<T> typeOutput;
    BufferedImage bufferedImage;
    BufferedImage reducedImage;
    int factor;
    BufferedImage imageGUI;
    boolean hasNext;
    boolean hasNextBeenCalled;
    int frameID = -1;
    String fileName;

    public XugglerSimplified(String filename, ImageType<T> typeOutput) {
        this.image = typeOutput.createImage(1, 1);
        this.open(filename, typeOutput);
    }

    public void open(String filename, ImageType<T> typeOutput) {
        this.fileName = filename;
        if (!IVideoResampler.isSupported((IVideoResampler.Feature)IVideoResampler.Feature.FEATURE_COLORSPACECONVERSION)) {
            throw new RuntimeException("you must install the GPL version of Xuggler (with IVideoResampler support) for this demo to work");
        }
        this.typeOutput = typeOutput;
        this.container = IContainer.make();
        if (this.container.open(filename, IContainer.Type.READ, null) < 0) {
            throw new IllegalArgumentException("could not open file: " + filename);
        }
        int numStreams = this.container.getNumStreams();
        this.videoStreamId = -1;
        this.videoCoder = null;
        for (int i = 0; i < numStreams; ++i) {
            IStream stream = this.container.getStream((long)i);
            IStreamCoder coder = stream.getStreamCoder();
            if (coder.getCodecType() != ICodec.Type.CODEC_TYPE_VIDEO) continue;
            this.videoStreamId = i;
            this.videoCoder = coder;
            break;
        }
        if (this.videoStreamId == -1) {
            throw new RuntimeException("could not find video stream in container: " + filename);
        }
        if (this.videoCoder.open() < 0) {
            throw new RuntimeException("could not open video decoder for container: " + filename);
        }
        this.resampler = null;
        if (this.videoCoder.getPixelType() != IPixelFormat.Type.BGR24) {
            this.resampler = IVideoResampler.make((int)this.videoCoder.getWidth(), (int)this.videoCoder.getHeight(), (IPixelFormat.Type)IPixelFormat.Type.BGR24, (int)this.videoCoder.getWidth(), (int)this.videoCoder.getHeight(), (IPixelFormat.Type)this.videoCoder.getPixelType());
            if (this.resampler == null) {
                throw new RuntimeException("could not create color space resampler for: " + filename);
            }
        }
        this.packet = IPacket.make();
        this.bufferedImage = new BufferedImage(this.videoCoder.getWidth(), this.videoCoder.getHeight(), 5);
        this.hasNext = this.readNextFrame();
        this.hasNextBeenCalled = false;
    }

    public void setReduce(int factor) {
        this.factor = factor;
        this.reducedImage = new BufferedImage(this.videoCoder.getWidth() / factor, this.videoCoder.getHeight() / factor, 5);
        this.handleReduce();
    }

    public int getNextWidth() {
        return this.image.getWidth();
    }

    public int getNextHeight() {
        return this.image.getHeight();
    }

    public boolean hasNext() {
        if (this.hasNextBeenCalled) {
            this.hasNext = this.readNextFrame();
            this.hasNextBeenCalled = false;
        }
        return this.hasNext;
    }

    private boolean readNextFrame() {
        while (this.container.readNextPacket(this.packet) >= 0) {
            int bytesDecoded;
            ++this.frameID;
            if (this.packet.getStreamIndex() != this.videoStreamId) continue;
            IVideoPicture picture = IVideoPicture.make((IPixelFormat.Type)this.videoCoder.getPixelType(), (int)this.videoCoder.getWidth(), (int)this.videoCoder.getHeight());
            for (int offset = 0; offset < this.packet.getSize(); offset += bytesDecoded) {
                bytesDecoded = this.videoCoder.decodeVideo(picture, this.packet, offset);
                if (bytesDecoded >= 0) continue;
                throw new RuntimeException("got error decoding video");
            }
        }
        return false;
    }

    private void handleReduce() {
        if (this.reducedImage != null) {
            Graphics2D g2 = this.reducedImage.createGraphics();
            g2.scale(1.0 / (double)this.factor, 1.0 / (double)this.factor);
            g2.drawImage((Image)this.bufferedImage, 0, 0, null);
            this.imageGUI = this.reducedImage;
        } else {
            this.imageGUI = this.bufferedImage;
        }
        this.image.reshape(this.imageGUI.getWidth(), this.imageGUI.getHeight());
        ConvertBufferedImage.convertFrom((BufferedImage)this.imageGUI, this.image, (boolean)true);
    }

    public T next() {
        this.hasNextBeenCalled = true;
        return this.image;
    }

    public void setLoop(boolean loop) {
    }

    public BufferedImage getGuiImage() {
        this.hasNextBeenCalled = true;
        return this.imageGUI;
    }

    public ImageType<T> getImageType() {
        return this.typeOutput;
    }

    public int getFrameNumber() {
        return this.frameID;
    }

    public void reset() {
        this.close();
        this.open(this.fileName, this.typeOutput);
    }

    public void close() {
        if (this.videoCoder != null) {
            this.videoCoder.close();
            this.videoCoder = null;
        }
        if (this.container != null) {
            this.container.close();
            this.container = null;
        }
        this.bufferedImage = null;
        this.converter = null;
        this.resampler = null;
        this.packet = null;
    }
}

