package org.bpsbits.kt.rest.prototypes.security

import io.quarkus.runtime.annotations.RegisterForReflection
import jakarta.ws.rs.container.ContainerRequestContext
import jakarta.ws.rs.container.ResourceInfo
import org.bpsbits.kt.rest.annotations.ExclusiveAccess

/**
 * Interface for Gatekeeper filters.
 * Provides the ability to easily apply custom access control filters to the JAX-RS resources.
 */
@RegisterForReflection
fun interface GateKeeper {

    fun approve(
        requestContext: ContainerRequestContext,
        resourceInfo: ResourceInfo,
        exclusiveAccess: ExclusiveAccess
    )

}