/*
 * Decompiled with CFR 0.152.
 */
package org.bpsbits.kt.rest.prototypes.rest;

import io.quarkus.runtime.annotations.RegisterForReflection;
import io.vertx.core.http.HttpServerRequest;
import jakarta.ws.rs.core.Response;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.bpsbits.kt.rest.commons.QuarkusApp;
import org.bpsbits.kt.rest.i18n.AcceptedLanguage;
import org.bpsbits.kt.rest.i18n.ISO6391Code;
import org.bpsbits.kt.rest.utils.brh.BrhKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@RegisterForReflection
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\bg\u0018\u00002\u00020\u0001J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0001H\u0016R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\fR\u001a\u0010\r\u001a\u0004\u0018\u00010\u000eX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0016"}, d2={"Lorg/bpsbits/kt/rest/prototypes/rest/BasicRequestHandler;", "", "detectedLanguage", "Lorg/bpsbits/kt/rest/i18n/ISO6391Code;", "getDetectedLanguage", "()Lorg/bpsbits/kt/rest/i18n/ISO6391Code;", "identityToken", "", "getIdentityToken", "()Ljava/lang/String;", "isSSL", "", "()Z", "request", "Lio/vertx/core/http/HttpServerRequest;", "getRequest", "()Lio/vertx/core/http/HttpServerRequest;", "setRequest", "(Lio/vertx/core/http/HttpServerRequest;)V", "buildResponse", "Ljakarta/ws/rs/core/Response;", "entity", "kt-rest"})
public interface BasicRequestHandler {
    @Nullable
    public HttpServerRequest getRequest();

    public void setRequest(@Nullable HttpServerRequest var1);

    public boolean isSSL();

    @NotNull
    public ISO6391Code getDetectedLanguage();

    @NotNull
    public String getIdentityToken();

    @NotNull
    public Response buildResponse(@NotNull Object var1);

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    @SourceDebugExtension(value={"SMAP\nBasicRequestHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BasicRequestHandler.kt\norg/bpsbits/kt/rest/prototypes/rest/BasicRequestHandler$DefaultImpls\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,80:1\n288#2,2:81\n*S KotlinDebug\n*F\n+ 1 BasicRequestHandler.kt\norg/bpsbits/kt/rest/prototypes/rest/BasicRequestHandler$DefaultImpls\n*L\n73#1:81,2\n*E\n"})
    public static final class DefaultImpls {
        public static boolean isSSL(@NotNull BasicRequestHandler $this) {
            HttpServerRequest httpServerRequest = $this.getRequest();
            return httpServerRequest != null ? httpServerRequest.isSSL() : false;
        }

        @NotNull
        public static ISO6391Code getDetectedLanguage(@NotNull BasicRequestHandler $this) {
            String langFromHeader;
            String langFromCookie;
            String detectCookie;
            String detectQuery = QuarkusApp.Companion.getLangDetectQuery();
            if (((CharSequence)detectQuery).length() > 0) {
                String langFromQuery;
                HttpServerRequest httpServerRequest = $this.getRequest();
                String string = httpServerRequest != null ? httpServerRequest.getParam(detectQuery) : null;
                if (string == null) {
                    string = "";
                }
                if (QuarkusApp.Companion.isSupportedLang(langFromQuery = string)) {
                    return ISO6391Code.Companion.resolve(langFromQuery);
                }
            }
            if (((CharSequence)(detectCookie = QuarkusApp.Companion.getLangDetectCookie())).length() > 0 && QuarkusApp.Companion.isSupportedLang(langFromCookie = BrhKt.cookieValue$default($this, detectCookie, null, 2, null))) {
                return ISO6391Code.Companion.resolve(langFromCookie);
            }
            String detectHeader = QuarkusApp.Companion.getLangDetectHeader();
            if (((CharSequence)detectHeader).length() > 0 && QuarkusApp.Companion.isSupportedLang(langFromHeader = BrhKt.headerValue$default($this, detectHeader, null, 2, null))) {
                return ISO6391Code.Companion.resolve(langFromHeader);
            }
            List<AcceptedLanguage> acceptedLangFromHeader = BrhKt.getAcceptedISO6391Languages($this);
            if (!((Collection)acceptedLangFromHeader).isEmpty() && QuarkusApp.Companion.isSupportedLang(((AcceptedLanguage)CollectionsKt.first(acceptedLangFromHeader)).getLanguage())) {
                return ISO6391Code.Companion.resolve(((AcceptedLanguage)CollectionsKt.first(acceptedLangFromHeader)).getLanguage());
            }
            return ISO6391Code.Companion.resolve(QuarkusApp.Companion.getPrimaryLang());
        }

        @NotNull
        public static String getIdentityToken(@NotNull BasicRequestHandler $this) {
            String string;
            Object v1;
            block2: {
                String tokenName = QuarkusApp.Companion.getIdentityTokenName();
                Object[] objectArray = new String[]{BrhKt.cookieValue$default($this, tokenName, null, 2, null), BrhKt.headerValue$default($this, tokenName, null, 2, null)};
                Iterable $this$firstOrNull$iv = CollectionsKt.listOf((Object[])objectArray);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    boolean bl2 = !StringsKt.isBlank((CharSequence)it);
                    if (!bl2) continue;
                    v1 = element$iv;
                    break block2;
                }
                v1 = null;
            }
            if ((string = (String)v1) == null) {
                string = "";
            }
            return string;
        }

        @NotNull
        public static Response buildResponse(@NotNull BasicRequestHandler $this, @NotNull Object entity) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            Response response = Response.ok().entity(entity).build();
            Intrinsics.checkNotNullExpressionValue((Object)response, (String)"build(...)");
            return response;
        }
    }
}

