/*
 * Decompiled with CFR 0.152.
 */
package org.bpsbits.kt.rest.utils.string;

import java.time.LocalDate;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.bpsbits.kt.rest.i18n.AcceptedLanguage;
import org.bpsbits.kt.rest.i18n.ISO6391Code;
import org.bpsbits.kt.rest.utils.string.StringKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u001a\n\u0010\u0007\u001a\u00020\u0002*\u00020\u0002\u001a\u001e\u0010\b\u001a\u00020\u0002*\u00020\u00022\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\u0002\u001a\n\u0010\f\u001a\u00020\u0001*\u00020\u0002\u001a\u0010\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e*\u00020\u0002\u001a\u0010\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e*\u00020\u0002\u001a\n\u0010\u0011\u001a\u00020\u0002*\u00020\u0002\u001a\n\u0010\u0012\u001a\u00020\u0013*\u00020\u0002\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0004\u00a8\u0006\u0014"}, d2={"matchesISODateFormat", "", "", "getMatchesISODateFormat", "(Ljava/lang/String;)Z", "matchesTomcatCookie", "getMatchesTomcatCookie", "doubleQuoteIfContainsUppercase", "intoPgFunctionQuery", "varsCount", "", "suffix", "isValidISODate", "parseAcceptedLanguages", "", "Lorg/bpsbits/kt/rest/i18n/AcceptedLanguage;", "parseAcceptedLanguagesISO6391", "sanitizePgFunctionName", "validateISODate", "", "kt-rest"})
@SourceDebugExtension(value={"SMAP\nstring.kt\nKotlin\n*S Kotlin\n*F\n+ 1 string.kt\norg/bpsbits/kt/rest/utils/string/StringKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,116:1\n1549#2:117\n1620#2,3:118\n766#2:121\n857#2,2:122\n1549#2:124\n1620#2,3:125\n1054#2:128\n1083#3,2:129\n*S KotlinDebug\n*F\n+ 1 string.kt\norg/bpsbits/kt/rest/utils/string/StringKt\n*L\n59#1:117\n59#1:118,3\n59#1:121\n59#1:122,2\n61#1:124\n61#1:125,3\n67#1:128\n94#1:129,2\n*E\n"})
public final class StringKt {
    public static final boolean getMatchesTomcatCookie(@NotNull String $this$matchesTomcatCookie) {
        Intrinsics.checkNotNullParameter((Object)$this$matchesTomcatCookie, (String)"<this>");
        return Intrinsics.areEqual((Object)$this$matchesTomcatCookie, (Object)"JSESSIONID");
    }

    public static final boolean getMatchesISODateFormat(@NotNull String $this$matchesISODateFormat) {
        Intrinsics.checkNotNullParameter((Object)$this$matchesISODateFormat, (String)"<this>");
        return new Regex("^\\d{4}-(0[1-9]|1[0-2])-(0[1-9]|1[0-9]|2[0-9]|3[0-1])$").matches((CharSequence)$this$matchesISODateFormat);
    }

    public static final boolean isValidISODate(@NotNull String $this$isValidISODate) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isValidISODate, (String)"<this>");
        if (!StringKt.getMatchesISODateFormat($this$isValidISODate)) {
            return false;
        }
        try {
            LocalDate.parse($this$isValidISODate);
            bl = true;
        }
        catch (DateTimeParseException e) {
            bl = false;
        }
        return bl;
    }

    public static final void validateISODate(@NotNull String $this$validateISODate) {
        Intrinsics.checkNotNullParameter((Object)$this$validateISODate, (String)"<this>");
        if (!StringKt.getMatchesISODateFormat($this$validateISODate)) {
            boolean $i$a$-require-StringKt$validateISODate$32 = false;
            String $i$a$-require-StringKt$validateISODate$32 = "Given string doesn't match the required date format! (Example: 2012-01-01).";
            throw new IllegalArgumentException($i$a$-require-StringKt$validateISODate$32.toString());
        }
        if (!StringKt.isValidISODate($this$validateISODate)) {
            boolean bl = false;
            String string = "Given string `" + $this$validateISODate + "` is not a valid date!";
            throw new IllegalArgumentException(string.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<AcceptedLanguage> parseAcceptedLanguages(@NotNull String $this$parseAcceptedLanguages) {
        Intrinsics.checkNotNullParameter((Object)$this$parseAcceptedLanguages, (String)"<this>");
        try {
            void $this$mapTo$iv$iv;
            void $this$filterTo$iv$iv;
            String it;
            Collection collection;
            Iterable $this$mapTo$iv$iv2;
            String[] stringArray = new String[]{","};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)$this$parseAcceptedLanguages, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                String string = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((Object)StringsKt.trim((CharSequence)it)).toString());
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv2 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                it = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((Object)StringsKt.trim((CharSequence)it)).toString());
            }
            Iterable $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv2 = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl = false;
                boolean bl2 = ((CharSequence)it).length() > 0;
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List rawLangList = (List)destination$iv$iv;
            if (rawLangList.isEmpty()) {
                return CollectionsKt.listOf((Object)new AcceptedLanguage(null, 0.0f, 3, null));
            }
            Iterable $this$map$iv2 = rawLangList;
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void lang;
                String bl = (String)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl3 = false;
                String[] stringArray2 = new String[]{";q="};
                List parts = StringsKt.split$default((CharSequence)((CharSequence)lang), (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
                collection.add(parts.size() == 2 ? new AcceptedLanguage((String)parts.get(0), Float.parseFloat((String)parts.get(1))) : new AcceptedLanguage((String)parts.get(0), 1.0f));
            }
            Iterable $this$sortedByDescending$iv = (List)destination$iv$iv2;
            boolean $i$f$sortedByDescending = false;
            List rankedLangList = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    AcceptedLanguage it = (AcceptedLanguage)b;
                    boolean bl = false;
                    Comparable comparable = Float.valueOf(it.getQ());
                    it = (AcceptedLanguage)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Float.valueOf(it.getQ()));
                }
            });
            return rankedLangList;
        }
        catch (Exception e) {
            return CollectionsKt.listOf((Object)new AcceptedLanguage(null, 0.0f, 3, null));
        }
    }

    @NotNull
    public static final List<AcceptedLanguage> parseAcceptedLanguagesISO6391(@NotNull String $this$parseAcceptedLanguagesISO6391) {
        Intrinsics.checkNotNullParameter((Object)$this$parseAcceptedLanguagesISO6391, (String)"<this>");
        List<AcceptedLanguage> list = StringKt.parseAcceptedLanguages($this$parseAcceptedLanguagesISO6391);
        List newList = new ArrayList();
        if (list.isEmpty()) {
            return CollectionsKt.listOf((Object)new AcceptedLanguage(null, 0.0f, 3, null));
        }
        for (AcceptedLanguage lang : list) {
            AcceptedLanguage acceptedLanguage = new AcceptedLanguage(ISO6391Code.Companion.resolve(lang.getLanguage()).getCode(), lang.getQ());
            newList.add(acceptedLanguage);
        }
        return newList;
    }

    @NotNull
    public static final String doubleQuoteIfContainsUppercase(@NotNull String $this$doubleQuoteIfContainsUppercase) {
        boolean bl;
        Object str;
        block2: {
            Intrinsics.checkNotNullParameter((Object)$this$doubleQuoteIfContainsUppercase, (String)"<this>");
            str = StringsKt.replace$default((String)$this$doubleQuoteIfContainsUppercase, (String)"\"", (String)"", (boolean)false, (int)4, null);
            CharSequence $this$any$iv = (CharSequence)str;
            boolean $i$f$any = false;
            for (int i = 0; i < $this$any$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$any$iv.charAt(i);
                boolean bl2 = false;
                if (!Character.isUpperCase(it)) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        if (bl) {
            str = "\"" + (String)str + "\"";
        }
        return str;
    }

    @NotNull
    public static final String sanitizePgFunctionName(@NotNull String $this$sanitizePgFunctionName) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$sanitizePgFunctionName, (String)"<this>");
        Object object = $this$sanitizePgFunctionName;
        Object[] objectArray = new Regex("[^a-zA-Z0-9_.]");
        String string = "";
        object = objectArray.replace((CharSequence)object, string);
        objectArray = new Regex("\\.+");
        string = ".";
        String str = objectArray.replace((CharSequence)object, string);
        if (StringsKt.contains$default((CharSequence)str, (CharSequence)".", (boolean)false, (int)2, null)) {
            objectArray = new char[1];
            objectArray[0] = (String)46;
            list = CollectionsKt.plus((Collection)CollectionsKt.take((Iterable)StringsKt.split$default((CharSequence)str, (char[])objectArray, (boolean)false, (int)0, (int)6, null), (int)2), (Object)"");
        } else {
            objectArray = new String[]{"", str};
            list = CollectionsKt.listOf((Object[])objectArray);
        }
        object = list;
        String schema = (String)object.get(0);
        String fnName = (String)object.get(1);
        schema = StringKt.doubleQuoteIfContainsUppercase(schema);
        fnName = StringKt.doubleQuoteIfContainsUppercase(fnName);
        return ((CharSequence)schema).length() > 0 ? schema + "." + fnName : fnName;
    }

    @NotNull
    public static final String intoPgFunctionQuery(@NotNull String $this$intoPgFunctionQuery, int varsCount, @NotNull String suffix) {
        Intrinsics.checkNotNullParameter((Object)$this$intoPgFunctionQuery, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        String fnName = StringKt.sanitizePgFunctionName($this$intoPgFunctionQuery);
        String varPlaceHolders2 = CollectionsKt.joinToString$default((Iterable)((Iterable)new IntRange(1, varsCount)), null, null, null, (int)0, null, (Function1)intoPgFunctionQuery.varPlaceHolders.1.INSTANCE, (int)31, null);
        String sanSuffix = ((Object)StringsKt.trim((CharSequence)suffix)).toString();
        return "select " + fnName + "(" + varPlaceHolders2 + ")" + sanSuffix + ";";
    }

    public static /* synthetic */ String intoPgFunctionQuery$default(String string, int n, String string2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        if ((n2 & 2) != 0) {
            string2 = "";
        }
        return StringKt.intoPgFunctionQuery(string, n, string2);
    }
}

