/*
 * BrAPI-Genotyping
 * The Breeding API (BrAPI) is a Standardized REST ful Web Service API Specification for communicating Plant Breeding Data. BrAPI allows for easy data sharing between databases and tools involved in plant breeding. <div class=\"brapi-section\"> <h2 class=\"brapi-section-title\">General Reference Documentation</h2> <div class=\"gen-info-link\"><a href=\"https://wiki.brapi.org/index.php/RESTfulness\">URL Structure</a></div> <div class=\"gen-info-link\"><a href=\"https://wiki.brapi.org/index.php/Response_Structure\">Response Structure</a></div> <div class=\"gen-info-link\"><a href=\"https://wiki.brapi.org/index.php/Dates_and_Times\">Date/Time Encoding</a></div> <div class=\"gen-info-link\"><a href=\"https://wiki.brapi.org/index.php/Location_Coordinates\">Location Encoding</a></div> <div class=\"gen-info-link\"><a href=\"https://wiki.brapi.org/index.php/Error_Handling\">Error Handling</a></div> <div class=\"gen-info-link\"><a href=\"https://wiki.brapi.org/index.php/Search_Services\">Search Services</a></div> </div>  <div class=\"brapi-section\"> <h2 class=\"brapi-section-title\">BrAPI Core</h2> <div class=\"brapi-section-description\">The BrAPI Core module contains high level entities used for organization and management. This includes Programs, Trials, Studies, Locations, People, and Lists</div> <div class=\"version-number\">V2.1</div> <div class=\"link-btn\"><a href=\"https://github.com/plantbreeding/API/tree/brapi-V2.1/Specification/BrAPI-Core\">GitHub</a></div> <div class=\"link-btn\"><a href=\"https://app.swaggerhub.com/apis/PlantBreedingAPI/BrAPI-Core/2.1\">SwaggerHub</a></div> <div class=\"link-btn\"><a href=\"https://brapicore21.docs.apiary.io\">Apiary</a></div> <div class=\"stop-float\"></div> </div>  <div class=\"brapi-section\"> <h2 class=\"brapi-section-title\">BrAPI Phenotyping</h2> <div class=\"brapi-section-description\">The BrAPI Phenotyping module contains entities related to phenotypic observations. This includes Observation Units, Observations, Observation Variables, Traits, Scales, Methods, and Images</div> <div class=\"version-number\">V2.1</div> <div class=\"link-btn\"><a href=\"https://github.com/plantbreeding/API/tree/brapi-V2.1/Specification/BrAPI-Phenotyping\">GitHub</a></div> <div class=\"link-btn\"><a href=\"https://app.swaggerhub.com/apis/PlantBreedingAPI/BrAPI-Phenotyping/2.1\">SwaggerHub</a></div> <div class=\"link-btn\"><a href=\"https://brapiphenotyping21.docs.apiary.io\">Apiary</a></div> <div class=\"stop-float\"></div> </div>  <div class=\"current-brapi-section brapi-section\"> <h2 class=\"brapi-section-title\">BrAPI Genotyping</h2> <div class=\"brapi-section-description\">The BrAPI Genotyping module contains entities related to genotyping analysis. This includes Samples, Markers, Variant Sets, Variants, Call Sets, Calls, References, Reads, and Vendor Orders</div> <div class=\"version-number\">V2.1</div> <div class=\"link-btn\"><a href=\"https://github.com/plantbreeding/API/tree/brapi-V2.1/Specification/BrAPI-Genotyping\">GitHub</a></div> <div class=\"link-btn\"><a href=\"https://app.swaggerhub.com/apis/PlantBreedingAPI/BrAPI-Genotyping/2.1\">SwaggerHub</a></div> <div class=\"link-btn\"><a href=\"https://brapigenotyping21.docs.apiary.io\">Apiary</a></div> <div class=\"stop-float\"></div> </div>  <div class=\"brapi-section\"> <h2 class=\"brapi-section-title\">BrAPI Germplasm</h2> <div class=\"brapi-section-description\">The BrAPI Germplasm module contains entities related to germplasm management. This includes Germplasm, Germplasm Attributes, Seed Lots, Crosses, Pedigree, and Progeny</div> <div class=\"version-number\">V2.1</div> <div class=\"link-btn\"><a href=\"https://github.com/plantbreeding/API/tree/brapi-V2.1/Specification/BrAPI-Germplasm\">GitHub</a></div> <div class=\"link-btn\"><a href=\"https://app.swaggerhub.com/apis/PlantBreedingAPI/BrAPI-Germplasm/2.1\">SwaggerHub</a></div> <div class=\"link-btn\"><a href=\"https://brapigermplasm21.docs.apiary.io\">Apiary</a></div> <div class=\"stop-float\"></div> </div>  <style> .link-btn{ float: left;  margin: 2px 10px 0 0;  padding: 0 5px;  border-radius: 5px;  background-color: #ddd; } .stop-float{   clear: both; } .version-number{   float: left;    margin: 5px 10px 0 5px; } .brapi-section-title{   margin: 0 10px 0 0;   font-size: 20px; } .current-brapi-section{   font-weight: bolder;   border-radius: 5px;    background-color: #ddd; } .brapi-section{   padding: 5px 5px;  } .brapi-section-description{   margin: 5px 0 0 5px; } </style>
 *
 * OpenAPI spec version: 2.1
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package org.brapi.v2.model.geno;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
/**
 * This is a single data matrix. It could be the allele matrix or an additional layer of metadata associated with each genotype value.
 */
public class BrAPIAlleleMatrixDataMatrices {
  @JsonProperty("dataMatrix")
  private List<List<String>> dataMatrix = null;

  @JsonProperty("dataMatrixAbbreviation")
  private String dataMatrixAbbreviation = null;

  @JsonProperty("dataMatrixName")
  private String dataMatrixName = null;

  @JsonProperty("dataType")
  private BrAPIDataTypeEnum dataType = null;

  public BrAPIAlleleMatrixDataMatrices dataMatrix(List<List<String>> dataMatrix) {
    this.dataMatrix = dataMatrix;
    return this;
  }

  public BrAPIAlleleMatrixDataMatrices addDataMatrixItem(List<String> dataMatrixItem) {
    if (this.dataMatrix == null) {
      this.dataMatrix = new ArrayList<List<String>>();
    }
    this.dataMatrix.add(dataMatrixItem);
    return this;
  }

   /**
   * The two dimensional array of data, providing the allele matrix or an additional layer of metadata associated with each genotype value. Each matrix should be the same size and orientation, aligned with the \&quot;callSetDbIds\&quot; as columns and the \&quot;variantDbIds\&quot; as rows.
   * @return dataMatrix
  **/
  public List<List<String>> getDataMatrix() {
    return dataMatrix;
  }

  public void setDataMatrix(List<List<String>> dataMatrix) {
    this.dataMatrix = dataMatrix;
  }

  public BrAPIAlleleMatrixDataMatrices dataMatrixAbbreviation(String dataMatrixAbbreviation) {
    this.dataMatrixAbbreviation = dataMatrixAbbreviation;
    return this;
  }

   /**
   * The abbreviated code of the field represented in this data matrix. These codes should match the VCF standard when possible and the key word \&quot;GT\&quot; is reserved for the allele matrix. Examples of other metadata matrices include: \&quot;GQ\&quot;, \&quot;RD\&quot;, and \&quot;HQ\&quot; &lt;br&gt; This maps to a FORMAT field in the VCF file standard.
   * @return dataMatrixAbbreviation
  **/
  public String getDataMatrixAbbreviation() {
    return dataMatrixAbbreviation;
  }

  public void setDataMatrixAbbreviation(String dataMatrixAbbreviation) {
    this.dataMatrixAbbreviation = dataMatrixAbbreviation;
  }

  public BrAPIAlleleMatrixDataMatrices dataMatrixName(String dataMatrixName) {
    this.dataMatrixName = dataMatrixName;
    return this;
  }

   /**
   * The name of the field represented in this data matrix. The key word \&quot;Genotype\&quot; is reserved for the allele matrix. Examples of other metadata matrices include: \&quot;Genotype Quality\&quot;, \&quot;Read Depth\&quot;, and \&quot;Haplotype Quality\&quot; &lt;br&gt; This maps to a FORMAT field in the VCF file standard.
   * @return dataMatrixName
  **/
  public String getDataMatrixName() {
    return dataMatrixName;
  }

  public void setDataMatrixName(String dataMatrixName) {
    this.dataMatrixName = dataMatrixName;
  }

  public BrAPIAlleleMatrixDataMatrices dataType(BrAPIDataTypeEnum dataType) {
    this.dataType = dataType;
    return this;
  }

   /**
   * The type of field represented in this data matrix. This is intended to help parse the data out of JSON.
   * @return dataType
  **/
  public BrAPIDataTypeEnum getDataType() {
    return dataType;
  }

  public void setDataType(BrAPIDataTypeEnum dataType) {
    this.dataType = dataType;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BrAPIAlleleMatrixDataMatrices alleleMatrixDataMatrices = (BrAPIAlleleMatrixDataMatrices) o;
    return Objects.equals(this.dataMatrix, alleleMatrixDataMatrices.dataMatrix) &&
        Objects.equals(this.dataMatrixAbbreviation, alleleMatrixDataMatrices.dataMatrixAbbreviation) &&
        Objects.equals(this.dataMatrixName, alleleMatrixDataMatrices.dataMatrixName) &&
        Objects.equals(this.dataType, alleleMatrixDataMatrices.dataType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(dataMatrix, dataMatrixAbbreviation, dataMatrixName, dataType);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AlleleMatrixDataMatrices {\n");
    
    sb.append("    dataMatrix: ").append(toIndentedString(dataMatrix)).append("\n");
    sb.append("    dataMatrixAbbreviation: ").append(toIndentedString(dataMatrixAbbreviation)).append("\n");
    sb.append("    dataMatrixName: ").append(toIndentedString(dataMatrixName)).append("\n");
    sb.append("    dataType: ").append(toIndentedString(dataType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
