/*
 * BrAPI-Genotyping
 * The Breeding API (BrAPI) is a Standardized REST ful Web Service API Specification for communicating Plant Breeding Data. BrAPI allows for easy data sharing between databases and tools involved in plant breeding. <div class=\"brapi-section\"> <h2 class=\"brapi-section-title\">General Reference Documentation</h2> <div class=\"gen-info-link\"><a href=\"https://wiki.brapi.org/index.php/RESTfulness\">URL Structure</a></div> <div class=\"gen-info-link\"><a href=\"https://wiki.brapi.org/index.php/Response_Structure\">Response Structure</a></div> <div class=\"gen-info-link\"><a href=\"https://wiki.brapi.org/index.php/Dates_and_Times\">Date/Time Encoding</a></div> <div class=\"gen-info-link\"><a href=\"https://wiki.brapi.org/index.php/Location_Coordinates\">Location Encoding</a></div> <div class=\"gen-info-link\"><a href=\"https://wiki.brapi.org/index.php/Error_Handling\">Error Handling</a></div> <div class=\"gen-info-link\"><a href=\"https://wiki.brapi.org/index.php/Search_Services\">Search Services</a></div> </div>  <div class=\"brapi-section\"> <h2 class=\"brapi-section-title\">BrAPI Core</h2> <div class=\"brapi-section-description\">The BrAPI Core module contains high level entities used for organization and management. This includes Programs, Trials, Studies, Locations, People, and Lists</div> <div class=\"version-number\">V2.1</div> <div class=\"link-btn\"><a href=\"https://github.com/plantbreeding/API/tree/brapi-V2.1/Specification/BrAPI-Core\">GitHub</a></div> <div class=\"link-btn\"><a href=\"https://app.swaggerhub.com/apis/PlantBreedingAPI/BrAPI-Core/2.1\">SwaggerHub</a></div> <div class=\"link-btn\"><a href=\"https://brapicore21.docs.apiary.io\">Apiary</a></div> <div class=\"stop-float\"></div> </div>  <div class=\"brapi-section\"> <h2 class=\"brapi-section-title\">BrAPI Phenotyping</h2> <div class=\"brapi-section-description\">The BrAPI Phenotyping module contains entities related to phenotypic observations. This includes Observation Units, Observations, Observation Variables, Traits, Scales, Methods, and Images</div> <div class=\"version-number\">V2.1</div> <div class=\"link-btn\"><a href=\"https://github.com/plantbreeding/API/tree/brapi-V2.1/Specification/BrAPI-Phenotyping\">GitHub</a></div> <div class=\"link-btn\"><a href=\"https://app.swaggerhub.com/apis/PlantBreedingAPI/BrAPI-Phenotyping/2.1\">SwaggerHub</a></div> <div class=\"link-btn\"><a href=\"https://brapiphenotyping21.docs.apiary.io\">Apiary</a></div> <div class=\"stop-float\"></div> </div>  <div class=\"current-brapi-section brapi-section\"> <h2 class=\"brapi-section-title\">BrAPI Genotyping</h2> <div class=\"brapi-section-description\">The BrAPI Genotyping module contains entities related to genotyping analysis. This includes Samples, Markers, Variant Sets, Variants, Call Sets, Calls, References, Reads, and Vendor Orders</div> <div class=\"version-number\">V2.1</div> <div class=\"link-btn\"><a href=\"https://github.com/plantbreeding/API/tree/brapi-V2.1/Specification/BrAPI-Genotyping\">GitHub</a></div> <div class=\"link-btn\"><a href=\"https://app.swaggerhub.com/apis/PlantBreedingAPI/BrAPI-Genotyping/2.1\">SwaggerHub</a></div> <div class=\"link-btn\"><a href=\"https://brapigenotyping21.docs.apiary.io\">Apiary</a></div> <div class=\"stop-float\"></div> </div>  <div class=\"brapi-section\"> <h2 class=\"brapi-section-title\">BrAPI Germplasm</h2> <div class=\"brapi-section-description\">The BrAPI Germplasm module contains entities related to germplasm management. This includes Germplasm, Germplasm Attributes, Seed Lots, Crosses, Pedigree, and Progeny</div> <div class=\"version-number\">V2.1</div> <div class=\"link-btn\"><a href=\"https://github.com/plantbreeding/API/tree/brapi-V2.1/Specification/BrAPI-Germplasm\">GitHub</a></div> <div class=\"link-btn\"><a href=\"https://app.swaggerhub.com/apis/PlantBreedingAPI/BrAPI-Germplasm/2.1\">SwaggerHub</a></div> <div class=\"link-btn\"><a href=\"https://brapigermplasm21.docs.apiary.io\">Apiary</a></div> <div class=\"stop-float\"></div> </div>  <style> .link-btn{ float: left;  margin: 2px 10px 0 0;  padding: 0 5px;  border-radius: 5px;  background-color: #ddd; } .stop-float{   clear: both; } .version-number{   float: left;    margin: 5px 10px 0 5px; } .brapi-section-title{   margin: 0 10px 0 0;   font-size: 20px; } .current-brapi-section{   font-weight: bolder;   border-radius: 5px;    background-color: #ddd; } .brapi-section{   padding: 5px 5px;  } .brapi-section-description{   margin: 5px 0 0 5px; } </style>
 *
 * OpenAPI spec version: 2.1
 *
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package org.brapi.v2.model.geno;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.brapi.v2.model.BrAPIExternalReference;

import javax.validation.Valid;
import java.util.List;
import java.util.Objects;

/**
 * Plate
 */

public class BrAPIPlate {
    private final transient Gson gson = new Gson();

    @JsonProperty("additionalInfo")
    private JsonObject additionalInfo = null;

    @JsonProperty("externalReferences")
    private List<BrAPIExternalReference> externalReferences = null;

    @JsonProperty("plateBarcode")
    private String plateBarcode = null;

    @JsonProperty("plateDbId")
    private String plateDbId = null;

    @JsonProperty("plateFormat")
    private BrAPIPlateFormat plateFormat = null;

    @JsonProperty("plateName")
    private String plateName = null;

    @JsonProperty("programDbId")
    private String programDbId = null;

    @JsonProperty("sampleType")
    private BrAPISampleTypeEnum sampleType = null;

    @JsonProperty("studyDbId")
    private String studyDbId = null;

    @JsonProperty("trialDbId")
    private String trialDbId = null;

    public BrAPIPlate additionalInfo(JsonObject additionalInfo) {
        this.additionalInfo = additionalInfo;
        return this;
    }

    public BrAPIPlate putAdditionalInfoItem(String key, Object additionalInfoItem) {
        if (this.additionalInfo == null) {
            this.additionalInfo = new JsonObject();
        }
        JsonElement newElement = gson.toJsonTree(additionalInfoItem);
        this.additionalInfo.add(key, newElement);
        return this;
    }

    /**
     * Additional arbitrary info
     * @return additionalInfo
     **/


    public JsonObject getAdditionalInfo() {
        return additionalInfo;
    }

    public void setAdditionalInfo(JsonObject additionalInfo) {
        this.additionalInfo = additionalInfo;
    }

    public BrAPIPlate externalReferences(List<BrAPIExternalReference> externalReferences) {
        this.externalReferences = externalReferences;
        return this;
    }

    /**
     * Get externalReferences
     * @return externalReferences
     **/


    @Valid
    public List<BrAPIExternalReference> getExternalReferences() {
        return externalReferences;
    }

    public void setExternalReferences(List<BrAPIExternalReference> externalReferences) {
        this.externalReferences = externalReferences;
    }

    public BrAPIPlate plateBarcode(String plateBarcode) {
        this.plateBarcode = plateBarcode;
        return this;
    }

    /**
     * A unique identifier physically attached to a &#x60;Plate&#x60;
     *
     * @return plateBarcode
     **/
    public String getPlateBarcode() {
        return plateBarcode;
    }

    public void setPlateBarcode(String plateBarcode) {
        this.plateBarcode = plateBarcode;
    }

    public BrAPIPlate plateDbId(String plateDbId) {
        this.plateDbId = plateDbId;
        return this;
    }

    /**
     * The ID which uniquely identifies a &#x60;Plate&#x60;
     *
     * @return plateDbId
     **/
    public String getPlateDbId() {
        return plateDbId;
    }

    public void setPlateDbId(String plateDbId) {
        this.plateDbId = plateDbId;
    }

    public BrAPIPlate plateFormat(BrAPIPlateFormat plateFormat) {
        this.plateFormat = plateFormat;
        return this;
    }

    /**
     * Enum for plate formats, usually \&quot;PLATE_96\&quot; for a 96 well plate or \&quot;TUBES\&quot; for plateless format
     *
     * @return plateFormat
     **/
    public BrAPIPlateFormat getPlateFormat() {
        return plateFormat;
    }

    public void setPlateFormat(BrAPIPlateFormat plateFormat) {
        this.plateFormat = plateFormat;
    }

    public BrAPIPlate plateName(String plateName) {
        this.plateName = plateName;
        return this;
    }

    /**
     * A human readable name for a &#x60;Plate&#x60;
     *
     * @return plateName
     **/
    public String getPlateName() {
        return plateName;
    }

    public void setPlateName(String plateName) {
        this.plateName = plateName;
    }

    public BrAPIPlate programDbId(String programDbId) {
        this.programDbId = programDbId;
        return this;
    }

    /**
     * The ID which uniquely identifies a &#x60;Program&#x60; within the given database server
     *
     * @return programDbId
     **/
    public String getProgramDbId() {
        return programDbId;
    }

    public void setProgramDbId(String programDbId) {
        this.programDbId = programDbId;
    }

    public BrAPIPlate sampleType(BrAPISampleTypeEnum sampleType) {
        this.sampleType = sampleType;
        return this;
    }

    /**
     * The type of samples taken. ex. &#x27;DNA&#x27;, &#x27;RNA&#x27;, &#x27;Tissue&#x27;, etc
     *
     * @return sampleType
     **/
    public BrAPISampleTypeEnum getSampleType() {
        return sampleType;
    }

    public void setSampleType(BrAPISampleTypeEnum sampleType) {
        this.sampleType = sampleType;
    }

    public BrAPIPlate studyDbId(String studyDbId) {
        this.studyDbId = studyDbId;
        return this;
    }

    /**
     * The ID which uniquely identifies a &#x60;Study&#x60; within the given database server
     *
     * @return studyDbId
     **/
    public String getStudyDbId() {
        return studyDbId;
    }

    public void setStudyDbId(String studyDbId) {
        this.studyDbId = studyDbId;
    }

    public BrAPIPlate trialDbId(String trialDbId) {
        this.trialDbId = trialDbId;
        return this;
    }

    /**
     * The ID which uniquely identifies a &#x60;Trial&#x60; within the given database server
     *
     * @return trialDbId
     **/
    public String getTrialDbId() {
        return trialDbId;
    }

    public void setTrialDbId(String trialDbId) {
        this.trialDbId = trialDbId;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BrAPIPlate plate = (BrAPIPlate) o;
        return Objects.equals(this.additionalInfo, plate.additionalInfo) &&
                Objects.equals(this.externalReferences, plate.externalReferences) &&
                Objects.equals(this.plateBarcode, plate.plateBarcode) &&
                Objects.equals(this.plateDbId, plate.plateDbId) &&
                Objects.equals(this.plateFormat, plate.plateFormat) &&
                Objects.equals(this.plateName, plate.plateName) &&
                Objects.equals(this.programDbId, plate.programDbId) &&
                Objects.equals(this.sampleType, plate.sampleType) &&
                Objects.equals(this.studyDbId, plate.studyDbId) &&
                Objects.equals(this.trialDbId, plate.trialDbId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(additionalInfo, externalReferences, plateBarcode, plateDbId, plateFormat, plateName, programDbId, sampleType, studyDbId, trialDbId);
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Plate {\n");

        sb.append("    additionalInfo: ").append(toIndentedString(additionalInfo)).append("\n");
        sb.append("    externalReferences: ").append(toIndentedString(externalReferences)).append("\n");
        sb.append("    plateBarcode: ").append(toIndentedString(plateBarcode)).append("\n");
        sb.append("    plateDbId: ").append(toIndentedString(plateDbId)).append("\n");
        sb.append("    plateFormat: ").append(toIndentedString(plateFormat)).append("\n");
        sb.append("    plateName: ").append(toIndentedString(plateName)).append("\n");
        sb.append("    programDbId: ").append(toIndentedString(programDbId)).append("\n");
        sb.append("    sampleType: ").append(toIndentedString(sampleType)).append("\n");
        sb.append("    studyDbId: ").append(toIndentedString(studyDbId)).append("\n");
        sb.append("    trialDbId: ").append(toIndentedString(trialDbId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
