/*
 * BrAPI-Genotyping
 * The Breeding API (BrAPI) is a Standardized REST ful Web Service API Specification for communicating Plant Breeding Data. BrAPI allows for easy data sharing between databases and tools involved in plant breeding. <div class=\"brapi-section\"> <h2 class=\"brapi-section-title\">General Reference Documentation</h2> <div class=\"gen-info-link\"><a href=\"https://wiki.brapi.org/index.php/RESTfulness\">URL Structure</a></div> <div class=\"gen-info-link\"><a href=\"https://wiki.brapi.org/index.php/Response_Structure\">Response Structure</a></div> <div class=\"gen-info-link\"><a href=\"https://wiki.brapi.org/index.php/Dates_and_Times\">Date/Time Encoding</a></div> <div class=\"gen-info-link\"><a href=\"https://wiki.brapi.org/index.php/Location_Coordinates\">Location Encoding</a></div> <div class=\"gen-info-link\"><a href=\"https://wiki.brapi.org/index.php/Error_Handling\">Error Handling</a></div> <div class=\"gen-info-link\"><a href=\"https://wiki.brapi.org/index.php/Search_Services\">Search Services</a></div> </div>  <div class=\"brapi-section\"> <h2 class=\"brapi-section-title\">BrAPI Core</h2> <div class=\"brapi-section-description\">The BrAPI Core module contains high level entities used for organization and management. This includes Programs, Trials, Studies, Locations, People, and Lists</div> <div class=\"version-number\">V2.1</div> <div class=\"link-btn\"><a href=\"https://github.com/plantbreeding/API/tree/brapi-V2.1/Specification/BrAPI-Core\">GitHub</a></div> <div class=\"link-btn\"><a href=\"https://app.swaggerhub.com/apis/PlantBreedingAPI/BrAPI-Core/2.1\">SwaggerHub</a></div> <div class=\"link-btn\"><a href=\"https://brapicore21.docs.apiary.io\">Apiary</a></div> <div class=\"stop-float\"></div> </div>  <div class=\"brapi-section\"> <h2 class=\"brapi-section-title\">BrAPI Phenotyping</h2> <div class=\"brapi-section-description\">The BrAPI Phenotyping module contains entities related to phenotypic observations. This includes Observation Units, Observations, Observation Variables, Traits, Scales, Methods, and Images</div> <div class=\"version-number\">V2.1</div> <div class=\"link-btn\"><a href=\"https://github.com/plantbreeding/API/tree/brapi-V2.1/Specification/BrAPI-Phenotyping\">GitHub</a></div> <div class=\"link-btn\"><a href=\"https://app.swaggerhub.com/apis/PlantBreedingAPI/BrAPI-Phenotyping/2.1\">SwaggerHub</a></div> <div class=\"link-btn\"><a href=\"https://brapiphenotyping21.docs.apiary.io\">Apiary</a></div> <div class=\"stop-float\"></div> </div>  <div class=\"current-brapi-section brapi-section\"> <h2 class=\"brapi-section-title\">BrAPI Genotyping</h2> <div class=\"brapi-section-description\">The BrAPI Genotyping module contains entities related to genotyping analysis. This includes Samples, Markers, Variant Sets, Variants, Call Sets, Calls, References, Reads, and Vendor Orders</div> <div class=\"version-number\">V2.1</div> <div class=\"link-btn\"><a href=\"https://github.com/plantbreeding/API/tree/brapi-V2.1/Specification/BrAPI-Genotyping\">GitHub</a></div> <div class=\"link-btn\"><a href=\"https://app.swaggerhub.com/apis/PlantBreedingAPI/BrAPI-Genotyping/2.1\">SwaggerHub</a></div> <div class=\"link-btn\"><a href=\"https://brapigenotyping21.docs.apiary.io\">Apiary</a></div> <div class=\"stop-float\"></div> </div>  <div class=\"brapi-section\"> <h2 class=\"brapi-section-title\">BrAPI Germplasm</h2> <div class=\"brapi-section-description\">The BrAPI Germplasm module contains entities related to germplasm management. This includes Germplasm, Germplasm Attributes, Seed Lots, Crosses, Pedigree, and Progeny</div> <div class=\"version-number\">V2.1</div> <div class=\"link-btn\"><a href=\"https://github.com/plantbreeding/API/tree/brapi-V2.1/Specification/BrAPI-Germplasm\">GitHub</a></div> <div class=\"link-btn\"><a href=\"https://app.swaggerhub.com/apis/PlantBreedingAPI/BrAPI-Germplasm/2.1\">SwaggerHub</a></div> <div class=\"link-btn\"><a href=\"https://brapigermplasm21.docs.apiary.io\">Apiary</a></div> <div class=\"stop-float\"></div> </div>  <style> .link-btn{ float: left;  margin: 2px 10px 0 0;  padding: 0 5px;  border-radius: 5px;  background-color: #ddd; } .stop-float{   clear: both; } .version-number{   float: left;    margin: 5px 10px 0 5px; } .brapi-section-title{   margin: 0 10px 0 0;   font-size: 20px; } .current-brapi-section{   font-weight: bolder;   border-radius: 5px;    background-color: #ddd; } .brapi-section{   padding: 5px 5px;  } .brapi-section-description{   margin: 5px 0 0 5px; } </style>
 *
 * OpenAPI spec version: 2.1
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package org.brapi.v2.model.geno.request;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
/**
 * AlleleMatrixSearchRequest
 */

public class BrAPIAlleleMatrixSearchRequest {
  @JsonProperty("callSetDbIds")
  private List<String> callSetDbIds = null;

  @JsonProperty("dataMatrixAbbreviations")
  private List<String> dataMatrixAbbreviations = null;

  @JsonProperty("dataMatrixNames")
  private List<String> dataMatrixNames = null;

  @JsonProperty("expandHomozygotes")
  private Boolean expandHomozygotes = null;

  @JsonProperty("germplasmDbIds")
  private List<String> germplasmDbIds = null;

  @JsonProperty("germplasmNames")
  private List<String> germplasmNames = null;

  @JsonProperty("germplasmPUIs")
  private List<String> germplasmPUIs = null;

  @JsonProperty("pagination")
  private List<BrAPIAlleleMatrixSearchRequestPagination> pagination = null;

  @JsonProperty("positionRanges")
  private List<String> positionRanges = null;

  @JsonProperty("preview")
  private Boolean preview = false;

  @JsonProperty("sampleDbIds")
  private List<String> sampleDbIds = null;

  @JsonProperty("sepPhased")
  private String sepPhased = null;

  @JsonProperty("sepUnphased")
  private String sepUnphased = null;

  @JsonProperty("unknownString")
  private String unknownString = null;

  @JsonProperty("variantDbIds")
  private List<String> variantDbIds = null;

  @JsonProperty("variantSetDbIds")
  private List<String> variantSetDbIds = null;

  public BrAPIAlleleMatrixSearchRequest callSetDbIds(List<String> callSetDbIds) {
    this.callSetDbIds = callSetDbIds;
    return this;
  }

  public BrAPIAlleleMatrixSearchRequest addCallSetDbIdsItem(String callSetDbIdsItem) {
    if (this.callSetDbIds == null) {
      this.callSetDbIds = new ArrayList<String>();
    }
    this.callSetDbIds.add(callSetDbIdsItem);
    return this;
  }

   /**
   * A list of IDs which uniquely identify &#x60;CallSets&#x60; within the given database server
   * @return callSetDbIds
  **/
  public List<String> getCallSetDbIds() {
    return callSetDbIds;
  }

  public void setCallSetDbIds(List<String> callSetDbIds) {
    this.callSetDbIds = callSetDbIds;
  }

  public BrAPIAlleleMatrixSearchRequest dataMatrixAbbreviations(List<String> dataMatrixAbbreviations) {
    this.dataMatrixAbbreviations = dataMatrixAbbreviations;
    return this;
  }

  public BrAPIAlleleMatrixSearchRequest addDataMatrixAbbreviationsItem(String dataMatrixAbbreviationsItem) {
    if (this.dataMatrixAbbreviations == null) {
      this.dataMatrixAbbreviations = new ArrayList<String>();
    }
    this.dataMatrixAbbreviations.add(dataMatrixAbbreviationsItem);
    return this;
  }

   /**
   * &#x60;dataMatrixAbbreviations&#x60; is a comma seperated list of abbreviations (ie &#x27;GT&#x27;, &#x27;RD&#x27; etc). This list controls which data matrices are returned in the response.
   * @return dataMatrixAbbreviations
  **/
  public List<String> getDataMatrixAbbreviations() {
    return dataMatrixAbbreviations;
  }

  public void setDataMatrixAbbreviations(List<String> dataMatrixAbbreviations) {
    this.dataMatrixAbbreviations = dataMatrixAbbreviations;
  }

  public BrAPIAlleleMatrixSearchRequest dataMatrixNames(List<String> dataMatrixNames) {
    this.dataMatrixNames = dataMatrixNames;
    return this;
  }

  public BrAPIAlleleMatrixSearchRequest addDataMatrixNamesItem(String dataMatrixNamesItem) {
    if (this.dataMatrixNames == null) {
      this.dataMatrixNames = new ArrayList<String>();
    }
    this.dataMatrixNames.add(dataMatrixNamesItem);
    return this;
  }

   /**
   * &#x60;dataMatrixNames&#x60; is a list of names (ie &#x27;Genotype&#x27;, &#x27;Read Depth&#x27; etc). This list controls which data matrices are returned in the response.
   * @return dataMatrixNames
  **/
  public List<String> getDataMatrixNames() {
    return dataMatrixNames;
  }

  public void setDataMatrixNames(List<String> dataMatrixNames) {
    this.dataMatrixNames = dataMatrixNames;
  }

  public BrAPIAlleleMatrixSearchRequest expandHomozygotes(Boolean expandHomozygotes) {
    this.expandHomozygotes = expandHomozygotes;
    return this;
  }

   /**
   * Should homozygotes be expanded (true) or collapsed into a single occurrence (false)
   * @return expandHomozygotes
  **/
  public Boolean isExpandHomozygotes() {
    return expandHomozygotes;
  }

  public void setExpandHomozygotes(Boolean expandHomozygotes) {
    this.expandHomozygotes = expandHomozygotes;
  }

  public BrAPIAlleleMatrixSearchRequest germplasmDbIds(List<String> germplasmDbIds) {
    this.germplasmDbIds = germplasmDbIds;
    return this;
  }

  public BrAPIAlleleMatrixSearchRequest addGermplasmDbIdsItem(String germplasmDbIdsItem) {
    if (this.germplasmDbIds == null) {
      this.germplasmDbIds = new ArrayList<String>();
    }
    this.germplasmDbIds.add(germplasmDbIdsItem);
    return this;
  }

   /**
   * A list of IDs which uniquely identify &#x60;Germplasm&#x60; within the given database server
   * @return germplasmDbIds
  **/
  public List<String> getGermplasmDbIds() {
    return germplasmDbIds;
  }

  public void setGermplasmDbIds(List<String> germplasmDbIds) {
    this.germplasmDbIds = germplasmDbIds;
  }

  public BrAPIAlleleMatrixSearchRequest germplasmNames(List<String> germplasmNames) {
    this.germplasmNames = germplasmNames;
    return this;
  }

  public BrAPIAlleleMatrixSearchRequest addGermplasmNamesItem(String germplasmNamesItem) {
    if (this.germplasmNames == null) {
      this.germplasmNames = new ArrayList<String>();
    }
    this.germplasmNames.add(germplasmNamesItem);
    return this;
  }

   /**
   * A list of human readable &#x60;Germplasm&#x60; names
   * @return germplasmNames
  **/
  public List<String> getGermplasmNames() {
    return germplasmNames;
  }

  public void setGermplasmNames(List<String> germplasmNames) {
    this.germplasmNames = germplasmNames;
  }

  public BrAPIAlleleMatrixSearchRequest germplasmPUIs(List<String> germplasmPUIs) {
    this.germplasmPUIs = germplasmPUIs;
    return this;
  }

  public BrAPIAlleleMatrixSearchRequest addGermplasmPUIsItem(String germplasmPUIsItem) {
    if (this.germplasmPUIs == null) {
      this.germplasmPUIs = new ArrayList<String>();
    }
    this.germplasmPUIs.add(germplasmPUIsItem);
    return this;
  }

   /**
   * A list of premenant unique identifiers associated with &#x60;Germplasm&#x60;
   * @return germplasmPUIs
  **/
  public List<String> getGermplasmPUIs() {
    return germplasmPUIs;
  }

  public void setGermplasmPUIs(List<String> germplasmPUIs) {
    this.germplasmPUIs = germplasmPUIs;
  }

  public BrAPIAlleleMatrixSearchRequest pagination(List<BrAPIAlleleMatrixSearchRequestPagination> pagination) {
    this.pagination = pagination;
    return this;
  }

  public BrAPIAlleleMatrixSearchRequest addPaginationItem(BrAPIAlleleMatrixSearchRequestPagination paginationItem) {
    if (this.pagination == null) {
      this.pagination = new ArrayList<BrAPIAlleleMatrixSearchRequestPagination>();
    }
    this.pagination.add(paginationItem);
    return this;
  }

   /**
   * Pagination for the matrix
   * @return pagination
  **/
  public List<BrAPIAlleleMatrixSearchRequestPagination> getPagination() {
    return pagination;
  }

  public void setPagination(List<BrAPIAlleleMatrixSearchRequestPagination> pagination) {
    this.pagination = pagination;
  }

  public BrAPIAlleleMatrixSearchRequest positionRanges(List<String> positionRanges) {
    this.positionRanges = positionRanges;
    return this;
  }

  public BrAPIAlleleMatrixSearchRequest addPositionRangesItem(String positionRangesItem) {
    if (this.positionRanges == null) {
      this.positionRanges = new ArrayList<String>();
    }
    this.positionRanges.add(positionRangesItem);
    return this;
  }

   /**
   * The postion range to search &lt;br/&gt; Uses the format \&quot;&lt;chrom&gt;:&lt;start&gt;-&lt;end&gt;\&quot; where &lt;chrom&gt; is the chromosome name, &lt;start&gt; is  the starting position of the range, and &lt;end&gt; is the ending position of the range
   * @return positionRanges
  **/
  public List<String> getPositionRanges() {
    return positionRanges;
  }

  public void setPositionRanges(List<String> positionRanges) {
    this.positionRanges = positionRanges;
  }

  public BrAPIAlleleMatrixSearchRequest preview(Boolean preview) {
    this.preview = preview;
    return this;
  }

   /**
   * Default Value &#x3D; false &lt;br/&gt; If &#x27;preview&#x27; is set to true, then the server should only return the lists of &#x27;callSetDbIds&#x27;,  &#x27;variantDbIds&#x27;, and &#x27;variantSetDbIds&#x27;. The server should not return any matrix data. This is intended to be a preview and give the client a sense of how large the matrix returned will be &lt;br/&gt; If &#x27;preview&#x27; is set to false or not set (default), then the server should return all the matrix data as requested.
   * @return preview
  **/
  public Boolean isPreview() {
    return preview;
  }

  public void setPreview(Boolean preview) {
    this.preview = preview;
  }

  public BrAPIAlleleMatrixSearchRequest sampleDbIds(List<String> sampleDbIds) {
    this.sampleDbIds = sampleDbIds;
    return this;
  }

  public BrAPIAlleleMatrixSearchRequest addSampleDbIdsItem(String sampleDbIdsItem) {
    if (this.sampleDbIds == null) {
      this.sampleDbIds = new ArrayList<String>();
    }
    this.sampleDbIds.add(sampleDbIdsItem);
    return this;
  }

   /**
   * A list of IDs which uniquely identify &#x60;Samples&#x60; within the given database server
   * @return sampleDbIds
  **/
  public List<String> getSampleDbIds() {
    return sampleDbIds;
  }

  public void setSampleDbIds(List<String> sampleDbIds) {
    this.sampleDbIds = sampleDbIds;
  }

  public BrAPIAlleleMatrixSearchRequest sepPhased(String sepPhased) {
    this.sepPhased = sepPhased;
    return this;
  }

   /**
   * The string used as a separator for phased allele calls.
   * @return sepPhased
  **/
  public String getSepPhased() {
    return sepPhased;
  }

  public void setSepPhased(String sepPhased) {
    this.sepPhased = sepPhased;
  }

  public BrAPIAlleleMatrixSearchRequest sepUnphased(String sepUnphased) {
    this.sepUnphased = sepUnphased;
    return this;
  }

   /**
   * The string used as a separator for unphased allele calls.
   * @return sepUnphased
  **/
  public String getSepUnphased() {
    return sepUnphased;
  }

  public void setSepUnphased(String sepUnphased) {
    this.sepUnphased = sepUnphased;
  }

  public BrAPIAlleleMatrixSearchRequest unknownString(String unknownString) {
    this.unknownString = unknownString;
    return this;
  }

   /**
   * The string used as a representation for missing data.
   * @return unknownString
  **/
  public String getUnknownString() {
    return unknownString;
  }

  public void setUnknownString(String unknownString) {
    this.unknownString = unknownString;
  }

  public BrAPIAlleleMatrixSearchRequest variantDbIds(List<String> variantDbIds) {
    this.variantDbIds = variantDbIds;
    return this;
  }

  public BrAPIAlleleMatrixSearchRequest addVariantDbIdsItem(String variantDbIdsItem) {
    if (this.variantDbIds == null) {
      this.variantDbIds = new ArrayList<String>();
    }
    this.variantDbIds.add(variantDbIdsItem);
    return this;
  }

   /**
   * A list of IDs which uniquely identify &#x60;Variants&#x60; within the given database server
   * @return variantDbIds
  **/
  public List<String> getVariantDbIds() {
    return variantDbIds;
  }

  public void setVariantDbIds(List<String> variantDbIds) {
    this.variantDbIds = variantDbIds;
  }

  public BrAPIAlleleMatrixSearchRequest variantSetDbIds(List<String> variantSetDbIds) {
    this.variantSetDbIds = variantSetDbIds;
    return this;
  }

  public BrAPIAlleleMatrixSearchRequest addVariantSetDbIdsItem(String variantSetDbIdsItem) {
    if (this.variantSetDbIds == null) {
      this.variantSetDbIds = new ArrayList<String>();
    }
    this.variantSetDbIds.add(variantSetDbIdsItem);
    return this;
  }

   /**
   * A list of IDs which uniquely identify &#x60;VariantSets&#x60; within the given database server
   * @return variantSetDbIds
  **/
  public List<String> getVariantSetDbIds() {
    return variantSetDbIds;
  }

  public void setVariantSetDbIds(List<String> variantSetDbIds) {
    this.variantSetDbIds = variantSetDbIds;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BrAPIAlleleMatrixSearchRequest alleleMatrixSearchRequest = (BrAPIAlleleMatrixSearchRequest) o;
    return Objects.equals(this.callSetDbIds, alleleMatrixSearchRequest.callSetDbIds) &&
        Objects.equals(this.dataMatrixAbbreviations, alleleMatrixSearchRequest.dataMatrixAbbreviations) &&
        Objects.equals(this.dataMatrixNames, alleleMatrixSearchRequest.dataMatrixNames) &&
        Objects.equals(this.expandHomozygotes, alleleMatrixSearchRequest.expandHomozygotes) &&
        Objects.equals(this.germplasmDbIds, alleleMatrixSearchRequest.germplasmDbIds) &&
        Objects.equals(this.germplasmNames, alleleMatrixSearchRequest.germplasmNames) &&
        Objects.equals(this.germplasmPUIs, alleleMatrixSearchRequest.germplasmPUIs) &&
        Objects.equals(this.pagination, alleleMatrixSearchRequest.pagination) &&
        Objects.equals(this.positionRanges, alleleMatrixSearchRequest.positionRanges) &&
        Objects.equals(this.preview, alleleMatrixSearchRequest.preview) &&
        Objects.equals(this.sampleDbIds, alleleMatrixSearchRequest.sampleDbIds) &&
        Objects.equals(this.sepPhased, alleleMatrixSearchRequest.sepPhased) &&
        Objects.equals(this.sepUnphased, alleleMatrixSearchRequest.sepUnphased) &&
        Objects.equals(this.unknownString, alleleMatrixSearchRequest.unknownString) &&
        Objects.equals(this.variantDbIds, alleleMatrixSearchRequest.variantDbIds) &&
        Objects.equals(this.variantSetDbIds, alleleMatrixSearchRequest.variantSetDbIds);
  }

  @Override
  public int hashCode() {
    return Objects.hash(callSetDbIds, dataMatrixAbbreviations, dataMatrixNames, expandHomozygotes, germplasmDbIds, germplasmNames, germplasmPUIs, pagination, positionRanges, preview, sampleDbIds, sepPhased, sepUnphased, unknownString, variantDbIds, variantSetDbIds);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AlleleMatrixSearchRequest {\n");
    
    sb.append("    callSetDbIds: ").append(toIndentedString(callSetDbIds)).append("\n");
    sb.append("    dataMatrixAbbreviations: ").append(toIndentedString(dataMatrixAbbreviations)).append("\n");
    sb.append("    dataMatrixNames: ").append(toIndentedString(dataMatrixNames)).append("\n");
    sb.append("    expandHomozygotes: ").append(toIndentedString(expandHomozygotes)).append("\n");
    sb.append("    germplasmDbIds: ").append(toIndentedString(germplasmDbIds)).append("\n");
    sb.append("    germplasmNames: ").append(toIndentedString(germplasmNames)).append("\n");
    sb.append("    germplasmPUIs: ").append(toIndentedString(germplasmPUIs)).append("\n");
    sb.append("    pagination: ").append(toIndentedString(pagination)).append("\n");
    sb.append("    positionRanges: ").append(toIndentedString(positionRanges)).append("\n");
    sb.append("    preview: ").append(toIndentedString(preview)).append("\n");
    sb.append("    sampleDbIds: ").append(toIndentedString(sampleDbIds)).append("\n");
    sb.append("    sepPhased: ").append(toIndentedString(sepPhased)).append("\n");
    sb.append("    sepUnphased: ").append(toIndentedString(sepUnphased)).append("\n");
    sb.append("    unknownString: ").append(toIndentedString(unknownString)).append("\n");
    sb.append("    variantDbIds: ").append(toIndentedString(variantDbIds)).append("\n");
    sb.append("    variantSetDbIds: ").append(toIndentedString(variantSetDbIds)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
