/*
 * BrAPI-Genotyping
 * The Breeding API (BrAPI) is a Standardized REST ful Web Service API Specification for communicating Plant Breeding Data. BrAPI allows for easy data sharing between databases and tools involved in plant breeding. <div class=\"brapi-section\"> <h2 class=\"brapi-section-title\">General Reference Documentation</h2> <div class=\"gen-info-link\"><a href=\"https://wiki.brapi.org/index.php/RESTfulness\">URL Structure</a></div> <div class=\"gen-info-link\"><a href=\"https://wiki.brapi.org/index.php/Response_Structure\">Response Structure</a></div> <div class=\"gen-info-link\"><a href=\"https://wiki.brapi.org/index.php/Dates_and_Times\">Date/Time Encoding</a></div> <div class=\"gen-info-link\"><a href=\"https://wiki.brapi.org/index.php/Location_Coordinates\">Location Encoding</a></div> <div class=\"gen-info-link\"><a href=\"https://wiki.brapi.org/index.php/Error_Handling\">Error Handling</a></div> <div class=\"gen-info-link\"><a href=\"https://wiki.brapi.org/index.php/Search_Services\">Search Services</a></div> </div>  <div class=\"brapi-section\"> <h2 class=\"brapi-section-title\">BrAPI Core</h2> <div class=\"brapi-section-description\">The BrAPI Core module contains high level entities used for organization and management. This includes Programs, Trials, Studies, Locations, People, and Lists</div> <div class=\"version-number\">V2.1</div> <div class=\"link-btn\"><a href=\"https://github.com/plantbreeding/API/tree/brapi-V2.1/Specification/BrAPI-Core\">GitHub</a></div> <div class=\"link-btn\"><a href=\"https://app.swaggerhub.com/apis/PlantBreedingAPI/BrAPI-Core/2.1\">SwaggerHub</a></div> <div class=\"link-btn\"><a href=\"https://brapicore21.docs.apiary.io\">Apiary</a></div> <div class=\"stop-float\"></div> </div>  <div class=\"brapi-section\"> <h2 class=\"brapi-section-title\">BrAPI Phenotyping</h2> <div class=\"brapi-section-description\">The BrAPI Phenotyping module contains entities related to phenotypic observations. This includes Observation Units, Observations, Observation Variables, Traits, Scales, Methods, and Images</div> <div class=\"version-number\">V2.1</div> <div class=\"link-btn\"><a href=\"https://github.com/plantbreeding/API/tree/brapi-V2.1/Specification/BrAPI-Phenotyping\">GitHub</a></div> <div class=\"link-btn\"><a href=\"https://app.swaggerhub.com/apis/PlantBreedingAPI/BrAPI-Phenotyping/2.1\">SwaggerHub</a></div> <div class=\"link-btn\"><a href=\"https://brapiphenotyping21.docs.apiary.io\">Apiary</a></div> <div class=\"stop-float\"></div> </div>  <div class=\"current-brapi-section brapi-section\"> <h2 class=\"brapi-section-title\">BrAPI Genotyping</h2> <div class=\"brapi-section-description\">The BrAPI Genotyping module contains entities related to genotyping analysis. This includes Samples, Markers, Variant Sets, Variants, Call Sets, Calls, References, Reads, and Vendor Orders</div> <div class=\"version-number\">V2.1</div> <div class=\"link-btn\"><a href=\"https://github.com/plantbreeding/API/tree/brapi-V2.1/Specification/BrAPI-Genotyping\">GitHub</a></div> <div class=\"link-btn\"><a href=\"https://app.swaggerhub.com/apis/PlantBreedingAPI/BrAPI-Genotyping/2.1\">SwaggerHub</a></div> <div class=\"link-btn\"><a href=\"https://brapigenotyping21.docs.apiary.io\">Apiary</a></div> <div class=\"stop-float\"></div> </div>  <div class=\"brapi-section\"> <h2 class=\"brapi-section-title\">BrAPI Germplasm</h2> <div class=\"brapi-section-description\">The BrAPI Germplasm module contains entities related to germplasm management. This includes Germplasm, Germplasm Attributes, Seed Lots, Crosses, Pedigree, and Progeny</div> <div class=\"version-number\">V2.1</div> <div class=\"link-btn\"><a href=\"https://github.com/plantbreeding/API/tree/brapi-V2.1/Specification/BrAPI-Germplasm\">GitHub</a></div> <div class=\"link-btn\"><a href=\"https://app.swaggerhub.com/apis/PlantBreedingAPI/BrAPI-Germplasm/2.1\">SwaggerHub</a></div> <div class=\"link-btn\"><a href=\"https://brapigermplasm21.docs.apiary.io\">Apiary</a></div> <div class=\"stop-float\"></div> </div>  <style> .link-btn{ float: left;  margin: 2px 10px 0 0;  padding: 0 5px;  border-radius: 5px;  background-color: #ddd; } .stop-float{   clear: both; } .version-number{   float: left;    margin: 5px 10px 0 5px; } .brapi-section-title{   margin: 0 10px 0 0;   font-size: 20px; } .current-brapi-section{   font-weight: bolder;   border-radius: 5px;    background-color: #ddd; } .brapi-section{   padding: 5px 5px;  } .brapi-section-description{   margin: 5px 0 0 5px; } </style>
 *
 * OpenAPI spec version: 2.1
 *
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package org.brapi.v2.model.geno.request;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.brapi.v2.model.BrAPISearchRequestParametersPaging;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * PlateSearchRequest
 */

public class BrAPIPlateSearchRequest extends BrAPISearchRequestParametersPaging {
    @JsonProperty("commonCropNames")
    private List<String> commonCropNames = null;

    @JsonProperty("externalReferenceIDs")
    private List<String> externalReferenceIDs = null;

    @JsonProperty("externalReferenceIds")
    private List<String> externalReferenceIds = null;

    @JsonProperty("externalReferenceSources")
    private List<String> externalReferenceSources = null;

    @JsonProperty("germplasmDbIds")
    private List<String> germplasmDbIds = null;

    @JsonProperty("germplasmNames")
    private List<String> germplasmNames = null;

    @JsonProperty("observationUnitDbIds")
    private List<String> observationUnitDbIds = null;

    @JsonProperty("plateBarcodes")
    private List<String> plateBarcodes = null;

    @JsonProperty("plateDbIds")
    private List<String> plateDbIds = null;

    @JsonProperty("plateNames")
    private List<String> plateNames = null;

    @JsonProperty("programDbIds")
    private List<String> programDbIds = null;

    @JsonProperty("programNames")
    private List<String> programNames = null;

    @JsonProperty("sampleDbIds")
    private List<String> sampleDbIds = null;

    @JsonProperty("sampleGroupDbIds")
    private List<String> sampleGroupDbIds = null;

    @JsonProperty("sampleNames")
    private List<String> sampleNames = null;

    @JsonProperty("studyDbIds")
    private List<String> studyDbIds = null;

    @JsonProperty("studyNames")
    private List<String> studyNames = null;

    @JsonProperty("trialDbIds")
    private List<String> trialDbIds = null;

    @JsonProperty("trialNames")
    private List<String> trialNames = null;

    public BrAPIPlateSearchRequest commonCropNames(List<String> commonCropNames) {
        this.commonCropNames = commonCropNames;
        return this;
    }

    public BrAPIPlateSearchRequest addCommonCropNamesItem(String commonCropNamesItem) {
        if (this.commonCropNames == null) {
            this.commonCropNames = new ArrayList<String>();
        }
        this.commonCropNames.add(commonCropNamesItem);
        return this;
    }

    /**
     * The BrAPI Common Crop Name is the simple, generalized, widely accepted name of the organism being researched. It is most often used in multi-crop systems where digital resources need to be divided at a high level. Things like &#x27;Maize&#x27;, &#x27;Wheat&#x27;, and &#x27;Rice&#x27; are examples of common crop names.  Use this parameter to only return results associated with the given crops.   Use &#x60;GET /commoncropnames&#x60; to find the list of available crops on a server.
     *
     * @return commonCropNames
     **/
    public List<String> getCommonCropNames() {
        return commonCropNames;
    }

    public void setCommonCropNames(List<String> commonCropNames) {
        this.commonCropNames = commonCropNames;
    }

    public BrAPIPlateSearchRequest externalReferenceIDs(List<String> externalReferenceIDs) {
        this.externalReferenceIDs = externalReferenceIDs;
        return this;
    }

    public BrAPIPlateSearchRequest addExternalReferenceIDsItem(String externalReferenceIDsItem) {
        if (this.externalReferenceIDs == null) {
            this.externalReferenceIDs = new ArrayList<String>();
        }
        this.externalReferenceIDs.add(externalReferenceIDsItem);
        return this;
    }

    /**
     * **Deprecated in v2.1** Please use &#x60;externalReferenceIds&#x60;. Github issue number #460  &lt;br&gt;List of external reference IDs. Could be a simple strings or a URIs. (use with &#x60;externalReferenceSources&#x60; parameter)
     *
     * @return externalReferenceIDs
     **/
    public List<String> getExternalReferenceIDs() {
        return externalReferenceIDs;
    }

    public void setExternalReferenceIDs(List<String> externalReferenceIDs) {
        this.externalReferenceIDs = externalReferenceIDs;
    }

    public BrAPIPlateSearchRequest externalReferenceIds(List<String> externalReferenceIds) {
        this.externalReferenceIds = externalReferenceIds;
        return this;
    }

    public BrAPIPlateSearchRequest addExternalReferenceIdsItem(String externalReferenceIdsItem) {
        if (this.externalReferenceIds == null) {
            this.externalReferenceIds = new ArrayList<String>();
        }
        this.externalReferenceIds.add(externalReferenceIdsItem);
        return this;
    }

    /**
     * List of external reference IDs. Could be a simple strings or a URIs. (use with &#x60;externalReferenceSources&#x60; parameter)
     *
     * @return externalReferenceIds
     **/
    public List<String> getExternalReferenceIds() {
        return externalReferenceIds;
    }

    public void setExternalReferenceIds(List<String> externalReferenceIds) {
        this.externalReferenceIds = externalReferenceIds;
    }

    public BrAPIPlateSearchRequest externalReferenceSources(List<String> externalReferenceSources) {
        this.externalReferenceSources = externalReferenceSources;
        return this;
    }

    public BrAPIPlateSearchRequest addExternalReferenceSourcesItem(String externalReferenceSourcesItem) {
        if (this.externalReferenceSources == null) {
            this.externalReferenceSources = new ArrayList<String>();
        }
        this.externalReferenceSources.add(externalReferenceSourcesItem);
        return this;
    }

    /**
     * List of identifiers for the source system or database of an external reference (use with &#x60;externalReferenceIDs&#x60; parameter)
     *
     * @return externalReferenceSources
     **/
    public List<String> getExternalReferenceSources() {
        return externalReferenceSources;
    }

    public void setExternalReferenceSources(List<String> externalReferenceSources) {
        this.externalReferenceSources = externalReferenceSources;
    }

    public BrAPIPlateSearchRequest germplasmDbIds(List<String> germplasmDbIds) {
        this.germplasmDbIds = germplasmDbIds;
        return this;
    }

    public BrAPIPlateSearchRequest addGermplasmDbIdsItem(String germplasmDbIdsItem) {
        if (this.germplasmDbIds == null) {
            this.germplasmDbIds = new ArrayList<String>();
        }
        this.germplasmDbIds.add(germplasmDbIdsItem);
        return this;
    }

    /**
     * The ID which uniquely identifies a germplasm
     *
     * @return germplasmDbIds
     **/
    public List<String> getGermplasmDbIds() {
        return germplasmDbIds;
    }

    public void setGermplasmDbIds(List<String> germplasmDbIds) {
        this.germplasmDbIds = germplasmDbIds;
    }

    public BrAPIPlateSearchRequest germplasmNames(List<String> germplasmNames) {
        this.germplasmNames = germplasmNames;
        return this;
    }

    public BrAPIPlateSearchRequest addGermplasmNamesItem(String germplasmNamesItem) {
        if (this.germplasmNames == null) {
            this.germplasmNames = new ArrayList<String>();
        }
        this.germplasmNames.add(germplasmNamesItem);
        return this;
    }

    /**
     * List of human readable names to identify germplasm to search for
     *
     * @return germplasmNames
     **/
    public List<String> getGermplasmNames() {
        return germplasmNames;
    }

    public void setGermplasmNames(List<String> germplasmNames) {
        this.germplasmNames = germplasmNames;
    }

    public BrAPIPlateSearchRequest observationUnitDbIds(List<String> observationUnitDbIds) {
        this.observationUnitDbIds = observationUnitDbIds;
        return this;
    }

    public BrAPIPlateSearchRequest addObservationUnitDbIdsItem(String observationUnitDbIdsItem) {
        if (this.observationUnitDbIds == null) {
            this.observationUnitDbIds = new ArrayList<String>();
        }
        this.observationUnitDbIds.add(observationUnitDbIdsItem);
        return this;
    }

    /**
     * The ID which uniquely identifies an observation unit
     *
     * @return observationUnitDbIds
     **/
    public List<String> getObservationUnitDbIds() {
        return observationUnitDbIds;
    }

    public void setObservationUnitDbIds(List<String> observationUnitDbIds) {
        this.observationUnitDbIds = observationUnitDbIds;
    }

    public BrAPIPlateSearchRequest page(Integer page) {
        super.setPage(page);
        return this;
    }

    public BrAPIPlateSearchRequest pageSize(Integer pageSize) {
        super.setPageSize(pageSize);
        return this;
    }

    public BrAPIPlateSearchRequest plateBarcodes(List<String> plateBarcodes) {
        this.plateBarcodes = plateBarcodes;
        return this;
    }

    public BrAPIPlateSearchRequest addPlateBarcodesItem(String plateBarcodesItem) {
        if (this.plateBarcodes == null) {
            this.plateBarcodes = new ArrayList<String>();
        }
        this.plateBarcodes.add(plateBarcodesItem);
        return this;
    }

    /**
     * A unique identifier physically attached to the plate
     *
     * @return plateBarcodes
     **/
    public List<String> getPlateBarcodes() {
        return plateBarcodes;
    }

    public void setPlateBarcodes(List<String> plateBarcodes) {
        this.plateBarcodes = plateBarcodes;
    }

    public BrAPIPlateSearchRequest plateDbIds(List<String> plateDbIds) {
        this.plateDbIds = plateDbIds;
        return this;
    }

    public BrAPIPlateSearchRequest addPlateDbIdsItem(String plateDbIdsItem) {
        if (this.plateDbIds == null) {
            this.plateDbIds = new ArrayList<String>();
        }
        this.plateDbIds.add(plateDbIdsItem);
        return this;
    }

    /**
     * The ID which uniquely identifies a plate of samples
     *
     * @return plateDbIds
     **/
    public List<String> getPlateDbIds() {
        return plateDbIds;
    }

    public void setPlateDbIds(List<String> plateDbIds) {
        this.plateDbIds = plateDbIds;
    }

    public BrAPIPlateSearchRequest plateNames(List<String> plateNames) {
        this.plateNames = plateNames;
        return this;
    }

    public BrAPIPlateSearchRequest addPlateNamesItem(String plateNamesItem) {
        if (this.plateNames == null) {
            this.plateNames = new ArrayList<String>();
        }
        this.plateNames.add(plateNamesItem);
        return this;
    }

    /**
     * The human readable name of a plate of samples
     *
     * @return plateNames
     **/
    public List<String> getPlateNames() {
        return plateNames;
    }

    public void setPlateNames(List<String> plateNames) {
        this.plateNames = plateNames;
    }

    public BrAPIPlateSearchRequest programDbIds(List<String> programDbIds) {
        this.programDbIds = programDbIds;
        return this;
    }

    public BrAPIPlateSearchRequest addProgramDbIdsItem(String programDbIdsItem) {
        if (this.programDbIds == null) {
            this.programDbIds = new ArrayList<String>();
        }
        this.programDbIds.add(programDbIdsItem);
        return this;
    }

    /**
     * A BrAPI Program represents the high level organization or group who is responsible for conducting trials and studies. Things like Breeding Programs and Funded Projects are considered BrAPI Programs.   Use this parameter to only return results associated with the given programs.   Use &#x60;GET /programs&#x60; to find the list of available programs on a server.
     *
     * @return programDbIds
     **/
    public List<String> getProgramDbIds() {
        return programDbIds;
    }

    public void setProgramDbIds(List<String> programDbIds) {
        this.programDbIds = programDbIds;
    }

    public BrAPIPlateSearchRequest programNames(List<String> programNames) {
        this.programNames = programNames;
        return this;
    }

    public BrAPIPlateSearchRequest addProgramNamesItem(String programNamesItem) {
        if (this.programNames == null) {
            this.programNames = new ArrayList<String>();
        }
        this.programNames.add(programNamesItem);
        return this;
    }

    /**
     * Use this parameter to only return results associated with the given program names. Program names are not required to be unique.  Use &#x60;GET /programs&#x60; to find the list of available programs on a server.
     *
     * @return programNames
     **/
    public List<String> getProgramNames() {
        return programNames;
    }

    public void setProgramNames(List<String> programNames) {
        this.programNames = programNames;
    }

    public BrAPIPlateSearchRequest sampleDbIds(List<String> sampleDbIds) {
        this.sampleDbIds = sampleDbIds;
        return this;
    }

    public BrAPIPlateSearchRequest addSampleDbIdsItem(String sampleDbIdsItem) {
        if (this.sampleDbIds == null) {
            this.sampleDbIds = new ArrayList<String>();
        }
        this.sampleDbIds.add(sampleDbIdsItem);
        return this;
    }

    /**
     * The ID which uniquely identifies a sample
     *
     * @return sampleDbIds
     **/
    public List<String> getSampleDbIds() {
        return sampleDbIds;
    }

    public void setSampleDbIds(List<String> sampleDbIds) {
        this.sampleDbIds = sampleDbIds;
    }

    public BrAPIPlateSearchRequest sampleGroupDbIds(List<String> sampleGroupDbIds) {
        this.sampleGroupDbIds = sampleGroupDbIds;
        return this;
    }

    public BrAPIPlateSearchRequest addSampleGroupDbIdsItem(String sampleGroupDbIdsItem) {
        if (this.sampleGroupDbIds == null) {
            this.sampleGroupDbIds = new ArrayList<String>();
        }
        this.sampleGroupDbIds.add(sampleGroupDbIdsItem);
        return this;
    }

    /**
     * The unique identifier for a group of related Samples
     *
     * @return sampleGroupDbIds
     **/
    public List<String> getSampleGroupDbIds() {
        return sampleGroupDbIds;
    }

    public void setSampleGroupDbIds(List<String> sampleGroupDbIds) {
        this.sampleGroupDbIds = sampleGroupDbIds;
    }

    public BrAPIPlateSearchRequest sampleNames(List<String> sampleNames) {
        this.sampleNames = sampleNames;
        return this;
    }

    public BrAPIPlateSearchRequest addSampleNamesItem(String sampleNamesItem) {
        if (this.sampleNames == null) {
            this.sampleNames = new ArrayList<String>();
        }
        this.sampleNames.add(sampleNamesItem);
        return this;
    }

    /**
     * The human readable name of the sample
     *
     * @return sampleNames
     **/
    public List<String> getSampleNames() {
        return sampleNames;
    }

    public void setSampleNames(List<String> sampleNames) {
        this.sampleNames = sampleNames;
    }

    public BrAPIPlateSearchRequest studyDbIds(List<String> studyDbIds) {
        this.studyDbIds = studyDbIds;
        return this;
    }

    public BrAPIPlateSearchRequest addStudyDbIdsItem(String studyDbIdsItem) {
        if (this.studyDbIds == null) {
            this.studyDbIds = new ArrayList<String>();
        }
        this.studyDbIds.add(studyDbIdsItem);
        return this;
    }

    /**
     * List of study identifiers to search for
     *
     * @return studyDbIds
     **/
    public List<String> getStudyDbIds() {
        return studyDbIds;
    }

    public void setStudyDbIds(List<String> studyDbIds) {
        this.studyDbIds = studyDbIds;
    }

    public BrAPIPlateSearchRequest studyNames(List<String> studyNames) {
        this.studyNames = studyNames;
        return this;
    }

    public BrAPIPlateSearchRequest addStudyNamesItem(String studyNamesItem) {
        if (this.studyNames == null) {
            this.studyNames = new ArrayList<String>();
        }
        this.studyNames.add(studyNamesItem);
        return this;
    }

    /**
     * List of study names to filter search results
     *
     * @return studyNames
     **/
    public List<String> getStudyNames() {
        return studyNames;
    }

    public void setStudyNames(List<String> studyNames) {
        this.studyNames = studyNames;
    }

    public BrAPIPlateSearchRequest trialDbIds(List<String> trialDbIds) {
        this.trialDbIds = trialDbIds;
        return this;
    }

    public BrAPIPlateSearchRequest addTrialDbIdsItem(String trialDbIdsItem) {
        if (this.trialDbIds == null) {
            this.trialDbIds = new ArrayList<String>();
        }
        this.trialDbIds.add(trialDbIdsItem);
        return this;
    }

    /**
     * The ID which uniquely identifies a trial to search for
     *
     * @return trialDbIds
     **/
    public List<String> getTrialDbIds() {
        return trialDbIds;
    }

    public void setTrialDbIds(List<String> trialDbIds) {
        this.trialDbIds = trialDbIds;
    }

    public BrAPIPlateSearchRequest trialNames(List<String> trialNames) {
        this.trialNames = trialNames;
        return this;
    }

    public BrAPIPlateSearchRequest addTrialNamesItem(String trialNamesItem) {
        if (this.trialNames == null) {
            this.trialNames = new ArrayList<String>();
        }
        this.trialNames.add(trialNamesItem);
        return this;
    }

    /**
     * The human readable name of a trial to search for
     *
     * @return trialNames
     **/
    public List<String> getTrialNames() {
        return trialNames;
    }

    public void setTrialNames(List<String> trialNames) {
        this.trialNames = trialNames;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BrAPIPlateSearchRequest plateSearchRequest = (BrAPIPlateSearchRequest) o;
        return Objects.equals(this.commonCropNames, plateSearchRequest.commonCropNames) &&
                Objects.equals(this.externalReferenceIDs, plateSearchRequest.externalReferenceIDs) &&
                Objects.equals(this.externalReferenceIds, plateSearchRequest.externalReferenceIds) &&
                Objects.equals(this.externalReferenceSources, plateSearchRequest.externalReferenceSources) &&
                Objects.equals(this.germplasmDbIds, plateSearchRequest.germplasmDbIds) &&
                Objects.equals(this.germplasmNames, plateSearchRequest.germplasmNames) &&
                Objects.equals(this.observationUnitDbIds, plateSearchRequest.observationUnitDbIds) &&
                Objects.equals(super.getPage(), plateSearchRequest.getPage()) &&
                Objects.equals(this.getPageSize(), plateSearchRequest.getPageSize()) &&
                Objects.equals(this.plateBarcodes, plateSearchRequest.plateBarcodes) &&
                Objects.equals(this.plateDbIds, plateSearchRequest.plateDbIds) &&
                Objects.equals(this.plateNames, plateSearchRequest.plateNames) &&
                Objects.equals(this.programDbIds, plateSearchRequest.programDbIds) &&
                Objects.equals(this.programNames, plateSearchRequest.programNames) &&
                Objects.equals(this.sampleDbIds, plateSearchRequest.sampleDbIds) &&
                Objects.equals(this.sampleGroupDbIds, plateSearchRequest.sampleGroupDbIds) &&
                Objects.equals(this.sampleNames, plateSearchRequest.sampleNames) &&
                Objects.equals(this.studyDbIds, plateSearchRequest.studyDbIds) &&
                Objects.equals(this.studyNames, plateSearchRequest.studyNames) &&
                Objects.equals(this.trialDbIds, plateSearchRequest.trialDbIds) &&
                Objects.equals(this.trialNames, plateSearchRequest.trialNames);
    }

    @Override
    public int hashCode() {
        return Objects.hash(commonCropNames, externalReferenceIDs, externalReferenceIds, externalReferenceSources, germplasmDbIds, germplasmNames, observationUnitDbIds, getPage(), getPageSize(), plateBarcodes, plateDbIds, plateNames, programDbIds, programNames, sampleDbIds, sampleGroupDbIds, sampleNames, studyDbIds, studyNames, trialDbIds, trialNames);
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PlateSearchRequest {\n");

        sb.append("    commonCropNames: ").append(toIndentedString(commonCropNames)).append("\n");
        sb.append("    externalReferenceIDs: ").append(toIndentedString(externalReferenceIDs)).append("\n");
        sb.append("    externalReferenceIds: ").append(toIndentedString(externalReferenceIds)).append("\n");
        sb.append("    externalReferenceSources: ").append(toIndentedString(externalReferenceSources)).append("\n");
        sb.append("    germplasmDbIds: ").append(toIndentedString(germplasmDbIds)).append("\n");
        sb.append("    germplasmNames: ").append(toIndentedString(germplasmNames)).append("\n");
        sb.append("    observationUnitDbIds: ").append(toIndentedString(observationUnitDbIds)).append("\n");
        sb.append("    page: ").append(toIndentedString(getPage())).append("\n");
        sb.append("    pageSize: ").append(toIndentedString(getPageSize())).append("\n");
        sb.append("    plateBarcodes: ").append(toIndentedString(plateBarcodes)).append("\n");
        sb.append("    plateDbIds: ").append(toIndentedString(plateDbIds)).append("\n");
        sb.append("    plateNames: ").append(toIndentedString(plateNames)).append("\n");
        sb.append("    programDbIds: ").append(toIndentedString(programDbIds)).append("\n");
        sb.append("    programNames: ").append(toIndentedString(programNames)).append("\n");
        sb.append("    sampleDbIds: ").append(toIndentedString(sampleDbIds)).append("\n");
        sb.append("    sampleGroupDbIds: ").append(toIndentedString(sampleGroupDbIds)).append("\n");
        sb.append("    sampleNames: ").append(toIndentedString(sampleNames)).append("\n");
        sb.append("    studyDbIds: ").append(toIndentedString(studyDbIds)).append("\n");
        sb.append("    studyNames: ").append(toIndentedString(studyNames)).append("\n");
        sb.append("    trialDbIds: ").append(toIndentedString(trialDbIds)).append("\n");
        sb.append("    trialNames: ").append(toIndentedString(trialNames)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
