/*
 * BrAPI-Genotyping
 * The Breeding API (BrAPI) is a Standardized REST ful Web Service API Specification for communicating Plant Breeding Data. BrAPI allows for easy data sharing between databases and tools involved in plant breeding. <div class=\"brapi-section\"> <h2 class=\"brapi-section-title\">General Reference Documentation</h2> <div class=\"gen-info-link\"><a href=\"https://wiki.brapi.org/index.php/RESTfulness\">URL Structure</a></div> <div class=\"gen-info-link\"><a href=\"https://wiki.brapi.org/index.php/Response_Structure\">Response Structure</a></div> <div class=\"gen-info-link\"><a href=\"https://wiki.brapi.org/index.php/Dates_and_Times\">Date/Time Encoding</a></div> <div class=\"gen-info-link\"><a href=\"https://wiki.brapi.org/index.php/Location_Coordinates\">Location Encoding</a></div> <div class=\"gen-info-link\"><a href=\"https://wiki.brapi.org/index.php/Error_Handling\">Error Handling</a></div> <div class=\"gen-info-link\"><a href=\"https://wiki.brapi.org/index.php/Search_Services\">Search Services</a></div> </div>  <div class=\"brapi-section\"> <h2 class=\"brapi-section-title\">BrAPI Core</h2> <div class=\"brapi-section-description\">The BrAPI Core module contains high level entities used for organization and management. This includes Programs, Trials, Studies, Locations, People, and Lists</div> <div class=\"version-number\">V2.1</div> <div class=\"link-btn\"><a href=\"https://github.com/plantbreeding/API/tree/brapi-V2.1/Specification/BrAPI-Core\">GitHub</a></div> <div class=\"link-btn\"><a href=\"https://app.swaggerhub.com/apis/PlantBreedingAPI/BrAPI-Core/2.1\">SwaggerHub</a></div> <div class=\"link-btn\"><a href=\"https://brapicore21.docs.apiary.io\">Apiary</a></div> <div class=\"stop-float\"></div> </div>  <div class=\"brapi-section\"> <h2 class=\"brapi-section-title\">BrAPI Phenotyping</h2> <div class=\"brapi-section-description\">The BrAPI Phenotyping module contains entities related to phenotypic observations. This includes Observation Units, Observations, Observation Variables, Traits, Scales, Methods, and Images</div> <div class=\"version-number\">V2.1</div> <div class=\"link-btn\"><a href=\"https://github.com/plantbreeding/API/tree/brapi-V2.1/Specification/BrAPI-Phenotyping\">GitHub</a></div> <div class=\"link-btn\"><a href=\"https://app.swaggerhub.com/apis/PlantBreedingAPI/BrAPI-Phenotyping/2.1\">SwaggerHub</a></div> <div class=\"link-btn\"><a href=\"https://brapiphenotyping21.docs.apiary.io\">Apiary</a></div> <div class=\"stop-float\"></div> </div>  <div class=\"current-brapi-section brapi-section\"> <h2 class=\"brapi-section-title\">BrAPI Genotyping</h2> <div class=\"brapi-section-description\">The BrAPI Genotyping module contains entities related to genotyping analysis. This includes Samples, Markers, Variant Sets, Variants, Call Sets, Calls, References, Reads, and Vendor Orders</div> <div class=\"version-number\">V2.1</div> <div class=\"link-btn\"><a href=\"https://github.com/plantbreeding/API/tree/brapi-V2.1/Specification/BrAPI-Genotyping\">GitHub</a></div> <div class=\"link-btn\"><a href=\"https://app.swaggerhub.com/apis/PlantBreedingAPI/BrAPI-Genotyping/2.1\">SwaggerHub</a></div> <div class=\"link-btn\"><a href=\"https://brapigenotyping21.docs.apiary.io\">Apiary</a></div> <div class=\"stop-float\"></div> </div>  <div class=\"brapi-section\"> <h2 class=\"brapi-section-title\">BrAPI Germplasm</h2> <div class=\"brapi-section-description\">The BrAPI Germplasm module contains entities related to germplasm management. This includes Germplasm, Germplasm Attributes, Seed Lots, Crosses, Pedigree, and Progeny</div> <div class=\"version-number\">V2.1</div> <div class=\"link-btn\"><a href=\"https://github.com/plantbreeding/API/tree/brapi-V2.1/Specification/BrAPI-Germplasm\">GitHub</a></div> <div class=\"link-btn\"><a href=\"https://app.swaggerhub.com/apis/PlantBreedingAPI/BrAPI-Germplasm/2.1\">SwaggerHub</a></div> <div class=\"link-btn\"><a href=\"https://brapigermplasm21.docs.apiary.io\">Apiary</a></div> <div class=\"stop-float\"></div> </div>  <style> .link-btn{ float: left;  margin: 2px 10px 0 0;  padding: 0 5px;  border-radius: 5px;  background-color: #ddd; } .stop-float{   clear: both; } .version-number{   float: left;    margin: 5px 10px 0 5px; } .brapi-section-title{   margin: 0 10px 0 0;   font-size: 20px; } .current-brapi-section{   font-weight: bolder;   border-radius: 5px;    background-color: #ddd; } .brapi-section{   padding: 5px 5px;  } .brapi-section-description{   margin: 5px 0 0 5px; } </style>
 *
 * OpenAPI spec version: 2.1
 *
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package org.brapi.v2.model.geno.request;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.brapi.v2.model.BrAPIExternalReference;
import org.threeten.bp.OffsetDateTime;

import javax.validation.Valid;
import java.util.List;
import java.util.Objects;

/**
 * SampleNewRequest
 */

public class BrAPISampleNewRequest {
    private final transient Gson gson = new Gson();

    @JsonProperty("additionalInfo")
    private JsonObject additionalInfo = null;

    @JsonProperty("column")
    private Integer column = null;

    @JsonProperty("externalReferences")
    private List<BrAPIExternalReference> externalReferences = null;

    @JsonProperty("germplasmDbId")
    private String germplasmDbId = null;

    @JsonProperty("observationUnitDbId")
    private String observationUnitDbId = null;

    @JsonProperty("plateDbId")
    private String plateDbId = null;

    @JsonProperty("plateName")
    private String plateName = null;

    @JsonProperty("programDbId")
    private String programDbId = null;

    @JsonProperty("row")
    private String row = null;

    @JsonProperty("sampleBarcode")
    private String sampleBarcode = null;

    @JsonProperty("sampleDescription")
    private String sampleDescription = null;

    @JsonProperty("sampleGroupDbId")
    private String sampleGroupDbId = null;

    @JsonProperty("sampleName")
    private String sampleName = null;

    @JsonProperty("samplePUI")
    private String samplePUI = null;

    @JsonProperty("sampleTimestamp")
    private OffsetDateTime sampleTimestamp = null;

    @JsonProperty("sampleType")
    private String sampleType = null;

    @JsonProperty("studyDbId")
    private String studyDbId = null;

    @JsonProperty("takenBy")
    private String takenBy = null;

    @JsonProperty("tissueType")
    private String tissueType = null;

    @JsonProperty("trialDbId")
    private String trialDbId = null;

    @JsonProperty("well")
    private String well = null;

    public BrAPISampleNewRequest additionalInfo(JsonObject additionalInfo) {
        this.additionalInfo = additionalInfo;
        return this;
    }

    public BrAPISampleNewRequest putAdditionalInfoItem(String key, Object additionalInfoItem) {
        if (this.additionalInfo == null) {
            this.additionalInfo = new JsonObject();
        }
        JsonElement newElement = gson.toJsonTree(additionalInfoItem);
        this.additionalInfo.add(key, newElement);
        return this;
    }

    /**
     * Additional arbitrary info
     * @return additionalInfo
     **/


    public JsonObject getAdditionalInfo() {
        return additionalInfo;
    }

    public void setAdditionalInfo(JsonObject additionalInfo) {
        this.additionalInfo = additionalInfo;
    }

    public BrAPISampleNewRequest column(Integer column) {
        this.column = column;
        return this;
    }

    /**
     * The Column identifier for this &#x60;Sample&#x60; location in the &#x60;Plate&#x60;
     * minimum: 1
     * maximum: 12
     *
     * @return column
     **/
    public Integer getColumn() {
        return column;
    }

    public void setColumn(Integer column) {
        this.column = column;
    }

    public BrAPISampleNewRequest externalReferences(List<BrAPIExternalReference> externalReferences) {
        this.externalReferences = externalReferences;
        return this;
    }

    /**
     * Get externalReferences
     * @return externalReferences
     **/


    @Valid
    public List<BrAPIExternalReference> getExternalReferences() {
        return externalReferences;
    }

    public void setExternalReferences(List<BrAPIExternalReference> externalReferences) {
        this.externalReferences = externalReferences;
    }

    public BrAPISampleNewRequest germplasmDbId(String germplasmDbId) {
        this.germplasmDbId = germplasmDbId;
        return this;
    }

    /**
     * The ID which uniquely identifies a &#x60;Germplasm&#x60;
     *
     * @return germplasmDbId
     **/
    public String getGermplasmDbId() {
        return germplasmDbId;
    }

    public void setGermplasmDbId(String germplasmDbId) {
        this.germplasmDbId = germplasmDbId;
    }

    public BrAPISampleNewRequest observationUnitDbId(String observationUnitDbId) {
        this.observationUnitDbId = observationUnitDbId;
        return this;
    }

    /**
     * The ID which uniquely identifies an &#x60;ObservationUnit&#x60;
     *
     * @return observationUnitDbId
     **/
    public String getObservationUnitDbId() {
        return observationUnitDbId;
    }

    public void setObservationUnitDbId(String observationUnitDbId) {
        this.observationUnitDbId = observationUnitDbId;
    }

    public BrAPISampleNewRequest plateDbId(String plateDbId) {
        this.plateDbId = plateDbId;
        return this;
    }

    /**
     * The ID which uniquely identifies a &#x60;Plate&#x60; of &#x60;Sample&#x60;
     *
     * @return plateDbId
     **/
    public String getPlateDbId() {
        return plateDbId;
    }

    public void setPlateDbId(String plateDbId) {
        this.plateDbId = plateDbId;
    }

    public BrAPISampleNewRequest plateName(String plateName) {
        this.plateName = plateName;
        return this;
    }

    /**
     * The human readable name of a &#x60;Plate&#x60;
     *
     * @return plateName
     **/
    public String getPlateName() {
        return plateName;
    }

    public void setPlateName(String plateName) {
        this.plateName = plateName;
    }

    public BrAPISampleNewRequest programDbId(String programDbId) {
        this.programDbId = programDbId;
        return this;
    }

    /**
     * The ID which uniquely identifies a &#x60;Program&#x60; within the given database server
     *
     * @return programDbId
     **/
    public String getProgramDbId() {
        return programDbId;
    }

    public void setProgramDbId(String programDbId) {
        this.programDbId = programDbId;
    }

    public BrAPISampleNewRequest row(String row) {
        this.row = row;
        return this;
    }

    /**
     * The Row identifier for this &#x60;Sample&#x60; location in the &#x60;Plate&#x60;
     *
     * @return row
     **/
    public String getRow() {
        return row;
    }

    public void setRow(String row) {
        this.row = row;
    }

    public BrAPISampleNewRequest sampleBarcode(String sampleBarcode) {
        this.sampleBarcode = sampleBarcode;
        return this;
    }

    /**
     * A unique identifier physically attached to the &#x60;Sample&#x60;
     *
     * @return sampleBarcode
     **/
    public String getSampleBarcode() {
        return sampleBarcode;
    }

    public void setSampleBarcode(String sampleBarcode) {
        this.sampleBarcode = sampleBarcode;
    }

    public BrAPISampleNewRequest sampleDescription(String sampleDescription) {
        this.sampleDescription = sampleDescription;
        return this;
    }

    /**
     * Description of a &#x60;Sample&#x60; &lt;br&gt;MIAPPE V1.1 (DM-79) Sample description - Any information not captured by the other sample fields, including quantification, sample treatments and processing.
     *
     * @return sampleDescription
     **/
    public String getSampleDescription() {
        return sampleDescription;
    }

    public void setSampleDescription(String sampleDescription) {
        this.sampleDescription = sampleDescription;
    }

    public BrAPISampleNewRequest sampleGroupDbId(String sampleGroupDbId) {
        this.sampleGroupDbId = sampleGroupDbId;
        return this;
    }

    /**
     * The ID which uniquely identifies a group of &#x60;Samples&#x60;
     *
     * @return sampleGroupDbId
     **/
    public String getSampleGroupDbId() {
        return sampleGroupDbId;
    }

    public void setSampleGroupDbId(String sampleGroupDbId) {
        this.sampleGroupDbId = sampleGroupDbId;
    }

    public BrAPISampleNewRequest sampleName(String sampleName) {
        this.sampleName = sampleName;
        return this;
    }

    /**
     * The human readable name of the &#x60;Sample&#x60;
     *
     * @return sampleName
     **/
    public String getSampleName() {
        return sampleName;
    }

    public void setSampleName(String sampleName) {
        this.sampleName = sampleName;
    }

    public BrAPISampleNewRequest samplePUI(String samplePUI) {
        this.samplePUI = samplePUI;
        return this;
    }

    /**
     * A permanent unique identifier for the &#x60;Sample&#x60; (DOI, URL, UUID, etc) &lt;br&gt; MIAPPE V1.1 (DM-81) External ID - An identifier for the sample in a persistent repository, comprising the name of the repository and the accession number of the observation unit therein. Submission to the EBI Biosamples repository is recommended. URI are recommended when possible.
     *
     * @return samplePUI
     **/
    public String getSamplePUI() {
        return samplePUI;
    }

    public void setSamplePUI(String samplePUI) {
        this.samplePUI = samplePUI;
    }

    public BrAPISampleNewRequest sampleTimestamp(OffsetDateTime sampleTimestamp) {
        this.sampleTimestamp = sampleTimestamp;
        return this;
    }

    /**
     * The date and time a &#x60;Sample&#x60; was collected from the field &lt;br&gt; MIAPPE V1.1 (DM-80) Collection date - The date and time when the sample was collected / harvested
     *
     * @return sampleTimestamp
     **/
    public OffsetDateTime getSampleTimestamp() {
        return sampleTimestamp;
    }

    public void setSampleTimestamp(OffsetDateTime sampleTimestamp) {
        this.sampleTimestamp = sampleTimestamp;
    }

    public BrAPISampleNewRequest sampleType(String sampleType) {
        this.sampleType = sampleType;
        return this;
    }

    /**
     * The type of &#x60;Sample&#x60; taken. ex. &#x27;DNA&#x27;, &#x27;RNA&#x27;, &#x27;Tissue&#x27;, etc
     *
     * @return sampleType
     **/
    public String getSampleType() {
        return sampleType;
    }

    public void setSampleType(String sampleType) {
        this.sampleType = sampleType;
    }

    public BrAPISampleNewRequest studyDbId(String studyDbId) {
        this.studyDbId = studyDbId;
        return this;
    }

    /**
     * The ID which uniquely identifies a &#x60;Study&#x60; within the given database server
     *
     * @return studyDbId
     **/
    public String getStudyDbId() {
        return studyDbId;
    }

    public void setStudyDbId(String studyDbId) {
        this.studyDbId = studyDbId;
    }

    public BrAPISampleNewRequest takenBy(String takenBy) {
        this.takenBy = takenBy;
        return this;
    }

    /**
     * The name or identifier of the entity which took the &#x60;Sample&#x60; from the field
     *
     * @return takenBy
     **/
    public String getTakenBy() {
        return takenBy;
    }

    public void setTakenBy(String takenBy) {
        this.takenBy = takenBy;
    }

    public BrAPISampleNewRequest tissueType(String tissueType) {
        this.tissueType = tissueType;
        return this;
    }

    /**
     * The type of tissue sampled. ex. &#x27;Leaf&#x27;, &#x27;Root&#x27;, etc. &lt;br&gt; MIAPPE V1.1 (DM-78) Plant anatomical entity - A description of  the plant part (e.g. leaf) or the plant product (e.g. resin) from which the sample was taken, in the form of an accession number to a suitable controlled vocabulary (Plant Ontology).
     *
     * @return tissueType
     **/
    public String getTissueType() {
        return tissueType;
    }

    public void setTissueType(String tissueType) {
        this.tissueType = tissueType;
    }

    public BrAPISampleNewRequest trialDbId(String trialDbId) {
        this.trialDbId = trialDbId;
        return this;
    }

    /**
     * The ID which uniquely identifies a &#x60;Trial&#x60; within the given database server
     *
     * @return trialDbId
     **/
    public String getTrialDbId() {
        return trialDbId;
    }

    public void setTrialDbId(String trialDbId) {
        this.trialDbId = trialDbId;
    }

    public BrAPISampleNewRequest well(String well) {
        this.well = well;
        return this;
    }

    /**
     * The Well identifier for this &#x60;Sample&#x60; location in the &#x60;Plate&#x60;. Usually a concatenation of Row and Column, or just a number if the &#x60;Samples&#x60; are not part of an ordered &#x60;Plate&#x60;.
     *
     * @return well
     **/
    public String getWell() {
        return well;
    }

    public void setWell(String well) {
        this.well = well;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BrAPISampleNewRequest sampleNewRequest = (BrAPISampleNewRequest) o;
        return Objects.equals(this.additionalInfo, sampleNewRequest.additionalInfo) &&
                Objects.equals(this.column, sampleNewRequest.column) &&
                Objects.equals(this.externalReferences, sampleNewRequest.externalReferences) &&
                Objects.equals(this.germplasmDbId, sampleNewRequest.germplasmDbId) &&
                Objects.equals(this.observationUnitDbId, sampleNewRequest.observationUnitDbId) &&
                Objects.equals(this.plateDbId, sampleNewRequest.plateDbId) &&
                Objects.equals(this.plateName, sampleNewRequest.plateName) &&
                Objects.equals(this.programDbId, sampleNewRequest.programDbId) &&
                Objects.equals(this.row, sampleNewRequest.row) &&
                Objects.equals(this.sampleBarcode, sampleNewRequest.sampleBarcode) &&
                Objects.equals(this.sampleDescription, sampleNewRequest.sampleDescription) &&
                Objects.equals(this.sampleGroupDbId, sampleNewRequest.sampleGroupDbId) &&
                Objects.equals(this.sampleName, sampleNewRequest.sampleName) &&
                Objects.equals(this.samplePUI, sampleNewRequest.samplePUI) &&
                Objects.equals(this.sampleTimestamp, sampleNewRequest.sampleTimestamp) &&
                Objects.equals(this.sampleType, sampleNewRequest.sampleType) &&
                Objects.equals(this.studyDbId, sampleNewRequest.studyDbId) &&
                Objects.equals(this.takenBy, sampleNewRequest.takenBy) &&
                Objects.equals(this.tissueType, sampleNewRequest.tissueType) &&
                Objects.equals(this.trialDbId, sampleNewRequest.trialDbId) &&
                Objects.equals(this.well, sampleNewRequest.well);
    }

    @Override
    public int hashCode() {
        return Objects.hash(additionalInfo, column, externalReferences, germplasmDbId, observationUnitDbId, plateDbId, plateName, programDbId, row, sampleBarcode, sampleDescription, sampleGroupDbId, sampleName, samplePUI, sampleTimestamp, sampleType, studyDbId, takenBy, tissueType, trialDbId, well);
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SampleNewRequest {\n");

        sb.append("    additionalInfo: ").append(toIndentedString(additionalInfo)).append("\n");
        sb.append("    column: ").append(toIndentedString(column)).append("\n");
        sb.append("    externalReferences: ").append(toIndentedString(externalReferences)).append("\n");
        sb.append("    germplasmDbId: ").append(toIndentedString(germplasmDbId)).append("\n");
        sb.append("    observationUnitDbId: ").append(toIndentedString(observationUnitDbId)).append("\n");
        sb.append("    plateDbId: ").append(toIndentedString(plateDbId)).append("\n");
        sb.append("    plateName: ").append(toIndentedString(plateName)).append("\n");
        sb.append("    programDbId: ").append(toIndentedString(programDbId)).append("\n");
        sb.append("    row: ").append(toIndentedString(row)).append("\n");
        sb.append("    sampleBarcode: ").append(toIndentedString(sampleBarcode)).append("\n");
        sb.append("    sampleDescription: ").append(toIndentedString(sampleDescription)).append("\n");
        sb.append("    sampleGroupDbId: ").append(toIndentedString(sampleGroupDbId)).append("\n");
        sb.append("    sampleName: ").append(toIndentedString(sampleName)).append("\n");
        sb.append("    samplePUI: ").append(toIndentedString(samplePUI)).append("\n");
        sb.append("    sampleTimestamp: ").append(toIndentedString(sampleTimestamp)).append("\n");
        sb.append("    sampleType: ").append(toIndentedString(sampleType)).append("\n");
        sb.append("    studyDbId: ").append(toIndentedString(studyDbId)).append("\n");
        sb.append("    takenBy: ").append(toIndentedString(takenBy)).append("\n");
        sb.append("    tissueType: ").append(toIndentedString(tissueType)).append("\n");
        sb.append("    trialDbId: ").append(toIndentedString(trialDbId)).append("\n");
        sb.append("    well: ").append(toIndentedString(well)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
