package org.brapi.v2.model.geno.request;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;


import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.validation.Valid;


/**
 * VendorOrderSubmissionRequest
 */


public class BrAPIVendorOrderSubmissionRequest extends BrAPIVendorPlateSubmissionRequest  {
  @JsonProperty("requiredServiceInfo")
  @Valid
  private Map<String, String> requiredServiceInfo = null;

  @JsonProperty("serviceIds")
  @Valid
  private List<String> serviceIds = new ArrayList<String>();

  public BrAPIVendorOrderSubmissionRequest requiredServiceInfo(Map<String, String> requiredServiceInfo) {
    this.requiredServiceInfo = requiredServiceInfo;
    return this;
  }

  public BrAPIVendorOrderSubmissionRequest putRequiredServiceInfoItem(String key, String requiredServiceInfoItem) {
    if (this.requiredServiceInfo == null) {
      this.requiredServiceInfo = new HashMap<String, String>();
    }
    this.requiredServiceInfo.put(key, requiredServiceInfoItem);
    return this;
  }

  /**
   * A map of additional data required by the requested service. This includes things like Volume and Concentration.
   * @return requiredServiceInfo
  **/
  
  
    public Map<String, String> getRequiredServiceInfo() {
    return requiredServiceInfo;
  }

  public void setRequiredServiceInfo(Map<String, String> requiredServiceInfo) {
    this.requiredServiceInfo = requiredServiceInfo;
  }

  public BrAPIVendorOrderSubmissionRequest serviceIds(List<String> serviceIds) {
    this.serviceIds = serviceIds;
    return this;
  }

  public BrAPIVendorOrderSubmissionRequest addServiceIdsItem(String serviceIdsItem) {
    this.serviceIds.add(serviceIdsItem);
    return this;
  }

  /**
   * A list of unique, alpha-numeric ID which identify the requested services to be applied to this order.  A Vendor Service defines what platform, technology, and markers will be used.  A list of available service IDs can be retrieved from the Vendor Specs.
   * @return serviceIds
  **/
  
      

    public List<String> getServiceIds() {
    return serviceIds;
  }

  public void setServiceIds(List<String> serviceIds) {
    this.serviceIds = serviceIds;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BrAPIVendorOrderSubmissionRequest vendorOrderSubmissionRequest = (BrAPIVendorOrderSubmissionRequest) o;
    return Objects.equals(this.requiredServiceInfo, vendorOrderSubmissionRequest.requiredServiceInfo) &&
        Objects.equals(this.serviceIds, vendorOrderSubmissionRequest.serviceIds) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(requiredServiceInfo, serviceIds, super.hashCode());
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class VendorOrderSubmissionRequest {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    requiredServiceInfo: ").append(toIndentedString(requiredServiceInfo)).append("\n");
    sb.append("    serviceIds: ").append(toIndentedString(serviceIds)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
