/*
 * BrAPI-Genotyping
 * The Breeding API (BrAPI) is a Standardized REST ful Web Service API Specification for communicating Plant Breeding Data. BrAPI allows for easy data sharing between databases and tools involved in plant breeding. <div class=\"brapi-section\"> <h2 class=\"brapi-section-title\">General Reference Documentation</h2> <div class=\"gen-info-link\"><a href=\"https://wiki.brapi.org/index.php/RESTfulness\">URL Structure</a></div> <div class=\"gen-info-link\"><a href=\"https://wiki.brapi.org/index.php/Response_Structure\">Response Structure</a></div> <div class=\"gen-info-link\"><a href=\"https://wiki.brapi.org/index.php/Dates_and_Times\">Date/Time Encoding</a></div> <div class=\"gen-info-link\"><a href=\"https://wiki.brapi.org/index.php/Location_Coordinates\">Location Encoding</a></div> <div class=\"gen-info-link\"><a href=\"https://wiki.brapi.org/index.php/Error_Handling\">Error Handling</a></div> <div class=\"gen-info-link\"><a href=\"https://wiki.brapi.org/index.php/Search_Services\">Search Services</a></div> </div>  <div class=\"brapi-section\"> <h2 class=\"brapi-section-title\">BrAPI Core</h2> <div class=\"brapi-section-description\">The BrAPI Core module contains high level entities used for organization and management. This includes Programs, Trials, Studies, Locations, People, and Lists</div> <div class=\"version-number\">V2.1</div> <div class=\"link-btn\"><a href=\"https://github.com/plantbreeding/API/tree/brapi-V2.1/Specification/BrAPI-Core\">GitHub</a></div> <div class=\"link-btn\"><a href=\"https://app.swaggerhub.com/apis/PlantBreedingAPI/BrAPI-Core/2.1\">SwaggerHub</a></div> <div class=\"link-btn\"><a href=\"https://brapicore21.docs.apiary.io\">Apiary</a></div> <div class=\"stop-float\"></div> </div>  <div class=\"brapi-section\"> <h2 class=\"brapi-section-title\">BrAPI Phenotyping</h2> <div class=\"brapi-section-description\">The BrAPI Phenotyping module contains entities related to phenotypic observations. This includes Observation Units, Observations, Observation Variables, Traits, Scales, Methods, and Images</div> <div class=\"version-number\">V2.1</div> <div class=\"link-btn\"><a href=\"https://github.com/plantbreeding/API/tree/brapi-V2.1/Specification/BrAPI-Phenotyping\">GitHub</a></div> <div class=\"link-btn\"><a href=\"https://app.swaggerhub.com/apis/PlantBreedingAPI/BrAPI-Phenotyping/2.1\">SwaggerHub</a></div> <div class=\"link-btn\"><a href=\"https://brapiphenotyping21.docs.apiary.io\">Apiary</a></div> <div class=\"stop-float\"></div> </div>  <div class=\"current-brapi-section brapi-section\"> <h2 class=\"brapi-section-title\">BrAPI Genotyping</h2> <div class=\"brapi-section-description\">The BrAPI Genotyping module contains entities related to genotyping analysis. This includes Samples, Markers, Variant Sets, Variants, Call Sets, Calls, References, Reads, and Vendor Orders</div> <div class=\"version-number\">V2.1</div> <div class=\"link-btn\"><a href=\"https://github.com/plantbreeding/API/tree/brapi-V2.1/Specification/BrAPI-Genotyping\">GitHub</a></div> <div class=\"link-btn\"><a href=\"https://app.swaggerhub.com/apis/PlantBreedingAPI/BrAPI-Genotyping/2.1\">SwaggerHub</a></div> <div class=\"link-btn\"><a href=\"https://brapigenotyping21.docs.apiary.io\">Apiary</a></div> <div class=\"stop-float\"></div> </div>  <div class=\"brapi-section\"> <h2 class=\"brapi-section-title\">BrAPI Germplasm</h2> <div class=\"brapi-section-description\">The BrAPI Germplasm module contains entities related to germplasm management. This includes Germplasm, Germplasm Attributes, Seed Lots, Crosses, Pedigree, and Progeny</div> <div class=\"version-number\">V2.1</div> <div class=\"link-btn\"><a href=\"https://github.com/plantbreeding/API/tree/brapi-V2.1/Specification/BrAPI-Germplasm\">GitHub</a></div> <div class=\"link-btn\"><a href=\"https://app.swaggerhub.com/apis/PlantBreedingAPI/BrAPI-Germplasm/2.1\">SwaggerHub</a></div> <div class=\"link-btn\"><a href=\"https://brapigermplasm21.docs.apiary.io\">Apiary</a></div> <div class=\"stop-float\"></div> </div>  <style> .link-btn{ float: left;  margin: 2px 10px 0 0;  padding: 0 5px;  border-radius: 5px;  background-color: #ddd; } .stop-float{   clear: both; } .version-number{   float: left;    margin: 5px 10px 0 5px; } .brapi-section-title{   margin: 0 10px 0 0;   font-size: 20px; } .current-brapi-section{   font-weight: bolder;   border-radius: 5px;    background-color: #ddd; } .brapi-section{   padding: 5px 5px;  } .brapi-section-description{   margin: 5px 0 0 5px; } </style>
 *
 * OpenAPI spec version: 2.1
 *
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package org.brapi.v2.model.geno.request;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.brapi.v2.model.BrAPIOntologyReference;
import org.brapi.v2.model.geno.BrAPIMeasurement;

import java.util.Objects;

/**
 * VendorOrderSubmissionRequestSamples
 */

public class BrAPIVendorOrderSubmissionRequestSamples {
    @JsonProperty("clientSampleBarCode")
    private String clientSampleBarCode = null;

    @JsonProperty("clientSampleId")
    private String clientSampleId = null;

    @JsonProperty("column")
    private Integer column = null;

    @JsonProperty("comments")
    private String comments = null;

    @JsonProperty("concentration")
    private BrAPIMeasurement concentration = null;

    @JsonProperty("organismName")
    private String organismName = null;

    @JsonProperty("row")
    private String row = null;

    @JsonProperty("speciesName")
    private String speciesName = null;

    @JsonProperty("taxonomyOntologyReference")
    private BrAPIOntologyReference taxonomyOntologyReference = null;

    @JsonProperty("tissueType")
    private String tissueType = null;

    @JsonProperty("tissueTypeOntologyReference")
    private BrAPIOntologyReference tissueTypeOntologyReference = null;

    @JsonProperty("volume")
    private BrAPIMeasurement volume = null;

    @JsonProperty("well")
    private String well = null;

    public BrAPIVendorOrderSubmissionRequestSamples clientSampleBarCode(String clientSampleBarCode) {
        this.clientSampleBarCode = clientSampleBarCode;
        return this;
    }

    /**
     * (Optional) The value of the bar code attached to this sample
     *
     * @return clientSampleBarCode
     **/
    public String getClientSampleBarCode() {
        return clientSampleBarCode;
    }

    public void setClientSampleBarCode(String clientSampleBarCode) {
        this.clientSampleBarCode = clientSampleBarCode;
    }

    public BrAPIVendorOrderSubmissionRequestSamples clientSampleId(String clientSampleId) {
        this.clientSampleId = clientSampleId;
        return this;
    }

    /**
     * The ID which uniquely identifies this sample to the client making the request
     *
     * @return clientSampleId
     **/
    public String getClientSampleId() {
        return clientSampleId;
    }

    public void setClientSampleId(String clientSampleId) {
        this.clientSampleId = clientSampleId;
    }

    public BrAPIVendorOrderSubmissionRequestSamples column(Integer column) {
        this.column = column;
        return this;
    }

    /**
     * The Column identifier for this samples location in the plate
     * minimum: 1
     * maximum: 12
     *
     * @return column
     **/
    public Integer getColumn() {
        return column;
    }

    public void setColumn(Integer column) {
        this.column = column;
    }

    public BrAPIVendorOrderSubmissionRequestSamples comments(String comments) {
        this.comments = comments;
        return this;
    }

    /**
     * Generic comments about this sample for the vendor
     *
     * @return comments
     **/
    public String getComments() {
        return comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public BrAPIVendorOrderSubmissionRequestSamples concentration(BrAPIMeasurement concentration) {
        this.concentration = concentration;
        return this;
    }

    /**
     * Get concentration
     *
     * @return concentration
     **/
    public BrAPIMeasurement getConcentration() {
        return concentration;
    }

    public void setConcentration(BrAPIMeasurement concentration) {
        this.concentration = concentration;
    }

    public BrAPIVendorOrderSubmissionRequestSamples organismName(String organismName) {
        this.organismName = organismName;
        return this;
    }

    /**
     * Scientific organism name
     *
     * @return organismName
     **/
    public String getOrganismName() {
        return organismName;
    }

    public void setOrganismName(String organismName) {
        this.organismName = organismName;
    }

    public BrAPIVendorOrderSubmissionRequestSamples row(String row) {
        this.row = row;
        return this;
    }

    /**
     * The Row identifier for this samples location in the plate
     *
     * @return row
     **/
    public String getRow() {
        return row;
    }

    public void setRow(String row) {
        this.row = row;
    }

    public BrAPIVendorOrderSubmissionRequestSamples speciesName(String speciesName) {
        this.speciesName = speciesName;
        return this;
    }

    /**
     * Scientific species name
     *
     * @return speciesName
     **/
    public String getSpeciesName() {
        return speciesName;
    }

    public void setSpeciesName(String speciesName) {
        this.speciesName = speciesName;
    }

    public BrAPIVendorOrderSubmissionRequestSamples taxonomyOntologyReference(BrAPIOntologyReference taxonomyOntologyReference) {
        this.taxonomyOntologyReference = taxonomyOntologyReference;
        return this;
    }

    /**
     * Get taxonomyOntologyReference
     *
     * @return taxonomyOntologyReference
     **/
    public BrAPIOntologyReference getTaxonomyOntologyReference() {
        return taxonomyOntologyReference;
    }

    public void setTaxonomyOntologyReference(BrAPIOntologyReference taxonomyOntologyReference) {
        this.taxonomyOntologyReference = taxonomyOntologyReference;
    }

    public BrAPIVendorOrderSubmissionRequestSamples tissueType(String tissueType) {
        this.tissueType = tissueType;
        return this;
    }

    /**
     * The type of tissue in this sample. List of accepted tissue types can be found in the Vendor Specs.
     *
     * @return tissueType
     **/
    public String getTissueType() {
        return tissueType;
    }

    public void setTissueType(String tissueType) {
        this.tissueType = tissueType;
    }

    public BrAPIVendorOrderSubmissionRequestSamples tissueTypeOntologyReference(BrAPIOntologyReference tissueTypeOntologyReference) {
        this.tissueTypeOntologyReference = tissueTypeOntologyReference;
        return this;
    }

    /**
     * Get tissueTypeOntologyReference
     *
     * @return tissueTypeOntologyReference
     **/
    public BrAPIOntologyReference getTissueTypeOntologyReference() {
        return tissueTypeOntologyReference;
    }

    public void setTissueTypeOntologyReference(BrAPIOntologyReference tissueTypeOntologyReference) {
        this.tissueTypeOntologyReference = tissueTypeOntologyReference;
    }

    public BrAPIVendorOrderSubmissionRequestSamples volume(BrAPIMeasurement volume) {
        this.volume = volume;
        return this;
    }

    /**
     * Get volume
     *
     * @return volume
     **/
    public BrAPIMeasurement getVolume() {
        return volume;
    }

    public void setVolume(BrAPIMeasurement volume) {
        this.volume = volume;
    }

    public BrAPIVendorOrderSubmissionRequestSamples well(String well) {
        this.well = well;
        return this;
    }

    /**
     * The Well identifier for this samples location in the plate. Usually a concatenation of Row and Column, or just a number if the samples are not part of an ordered plate.
     *
     * @return well
     **/
    public String getWell() {
        return well;
    }

    public void setWell(String well) {
        this.well = well;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BrAPIVendorOrderSubmissionRequestSamples vendorOrderSubmissionRequestSamples = (BrAPIVendorOrderSubmissionRequestSamples) o;
        return Objects.equals(this.clientSampleBarCode, vendorOrderSubmissionRequestSamples.clientSampleBarCode) &&
                Objects.equals(this.clientSampleId, vendorOrderSubmissionRequestSamples.clientSampleId) &&
                Objects.equals(this.column, vendorOrderSubmissionRequestSamples.column) &&
                Objects.equals(this.comments, vendorOrderSubmissionRequestSamples.comments) &&
                Objects.equals(this.concentration, vendorOrderSubmissionRequestSamples.concentration) &&
                Objects.equals(this.organismName, vendorOrderSubmissionRequestSamples.organismName) &&
                Objects.equals(this.row, vendorOrderSubmissionRequestSamples.row) &&
                Objects.equals(this.speciesName, vendorOrderSubmissionRequestSamples.speciesName) &&
                Objects.equals(this.taxonomyOntologyReference, vendorOrderSubmissionRequestSamples.taxonomyOntologyReference) &&
                Objects.equals(this.tissueType, vendorOrderSubmissionRequestSamples.tissueType) &&
                Objects.equals(this.tissueTypeOntologyReference, vendorOrderSubmissionRequestSamples.tissueTypeOntologyReference) &&
                Objects.equals(this.volume, vendorOrderSubmissionRequestSamples.volume) &&
                Objects.equals(this.well, vendorOrderSubmissionRequestSamples.well);
    }

    @Override
    public int hashCode() {
        return Objects.hash(clientSampleBarCode, clientSampleId, column, comments, concentration, organismName, row, speciesName, taxonomyOntologyReference, tissueType, tissueTypeOntologyReference, volume, well);
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VendorOrderSubmissionRequestSamples {\n");

        sb.append("    clientSampleBarCode: ").append(toIndentedString(clientSampleBarCode)).append("\n");
        sb.append("    clientSampleId: ").append(toIndentedString(clientSampleId)).append("\n");
        sb.append("    column: ").append(toIndentedString(column)).append("\n");
        sb.append("    comments: ").append(toIndentedString(comments)).append("\n");
        sb.append("    concentration: ").append(toIndentedString(concentration)).append("\n");
        sb.append("    organismName: ").append(toIndentedString(organismName)).append("\n");
        sb.append("    row: ").append(toIndentedString(row)).append("\n");
        sb.append("    speciesName: ").append(toIndentedString(speciesName)).append("\n");
        sb.append("    taxonomyOntologyReference: ").append(toIndentedString(taxonomyOntologyReference)).append("\n");
        sb.append("    tissueType: ").append(toIndentedString(tissueType)).append("\n");
        sb.append("    tissueTypeOntologyReference: ").append(toIndentedString(tissueTypeOntologyReference)).append("\n");
        sb.append("    volume: ").append(toIndentedString(volume)).append("\n");
        sb.append("    well: ").append(toIndentedString(well)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
