/*
 * BrAPI-Germplasm
 * The Breeding API (BrAPI) is a Standardized REST ful Web Service API Specification for communicating Plant Breeding Data. BrAPI allows for easy data sharing between databases and tools involved in plant breeding. <div class=\"brapi-section\"> <h2 class=\"brapi-section-title\">General Reference Documentation</h2> <div class=\"gen-info-link\"><a href=\"https://wiki.brapi.org/index.php/RESTfulness\">URL Structure</a></div> <div class=\"gen-info-link\"><a href=\"https://wiki.brapi.org/index.php/Response_Structure\">Response Structure</a></div> <div class=\"gen-info-link\"><a href=\"https://wiki.brapi.org/index.php/Dates_and_Times\">Date/Time Encoding</a></div> <div class=\"gen-info-link\"><a href=\"https://wiki.brapi.org/index.php/Location_Coordinates\">Location Encoding</a></div> <div class=\"gen-info-link\"><a href=\"https://wiki.brapi.org/index.php/Error_Handling\">Error Handling</a></div> <div class=\"gen-info-link\"><a href=\"https://wiki.brapi.org/index.php/Search_Services\">Search Services</a></div> </div>  <div class=\"brapi-section\"> <h2 class=\"brapi-section-title\">BrAPI Core</h2> <div class=\"brapi-section-description\">The BrAPI Core module contains high level entities used for organization and management. This includes Programs, Trials, Studies, Locations, People, and Lists</div> <div class=\"version-number\">V2.1</div> <div class=\"link-btn\"><a href=\"https://github.com/plantbreeding/API/tree/brapi-V2.1/Specification/BrAPI-Core\">GitHub</a></div> <div class=\"link-btn\"><a href=\"https://app.swaggerhub.com/apis/PlantBreedingAPI/BrAPI-Core/2.1\">SwaggerHub</a></div> <div class=\"link-btn\"><a href=\"https://brapicore21.docs.apiary.io\">Apiary</a></div> <div class=\"stop-float\"></div> </div>  <div class=\"brapi-section\"> <h2 class=\"brapi-section-title\">BrAPI Phenotyping</h2> <div class=\"brapi-section-description\">The BrAPI Phenotyping module contains entities related to phenotypic observations. This includes Observation Units, Observations, Observation Variables, Traits, Scales, Methods, and Images</div> <div class=\"version-number\">V2.1</div> <div class=\"link-btn\"><a href=\"https://github.com/plantbreeding/API/tree/brapi-V2.1/Specification/BrAPI-Phenotyping\">GitHub</a></div> <div class=\"link-btn\"><a href=\"https://app.swaggerhub.com/apis/PlantBreedingAPI/BrAPI-Phenotyping/2.1\">SwaggerHub</a></div> <div class=\"link-btn\"><a href=\"https://brapiphenotyping21.docs.apiary.io\">Apiary</a></div> <div class=\"stop-float\"></div> </div>  <div class=\"brapi-section\"> <h2 class=\"brapi-section-title\">BrAPI Genotyping</h2> <div class=\"brapi-section-description\">The BrAPI Genotyping module contains entities related to genotyping analysis. This includes Samples, Markers, Variant Sets, Variants, Call Sets, Calls, References, Reads, and Vendor Orders</div> <div class=\"version-number\">V2.1</div> <div class=\"link-btn\"><a href=\"https://github.com/plantbreeding/API/tree/brapi-V2.1/Specification/BrAPI-Genotyping\">GitHub</a></div> <div class=\"link-btn\"><a href=\"https://app.swaggerhub.com/apis/PlantBreedingAPI/BrAPI-Genotyping/2.1\">SwaggerHub</a></div> <div class=\"link-btn\"><a href=\"https://brapigenotyping21.docs.apiary.io\">Apiary</a></div> <div class=\"stop-float\"></div> </div>  <div class=\"current-brapi-section brapi-section\"> <h2 class=\"brapi-section-title\">BrAPI Germplasm</h2> <div class=\"brapi-section-description\">The BrAPI Germplasm module contains entities related to germplasm management. This includes Germplasm, Germplasm Attributes, Seed Lots, Crosses, Pedigree, and Progeny</div> <div class=\"version-number\">V2.1</div> <div class=\"link-btn\"><a href=\"https://github.com/plantbreeding/API/tree/brapi-V2.1/Specification/BrAPI-Germplasm\">GitHub</a></div> <div class=\"link-btn\"><a href=\"https://app.swaggerhub.com/apis/PlantBreedingAPI/BrAPI-Germplasm/2.1\">SwaggerHub</a></div> <div class=\"link-btn\"><a href=\"https://brapigermplasm21.docs.apiary.io\">Apiary</a></div> <div class=\"stop-float\"></div> </div>  <style> .link-btn{ float: left;  margin: 2px 10px 0 0;  padding: 0 5px;  border-radius: 5px;  background-color: #ddd; } .stop-float{   clear: both; } .version-number{   float: left;    margin: 5px 10px 0 5px; } .brapi-section-title{   margin: 0 10px 0 0;   font-size: 20px; } .current-brapi-section{   font-weight: bolder;   border-radius: 5px;    background-color: #ddd; } .brapi-section{   padding: 5px 5px;  } .brapi-section-description{   margin: 5px 0 0 5px; } </style>
 *
 * OpenAPI spec version: 2.1
 *
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package org.brapi.v2.model.germ;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

import org.brapi.v2.model.BrAPIExternalReference;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * PedigreeNode
 */

public class BrAPIPedigreeNode {
    @JsonProperty("additionalInfo")
    private Map<String, String> additionalInfo = null;

    @JsonProperty("breedingMethodDbId")
    private String breedingMethodDbId = null;

    @JsonProperty("breedingMethodName")
    private String breedingMethodName = null;

    @JsonProperty("crossingProjectDbId")
    private String crossingProjectDbId = null;

    @JsonProperty("crossingYear")
    private Integer crossingYear = null;

    @JsonProperty("defaultDisplayName")
    private String defaultDisplayName = null;

    @JsonProperty("externalReferences")
    private List<BrAPIExternalReference> externalReferences = null;

    @JsonProperty("familyCode")
    private String familyCode = null;

    @JsonProperty("germplasmDbId")
    private String germplasmDbId = null;

    @JsonProperty("germplasmName")
    private String germplasmName = null;

    @JsonProperty("germplasmPUI")
    private String germplasmPUI = null;

    @JsonProperty("parents")
    private List<BrAPIPedigreeNodeRelative> parents = null;

    @JsonProperty("pedigreeString")
    private String pedigreeString = null;

    @JsonProperty("pedigree")
    @Deprecated
    private String pedigree = null;

    @JsonProperty("progeny")
    private List<BrAPIPedigreeNodeRelative> progeny = null;

    @JsonProperty("siblings")
    private List<BrAPIPedigreeNodeSibling> siblings = null;

    public BrAPIPedigreeNode additionalInfo(Map<String, String> additionalInfo) {
        this.additionalInfo = additionalInfo;
        return this;
    }

    public BrAPIPedigreeNode putAdditionalInfoItem(String key, String additionalInfoItem) {
        if (this.additionalInfo == null) {
            this.additionalInfo = new HashMap<String, String>();
        }
        this.additionalInfo.put(key, additionalInfoItem);
        return this;
    }

    /**
     * A free space containing any additional information related to a particular object. A data source may provide any JSON object, unrestriced by the BrAPI specification.
     *
     * @return additionalInfo
     **/
    public Map<String, String> getAdditionalInfo() {
        return additionalInfo;
    }

    public void setAdditionalInfo(Map<String, String> additionalInfo) {
        this.additionalInfo = additionalInfo;
    }

    public BrAPIPedigreeNode breedingMethodDbId(String breedingMethodDbId) {
        this.breedingMethodDbId = breedingMethodDbId;
        return this;
    }

    /**
     * The unique identifier for the breeding method used to create this germplasm
     *
     * @return breedingMethodDbId
     **/
    public String getBreedingMethodDbId() {
        return breedingMethodDbId;
    }

    public void setBreedingMethodDbId(String breedingMethodDbId) {
        this.breedingMethodDbId = breedingMethodDbId;
    }

    public BrAPIPedigreeNode breedingMethodName(String breedingMethodName) {
        this.breedingMethodName = breedingMethodName;
        return this;
    }

    /**
     * The human readable name of the breeding method used to create this germplasm
     *
     * @return breedingMethodName
     **/
    public String getBreedingMethodName() {
        return breedingMethodName;
    }

    public void setBreedingMethodName(String breedingMethodName) {
        this.breedingMethodName = breedingMethodName;
    }

    public BrAPIPedigreeNode crossingProjectDbId(String crossingProjectDbId) {
        this.crossingProjectDbId = crossingProjectDbId;
        return this;
    }

    /**
     * The crossing project used to generate this germplasm
     *
     * @return crossingProjectDbId
     **/
    public String getCrossingProjectDbId() {
        return crossingProjectDbId;
    }

    public void setCrossingProjectDbId(String crossingProjectDbId) {
        this.crossingProjectDbId = crossingProjectDbId;
    }

    public BrAPIPedigreeNode crossingYear(Integer crossingYear) {
        this.crossingYear = crossingYear;
        return this;
    }

    /**
     * The year the parents were originally crossed
     *
     * @return crossingYear
     **/
    public Integer getCrossingYear() {
        return crossingYear;
    }

    public void setCrossingYear(Integer crossingYear) {
        this.crossingYear = crossingYear;
    }

    public BrAPIPedigreeNode defaultDisplayName(String defaultDisplayName) {
        this.defaultDisplayName = defaultDisplayName;
        return this;
    }

    /**
     * Human readable name used for display purposes
     *
     * @return defaultDisplayName
     **/
    public String getDefaultDisplayName() {
        return defaultDisplayName;
    }

    public void setDefaultDisplayName(String defaultDisplayName) {
        this.defaultDisplayName = defaultDisplayName;
    }

    public BrAPIPedigreeNode externalReferences(List<BrAPIExternalReference> externalReferences) {
        this.externalReferences = externalReferences;
        return this;
    }

    /**
     * Get externalReferences
     *
     * @return externalReferences
     **/
    public List<BrAPIExternalReference> getExternalReferences() {
        return externalReferences;
    }

    public void setExternalReferences(List<BrAPIExternalReference> externalReferences) {
        this.externalReferences = externalReferences;
    }

    public BrAPIPedigreeNode familyCode(String familyCode) {
        this.familyCode = familyCode;
        return this;
    }

    /**
     * The code representing the family of this germplasm
     *
     * @return familyCode
     **/
    public String getFamilyCode() {
        return familyCode;
    }

    public void setFamilyCode(String familyCode) {
        this.familyCode = familyCode;
    }

    public BrAPIPedigreeNode germplasmDbId(String germplasmDbId) {
        this.germplasmDbId = germplasmDbId;
        return this;
    }

    /**
     * The ID which uniquely identifies a germplasm
     *
     * @return germplasmDbId
     **/
    public String getGermplasmDbId() {
        return germplasmDbId;
    }

    public void setGermplasmDbId(String germplasmDbId) {
        this.germplasmDbId = germplasmDbId;
    }

    public BrAPIPedigreeNode germplasmName(String germplasmName) {
        this.germplasmName = germplasmName;
        return this;
    }

    /**
     * A human readable name for a germplasm
     *
     * @return germplasmName
     **/
    public String getGermplasmName() {
        return germplasmName;
    }

    public void setGermplasmName(String germplasmName) {
        this.germplasmName = germplasmName;
    }

    public BrAPIPedigreeNode germplasmPUI(String germplasmPUI) {
        this.germplasmPUI = germplasmPUI;
        return this;
    }

    /**
     * The Permanent Unique Identifier which represents a germplasm  MIAPPE V1.1 (DM-41) Biological material ID - Code used to identify the biological material in the data file. Should be unique within the Investigation. Can correspond to experimental plant ID, seed lot ID, etc This material identification is different from a BiosampleID which corresponds to Observation Unit or Samples sections below.  MIAPPE V1.1 (DM-51) Material source DOI - Digital Object Identifier (DOI) of the material source  MCPD (v2.1) (PUID) 0. Any persistent, unique identifier assigned to the accession so it can be unambiguously referenced at the global level and the information associated with it harvested through automated means. Report one PUID for each accession. The Secretariat of the International Treaty on Plant Genetic Resources for Food and Agriculture (PGRFA) is facilitating the assignment of a persistent unique identifier (PUID), in the form of a DOI, to PGRFA at the accession level. Genebanks not applying a true PUID to their accessions should use, and request recipients to use, the concatenation of INSTCODE, ACCENUMB, and GENUS as a globally unique identifier similar in most respects to the PUID whenever they exchange information on accessions with third parties.
     *
     * @return germplasmPUI
     **/
    public String getGermplasmPUI() {
        return germplasmPUI;
    }

    public void setGermplasmPUI(String germplasmPUI) {
        this.germplasmPUI = germplasmPUI;
    }

    public BrAPIPedigreeNode parents(List<? extends BrAPIPedigreeNodeRelative> parents) {
        this.parents = new ArrayList<>(parents);
        return this;
    }

    public BrAPIPedigreeNode addParentsItem(BrAPIPedigreeNodeRelative parentsItem) {
        if (this.parents == null) {
            this.parents = new ArrayList<BrAPIPedigreeNodeRelative>();
        }
        this.parents.add(parentsItem);
        return this;
    }

    /**
     * A list of parent germplasm references in the pedigree tree for this germplasm. These represent edges in the tree, connecting to other nodes. &lt;br/&gt; Typically, this array should only have one parent (clonal or self) or two parents (cross). In some special cases, there may be more parents, usually when the exact parent is not known.  &lt;br/&gt; If the parameter &#x27;includeParents&#x27; is set to false, then this array should be empty, null, or not present in the response.
     *
     * @return parents
     **/
    public List<? extends BrAPIPedigreeNodeRelative> getParents() {
        return parents;
    }

    public void setParents(List<? extends BrAPIPedigreeNodeRelative> parents) {
        this.parents = new ArrayList<>(parents);
    }

    public BrAPIPedigreeNode pedigreeString(String pedigreeString) {
        this.pedigreeString = pedigreeString;
        return this;
    }

    /**
     * The string representation of the pedigree for this germplasm in PURDY notation
     *
     * @return pedigreeString
     **/
    public String getPedigreeString() {
        return pedigreeString;
    }

    public void setPedigreeString(String pedigreeString) {
        this.pedigreeString = pedigreeString;
    }

    @Deprecated
    public BrAPIPedigreeNode pedigree(String pedigree) {
        this.pedigree = pedigree;
        return this;
    }

    /**
     * The string representation of the pedigree.
     *
     * @return pedigree
     **/

    @Deprecated
    public String getPedigree() {
        return pedigree;
    }

    @Deprecated
    public void setPedigree(String pedigree) {
        this.pedigree = pedigree;
    }

    public BrAPIPedigreeNode progeny(List<BrAPIPedigreeNodeRelative> progeny) {
        this.progeny = progeny;
        return this;
    }

    public BrAPIPedigreeNode addProgenyItem(BrAPIPedigreeNodeRelative progenyItem) {
        if (this.progeny == null) {
            this.progeny = new ArrayList<BrAPIPedigreeNodeRelative>();
        }
        this.progeny.add(progenyItem);
        return this;
    }

    /**
     * A list of germplasm references that are direct children of this germplasm. These represent edges in the tree, connecting to other nodes. &lt;br/&gt; The given germplasm could have a large number of progeny, across a number of different breeding methods. The &#x27;parentType&#x27; shows        the type of parent this germplasm is to each of the child germplasm references. &lt;br/&gt; If the parameter &#x27;includeProgeny&#x27; is set to false, then this array should be empty, null, or not present in the response.
     *
     * @return progeny
     **/
    public List<BrAPIPedigreeNodeRelative> getProgeny() {
        return progeny;
    }

    public void setProgeny(List<BrAPIPedigreeNodeRelative> progeny) {
        this.progeny = progeny;
    }

    public BrAPIPedigreeNode siblings(List<? extends BrAPIPedigreeNodeSibling> siblings) {
        this.siblings = new ArrayList<>(siblings);
        return this;
    }

    public BrAPIPedigreeNode addSiblingsItem(BrAPIPedigreeNodeSibling siblingsItem) {
        if (this.siblings == null) {
            this.siblings = new ArrayList<BrAPIPedigreeNodeSibling>();
        }
        this.siblings.add(siblingsItem);
        return this;
    }

    /**
     * A list of sibling germplasm references in the pedigree tree for this germplasm. These represent edges in the tree, connecting to other nodes. &lt;br/&gt; Siblings share at least one parent with the given germplasm.  &lt;br/&gt; If the parameter &#x27;includeSiblings&#x27; is set to false, then this array should be empty, null, or not present in the response.
     *
     * @return siblings
     **/
    public List<? extends BrAPIPedigreeNodeSibling> getSiblings() {
        return siblings;
    }

    public void setSiblings(List<? extends BrAPIPedigreeNodeSibling> siblings) {
        this.siblings = new ArrayList<>(siblings);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BrAPIPedigreeNode pedigreeNode = (BrAPIPedigreeNode) o;
        return Objects.equals(this.additionalInfo, pedigreeNode.additionalInfo) &&
                Objects.equals(this.breedingMethodDbId, pedigreeNode.breedingMethodDbId) &&
                Objects.equals(this.breedingMethodName, pedigreeNode.breedingMethodName) &&
                Objects.equals(this.crossingProjectDbId, pedigreeNode.crossingProjectDbId) &&
                Objects.equals(this.crossingYear, pedigreeNode.crossingYear) &&
                Objects.equals(this.defaultDisplayName, pedigreeNode.defaultDisplayName) &&
                Objects.equals(this.externalReferences, pedigreeNode.externalReferences) &&
                Objects.equals(this.familyCode, pedigreeNode.familyCode) &&
                Objects.equals(this.germplasmDbId, pedigreeNode.germplasmDbId) &&
                Objects.equals(this.germplasmName, pedigreeNode.germplasmName) &&
                Objects.equals(this.germplasmPUI, pedigreeNode.germplasmPUI) &&
                Objects.equals(this.parents, pedigreeNode.parents) &&
                Objects.equals(this.pedigreeString, pedigreeNode.pedigreeString) &&
                Objects.equals(this.progeny, pedigreeNode.progeny) &&
                Objects.equals(this.siblings, pedigreeNode.siblings);
    }

    @Override
    public int hashCode() {
        return Objects.hash(additionalInfo, breedingMethodDbId, breedingMethodName, crossingProjectDbId, crossingYear, defaultDisplayName, externalReferences, familyCode, germplasmDbId, germplasmName, germplasmPUI, parents, pedigreeString, progeny, siblings);
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PedigreeNode {\n");

        sb.append("    additionalInfo: ").append(toIndentedString(additionalInfo)).append("\n");
        sb.append("    breedingMethodDbId: ").append(toIndentedString(breedingMethodDbId)).append("\n");
        sb.append("    breedingMethodName: ").append(toIndentedString(breedingMethodName)).append("\n");
        sb.append("    crossingProjectDbId: ").append(toIndentedString(crossingProjectDbId)).append("\n");
        sb.append("    crossingYear: ").append(toIndentedString(crossingYear)).append("\n");
        sb.append("    defaultDisplayName: ").append(toIndentedString(defaultDisplayName)).append("\n");
        sb.append("    externalReferences: ").append(toIndentedString(externalReferences)).append("\n");
        sb.append("    familyCode: ").append(toIndentedString(familyCode)).append("\n");
        sb.append("    germplasmDbId: ").append(toIndentedString(germplasmDbId)).append("\n");
        sb.append("    germplasmName: ").append(toIndentedString(germplasmName)).append("\n");
        sb.append("    germplasmPUI: ").append(toIndentedString(germplasmPUI)).append("\n");
        sb.append("    parents: ").append(toIndentedString(parents)).append("\n");
        sb.append("    pedigreeString: ").append(toIndentedString(pedigreeString)).append("\n");
        sb.append("    progeny: ").append(toIndentedString(progeny)).append("\n");
        sb.append("    siblings: ").append(toIndentedString(siblings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
