package org.brapi.v2.model.pheno.response;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.ArrayList;
import java.util.List;

import javax.validation.Valid;

import org.brapi.v2.model.BrAPIResponseResult;
import org.brapi.v2.model.pheno.BrAPIObservationUnitHierarchyLevel;


/**
 * ObservationLevelListResponseResult
 */


public class BrAPIObservationLevelListResponseResult implements BrAPIResponseResult<BrAPIObservationUnitHierarchyLevel>  {
  @JsonProperty("data")
  @Valid
  private List<BrAPIObservationUnitHierarchyLevel> data = new ArrayList<BrAPIObservationUnitHierarchyLevel>();

  public BrAPIObservationLevelListResponseResult data(List<BrAPIObservationUnitHierarchyLevel> data) {
    this.data = data;
    return this;
  }

  public BrAPIObservationLevelListResponseResult addDataItem(BrAPIObservationUnitHierarchyLevel dataItem) {
    this.data.add(dataItem);
    return this;
  }

  /**
   * Get data
   * @return data
  **/
  
      
    @Valid
    public List<BrAPIObservationUnitHierarchyLevel> getData() {
    return data;
  }

  public void setData(List<BrAPIObservationUnitHierarchyLevel> data) {
    this.data = data;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BrAPIObservationLevelListResponseResult observationLevelListResponseResult = (BrAPIObservationLevelListResponseResult) o;
    return Objects.equals(this.data, observationLevelListResponseResult.data);
  }

  @Override
  public int hashCode() {
    return Objects.hash(data);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ObservationLevelListResponseResult {\n");
    
    sb.append("    data: ").append(toIndentedString(data)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
