/*
 * Decompiled with CFR 0.152.
 */
package org.brapi.v2.model.core;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.JsonAdapter;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import org.brapi.v2.model.BrAPIExternalReference;
import org.brapi.v2.model.NullableJsonElementTypeAdapterFactory;
import org.brapi.v2.model.core.BrAPIContact;
import org.brapi.v2.model.core.BrAPITrialDatasetAuthorships;
import org.brapi.v2.model.core.BrAPITrialPublications;

public class BrAPITrial {
    @JsonProperty(value="trialDbId")
    private String trialDbId = null;
    @JsonProperty(value="active")
    private Boolean active = null;
    @JsonProperty(value="additionalInfo")
    @Valid
    @JsonAdapter(value=NullableJsonElementTypeAdapterFactory.class)
    private JsonObject additionalInfo = null;
    @JsonProperty(value="commonCropName")
    private String commonCropName = null;
    @JsonProperty(value="contacts")
    @Valid
    private List<BrAPIContact> contacts = null;
    @JsonProperty(value="datasetAuthorships")
    @Valid
    private List<BrAPITrialDatasetAuthorships> datasetAuthorships = null;
    @JsonProperty(value="documentationURL")
    private String documentationURL = null;
    @JsonProperty(value="endDate")
    private LocalDate endDate = null;
    @JsonProperty(value="externalReferences")
    private List<BrAPIExternalReference> externalReferences = null;
    @JsonProperty(value="programDbId")
    private String programDbId = null;
    @JsonProperty(value="programName")
    private String programName = null;
    @JsonProperty(value="publications")
    @Valid
    private List<BrAPITrialPublications> publications = null;
    @JsonProperty(value="startDate")
    private LocalDate startDate = null;
    @JsonProperty(value="trialDescription")
    private String trialDescription = null;
    @JsonProperty(value="trialName")
    private String trialName = null;
    @JsonProperty(value="trialPUI")
    private String trialPUI = null;
    private final transient Gson gson = new Gson();

    public String getTrialDbId() {
        return this.trialDbId;
    }

    public void setTrialDbId(String trialDbId) {
        this.trialDbId = trialDbId;
    }

    public BrAPITrial trialDbId(String trialDbId) {
        this.trialDbId = trialDbId;
        return this;
    }

    public BrAPITrial active(Boolean active) {
        this.active = active;
        return this;
    }

    public Boolean isActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public BrAPITrial additionalInfo(JsonObject additionalInfo) {
        this.additionalInfo = additionalInfo;
        return this;
    }

    public BrAPITrial putAdditionalInfoItem(String key, Object additionalInfoItem) {
        if (this.additionalInfo == null) {
            this.additionalInfo = new JsonObject();
        }
        JsonElement newElement = this.gson.toJsonTree(additionalInfoItem);
        this.additionalInfo.add(key, newElement);
        return this;
    }

    public JsonObject getAdditionalInfo() {
        return this.additionalInfo;
    }

    public void setAdditionalInfo(JsonObject additionalInfo) {
        this.additionalInfo = additionalInfo;
    }

    public BrAPITrial commonCropName(String commonCropName) {
        this.commonCropName = commonCropName;
        return this;
    }

    public String getCommonCropName() {
        return this.commonCropName;
    }

    public void setCommonCropName(String commonCropName) {
        this.commonCropName = commonCropName;
    }

    public BrAPITrial contacts(List<BrAPIContact> contacts) {
        this.contacts = contacts;
        return this;
    }

    public BrAPITrial addContactsItem(BrAPIContact contactsItem) {
        if (this.contacts == null) {
            this.contacts = new ArrayList<BrAPIContact>();
        }
        this.contacts.add(contactsItem);
        return this;
    }

    @Valid
    public List<BrAPIContact> getContacts() {
        return this.contacts;
    }

    public void setContacts(List<BrAPIContact> contacts) {
        this.contacts = contacts;
    }

    public BrAPITrial datasetAuthorships(List<BrAPITrialDatasetAuthorships> datasetAuthorships) {
        this.datasetAuthorships = datasetAuthorships;
        return this;
    }

    public BrAPITrial addDatasetAuthorshipsItem(BrAPITrialDatasetAuthorships datasetAuthorshipsItem) {
        if (this.datasetAuthorships == null) {
            this.datasetAuthorships = new ArrayList<BrAPITrialDatasetAuthorships>();
        }
        this.datasetAuthorships.add(datasetAuthorshipsItem);
        return this;
    }

    @Valid
    public List<BrAPITrialDatasetAuthorships> getDatasetAuthorships() {
        return this.datasetAuthorships;
    }

    public void setDatasetAuthorships(List<BrAPITrialDatasetAuthorships> datasetAuthorships) {
        this.datasetAuthorships = datasetAuthorships;
    }

    public BrAPITrial documentationURL(String documentationURL) {
        this.documentationURL = documentationURL;
        return this;
    }

    public String getDocumentationURL() {
        return this.documentationURL;
    }

    public void setDocumentationURL(String documentationURL) {
        this.documentationURL = documentationURL;
    }

    public BrAPITrial endDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    @Valid
    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public BrAPITrial externalReferences(List<BrAPIExternalReference> externalReferences) {
        this.externalReferences = externalReferences;
        return this;
    }

    @Valid
    public List<BrAPIExternalReference> getExternalReferences() {
        return this.externalReferences;
    }

    public void setExternalReferences(List<BrAPIExternalReference> externalReferences) {
        this.externalReferences = externalReferences;
    }

    public BrAPITrial programDbId(String programDbId) {
        this.programDbId = programDbId;
        return this;
    }

    public String getProgramDbId() {
        return this.programDbId;
    }

    public void setProgramDbId(String programDbId) {
        this.programDbId = programDbId;
    }

    public BrAPITrial programName(String programName) {
        this.programName = programName;
        return this;
    }

    public String getProgramName() {
        return this.programName;
    }

    public void setProgramName(String programName) {
        this.programName = programName;
    }

    public BrAPITrial publications(List<BrAPITrialPublications> publications) {
        this.publications = publications;
        return this;
    }

    public BrAPITrial addPublicationsItem(BrAPITrialPublications publicationsItem) {
        if (this.publications == null) {
            this.publications = new ArrayList<BrAPITrialPublications>();
        }
        this.publications.add(publicationsItem);
        return this;
    }

    @Valid
    public List<BrAPITrialPublications> getPublications() {
        return this.publications;
    }

    public void setPublications(List<BrAPITrialPublications> publications) {
        this.publications = publications;
    }

    public BrAPITrial startDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @Valid
    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public BrAPITrial trialDescription(String trialDescription) {
        this.trialDescription = trialDescription;
        return this;
    }

    public String getTrialDescription() {
        return this.trialDescription;
    }

    public void setTrialDescription(String trialDescription) {
        this.trialDescription = trialDescription;
    }

    public BrAPITrial trialName(String trialName) {
        this.trialName = trialName;
        return this;
    }

    public String getTrialName() {
        return this.trialName;
    }

    public void setTrialName(String trialName) {
        this.trialName = trialName;
    }

    public BrAPITrial trialPUI(String trialPUI) {
        this.trialPUI = trialPUI;
        return this;
    }

    public String getTrialPUI() {
        return this.trialPUI;
    }

    public void setTrialPUI(String trialPUI) {
        this.trialPUI = trialPUI;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BrAPITrial trial = (BrAPITrial)o;
        return Objects.equals(this.trialDbId, trial.trialDbId) && Objects.equals(this.active, trial.active) && Objects.equals(this.additionalInfo, trial.additionalInfo) && Objects.equals(this.commonCropName, trial.commonCropName) && Objects.equals(this.contacts, trial.contacts) && Objects.equals(this.datasetAuthorships, trial.datasetAuthorships) && Objects.equals(this.documentationURL, trial.documentationURL) && Objects.equals(this.endDate, trial.endDate) && Objects.equals(this.externalReferences, trial.externalReferences) && Objects.equals(this.programDbId, trial.programDbId) && Objects.equals(this.programName, trial.programName) && Objects.equals(this.publications, trial.publications) && Objects.equals(this.startDate, trial.startDate) && Objects.equals(this.trialDescription, trial.trialDescription) && Objects.equals(this.trialName, trial.trialName) && Objects.equals(this.trialPUI, trial.trialPUI);
    }

    public int hashCode() {
        return Objects.hash(this.trialDbId, this.active, this.additionalInfo, this.commonCropName, this.contacts, this.datasetAuthorships, this.documentationURL, this.endDate, this.externalReferences, this.programDbId, this.programName, this.publications, this.startDate, this.trialDescription, this.trialName, this.trialPUI);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Trial {\n");
        sb.append("    trialDbId: ").append(this.toIndentedString(this.trialDbId)).append("\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    additionalInfo: ").append(this.toIndentedString(this.additionalInfo)).append("\n");
        sb.append("    commonCropName: ").append(this.toIndentedString(this.commonCropName)).append("\n");
        sb.append("    contacts: ").append(this.toIndentedString(this.contacts)).append("\n");
        sb.append("    datasetAuthorships: ").append(this.toIndentedString(this.datasetAuthorships)).append("\n");
        sb.append("    documentationURL: ").append(this.toIndentedString(this.documentationURL)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    externalReferences: ").append(this.toIndentedString(this.externalReferences)).append("\n");
        sb.append("    programDbId: ").append(this.toIndentedString(this.programDbId)).append("\n");
        sb.append("    programName: ").append(this.toIndentedString(this.programName)).append("\n");
        sb.append("    publications: ").append(this.toIndentedString(this.publications)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    trialDescription: ").append(this.toIndentedString(this.trialDescription)).append("\n");
        sb.append("    trialName: ").append(this.toIndentedString(this.trialName)).append("\n");
        sb.append("    trialPUI: ").append(this.toIndentedString(this.trialPUI)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

