/*
 * Decompiled with CFR 0.152.
 */
package org.brapi.schematools.core.brapischema;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SpecVersion;
import graphql.com.google.common.collect.Streams;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.brapi.schematools.core.brapischema.BrAPISchemaReaderException;
import org.brapi.schematools.core.model.BrAPIArrayType;
import org.brapi.schematools.core.model.BrAPIEnumType;
import org.brapi.schematools.core.model.BrAPIEnumValue;
import org.brapi.schematools.core.model.BrAPIObjectProperty;
import org.brapi.schematools.core.model.BrAPIObjectType;
import org.brapi.schematools.core.model.BrAPIOneOfType;
import org.brapi.schematools.core.model.BrAPIPrimitiveType;
import org.brapi.schematools.core.model.BrAPIReferenceType;
import org.brapi.schematools.core.model.BrAPIType;
import org.brapi.schematools.core.response.Response;
import org.brapi.schematools.core.utils.StringUtils;

public class BrAPISchemaReader {
    private static final Pattern REF_PATTERN = Pattern.compile("^(\\w+).json#\\/\\$defs\\/(\\w+)$");
    private final JsonSchemaFactory factory;
    private final ObjectMapper objectMapper;

    public BrAPISchemaReader() {
        this.factory = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SpecVersion.VersionFlag.V202012);
        this.objectMapper = new ObjectMapper();
    }

    public List<BrAPIObjectType> readDirectories(Path schemaDirectory) throws BrAPISchemaReaderException {
        try {
            return Files.find(schemaDirectory, 2, this::schemaPathMatcher, new FileVisitOption[0]).flatMap(this::createBrAPISchemas).collect(Response.toList()).getResultOrThrow(response -> new RuntimeException(response.getMessagesCombined(",")));
        }
        catch (IOException | RuntimeException e) {
            throw new BrAPISchemaReaderException(e);
        }
    }

    public BrAPIObjectType readSchema(Path schemaPath, String module) throws BrAPISchemaReaderException {
        try {
            return this.createBrAPISchemas(schemaPath, module).collect(Response.toList()).mapResult(list -> (BrAPIObjectType)list.get(0)).getResultOrThrow(response -> new RuntimeException(response.getMessagesCombined(",")));
        }
        catch (RuntimeException e) {
            throw new BrAPISchemaReaderException(e);
        }
    }

    public BrAPIObjectType readSchema(String schema, String module) throws BrAPISchemaReaderException {
        try {
            return this.createBrAPISchemas(this.objectMapper.readTree(schema), module).collect(Response.toList()).mapResult(list -> (BrAPIObjectType)list.get(0)).getResultOrThrow(response -> new RuntimeException(response.getMessagesCombined(",")));
        }
        catch (JsonProcessingException | RuntimeException e) {
            throw new BrAPISchemaReaderException((Exception)e);
        }
    }

    private Stream<Response<BrAPIObjectType>> createBrAPISchemas(Path path) {
        return this.createBrAPISchemas(path, path.getParent().getFileName().toString());
    }

    private Stream<Response<BrAPIObjectType>> createBrAPISchemas(Path path, String module) {
        JsonSchema schema = this.factory.getSchema(path.toUri());
        JsonNode json = schema.getSchemaNode();
        return this.createBrAPISchemas(json, module);
    }

    private Stream<Response<BrAPIObjectType>> createBrAPISchemas(JsonNode json, String module) {
        JsonNode defs = json.get("$defs");
        if (defs != null) {
            json = defs;
        }
        Iterator iterator = json.fields();
        return Stream.generate(() -> null).takeWhile(x -> iterator.hasNext()).map(n -> (Map.Entry)iterator.next()).map(entry -> this.createObjectType((JsonNode)entry.getValue(), (String)entry.getKey(), module).mapResult(result -> (BrAPIObjectType)result));
    }

    private boolean schemaPathMatcher(Path path, BasicFileAttributes basicFileAttributes) {
        return basicFileAttributes.isRegularFile();
    }

    private Response<BrAPIType> createType(JsonNode jsonNode, String fallbackName, String module) {
        boolean isEnum = jsonNode.has("enum");
        return this.findChildNode(jsonNode, "$ref", false).ifPresentMapResultToResponseOr(this::createReferenceType, () -> this.findStringList(jsonNode, "type", true).mapResultToResponse(types -> {
            if (types.contains("object")) {
                if (isEnum) {
                    return Response.fail(Response.ErrorType.VALIDATION, String.format("Object Type '%s' can not be an enum!", fallbackName));
                }
                if (jsonNode.has("oneOf")) {
                    return this.createOneOfType(jsonNode, this.findNameFromTitle(jsonNode).getResultIfPresentOrElseResult(fallbackName), module);
                }
                return this.createObjectType(jsonNode, this.findNameFromTitle(jsonNode).getResultIfPresentOrElseResult(fallbackName), module);
            }
            if (types.contains("array")) {
                if (isEnum) {
                    return Response.fail(Response.ErrorType.VALIDATION, String.format("Array Type '%s' can not be an enum!", fallbackName));
                }
                return this.createArrayType(jsonNode, this.findNameFromTitle(jsonNode).getResultIfPresentOrElseResult(fallbackName), module);
            }
            if (types.contains("string")) {
                if (isEnum) {
                    return this.createEnumType(jsonNode, this.findNameFromTitle(jsonNode).getResultIfPresentOrElseResult(fallbackName), "string", module);
                }
                return Response.success(BrAPIPrimitiveType.STRING);
            }
            if (types.contains("integer")) {
                if (isEnum) {
                    return this.createEnumType(jsonNode, this.findNameFromTitle(jsonNode).getResultIfPresentOrElseResult(fallbackName), "integer", module);
                }
                return Response.success(BrAPIPrimitiveType.INTEGER);
            }
            if (types.contains("number")) {
                if (isEnum) {
                    return this.createEnumType(jsonNode, this.findNameFromTitle(jsonNode).getResultIfPresentOrElseResult(fallbackName), "number", module);
                }
                return Response.success(BrAPIPrimitiveType.NUMBER);
            }
            if (types.contains("boolean")) {
                if (isEnum) {
                    return this.createEnumType(jsonNode, this.findNameFromTitle(jsonNode).getResultIfPresentOrElseResult(fallbackName), "boolean", module);
                }
                return Response.success(BrAPIPrimitiveType.BOOLEAN);
            }
            return Response.fail(Response.ErrorType.VALIDATION, String.format("Unknown type(s) '%s' in node '%s'", types, jsonNode));
        }));
    }

    private Response<String> findNameFromTitle(JsonNode jsonNode) {
        return this.findString(jsonNode, "title", false).mapResult(name -> name != null ? name.replace(" ", "") : null);
    }

    private Response<BrAPIType> createReferenceType(JsonNode jsonNode) {
        BrAPIReferenceType.BrAPIReferenceTypeBuilder builder = BrAPIReferenceType.builder();
        return this.findString(jsonNode).mapResultToResponse(this::parseRef).onSuccessDoWithResult(builder::name).map(() -> Response.success(builder.build()));
    }

    private Response<String> parseRef(String ref) {
        Matcher matcher = REF_PATTERN.matcher(ref);
        if (matcher.matches()) {
            return Response.success(matcher.group(2));
        }
        return Response.fail(Response.ErrorType.VALIDATION, String.format("Ref '%s' does not match ref pattern '%s'", ref, REF_PATTERN));
    }

    private Response<BrAPIType> createArrayType(JsonNode jsonNode, String name, String module) {
        BrAPIArrayType.BrAPIArrayTypeBuilder builder = BrAPIArrayType.builder().name(name);
        return this.findChildNode(jsonNode, "items", true).mapResultToResponse(childNode -> this.createType((JsonNode)childNode, String.format("%sItem", name), module).onSuccessDoWithResult(builder::items)).map(() -> Response.success(builder.build()));
    }

    private Response<BrAPIType> createObjectType(JsonNode jsonNode, String name, String module) {
        BrAPIObjectType.BrAPIObjectTypeBuilder builder = BrAPIObjectType.builder().name(name).module(module);
        this.findString(jsonNode, "description", false).onSuccessDoWithResult(builder::description);
        List required = this.findStringList(jsonNode, "required", false).getResultIfPresentOrElseResult(Collections.emptyList());
        ArrayList properties = new ArrayList();
        return Response.empty().mapOnCondition(jsonNode.has("brapi-metadata"), () -> this.findChildNode(jsonNode, "brapi-metadata", false).mapResultToResponse(this::parseMetadata).onSuccessDoWithResult(builder::primaryModel)).mapOnCondition(jsonNode.has("additionalProperties"), () -> this.findChildNode(jsonNode, "additionalProperties", false).mapResultToResponse(additionalPropertiesNode -> this.createProperty((JsonNode)additionalPropertiesNode, "additionalProperties", module, required.contains("additionalProperties")).onSuccessDoWithResult(properties::add))).mapOnCondition(jsonNode.has("properties"), () -> this.findChildNode(jsonNode, "properties", false).mapResult(JsonNode::fields).mapResultToResponse(fields -> this.createProperties((Iterator<Map.Entry<String, JsonNode>>)fields, module, required)).onSuccessDoWithResult(properties::addAll)).onSuccessDo(() -> builder.properties(properties)).map(() -> Response.success(builder.build()));
    }

    private Response<Boolean> parseMetadata(JsonNode metadata) {
        return this.findBoolean(metadata, "primaryModel", false);
    }

    private Response<List<BrAPIObjectProperty>> createProperties(Iterator<Map.Entry<String, JsonNode>> fields, String module, List<String> required) {
        return Streams.stream(fields).map(field -> this.createProperty((JsonNode)field.getValue(), (String)field.getKey(), module, required.contains(field.getKey()))).collect(Response.toList());
    }

    private Response<BrAPIObjectProperty> createProperty(JsonNode jsonNode, String name, String module, boolean required) {
        BrAPIObjectProperty.BrAPIObjectPropertyBuilder builder = BrAPIObjectProperty.builder().name(name).required(required);
        this.findString(jsonNode, "description", false).onSuccessDoWithResult(builder::description);
        return this.createType(jsonNode, StringUtils.toSentenceCase(name), module).onSuccessDoWithResult(builder::type).map(() -> Response.success(builder.build()));
    }

    private Response<BrAPIType> createOneOfType(JsonNode jsonNode, String name, String module) {
        BrAPIOneOfType.BrAPIOneOfTypeBuilder builder = BrAPIOneOfType.builder().name(name).module(module);
        this.findString(jsonNode, "description", false).onSuccessDoWithResult(builder::description);
        return this.findChildNode(jsonNode, "oneOf", true).mapResult(this::childNodes).mapResultToResponse(childNodes -> childNodes.mapResultToResponse(nodes -> this.createPossibleTypes((List<JsonNode>)nodes, name, module))).onSuccessDoWithResult(builder::possibleTypes).map(() -> Response.success(builder.build()));
    }

    private Response<List<BrAPIType>> createPossibleTypes(List<JsonNode> jsonNodes, String fallbackNamePrefix, String module) {
        AtomicInteger i = new AtomicInteger();
        return jsonNodes.stream().map(jsonNode -> this.createType((JsonNode)jsonNode, String.format("%s%d", fallbackNamePrefix, i.incrementAndGet()), module)).collect(Response.toList());
    }

    private Response<BrAPIType> createEnumType(JsonNode jsonNode, String name, String type, String module) {
        BrAPIEnumType.BrAPIEnumTypeBuilder builder = BrAPIEnumType.builder().name(name).type(type).module(module);
        this.findString(jsonNode, "description", false).onSuccessDoWithResult(builder::description);
        return this.findStringList(jsonNode, "enum", true).mapResultToResponse(strings -> this.createEnumValues((List<String>)strings, type)).onSuccessDoWithResult(builder::values).map(() -> Response.success(builder.build()));
    }

    private Response<List<BrAPIEnumValue>> createEnumValues(List<String> strings, String type) {
        return strings.stream().map(string -> this.createEnumValue((String)string, type)).collect(Response.toList());
    }

    private Response<BrAPIEnumValue> createEnumValue(String string, String type) {
        BrAPIEnumValue.BrAPIEnumValueBuilder builder = BrAPIEnumValue.builder().name(string);
        try {
            return switch (type) {
                case "string" -> Response.success(builder.value(string).build());
                case "integer" -> Response.success(builder.value(Integer.valueOf(string)).build());
                case "number" -> Response.success(builder.value(Float.valueOf(string)).build());
                case "boolean" -> Response.success(builder.value(Boolean.valueOf(string)).build());
                default -> Response.fail(Response.ErrorType.VALIDATION, String.format("Unknown primitive type '%s'", type));
            };
        }
        catch (NumberFormatException e) {
            return Response.fail(Response.ErrorType.VALIDATION, String.format("Can not convert '%s' to type '%s'", string, type));
        }
    }

    private Response<String> findString(JsonNode parentNode, String fieldName, boolean required) {
        return this.findChildNode(parentNode, fieldName, required).mapResultToResponse(jsonNode -> {
            if (jsonNode instanceof TextNode) {
                TextNode textNode = (TextNode)jsonNode;
                return Response.success(textNode.asText());
            }
            return required ? Response.fail(Response.ErrorType.VALIDATION, String.format("Child node type '%s' was not TextNode with field name '%s' for parent node '%s'", jsonNode.getClass().getName(), parentNode, fieldName)) : Response.empty();
        });
    }

    private Response<Boolean> findBoolean(JsonNode parentNode, String fieldName, boolean required) {
        return this.findChildNode(parentNode, fieldName, required).mapResultToResponse(jsonNode -> {
            if (jsonNode instanceof BooleanNode) {
                BooleanNode booleanNode = (BooleanNode)jsonNode;
                return Response.success(booleanNode.asBoolean());
            }
            return required ? Response.fail(Response.ErrorType.VALIDATION, String.format("Child node type '%s' was not BooleanNode with field name '%s' for parent node '%s'", jsonNode.getClass().getName(), parentNode, fieldName)) : Response.empty();
        });
    }

    private Response<List<String>> findStringList(JsonNode parentNode, String fieldName, boolean required) {
        return this.findChildNode(parentNode, fieldName, required).mapResultToResponse(jsonNode -> {
            if (jsonNode instanceof ArrayNode) {
                ArrayNode arrayNode = (ArrayNode)jsonNode;
                return StreamSupport.stream(arrayNode.spliterator(), false).filter(childNode -> !(childNode instanceof NullNode)).map(this::findString).filter(stringResponse -> stringResponse.getResult() != null).collect(Response.toList());
            }
            if (jsonNode instanceof TextNode) {
                TextNode textNode = (TextNode)jsonNode;
                return Response.success(Collections.singletonList(textNode.asText()));
            }
            return required ? Response.fail(Response.ErrorType.VALIDATION, String.format("Unknown child node type '%s' with field name '%s' for parent node '%s'", jsonNode.getClass().getName(), parentNode, fieldName)) : Response.empty();
        });
    }

    private Response<String> findString(JsonNode jsonNode) {
        if (jsonNode instanceof TextNode) {
            TextNode textNode = (TextNode)jsonNode;
            return Response.success(textNode.asText());
        }
        if (jsonNode != null) {
            return Response.fail(Response.ErrorType.VALIDATION, String.format("Node type '%s' is not string", jsonNode.getClass().getName()));
        }
        return Response.empty();
    }

    private Response<JsonNode> findChildNode(JsonNode parentNode, String fieldName, boolean required) {
        JsonNode jsonNode = parentNode.get(fieldName);
        if (jsonNode != null) {
            return Response.success(jsonNode);
        }
        if (required) {
            return Response.fail(Response.ErrorType.VALIDATION, String.format("Parent node '%s' does not have child node with field name '%s'", parentNode, fieldName));
        }
        return Response.empty();
    }

    private Response<List<JsonNode>> childNodes(JsonNode parentNode) {
        if (parentNode instanceof ArrayNode) {
            ArrayNode arrayNode = (ArrayNode)parentNode;
            return Response.success(StreamSupport.stream(arrayNode.spliterator(), false).toList());
        }
        return Response.fail(Response.ErrorType.VALIDATION, String.format("Parent Node type '%s' is not ArrayNode", parentNode.getClass().getName()));
    }

    public BrAPISchemaReader(JsonSchemaFactory factory, ObjectMapper objectMapper) {
        this.factory = factory;
        this.objectMapper = objectMapper;
    }
}

