/*
 * Decompiled with CFR 0.152.
 */
package org.brapi.schematools.core.graphql;

import graphql.Scalars;
import graphql.TypeResolutionEnvironment;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLEnumValueDefinition;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNamedOutputType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLTypeReference;
import graphql.schema.GraphQLUnionType;
import graphql.schema.TypeResolver;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.brapi.schematools.core.brapischema.BrAPISchemaReader;
import org.brapi.schematools.core.brapischema.BrAPISchemaReaderException;
import org.brapi.schematools.core.graphql.options.GraphQLGeneratorOptions;
import org.brapi.schematools.core.model.BrAPIArrayType;
import org.brapi.schematools.core.model.BrAPIEnumType;
import org.brapi.schematools.core.model.BrAPIEnumValue;
import org.brapi.schematools.core.model.BrAPIObjectProperty;
import org.brapi.schematools.core.model.BrAPIObjectType;
import org.brapi.schematools.core.model.BrAPIOneOfType;
import org.brapi.schematools.core.model.BrAPIPrimitiveType;
import org.brapi.schematools.core.model.BrAPIReferenceType;
import org.brapi.schematools.core.model.BrAPIType;
import org.brapi.schematools.core.response.Response;
import org.brapi.schematools.core.utils.StringUtils;

public class GraphQLGenerator {
    private final BrAPISchemaReader schemaReader;

    public GraphQLGenerator() {
        this.schemaReader = new BrAPISchemaReader();
    }

    public Response<GraphQLSchema> generate(Path schemaDirectory, GraphQLGeneratorOptions options) {
        try {
            return new Generator(options, this.schemaReader.readDirectories(schemaDirectory)).generate();
        }
        catch (BrAPISchemaReaderException e) {
            return Response.fail(Response.ErrorType.VALIDATION, e.getMessage());
        }
    }

    public GraphQLGenerator(BrAPISchemaReader schemaReader) {
        this.schemaReader = schemaReader;
    }

    public class Generator {
        private final GraphQLGeneratorOptions options;
        private final List<BrAPIObjectType> brAPISchemas;
        private final Map<String, GraphQLOutputType> objectTypes;
        private final Map<String, GraphQLUnionType> unionTypes;
        private final Map<String, GraphQLEnumType> enumTypes;
        private final GraphQLCodeRegistry.Builder codeRegistry = GraphQLCodeRegistry.newCodeRegistry();

        public Generator(GraphQLGeneratorOptions options, List<BrAPIObjectType> brAPISchemas) {
            this.options = options;
            this.brAPISchemas = brAPISchemas;
            this.objectTypes = new HashMap<String, GraphQLOutputType>();
            this.unionTypes = new HashMap<String, GraphQLUnionType>();
            this.enumTypes = new HashMap<String, GraphQLEnumType>();
        }

        public Response<GraphQLSchema> generate() {
            return this.brAPISchemas.stream().map(this::createObjectType).collect(Response.toList()).mapResultToResponse(this::createSchema);
        }

        private Response<GraphQLSchema> createSchema(List<GraphQLOutputType> types) {
            GraphQLSchema.Builder builder = GraphQLSchema.newSchema();
            if (this.options.isGeneratingQueryType()) {
                GraphQLObjectType.Builder query = GraphQLObjectType.newObject().name(this.options.getQueryType().getName());
                types.stream().map(type -> this.generateSingleGraphQLQuery((GraphQLObjectType)type)).forEach(arg_0 -> ((GraphQLObjectType.Builder)query).field(arg_0));
                builder.query(query);
            }
            if (this.options.isGeneratingMutationType()) {
                GraphQLObjectType.Builder mutation = GraphQLObjectType.newObject().name(this.options.getMutationType().getName());
                types.stream().map(type -> this.generateSingleGraphQLMutation((GraphQLObjectType)type)).forEach(arg_0 -> ((GraphQLObjectType.Builder)mutation).field(arg_0));
                builder.mutation(mutation);
            }
            HashSet<GraphQLOutputType> additionalTypes = new HashSet<GraphQLOutputType>(types);
            builder.additionalTypes(additionalTypes);
            this.unionTypes.values().forEach(graphQLType -> this.codeRegistry.typeResolver(graphQLType, (TypeResolver)new UnionTypeResolver((GraphQLUnionType)graphQLType)));
            builder.codeRegistry(this.codeRegistry.build());
            return Response.success(builder.build());
        }

        private Response<GraphQLOutputType> createType(BrAPIType type) {
            if (type instanceof BrAPIObjectType) {
                return this.createObjectType((BrAPIObjectType)type);
            }
            if (type instanceof BrAPIOneOfType) {
                return this.createUnionType((BrAPIOneOfType)type);
            }
            if (type instanceof BrAPIArrayType) {
                return this.createListType((BrAPIArrayType)type);
            }
            if (type instanceof BrAPIReferenceType) {
                return this.createReferenceType((BrAPIReferenceType)type);
            }
            if (type instanceof BrAPIEnumType) {
                return this.createEnumType((BrAPIEnumType)type);
            }
            if (type instanceof BrAPIPrimitiveType) {
                BrAPIPrimitiveType primitiveType = (BrAPIPrimitiveType)type;
                return switch (primitiveType.getName()) {
                    case "string" -> Response.success(Scalars.GraphQLString);
                    case "integer" -> Response.success(Scalars.GraphQLInt);
                    case "number" -> Response.success(Scalars.GraphQLFloat);
                    case "boolean" -> Response.success(Scalars.GraphQLBoolean);
                    default -> Response.fail(Response.ErrorType.VALIDATION, String.format("Unknown primitive type '%s'", primitiveType.getName()));
                };
            }
            return Response.fail(Response.ErrorType.VALIDATION, String.format("Unknown type '%s'", type.getName()));
        }

        private Response<GraphQLOutputType> createReferenceType(BrAPIReferenceType type) {
            return Response.success(GraphQLTypeReference.typeRef((String)type.getName()));
        }

        private Response<GraphQLOutputType> createListType(BrAPIArrayType type) {
            return this.createType(type.getItems()).mapResult(GraphQLList::list);
        }

        private Response<GraphQLOutputType> createObjectType(BrAPIObjectType type) {
            GraphQLOutputType existingType = this.objectTypes.get(type.getName());
            if (existingType != null) {
                return Response.success(existingType);
            }
            GraphQLObjectType.Builder builder = GraphQLObjectType.newObject().name(type.getName()).description(type.getDescription());
            return type.getProperties().stream().map(this::createFieldDefinition).collect(Response.toList()).onSuccessDoWithResult(arg_0 -> ((GraphQLObjectType.Builder)builder).fields(arg_0)).map(() -> this.addObjectType(builder.build()));
        }

        private Response<GraphQLFieldDefinition> createFieldDefinition(BrAPIObjectProperty property) {
            GraphQLFieldDefinition.Builder builder = GraphQLFieldDefinition.newFieldDefinition().name(property.getName()).description(property.getDescription());
            return this.createType(property.getType()).onSuccessDoWithResult(arg_0 -> ((GraphQLFieldDefinition.Builder)builder).type(arg_0)).map(() -> Response.success(builder.build()));
        }

        private Response<GraphQLOutputType> createUnionType(BrAPIOneOfType type) {
            GraphQLOutputType existingType = (GraphQLOutputType)this.unionTypes.get(type.getName());
            if (existingType != null) {
                return Response.success(existingType);
            }
            GraphQLUnionType.Builder builder = GraphQLUnionType.newUnionType().name(type.getName()).description(type.getDescription());
            return type.getPossibleTypes().stream().map(this::createNamedOutputType).collect(Response.toList()).onSuccessDoWithResult(arg_0 -> ((GraphQLUnionType.Builder)builder).replacePossibleTypes(arg_0)).map(() -> this.addUnionType(builder.build()));
        }

        private Response<GraphQLNamedOutputType> createNamedOutputType(BrAPIType type) {
            try {
                return this.createType(type).mapResult(t -> (GraphQLNamedOutputType)t);
            }
            catch (ClassCastException e) {
                return Response.fail(Response.ErrorType.VALIDATION, String.format("Type can not be cast to GraphQLNamedOutputType, due to '%s'", e));
            }
        }

        private Response<GraphQLOutputType> createEnumType(BrAPIEnumType type) {
            GraphQLOutputType existingType = (GraphQLOutputType)this.enumTypes.get(type.getName());
            if (existingType != null) {
                return Response.success(existingType);
            }
            return this.addEnumType(GraphQLEnumType.newEnum().name(type.getName()).description(type.getDescription()).values(type.getValues().stream().map(this::createEnumValue).toList()).build());
        }

        private GraphQLEnumValueDefinition createEnumValue(BrAPIEnumValue brAPIEnumValue) {
            return GraphQLEnumValueDefinition.newEnumValueDefinition().name(StringUtils.makeValidName(brAPIEnumValue.getName())).value(brAPIEnumValue.getValue()).build();
        }

        private Response<GraphQLOutputType> addObjectType(GraphQLObjectType type) {
            this.objectTypes.put(type.getName(), (GraphQLOutputType)type);
            return Response.success(type);
        }

        private Response<GraphQLOutputType> addUnionType(GraphQLUnionType type) {
            this.unionTypes.put(type.getName(), type);
            return Response.success(type);
        }

        private Response<GraphQLOutputType> addEnumType(GraphQLEnumType type) {
            this.enumTypes.put(type.getName(), type);
            return Response.success(type);
        }

        private GraphQLFieldDefinition.Builder generateSingleGraphQLQuery(GraphQLObjectType type) {
            return GraphQLFieldDefinition.newFieldDefinition().name(StringUtils.toParameterCase(type.getName())).description(this.createSingleQueryDescription(type)).arguments(this.createSingleQueryArguments(type)).type((GraphQLOutputType)GraphQLTypeReference.typeRef((String)type.getName()));
        }

        private String createSingleQueryDescription(GraphQLObjectType type) {
            return String.format(this.options.getQueryType().getSingleQuery().getDescriptionFormat(), type.getName());
        }

        private GraphQLFieldDefinition.Builder generateSingleGraphQLMutation(GraphQLObjectType type) {
            return GraphQLFieldDefinition.newFieldDefinition().name(StringUtils.toParameterCase(type.getName()));
        }

        private List<GraphQLArgument> createSingleQueryArguments(GraphQLObjectType type) {
            return Collections.singletonList(GraphQLArgument.newArgument().name(String.format(this.options.getIds().getNameFormat(), StringUtils.toParameterCase(type.getName()))).type((GraphQLInputType)(this.options.getIds().isUsingIDType() ? Scalars.GraphQLID : Scalars.GraphQLString)).build());
        }

        public GraphQLGeneratorOptions getOptions() {
            return this.options;
        }

        public List<BrAPIObjectType> getBrAPISchemas() {
            return this.brAPISchemas;
        }

        public Map<String, GraphQLOutputType> getObjectTypes() {
            return this.objectTypes;
        }

        public Map<String, GraphQLUnionType> getUnionTypes() {
            return this.unionTypes;
        }

        public Map<String, GraphQLEnumType> getEnumTypes() {
            return this.enumTypes;
        }

        public GraphQLCodeRegistry.Builder getCodeRegistry() {
            return this.codeRegistry;
        }
    }

    private static class UnionTypeResolver
    implements TypeResolver {
        private GraphQLUnionType unionType;

        public GraphQLObjectType getType(TypeResolutionEnvironment schemaName) {
            return (GraphQLObjectType)this.unionType.getTypes().get(0);
        }

        public UnionTypeResolver(GraphQLUnionType unionType) {
            this.unionType = unionType;
        }
    }
}

