/*
 * Decompiled with CFR 0.152.
 */
package org.brapi.schematools.core.graphql.options;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.brapi.schematools.core.graphql.options.IdOptions;
import org.brapi.schematools.core.graphql.options.MutationTypeOptions;
import org.brapi.schematools.core.graphql.options.QueryTypeOptions;
import org.yaml.snakeyaml.Yaml;

public class GraphQLGeneratorOptions {
    QueryTypeOptions queryType;
    MutationTypeOptions mutationType;
    IdOptions ids;

    public static GraphQLGeneratorOptions load(Path optionsFile) throws IOException {
        return GraphQLGeneratorOptions.load(Files.newInputStream(optionsFile, new OpenOption[0]));
    }

    public static GraphQLGeneratorOptions load() {
        InputStream inputStream = GraphQLGeneratorOptions.class.getClassLoader().getResourceAsStream("graphql-options.yaml");
        return GraphQLGeneratorOptions.load(inputStream);
    }

    private static GraphQLGeneratorOptions load(InputStream inputStream) {
        Yaml yaml = new Yaml();
        return (GraphQLGeneratorOptions)yaml.loadAs(inputStream, GraphQLGeneratorOptions.class);
    }

    public boolean isGeneratingQueryType() {
        return this.queryType != null && this.queryType.isGenerate();
    }

    public boolean isGeneratingMutationType() {
        return this.mutationType != null && this.mutationType.isGenerate();
    }

    public QueryTypeOptions getQueryType() {
        return this.queryType;
    }

    public MutationTypeOptions getMutationType() {
        return this.mutationType;
    }

    public IdOptions getIds() {
        return this.ids;
    }

    public void setQueryType(QueryTypeOptions queryType) {
        this.queryType = queryType;
    }

    public void setMutationType(MutationTypeOptions mutationType) {
        this.mutationType = mutationType;
    }

    public void setIds(IdOptions ids) {
        this.ids = ids;
    }
}

