/*
 * Decompiled with CFR 0.152.
 */
package org.brapi.schematools.core.response;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.brapi.schematools.core.response.ResponseFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Response<T> {
    private static final Logger log = LoggerFactory.getLogger(Response.class);
    private T result;
    private final EnumMap<ErrorType, Set<Error>> errors = new EnumMap(ErrorType.class);

    private Response(T result) {
        this.errors.put(ErrorType.VALIDATION, new HashSet());
        this.errors.put(ErrorType.PERMISSION, new HashSet());
        this.errors.put(ErrorType.OTHER, new HashSet());
        this.result = result;
    }

    private Response() {
        this.errors.put(ErrorType.VALIDATION, new HashSet());
        this.errors.put(ErrorType.PERMISSION, new HashSet());
        this.errors.put(ErrorType.OTHER, new HashSet());
    }

    private Response(Response<T> response) {
        this.getErrors(ErrorType.VALIDATION).addAll(response.getErrors(ErrorType.VALIDATION));
        this.getErrors(ErrorType.PERMISSION).addAll(response.getErrors(ErrorType.PERMISSION));
        this.getErrors(ErrorType.OTHER).addAll(response.getErrors(ErrorType.OTHER));
        this.result = response.result;
    }

    public static <T> Response<T> success(T result) {
        return new Response<T>(result);
    }

    public static <T> Response<T> empty() {
        return new Response<T>();
    }

    private static <T> Response<T> fail(ErrorType type, Error error) {
        Response<T> response = new Response<T>();
        switch (type) {
            case VALIDATION: {
                response.getErrors(ErrorType.VALIDATION).add(error);
                break;
            }
            case PERMISSION: {
                response.getErrors(ErrorType.PERMISSION).add(error);
                break;
            }
            case OTHER: {
                response.getErrors(ErrorType.OTHER).add(error);
            }
        }
        return response;
    }

    public static <T> Response<T> fail(ErrorType type, String code, String message) {
        return Response.fail(type, Error.of(code, message, type));
    }

    public static <T> Response<T> fail(ErrorType type, String message) {
        return Response.fail(type, "", message);
    }

    public static <T> Response<T> failWithLogging(ErrorType type, String message, ErrorLogging errorLogging) {
        errorLogging.executeLogging();
        return Response.fail(type, "", message);
    }

    public Response<T> mergeErrors(Response<?> response) {
        this.getErrors(ErrorType.VALIDATION).addAll(response.getErrors(ErrorType.VALIDATION));
        this.getErrors(ErrorType.PERMISSION).addAll(response.getErrors(ErrorType.PERMISSION));
        this.getErrors(ErrorType.OTHER).addAll(response.getErrors(ErrorType.OTHER));
        return this;
    }

    public <C> Response<T> mergeErrors(Supplier<Response<C>> supplier) {
        Response<C> response = supplier.get();
        this.getErrors(ErrorType.VALIDATION).addAll(response.getErrors(ErrorType.VALIDATION));
        this.getErrors(ErrorType.PERMISSION).addAll(response.getErrors(ErrorType.PERMISSION));
        this.getErrors(ErrorType.OTHER).addAll(response.getErrors(ErrorType.OTHER));
        return this;
    }

    public <C> Response<T> mapErrors(Function<Response<T>, Response<C>> function) {
        Response<C> response = function.apply(this);
        this.getErrors(ErrorType.VALIDATION).clear();
        this.getErrors(ErrorType.PERMISSION).clear();
        this.getErrors(ErrorType.OTHER).clear();
        this.getErrors(ErrorType.VALIDATION).addAll(response.getErrors(ErrorType.VALIDATION));
        this.getErrors(ErrorType.PERMISSION).addAll(response.getErrors(ErrorType.PERMISSION));
        this.getErrors(ErrorType.OTHER).addAll(response.getErrors(ErrorType.OTHER));
        return this;
    }

    public <C> Response<T> mapResultErrors(Function<T, Response<C>> function) {
        if (this.hasNoErrors()) {
            Response<C> response = function.apply(this.getResult());
            this.getErrors(ErrorType.VALIDATION).addAll(response.getErrors(ErrorType.VALIDATION));
            this.getErrors(ErrorType.PERMISSION).addAll(response.getErrors(ErrorType.PERMISSION));
            this.getErrors(ErrorType.OTHER).addAll(response.getErrors(ErrorType.OTHER));
        }
        return this;
    }

    public T getResult() {
        if (this.hasNoErrors()) {
            return this.result;
        }
        throw new RuntimeException(String.format("Trying to access the result while an error has occurred, [%s]", this.getMessagesCombined(";")));
    }

    public T orElseResult(T result) {
        return this.hasErrors() ? result : this.getResult();
    }

    public T orElseGetResult(Supplier<T> supplier) {
        return this.hasErrors() ? supplier.get() : this.getResult();
    }

    public T getResultOrThrow(Exception ex) throws Exception {
        if (this.hasErrors()) {
            throw ex;
        }
        return this.getResult();
    }

    public T getResultOrThrow(Supplier<RuntimeException> supplier) {
        if (this.hasErrors()) {
            throw supplier.get();
        }
        return this.getResult();
    }

    public T getResultOrThrow(Function<Response<?>, ? extends RuntimeException> function) {
        if (this.hasErrors()) {
            throw function.apply(this);
        }
        return this.getResult();
    }

    public T getResultOrThrow() {
        return this.getResultOrThrow(() -> new ResponseFailedException(this));
    }

    public boolean hasErrors() {
        return !this.getValidationErrors().isEmpty() || !this.getPermissionErrors().isEmpty() || !this.getOtherErrors().isEmpty();
    }

    public boolean hasNoErrors() {
        return this.getValidationErrors().isEmpty() && this.getPermissionErrors().isEmpty() && this.getOtherErrors().isEmpty();
    }

    public <U> Response<U> merge(Response<U> response) {
        response.getErrors(ErrorType.VALIDATION).addAll(this.getErrors(ErrorType.VALIDATION));
        response.getErrors(ErrorType.PERMISSION).addAll(this.getErrors(ErrorType.PERMISSION));
        response.getErrors(ErrorType.OTHER).addAll(this.getErrors(ErrorType.OTHER));
        return response;
    }

    public <U> Response<U> merge(Supplier<Response<U>> responseSupplier) {
        Response<U> response = responseSupplier.get();
        response.getErrors(ErrorType.VALIDATION).addAll(this.getErrors(ErrorType.VALIDATION));
        response.getErrors(ErrorType.PERMISSION).addAll(this.getErrors(ErrorType.PERMISSION));
        response.getErrors(ErrorType.OTHER).addAll(this.getErrors(ErrorType.OTHER));
        return response;
    }

    public <U> Response<U> mergeOnCondition(boolean condition, Supplier<Response<U>> supplier) {
        return condition ? this.merge(supplier.get()) : new Response<T>().mergeErrors(this);
    }

    public <U> Response<U> mapOnCondition(boolean condition, Function<Response<T>, Response<U>> function) {
        return condition && this.hasNoErrors() ? this.merge(function.apply(this)) : new Response<T>().mergeErrors(this);
    }

    public <U> Response<U> mapOnCondition(boolean condition, Supplier<Response<U>> supplier) {
        return condition && this.hasNoErrors() ? this.merge(supplier.get()) : new Response<T>().mergeErrors(this);
    }

    public <U> Response<U> mapResponseOnCondition(boolean condition, Function<T, Response<U>> function) {
        return condition && this.hasNoErrors() ? this.merge(function.apply(this.getResult())) : new Response<T>().mergeErrors(this);
    }

    public <U> Response<U> map(Supplier<Response<U>> supplier) {
        return this.mergeOnCondition(this.hasNoErrors(), supplier);
    }

    public <U> Response<U> map(Function<Response<T>, Response<U>> function) {
        return this.hasNoErrors() ? function.apply(this) : new Response<T>().mergeErrors(this);
    }

    public Response<T> or(Supplier<Response<T>> supplier) {
        return this.hasErrors() ? supplier.get() : this;
    }

    public Response<T> orElse(Response<T> response) {
        return this.or(() -> response);
    }

    public <U> Response<U> mapResult(Function<T, U> function) {
        if (this.hasNoErrors()) {
            return new Response<U>(function.apply(this.getResult()));
        }
        return new Response<T>().mergeErrors(this);
    }

    public <RESULT> Response<RESULT> withResult(RESULT result) {
        if (this.hasNoErrors()) {
            return new Response<RESULT>(result);
        }
        return new Response<T>().mergeErrors(this);
    }

    public <RESULT> Response<RESULT> withResult(Supplier<RESULT> result) {
        if (this.hasNoErrors()) {
            return new Response<RESULT>(result.get());
        }
        return new Response<T>().mergeErrors(this);
    }

    public Response<T> conditionalMapResult(boolean condition, UnaryOperator<T> function) {
        if (this.hasNoErrors()) {
            return condition ? new Response(function.apply(this.getResult())) : this;
        }
        return this;
    }

    public Response<T> conditionalMapResultToResponse(Predicate<T> predicate, Supplier<Response<T>> supplier) {
        if (this.hasNoErrors()) {
            return predicate.test(this.getResult()) ? supplier.get() : this;
        }
        return this;
    }

    public Response<T> conditionalMapResultToResponse(Predicate<T> predicate, Function<T, Response<T>> function) {
        if (this.hasNoErrors()) {
            return predicate.test(this.getResult()) ? function.apply(this.getResult()) : this;
        }
        return this;
    }

    public Response<T> conditionalMapResultToResponse(boolean condition, Supplier<Response<T>> supplier) {
        if (this.hasNoErrors()) {
            return condition ? supplier.get() : this;
        }
        return this;
    }

    public Response<T> conditionalMapResultToResponse(boolean condition, Function<T, Response<T>> function) {
        if (this.hasNoErrors()) {
            return condition ? function.apply(this.getResult()) : this;
        }
        return this;
    }

    public <U> Response<U> mapResultToResponse(Function<T, Response<U>> function) {
        if (this.hasNoErrors()) {
            return function.apply(this.getResult());
        }
        return new Response<T>().mergeErrors(this);
    }

    public Response<T> justDo(Supplier<Void> supplier) {
        supplier.get();
        return this;
    }

    public Response<T> justDoOnCondition(boolean condition, Supplier<Void> supplier) {
        if (condition) {
            supplier.get();
        }
        return this;
    }

    public Response<T> onSuccessDo(Consumer<Response<T>> consumer) {
        if (this.hasErrors()) {
            return this;
        }
        consumer.accept(this);
        return this;
    }

    public Response<T> onSuccessDo(Supplier<Void> supplier) {
        if (this.hasErrors()) {
            return this;
        }
        supplier.get();
        return this;
    }

    public Response<T> onSuccessDo(Runnable action) {
        if (this.hasErrors()) {
            return this;
        }
        action.run();
        return this;
    }

    public Response<T> onSuccessDoWithResult(Consumer<T> consumer) {
        if (this.hasErrors()) {
            return this;
        }
        consumer.accept(this.getResult());
        return this;
    }

    public Response<T> onSuccessDoOnCondition(Predicate<T> condition, Supplier<Void> supplier) {
        if (this.hasErrors()) {
            return this;
        }
        if (condition.test(this.getResult())) {
            supplier.get();
        }
        return this;
    }

    public Response<T> onSuccessDoOnCondition(Predicate<T> condition, Runnable runnable) {
        if (this.hasErrors()) {
            return this;
        }
        if (condition.test(this.getResult())) {
            runnable.run();
        }
        return this;
    }

    public Response<T> onSuccessDoOnCondition(boolean condition, Runnable action) {
        if (!this.hasErrors() && condition) {
            action.run();
        }
        return this;
    }

    public Response<T> onFailDo(Runnable callBack) {
        if (this.hasErrors()) {
            callBack.run();
        }
        return this;
    }

    public Response<T> onFailDoWithResponse(Consumer<Response<T>> consumer) {
        if (this.hasErrors()) {
            consumer.accept(this);
            return this;
        }
        return this;
    }

    public boolean isPresent() {
        return !this.hasErrors() && this.result != null;
    }

    public boolean isEmpty() {
        return !this.hasErrors() && this.result == null;
    }

    public T getResultIfPresentOrElseResult(Supplier<T> supplier) {
        return this.isPresent() ? this.getResult() : supplier.get();
    }

    public T getResultIfPresentOrElseResult(T result) {
        return this.isPresent() ? this.getResult() : result;
    }

    public <U> Response<U> ifPresentMapResultToResponseOr(Function<T, Response<U>> function, Supplier<Response<U>> supplier) {
        if (this.isPresent()) {
            return function.apply(this.getResult());
        }
        return supplier.get();
    }

    public Response<T> addError(ErrorType type, Error error) {
        switch (type) {
            case VALIDATION: {
                this.getErrors(ErrorType.VALIDATION).add(error);
                break;
            }
            case PERMISSION: {
                this.getErrors(ErrorType.PERMISSION).add(error);
                break;
            }
            case OTHER: {
                log.error(error.getMessage());
                this.getErrors(ErrorType.OTHER).add(error);
            }
        }
        return new Response<T>(this);
    }

    public Response<T> addError(ErrorType type, String code, String message) {
        return this.addError(type, Error.of(code, message, type));
    }

    private Set<Error> getErrors(ErrorType errorType) {
        return this.errors.get((Object)errorType);
    }

    public Collection<Error> getValidationErrors() {
        return Collections.unmodifiableSet(this.getErrors(ErrorType.VALIDATION));
    }

    public Collection<Error> getPermissionErrors() {
        return Collections.unmodifiableSet(this.getErrors(ErrorType.PERMISSION));
    }

    public Collection<Error> getOtherErrors() {
        return Collections.unmodifiableSet(this.getErrors(ErrorType.OTHER));
    }

    public Collection<Error> getAllErrors() {
        return Stream.concat(Stream.concat(this.getErrors(ErrorType.VALIDATION).stream(), this.getErrors(ErrorType.PERMISSION).stream()), this.getErrors(ErrorType.OTHER).stream()).collect(Collectors.toList());
    }

    public List<String> getMessages() {
        return Stream.concat(Stream.concat(this.getErrors(ErrorType.VALIDATION).stream(), this.getErrors(ErrorType.PERMISSION).stream()), this.getErrors(ErrorType.OTHER).stream()).map(Error::getMessage).collect(Collectors.toList());
    }

    public String getMessagesCombined(String delimiter) {
        return String.join((CharSequence)delimiter, this.getMessages());
    }

    public static <T> Collector<Response<T>, Response<List<T>>, Response<List<T>>> toList() {
        return Collector.of(() -> new Response(new ArrayList()), Response.getResultToResultListAccumulator(), Response.getListCombiner(), Collector.Characteristics.IDENTITY_FINISH);
    }

    public static <T> Collector<Response<T>, Response<Set<T>>, Response<Set<T>>> toSet() {
        return Collector.of(() -> new Response(new HashSet()), Response.getResultToResultSetAccumulator(), Response.getSetCombiner(), Collector.Characteristics.UNORDERED);
    }

    public static <T> Collector<Response<List<T>>, Response<List<T>>, Response<List<T>>> mergeLists() {
        return Collector.of(() -> new Response(new ArrayList()), Response.getResultListAccumulator(), Response.getListCombiner(), Collector.Characteristics.IDENTITY_FINISH);
    }

    private static <T> BiConsumer<Response<List<T>>, Response<T>> getResultToResultListAccumulator() {
        return (listResponse, response) -> {
            listResponse.mergeErrors((Response<?>)response);
            if (response.result != null) {
                ((List)listResponse.result).add(response.result);
            }
        };
    }

    private static <T> BiConsumer<Response<Set<T>>, Response<T>> getResultToResultSetAccumulator() {
        return (setResponse, response) -> {
            setResponse.mergeErrors((Response<?>)response);
            if (response.result != null) {
                ((Set)setResponse.result).add(response.result);
            }
        };
    }

    private static <T> BiConsumer<Response<List<T>>, Response<List<T>>> getResultListAccumulator() {
        return (listResponse, response) -> {
            listResponse.mergeErrors((Response<?>)response);
            if (response.result != null) {
                ((List)listResponse.result).addAll((Collection)response.result);
            }
        };
    }

    private static <T> BinaryOperator<Response<List<T>>> getListCombiner() {
        return (listResponse1, listResponse2) -> {
            listResponse1.mergeErrors((Response<?>)listResponse2);
            ((List)listResponse1.result).addAll((Collection)listResponse2.result);
            return listResponse1;
        };
    }

    private static <T> BinaryOperator<Response<Set<T>>> getSetCombiner() {
        return (setResponse1, setResponse2) -> {
            setResponse1.mergeErrors((Response<?>)setResponse2);
            ((Set)setResponse1.result).addAll((Collection)setResponse2.result);
            return setResponse1;
        };
    }

    public static enum ErrorType {
        VALIDATION,
        PERMISSION,
        OTHER;

    }

    public static final class Error {
        private final String code;
        private final String message;
        private final ErrorType type;

        private Error(String code, String message, ErrorType type) {
            this.code = code;
            this.message = message;
            this.type = type;
        }

        public static Error of(String code, String message, ErrorType type) {
            return new Error(code, message, type);
        }

        public String getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }

        public ErrorType getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Error)) {
                return false;
            }
            Error other = (Error)o;
            String this$code = this.getCode();
            String other$code = other.getCode();
            if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
                return false;
            }
            ErrorType this$type = this.getType();
            ErrorType other$type = other.getType();
            return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $code = this.getCode();
            result = result * 59 + ($code == null ? 43 : $code.hashCode());
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            ErrorType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            return result;
        }

        public String toString() {
            return "Response.Error(code=" + this.getCode() + ", message=" + this.getMessage() + ", type=" + this.getType() + ")";
        }
    }

    @FunctionalInterface
    public static interface ErrorLogging {
        public void executeLogging();
    }
}

