/*
 * Decompiled with CFR 0.152.
 */
package org.brapi.schematools.core.utils;

import graphql.com.google.common.collect.ImmutableList;
import graphql.com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {
    private static final Set<String> unpluralisables = ImmutableSet.of((Object)"equipment", (Object)"information", (Object)"rice", (Object)"money", (Object)"species", (Object)"series", (Object[])new String[]{"fish", "sheep", "deer"});
    private static final List<Replacer> singularisations = ImmutableList.of((Object)StringUtils.replace("(.*)people$").with("$1person"), (Object)StringUtils.replace("oxen$").with("ox"), (Object)StringUtils.replace("children$").with("child"), (Object)StringUtils.replace("feet$").with("foot"), (Object)StringUtils.replace("teeth$").with("tooth"), (Object)StringUtils.replace("geese$").with("goose"), (Object)StringUtils.replace("(.*)ives?$").with("$1ife"), (Object)StringUtils.replace("(.*)ves?$").with("$1f"), (Object)StringUtils.replace("(.*)men$").with("$1man"), (Object)StringUtils.replace("(.+[aeiou])ys$").with("$1y"), (Object)StringUtils.replace("(.+[^aeiou])ies$").with("$1y"), (Object)StringUtils.replace("(.+)zes$").with("$1"), (Object[])new Replacer[]{StringUtils.replace("([m|l])ice$").with("$1ouse"), StringUtils.replace("matrices$").with("matrix"), StringUtils.replace("indices$").with("index"), StringUtils.replace("(.+[^aeiou])ices$").with("$1ice"), StringUtils.replace("(.*)ices$").with("$1ex"), StringUtils.replace("(octop|vir)i$").with("$1us"), StringUtils.replace("bases$").with("base"), StringUtils.replace("(.+(s|x|sh|ch))es$").with("$1"), StringUtils.replace("(.+)s$").with("$1")});
    private static final List<Replacer> pluralisations = ImmutableList.of((Object)StringUtils.replace("(.*)person$").with("$1people"), (Object)StringUtils.replace("ox$").with("oxen"), (Object)StringUtils.replace("child$").with("children"), (Object)StringUtils.replace("foot$").with("feet"), (Object)StringUtils.replace("tooth$").with("teeth"), (Object)StringUtils.replace("goose$").with("geese"), (Object)StringUtils.replace("(.*)fe?$").with("$1ves"), (Object)StringUtils.replace("(.*)man$").with("$1men"), (Object)StringUtils.replace("(.+[aeiou]y)$").with("$1s"), (Object)StringUtils.replace("(.+[^aeiou])y$").with("$1ies"), (Object)StringUtils.replace("(.+z)$").with("$1zes"), (Object)StringUtils.replace("([m|l])ouse$").with("$1ice"), (Object[])new Replacer[]{StringUtils.replace("(.+)(e|i)x$").with("$1ices"), StringUtils.replace("(octop|vir)us$").with("$1i"), StringUtils.replace("(.+(s|x|sh|ch))$").with("$1es"), StringUtils.replace("(.+)").with("$1s")});

    public static String toSingular(String value) {
        if (unpluralisables.contains(value.toLowerCase())) {
            return value;
        }
        for (Replacer singularization : singularisations) {
            if (!singularization.matches(value)) continue;
            return singularization.replace();
        }
        return value;
    }

    public static String toPlural(String value) {
        if (unpluralisables.contains(value.toLowerCase())) {
            return value;
        }
        for (Replacer pluralisation : pluralisations) {
            if (!pluralisation.matches(value)) continue;
            return pluralisation.replace();
        }
        return value;
    }

    public static String makeValidName(String string) {
        if (string == null) {
            return "null";
        }
        if (((String)string).isBlank()) {
            return "blank";
        }
        if (((String)string).matches("^\\d.*$")) {
            string = "N" + (String)string;
        }
        return ((String)string).replace("-", "_").replace("/", "_").replace(".", "_");
    }

    public static String toSentenceCase(String value) {
        return value.substring(0, 1).toUpperCase() + value.substring(1);
    }

    public static String toParameterCase(String value) {
        return value.substring(0, 1).toLowerCase() + value.substring(1);
    }

    public static boolean startsWithLowerCase(String value) {
        return value.matches("^[a-z].*$");
    }

    public static boolean startsWithUpperCase(String value) {
        return value.matches("^[A-Z].*$");
    }

    static Replacer.Builder replace(String pattern) {
        return new Replacer.Builder(Pattern.compile(pattern));
    }

    static class Replacer {
        Pattern pattern;
        String replacement;
        Matcher m;

        private Replacer(Pattern pattern, String replacement) {
            this.pattern = pattern;
            this.replacement = replacement;
        }

        boolean matches(String word) {
            this.m = this.pattern.matcher(word);
            return this.m.matches();
        }

        String replace() {
            return this.m.replaceFirst(this.replacement);
        }

        static class Builder {
            private final Pattern pattern;

            Builder(Pattern pattern) {
                this.pattern = pattern;
            }

            Replacer with(String replacement) {
                return new Replacer(this.pattern, replacement);
            }
        }
    }
}

