/*
 * Decompiled with CFR 0.152.
 */
package org.brapi.schematools.core.brapischema;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SpecVersion;
import graphql.com.google.common.collect.Streams;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.brapi.schematools.core.brapischema.BrAPISchemaReaderException;
import org.brapi.schematools.core.model.BrAPIAllOfType;
import org.brapi.schematools.core.model.BrAPIArrayType;
import org.brapi.schematools.core.model.BrAPIClass;
import org.brapi.schematools.core.model.BrAPIEnumType;
import org.brapi.schematools.core.model.BrAPIEnumValue;
import org.brapi.schematools.core.model.BrAPIMetadata;
import org.brapi.schematools.core.model.BrAPIObjectProperty;
import org.brapi.schematools.core.model.BrAPIObjectType;
import org.brapi.schematools.core.model.BrAPIOneOfType;
import org.brapi.schematools.core.model.BrAPIPrimitiveType;
import org.brapi.schematools.core.model.BrAPIReferenceType;
import org.brapi.schematools.core.model.BrAPIRelationshipType;
import org.brapi.schematools.core.model.BrAPIType;
import org.brapi.schematools.core.response.Response;
import org.brapi.schematools.core.utils.StringUtils;

public class BrAPISchemaReader {
    private static final Pattern REF_PATTERN = Pattern.compile("((?:\\.{1,2}+/)*(?:[\\w-]+\\/)*(?:\\w+).json)?#\\/\\$defs\\/(\\w+)");
    private static final List<String> COMMON_MODULES = List.of("Schemas", "Parameters", "Requests");
    private final JsonSchemaFactory factory;
    private final ObjectMapper objectMapper;

    public BrAPISchemaReader() {
        this.factory = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SpecVersion.VersionFlag.V202012);
        this.objectMapper = new ObjectMapper();
    }

    public Response<List<BrAPIClass>> readDirectories(Path schemaDirectory) {
        return new Reader().readDirectories(schemaDirectory);
    }

    public Response<BrAPIClass> readSchema(Path schemaPath, String module) throws BrAPISchemaReaderException {
        try {
            return new Reader().createBrAPISchemas(schemaPath, module).mapResult(list -> (BrAPIClass)list.get(0));
        }
        catch (RuntimeException e) {
            throw new BrAPISchemaReaderException(e);
        }
    }

    public Response<List<BrAPIClass>> readSchema(Path path, String schema, String module) throws BrAPISchemaReaderException {
        try {
            return new Reader().createBrAPISchemas(path, this.objectMapper.readTree(schema), module);
        }
        catch (JsonProcessingException | RuntimeException e) {
            throw new BrAPISchemaReaderException(String.format("Can not read schema at '%s' in module '%s' from '%s', due to '%s'", path, module, schema, e.getMessage()), (Exception)e);
        }
    }

    public BrAPISchemaReader(JsonSchemaFactory factory, ObjectMapper objectMapper) {
        this.factory = factory;
        this.objectMapper = objectMapper;
    }

    private class Reader {
        private final Map<Path, JsonNode> schemaNodes = new HashMap<Path, JsonNode>();

        private Reader() {
        }

        private Response<List<BrAPIClass>> readDirectories(Path schemaDirectory) {
            Response<List<BrAPIClass>> response;
            block9: {
                Stream<Path> schemas = Files.find(schemaDirectory, 3, this::schemaPathMatcher, new FileVisitOption[0]);
                try {
                    response = this.dereferenceAndValidate(schemas.map(this::createBrAPISchemas).collect(Response.mergeLists()));
                    if (schemas == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (schemas != null) {
                            try {
                                schemas.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (NoSuchFileException noSuchFileException) {
                        return Response.fail(Response.ErrorType.VALIDATION, String.format("The schema directory '%s' does not exist", schemaDirectory));
                    }
                    catch (IOException | RuntimeException e) {
                        return Response.fail(Response.ErrorType.VALIDATION, schemaDirectory, String.format("%s: %s", e.getClass().getSimpleName(), e.getMessage()));
                    }
                }
                schemas.close();
            }
            return response;
        }

        private Response<List<BrAPIClass>> dereferenceAndValidate(Response<List<BrAPIClass>> types) {
            return types.mapResult(this::dereference).mapResultToResponse(this::validate);
        }

        private List<BrAPIClass> dereference(List<BrAPIClass> types) {
            Map typeMap = types.stream().collect(Collectors.toMap(BrAPIType::getName, Function.identity()));
            ArrayList<BrAPIClass> brAPIClasses = new ArrayList<BrAPIClass>();
            types.forEach(type -> {
                if (type instanceof BrAPIAllOfType) {
                    BrAPIAllOfType brAPIAllOfType = (BrAPIAllOfType)type;
                    brAPIClasses.add(BrAPIObjectType.builder().name(brAPIAllOfType.getName()).description(brAPIAllOfType.getDescription()).module(brAPIAllOfType.getModule()).metadata(brAPIAllOfType.getMetadata() != null ? brAPIAllOfType.getMetadata().toBuilder().build() : null).interfaces(this.extractInterfaces(brAPIAllOfType, typeMap)).properties(this.extractProperties(new ArrayList<BrAPIObjectProperty>(), brAPIAllOfType, typeMap)).build());
                } else {
                    brAPIClasses.add((BrAPIClass)type);
                }
            });
            return brAPIClasses;
        }

        private Response<List<BrAPIClass>> validate(List<BrAPIClass> brAPIClasses) {
            Map classesMap = brAPIClasses.stream().collect(Collectors.toMap(BrAPIType::getName, Function.identity()));
            return brAPIClasses.stream().map(brAPIClass -> this.validateClass(classesMap, (BrAPIClass)brAPIClass).mapResult(t -> (BrAPIClass)t)).collect(Response.toList());
        }

        private Response<BrAPIType> validateClass(Map<String, BrAPIClass> classesMap, BrAPIClass brAPIClass) {
            return this.validateBrAPIMetadata(brAPIClass).map(() -> {
                if (brAPIClass instanceof BrAPIAllOfType) {
                    BrAPIAllOfType brAPIAllOfType = (BrAPIAllOfType)brAPIClass;
                    return Response.fail(Response.ErrorType.VALIDATION, String.format("BrAPIAllOfType '%s' was not de-referenced", brAPIAllOfType.getName()));
                }
                if (brAPIClass instanceof BrAPIOneOfType) {
                    BrAPIOneOfType brAPIOneOfType = (BrAPIOneOfType)brAPIClass;
                    return brAPIOneOfType.getPossibleTypes().stream().map(possibleType -> this.validateType(classesMap, (BrAPIType)possibleType)).collect(Response.toList()).withResult(brAPIClass);
                }
                if (brAPIClass instanceof BrAPIObjectType) {
                    BrAPIObjectType brAPIObjectType = (BrAPIObjectType)brAPIClass;
                    return brAPIObjectType.getProperties().stream().map(property -> this.validateProperty(classesMap, brAPIObjectType, (BrAPIObjectProperty)property)).collect(Response.toList()).withResult(brAPIClass);
                }
                return Response.success(brAPIClass);
            });
        }

        private Response<BrAPIType> validateType(Map<String, BrAPIClass> classesMap, BrAPIType brAPIType) {
            if (brAPIType instanceof BrAPIClass) {
                BrAPIClass brAPIAllOfType = (BrAPIClass)brAPIType;
                return this.validateClass(classesMap, brAPIAllOfType);
            }
            return Response.success(brAPIType);
        }

        private Response<BrAPIMetadata> validateBrAPIMetadata(BrAPIClass brAPIClass) {
            BrAPIMetadata metadata = brAPIClass.getMetadata();
            if (metadata != null) {
                int i = 0;
                if (metadata.isPrimaryModel()) {
                    ++i;
                }
                if (metadata.isRequest()) {
                    ++i;
                }
                if (metadata.isParameters()) {
                    ++i;
                }
                if (metadata.isInterfaceClass()) {
                    ++i;
                }
                if (i > 1) {
                    return Response.fail(Response.ErrorType.VALIDATION, String.format("In class '%s', 'primaryModel', 'request', 'properties', 'interface' are mutually exclusive, only one can be set to to true", brAPIClass.getName()));
                }
            }
            return Response.success(metadata);
        }

        private Response<BrAPIObjectProperty> validateProperty(Map<String, BrAPIClass> classesMap, BrAPIObjectType brAPIObjectType, BrAPIObjectProperty property) {
            BrAPIReferenceType brAPIReferenceType;
            BrAPIType propertyType = property.getType();
            if (propertyType instanceof BrAPIReferenceType && (propertyType = (BrAPIType)classesMap.get((brAPIReferenceType = (BrAPIReferenceType)propertyType).getName())) == null) {
                return Response.fail(Response.ErrorType.VALIDATION, String.format("Property '%s' in type '%s' is a Reference, but the referenced type '%s' is not available", property.getName(), brAPIObjectType.getName(), brAPIReferenceType.getName()));
            }
            BrAPIRelationshipType relationshipType = property.getRelationshipType();
            if (relationshipType != null) {
                switch (relationshipType) {
                    case MANY_TO_ONE: 
                    case ONE_TO_ONE: {
                        if (!(propertyType instanceof BrAPIArrayType)) break;
                        return Response.fail(Response.ErrorType.VALIDATION, String.format("Property '%s' in type '%s' has relationshipType '%s', referenced type '%s' is an array", new Object[]{property.getName(), brAPIObjectType.getName(), relationshipType, propertyType.getName()}));
                    }
                    case ONE_TO_MANY: 
                    case MANY_TO_MANY: {
                        if (propertyType instanceof BrAPIArrayType) break;
                        return Response.fail(Response.ErrorType.VALIDATION, String.format("Property '%s' in type '%s' has relationshipType '%s', referenced type '%s' is not an array", new Object[]{property.getName(), brAPIObjectType.getName(), relationshipType, propertyType.getName()}));
                    }
                }
            }
            if (property.getReferencedAttribute() != null) {
                BrAPIType type = this.unwrapType(property.getType());
                BrAPIClass referencedType = classesMap.get(type.getName());
                if (referencedType == null) {
                    return Response.fail(Response.ErrorType.VALIDATION, String.format("Property '%s' in type '%s' has a Referenced Attribute '%s', but the referenced type '%s' is not available", property.getName(), brAPIObjectType.getName(), property.getReferencedAttribute(), property.getType().getName()));
                }
                if (referencedType instanceof BrAPIObjectType) {
                    BrAPIObjectType referencedObjectType = (BrAPIObjectType)referencedType;
                    if (referencedObjectType.getProperties().stream().noneMatch(childProperty -> property.getReferencedAttribute().equals(childProperty.getName()))) {
                        return Response.fail(Response.ErrorType.VALIDATION, String.format("Property '%s' in type '%s' has a Referenced Attribute '%s', but the property does not exist in the referenced type '%s'", property.getName(), brAPIObjectType.getName(), property.getReferencedAttribute(), referencedType.getName()));
                    }
                } else {
                    return Response.fail(Response.ErrorType.VALIDATION, String.format("Property '%s' in type '%s' has a Referenced Attribute '%s', but the referenced type '%s' is not a BrAPIObjectType", property.getName(), brAPIObjectType.getName(), property.getReferencedAttribute(), referencedType.getName()));
                }
            }
            return Response.success(property);
        }

        private BrAPIType unwrapType(BrAPIType type) {
            if (type instanceof BrAPIArrayType) {
                BrAPIArrayType brAPIArrayType = (BrAPIArrayType)type;
                return this.unwrapType(brAPIArrayType.getItems());
            }
            return type;
        }

        private List<BrAPIObjectProperty> extractProperties(List<BrAPIObjectProperty> properties, BrAPIType brAPIType, Map<String, BrAPIType> typeMap) {
            if (brAPIType instanceof BrAPIObjectType) {
                BrAPIObjectType brAPIObjectType = (BrAPIObjectType)brAPIType;
                properties.addAll(brAPIObjectType.getProperties());
            } else if (brAPIType instanceof BrAPIAllOfType) {
                BrAPIAllOfType brAPIAllOfType = (BrAPIAllOfType)brAPIType;
                brAPIAllOfType.getAllTypes().forEach(type -> this.extractProperties(properties, (BrAPIType)type, typeMap));
            } else if (brAPIType instanceof BrAPIReferenceType) {
                BrAPIReferenceType brAPIReferenceType = (BrAPIReferenceType)brAPIType;
                this.extractProperties(properties, typeMap.get(brAPIReferenceType.getName()), typeMap);
            }
            return properties;
        }

        private List<BrAPIObjectType> extractInterfaces(BrAPIAllOfType brAPIAllOfType, Map<String, BrAPIType> typeMap) {
            ArrayList<BrAPIObjectType> interfaces = new ArrayList<BrAPIObjectType>();
            brAPIAllOfType.getAllTypes().forEach(type -> {
                BrAPIType allType = (BrAPIType)typeMap.get(type.getName());
                if (allType instanceof BrAPIObjectType && this.isInterface((BrAPIObjectType)allType)) {
                    interfaces.add((BrAPIObjectType)allType);
                }
            });
            return interfaces;
        }

        private boolean isInterface(BrAPIClass brAPIClass) {
            return brAPIClass.getMetadata() != null && brAPIClass.getMetadata().isInterfaceClass();
        }

        private Response<List<BrAPIClass>> createBrAPISchemas(Path path) {
            return this.createBrAPISchemas(path, this.findModule(path));
        }

        private String findModule(Path path) {
            String module = path != null ? path.getParent().getFileName().toString() : null;
            return module != null && COMMON_MODULES.contains(module) ? null : module;
        }

        private Response<List<BrAPIClass>> createBrAPISchemas(Path path, String module) {
            return this.findSchema(path).mapResultToResponse(json -> this.createBrAPISchemas(path, (JsonNode)json, module));
        }

        private Response<JsonNode> findSchema(Path path) {
            JsonNode json = this.schemaNodes.get(path);
            if (json != null) {
                return Response.success(json);
            }
            try {
                JsonSchema schema = BrAPISchemaReader.this.factory.getSchema(path.toUri());
                json = schema.getSchemaNode();
                this.schemaNodes.put(path, json);
                return Response.success(json);
            }
            catch (RuntimeException e) {
                return Response.fail(Response.ErrorType.VALIDATION, path, String.format("Can not read json node from path '%s' due to '%s'", path, e.getMessage()));
            }
        }

        private Response<List<BrAPIClass>> createBrAPISchemas(Path path, JsonNode json, String module) {
            JsonNode defs = json.get("$defs");
            if (defs != null) {
                json = defs;
            }
            Iterator iterator = json.fields();
            return Stream.generate(() -> null).takeWhile(x -> iterator.hasNext()).map(n -> (Map.Entry)iterator.next()).map(entry -> this.createBrAPIClass(path, (JsonNode)entry.getValue(), (String)entry.getKey(), module)).collect(Response.toList());
        }

        private Response<BrAPIClass> createBrAPIClass(Path path, JsonNode jsonNode, String fallbackName, String module) {
            try {
                return this.createType(path, jsonNode, fallbackName, module).mapResult(type -> (BrAPIClass)type);
            }
            catch (ClassCastException e) {
                return Response.fail(Response.ErrorType.VALIDATION, path, String.format("Can not cast type '%s' to BrAPIClass!", fallbackName));
            }
        }

        private boolean schemaPathMatcher(Path path, BasicFileAttributes basicFileAttributes) {
            return basicFileAttributes.isRegularFile() && path.toString().endsWith(".json");
        }

        private Response<BrAPIType> createType(Path path, JsonNode jsonNode, String fallbackName, String module) {
            if (jsonNode.has("allOf")) {
                return this.createAllOfType(path, jsonNode, this.findNameFromTitle(path, jsonNode).getResultIfPresentOrElseResult(fallbackName), module);
            }
            if (jsonNode.has("oneOf")) {
                return this.createOneOfType(path, jsonNode, this.findNameFromTitle(path, jsonNode).getResultIfPresentOrElseResult(fallbackName), module);
            }
            boolean isEnum = jsonNode.has("enum");
            return this.findChildNode(path, jsonNode, "$ref", false).ifPresentMapResultToResponseOr(ref -> this.createReferenceType(path, (JsonNode)ref), () -> this.findStringList(path, jsonNode, "type", true).mapResultToResponse(types -> {
                if (types.contains("object")) {
                    if (isEnum) {
                        return Response.fail(Response.ErrorType.VALIDATION, path, String.format("Object Type '%s' can not be an enum!", fallbackName));
                    }
                    return this.createObjectType(path, jsonNode, this.findNameFromTitle(path, jsonNode).getResultIfPresentOrElseResult(fallbackName), module);
                }
                if (types.contains("array")) {
                    if (isEnum) {
                        return Response.fail(Response.ErrorType.VALIDATION, path, String.format("Array Type '%s' can not be an enum!", fallbackName));
                    }
                    return this.createArrayType(path, jsonNode, this.findNameFromTitle(path, jsonNode).getResultIfPresentOrElseResult(fallbackName), module);
                }
                if (types.contains("string")) {
                    if (isEnum) {
                        return this.createEnumType(path, jsonNode, this.findNameFromTitle(path, jsonNode).getResultIfPresentOrElseResult(fallbackName), "string", module);
                    }
                    return Response.success(BrAPIPrimitiveType.STRING);
                }
                if (types.contains("integer")) {
                    if (isEnum) {
                        return this.createEnumType(path, jsonNode, this.findNameFromTitle(path, jsonNode).getResultIfPresentOrElseResult(fallbackName), "integer", module);
                    }
                    return Response.success(BrAPIPrimitiveType.INTEGER);
                }
                if (types.contains("number")) {
                    if (isEnum) {
                        return this.createEnumType(path, jsonNode, this.findNameFromTitle(path, jsonNode).getResultIfPresentOrElseResult(fallbackName), "number", module);
                    }
                    return Response.success(BrAPIPrimitiveType.NUMBER);
                }
                if (types.contains("boolean")) {
                    if (isEnum) {
                        return this.createEnumType(path, jsonNode, this.findNameFromTitle(path, jsonNode).getResultIfPresentOrElseResult(fallbackName), "boolean", module);
                    }
                    return Response.success(BrAPIPrimitiveType.BOOLEAN);
                }
                return Response.fail(Response.ErrorType.VALIDATION, path, String.format("Unknown type(s) '%s' in node '%s'", types, jsonNode));
            }));
        }

        private Response<String> findNameFromTitle(Path path, JsonNode jsonNode) {
            return this.findString(path, jsonNode, "title", false).mapResult(name -> name != null ? name.replace(" ", "") : null);
        }

        private Response<BrAPIType> createReferenceType(Path path, JsonNode jsonNode) {
            BrAPIReferenceType.BrAPIReferenceTypeBuilder builder = BrAPIReferenceType.builder();
            return this.findString(path, jsonNode).mapResultToResponse(ref -> this.parseRef(path, (String)ref)).onSuccessDoWithResult(builder::name).map(() -> Response.success(builder.build()));
        }

        private Response<String> parseRef(Path path, String ref) {
            Matcher matcher = REF_PATTERN.matcher(ref);
            if (matcher.matches()) {
                if (path != null && matcher.group(1) != null) {
                    Path refPath = path.getParent().resolve(matcher.group(1));
                    if (!refPath.toFile().isFile()) {
                        return Response.fail(Response.ErrorType.VALIDATION, path, String.format("Can not find json file '%s' referenced in '%s'", refPath, path));
                    }
                    return this.findSchema(refPath).mapResultToResponse(json -> this.findInJson(path, refPath, (JsonNode)json, matcher.group(2)));
                }
                return Response.success(matcher.group(2));
            }
            return Response.fail(Response.ErrorType.VALIDATION, path, String.format("Ref '%s' does not match ref pattern '%s'", ref, REF_PATTERN));
        }

        private Response<String> findInJson(Path path, Path refPath, JsonNode json, String schemaName) {
            JsonNode defs = json.get("$defs");
            if (defs != null && defs.has(schemaName)) {
                return Response.success(schemaName);
            }
            return Response.fail(Response.ErrorType.VALIDATION, path, String.format("Can not find '%s' referenced in '%s'", schemaName, refPath));
        }

        private Response<BrAPIType> createArrayType(Path path, JsonNode jsonNode, String name, String module) {
            BrAPIArrayType.BrAPIArrayTypeBuilder builder = BrAPIArrayType.builder().name(name);
            return this.findChildNode(path, jsonNode, "items", true).mapResultToResponse(childNode -> this.createType(path, (JsonNode)childNode, StringUtils.toSingular(name), module).onSuccessDoWithResult(builder::items)).map(() -> Response.success(builder.build()));
        }

        private Response<BrAPIType> createObjectType(Path path, JsonNode jsonNode, String name, String module) {
            BrAPIObjectType.BrAPIObjectTypeBuilder builder = BrAPIObjectType.builder().name(name).module(module).interfaces(new ArrayList<BrAPIObjectType>());
            this.findString(path, jsonNode, "description", false).onSuccessDoWithResult(builder::description);
            List required = this.findStringList(path, jsonNode, "required", false).getResultIfPresentOrElseResult(Collections.emptyList());
            ArrayList properties = new ArrayList();
            return Response.empty().mapOnCondition(jsonNode.has("additionalProperties"), () -> this.findChildNode(path, jsonNode, "additionalProperties", true).mapResultToResponse(additionalPropertiesNode -> this.createProperty(path, (JsonNode)additionalPropertiesNode, "additionalProperties", module, required.contains("additionalProperties")).onSuccessDoWithResult(properties::add))).mapOnCondition(jsonNode.has("properties"), () -> this.findChildNode(path, jsonNode, "properties", true).mapResult(JsonNode::fields).mapResultToResponse(fields -> this.createProperties(path, (Iterator<Map.Entry<String, JsonNode>>)fields, module, required)).onSuccessDoWithResult(properties::addAll)).onSuccessDo(() -> builder.properties(properties)).mapResult(propertyList -> this.validateRequiredProperties(required, properties, name)).mapOnCondition(jsonNode.has("brapi-metadata"), () -> this.findChildNode(path, jsonNode, "brapi-metadata", true).mapResultToResponse(metadata -> this.parseMetadata(path, (JsonNode)metadata)).onSuccessDoWithResult(builder::metadata)).map(() -> Response.success(builder.build()));
        }

        private Response<List<BrAPIObjectProperty>> validateRequiredProperties(List<String> requiredPropertyNames, List<BrAPIObjectProperty> properties, String objectName) {
            return requiredPropertyNames.stream().map(name -> this.validateRequiredProperty((String)name, properties, objectName)).collect(Response.toList());
        }

        private Response<BrAPIObjectProperty> validateRequiredProperty(String requiredPropertyName, List<BrAPIObjectProperty> properties, String objectName) {
            return properties.stream().filter(property -> property.getName().equals(requiredPropertyName)).findAny().map(Response::success).orElseGet(() -> Response.fail(Response.ErrorType.VALIDATION, String.format("The required property '%s' is not found in the list of properties of '%s', expecting one of '%s'", requiredPropertyName, objectName, properties.stream().map(BrAPIObjectProperty::getName).collect(Collectors.joining(", ")))));
        }

        private Response<List<BrAPIObjectProperty>> createProperties(Path path, Iterator<Map.Entry<String, JsonNode>> fields, String module, List<String> required) {
            return Streams.stream(fields).map(field -> this.createProperty(path, (JsonNode)field.getValue(), (String)field.getKey(), module, required.contains(field.getKey()))).collect(Response.toList());
        }

        private Response<BrAPIObjectProperty> createProperty(Path path, JsonNode jsonNode, String name, String module, boolean required) {
            BrAPIObjectProperty.BrAPIObjectPropertyBuilder builder = BrAPIObjectProperty.builder().name(name).required(required);
            this.findString(path, jsonNode, "description", false).onSuccessDoWithResult(builder::description);
            this.findString(path, jsonNode, "referencedAttribute", false).onSuccessDoWithResult(builder::referencedAttribute);
            return this.createType(path, jsonNode, StringUtils.toSentenceCase(name), module).onSuccessDoWithResult(builder::type).mapOnCondition(jsonNode.has("relationshipType"), () -> this.findString(path, jsonNode, "relationshipType", true).mapResultToResponse(BrAPIRelationshipType::fromNameOrLabel).onSuccessDoWithResult(builder::relationshipType)).map(() -> Response.success(builder.build()));
        }

        private Response<BrAPIMetadata> parseMetadata(Path path, JsonNode metadata) {
            BrAPIMetadata.BrAPIMetadataBuilder builder = BrAPIMetadata.builder();
            return this.findBoolean(path, metadata, "primaryModel", false, false).onSuccessDoWithResult(builder::primaryModel).merge(this.findBoolean(path, metadata, "request", false, false)).onSuccessDoWithResult(builder::request).merge(this.findBoolean(path, metadata, "parameters", false, false)).onSuccessDoWithResult(builder::parameters).merge(this.findBoolean(path, metadata, "interface", false, false)).onSuccessDoWithResult(builder::interfaceClass).map(() -> Response.success(builder.build()));
        }

        private Response<BrAPIType> createAllOfType(Path path, JsonNode jsonNode, String name, String module) {
            BrAPIAllOfType.BrAPIAllOfTypeBuilder builder = BrAPIAllOfType.builder().name(name).module(module);
            this.findString(path, jsonNode, "description", false).onSuccessDoWithResult(builder::description);
            return this.findChildNode(path, jsonNode, "allOf", true).mapResult(node -> this.childNodes(path, (JsonNode)node)).mapResultToResponse(childNodes -> childNodes.mapResultToResponse(nodes -> this.createAllTypes(path, (List<JsonNode>)nodes, name, module))).onSuccessDoWithResult(builder::allTypes).mapOnCondition(jsonNode.has("brapi-metadata"), () -> this.findChildNode(path, jsonNode, "brapi-metadata", true).mapResultToResponse(metadata -> this.parseMetadata(path, (JsonNode)metadata)).onSuccessDoWithResult(builder::metadata)).map(() -> Response.success(builder.build()));
        }

        private Response<List<BrAPIType>> createAllTypes(Path path, List<JsonNode> jsonNodes, String fallbackNamePrefix, String module) {
            AtomicInteger i = new AtomicInteger();
            return jsonNodes.stream().map(jsonNode -> this.createType(path, (JsonNode)jsonNode, String.format("%s%d", fallbackNamePrefix, i.incrementAndGet()), module)).collect(Response.toList());
        }

        private Response<BrAPIType> createOneOfType(Path path, JsonNode jsonNode, String name, String module) {
            BrAPIOneOfType.BrAPIOneOfTypeBuilder builder = BrAPIOneOfType.builder().name(name).module(module);
            this.findString(path, jsonNode, "description", false).onSuccessDoWithResult(builder::description);
            return this.findChildNode(path, jsonNode, "oneOf", true).mapResult(node -> this.childNodes(path, (JsonNode)node)).mapResultToResponse(childNodes -> childNodes.mapResultToResponse(nodes -> this.createPossibleTypes(path, (List<JsonNode>)nodes, name, module))).onSuccessDoWithResult(builder::possibleTypes).mapOnCondition(jsonNode.has("brapi-metadata"), () -> this.findChildNode(path, jsonNode, "brapi-metadata", true).mapResultToResponse(metadata -> this.parseMetadata(path, (JsonNode)metadata)).onSuccessDoWithResult(builder::metadata)).map(() -> Response.success(builder.build()));
        }

        private Response<List<BrAPIType>> createPossibleTypes(Path path, List<JsonNode> jsonNodes, String fallbackNamePrefix, String module) {
            AtomicInteger i = new AtomicInteger();
            return jsonNodes.stream().map(jsonNode -> this.createType(path, (JsonNode)jsonNode, String.format("%s%d", fallbackNamePrefix, i.incrementAndGet()), module)).collect(Response.toList());
        }

        private Response<BrAPIType> createEnumType(Path path, JsonNode jsonNode, String name, String type, String module) {
            BrAPIEnumType.BrAPIEnumTypeBuilder builder = BrAPIEnumType.builder().name(name).type(type).module(module);
            this.findString(path, jsonNode, "description", false).onSuccessDoWithResult(builder::description);
            return this.findStringList(path, jsonNode, "enum", true).mapResultToResponse(strings -> this.createEnumValues(path, (List<String>)strings, type)).onSuccessDoWithResult(builder::values).mapOnCondition(jsonNode.has("brapi-metadata"), () -> this.findChildNode(path, jsonNode, "brapi-metadata", true).mapResultToResponse(metadata -> this.parseMetadata(path, (JsonNode)metadata)).onSuccessDoWithResult(builder::metadata)).map(() -> Response.success(builder.build()));
        }

        private Response<List<BrAPIEnumValue>> createEnumValues(Path path, List<String> strings, String type) {
            return strings.stream().map(string -> this.createEnumValue(path, (String)string, type)).collect(Response.toList());
        }

        private Response<BrAPIEnumValue> createEnumValue(Path path, String string, String type) {
            BrAPIEnumValue.BrAPIEnumValueBuilder builder = BrAPIEnumValue.builder().name(string);
            try {
                return switch (type) {
                    case "string" -> Response.success(builder.value(string).build());
                    case "integer" -> Response.success(builder.value(Integer.valueOf(string)).build());
                    case "number" -> Response.success(builder.value(Float.valueOf(string)).build());
                    case "boolean" -> Response.success(builder.value(Boolean.valueOf(string)).build());
                    default -> Response.fail(Response.ErrorType.VALIDATION, path, String.format("Unknown primitive type '%s'", type));
                };
            }
            catch (NumberFormatException e) {
                return Response.fail(Response.ErrorType.VALIDATION, path, String.format("Can not convert '%s' to type '%s'", string, type));
            }
        }

        private Response<String> findString(Path path, JsonNode parentNode, String fieldName, boolean required) {
            return this.findChildNode(path, parentNode, fieldName, required).mapResultToResponse(jsonNode -> {
                if (jsonNode instanceof TextNode) {
                    TextNode textNode = (TextNode)jsonNode;
                    return Response.success(textNode.asText());
                }
                return required ? Response.fail(Response.ErrorType.VALIDATION, path, String.format("Child node type '%s' was not TextNode with field name '%s' for parent node '%s'", jsonNode.getClass().getName(), parentNode, fieldName)) : Response.empty();
            });
        }

        private Response<Boolean> findBoolean(Path path, JsonNode parentNode, String fieldName, boolean required, boolean defaultValue) {
            return this.findChildNode(path, parentNode, fieldName, required).mapResultToResponse(jsonNode -> {
                if (jsonNode instanceof BooleanNode) {
                    BooleanNode booleanNode = (BooleanNode)jsonNode;
                    return Response.success(booleanNode.asBoolean());
                }
                return required ? Response.fail(Response.ErrorType.VALIDATION, path, String.format("Child node type '%s' was not BooleanNode with field name '%s' for parent node '%s'", jsonNode.getClass().getName(), parentNode, fieldName)) : Response.success(defaultValue);
            });
        }

        private Response<List<String>> findStringList(Path path, JsonNode parentNode, String fieldName, boolean required) {
            return this.findChildNode(path, parentNode, fieldName, required).mapResultToResponse(jsonNode -> {
                if (jsonNode instanceof ArrayNode) {
                    ArrayNode arrayNode = (ArrayNode)jsonNode;
                    return StreamSupport.stream(arrayNode.spliterator(), false).filter(childNode -> !(childNode instanceof NullNode)).map(node -> this.findString(path, (JsonNode)node)).filter(stringResponse -> stringResponse.getResult() != null).collect(Response.toList());
                }
                if (jsonNode instanceof TextNode) {
                    TextNode textNode = (TextNode)jsonNode;
                    return Response.success(Collections.singletonList(textNode.asText()));
                }
                return required ? Response.fail(Response.ErrorType.VALIDATION, path, String.format("Unknown child node type '%s' with field name '%s' for parent node '%s'", jsonNode.getClass().getName(), parentNode, fieldName)) : Response.empty();
            });
        }

        private Response<String> findString(Path path, JsonNode jsonNode) {
            if (jsonNode instanceof TextNode) {
                TextNode textNode = (TextNode)jsonNode;
                return Response.success(textNode.asText());
            }
            if (jsonNode != null) {
                return Response.fail(Response.ErrorType.VALIDATION, path, String.format("Node type '%s' is not string", jsonNode.getClass().getName()));
            }
            return Response.empty();
        }

        private Response<JsonNode> findChildNode(Path path, JsonNode parentNode, String fieldName, boolean required) {
            JsonNode jsonNode = parentNode.get(fieldName);
            if (jsonNode != null) {
                return Response.success(jsonNode);
            }
            if (required) {
                return Response.fail(Response.ErrorType.VALIDATION, path, String.format("Parent node '%s' does not have child node with field name '%s'", parentNode, fieldName));
            }
            return Response.empty();
        }

        private Response<List<JsonNode>> childNodes(Path path, JsonNode parentNode) {
            if (parentNode instanceof ArrayNode) {
                ArrayNode arrayNode = (ArrayNode)parentNode;
                return Response.success(StreamSupport.stream(arrayNode.spliterator(), false).toList());
            }
            return Response.fail(Response.ErrorType.VALIDATION, path, String.format("Parent Node type '%s' is not ArrayNode", parentNode.getClass().getName()));
        }
    }
}

