/*
 * Decompiled with CFR 0.152.
 */
package org.brapi.schematools.core.graphql.options;

import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.NonNull;
import org.brapi.schematools.core.model.BrAPIType;
import org.brapi.schematools.core.options.AbstractGeneratorSubOptions;
import org.brapi.schematools.core.utils.StringUtils;
import org.brapi.schematools.core.validiation.Validation;

public abstract class AbstractGraphQLOptions
extends AbstractGeneratorSubOptions {
    private Boolean pluralisingName;
    private String nameFormat;

    @Override
    public Validation validate() {
        return super.validate().assertNotNull(this.pluralisingName, "'pluralisingName' option on %s is null", this.getClass().getSimpleName()).assertNotNull(this.nameFormat, "'analyse' option on %s is null", this.getClass().getSimpleName());
    }

    public void override(AbstractGraphQLOptions overrideOptions) {
        super.override(overrideOptions);
        if (overrideOptions.pluralisingName != null) {
            this.setPluralisingName(overrideOptions.pluralisingName);
        }
        if (overrideOptions.nameFormat != null) {
            this.setNameFormat(overrideOptions.nameFormat);
        }
    }

    @JsonIgnore
    public final String getNameFor(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return String.format(this.nameFormat, this.nameFormat.startsWith("%s") ? StringUtils.toParameterCase(name) : name);
    }

    @JsonIgnore
    public final String getNameFor(@NonNull BrAPIType type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return this.getNameFor(type.getName());
    }

    public boolean isPluralisingName() {
        return this.pluralisingName != null && this.pluralisingName != false;
    }

    public Boolean getPluralisingName() {
        return this.pluralisingName;
    }

    public void setPluralisingName(Boolean pluralisingName) {
        this.pluralisingName = pluralisingName;
    }

    public void setNameFormat(String nameFormat) {
        this.nameFormat = nameFormat;
    }

    protected AbstractGraphQLOptions() {
    }

    protected AbstractGraphQLOptions(Boolean pluralisingName, String nameFormat) {
        this.pluralisingName = pluralisingName;
        this.nameFormat = nameFormat;
    }

    private String getNameFormat() {
        return this.nameFormat;
    }
}

