/*
 * Decompiled with CFR 0.152.
 */
package org.brapi.schematools.core.graphql.options;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;
import org.brapi.schematools.core.graphql.options.AbstractGraphQLOptions;
import org.brapi.schematools.core.graphql.options.InputOptions;
import org.brapi.schematools.core.graphql.options.MutationTypeOptions;
import org.brapi.schematools.core.graphql.options.PropertiesOptions;
import org.brapi.schematools.core.graphql.options.QueryTypeOptions;
import org.brapi.schematools.core.model.BrAPIClass;
import org.brapi.schematools.core.model.BrAPIType;
import org.brapi.schematools.core.options.AbstractGeneratorOptions;
import org.brapi.schematools.core.utils.ConfigurationUtils;
import org.brapi.schematools.core.validiation.Validation;

public class GraphQLGeneratorOptions
extends AbstractGeneratorOptions {
    private InputOptions input;
    private QueryTypeOptions queryType;
    private MutationTypeOptions mutationType;
    private PropertiesOptions properties;
    private Boolean mergeOneOfType;
    private Map<String, Boolean> mergingOneOfTypeFor = new HashMap<String, Boolean>();

    public static GraphQLGeneratorOptions load() {
        try {
            return ConfigurationUtils.load("graphql-options.yaml", GraphQLGeneratorOptions.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static GraphQLGeneratorOptions load(Path optionsFile) throws IOException {
        return GraphQLGeneratorOptions.load().override(ConfigurationUtils.load(optionsFile, GraphQLGeneratorOptions.class));
    }

    public static GraphQLGeneratorOptions load(InputStream inputStream) throws IOException {
        return GraphQLGeneratorOptions.load().override(ConfigurationUtils.load(inputStream, GraphQLGeneratorOptions.class));
    }

    @Override
    public Validation validate() {
        return super.validate().assertNotNull(this.input, "Input Options are null", new Object[0]).assertNotNull(this.queryType, "Query Options are null", new Object[0]).assertNotNull(this.mutationType, "Mutation Options are null", new Object[0]).assertNotNull(this.properties, "Properties Options are null", new Object[0]).assertNotNull(this.mergeOneOfType, "'mergeOneOfType' option on %s is null", this.getClass().getSimpleName()).merge(this.input).merge(this.queryType).merge(this.mutationType).merge(this.properties);
    }

    public GraphQLGeneratorOptions override(GraphQLGeneratorOptions overrideOptions) {
        super.override(overrideOptions);
        if (overrideOptions.input != null) {
            this.input.override(overrideOptions.input);
        }
        if (overrideOptions.queryType != null) {
            this.queryType.override(overrideOptions.queryType);
        }
        if (overrideOptions.mutationType != null) {
            this.mutationType.override(overrideOptions.mutationType);
        }
        if (overrideOptions.properties != null) {
            this.properties.override(overrideOptions.properties);
        }
        if (overrideOptions.mergeOneOfType != null) {
            this.setMergeOneOfType(overrideOptions.mergeOneOfType);
        }
        this.mergingOneOfTypeFor.putAll(overrideOptions.mergingOneOfTypeFor);
        return this;
    }

    @JsonIgnore
    public boolean isGeneratingQueryType() {
        return this.isGeneratingSingleQueries() || this.isGeneratingListQueries() || this.isGeneratingSearchQueries();
    }

    @JsonIgnore
    public boolean isGeneratingSingleQueries() {
        return this.queryType.getSingleQuery().isGenerating();
    }

    @JsonIgnore
    public boolean isGeneratingSingleQueryFor(String name) {
        return this.queryType.getSingleQuery().isGeneratingFor(name);
    }

    @JsonIgnore
    public boolean isGeneratingListQueries() {
        return this.queryType.getListQuery().isGenerating();
    }

    @JsonIgnore
    public boolean isGeneratingListQueryFor(String name) {
        return this.queryType.getListQuery().isGeneratingFor(name);
    }

    @JsonIgnore
    public boolean isGeneratingSearchQueries() {
        return this.queryType.getSearchQuery().isGenerating();
    }

    @JsonIgnore
    public boolean isGeneratingSearchQueryFor(String name) {
        return this.queryType.getSearchQuery().isGeneratingFor(name);
    }

    @JsonIgnore
    public boolean isGeneratingMutationType() {
        return this.isGeneratingCreateMutation() || this.isGeneratingUpdateMutation() || this.isGeneratingDeleteMutation();
    }

    @JsonIgnore
    public boolean isGeneratingCreateMutation() {
        return this.mutationType.getCreateMutation().isGenerating();
    }

    @JsonIgnore
    public boolean isGeneratingCreateMutationFor(String name) {
        return this.mutationType.getCreateMutation().isGeneratingFor(name);
    }

    @JsonIgnore
    public boolean isGeneratingUpdateMutation() {
        return this.mutationType.getUpdateMutation() != null && this.mutationType.getUpdateMutation().isGenerating();
    }

    @JsonIgnore
    public boolean isGeneratingUpdateMutationFor(String name) {
        return this.mutationType.getUpdateMutation().isGeneratingFor(name);
    }

    @JsonIgnore
    public boolean isGeneratingDeleteMutation() {
        return this.mutationType.getDeleteMutation() != null && this.mutationType.getDeleteMutation().isGenerating();
    }

    @JsonIgnore
    public boolean isGeneratingDeleteMutationFor(String name) {
        return this.mutationType.getUpdateMutation().isGeneratingFor(name);
    }

    @JsonIgnore
    public boolean isUsingIDType() {
        return this.properties.getIds().isUsingIDType();
    }

    @JsonIgnore
    public final String getQueryInputParameterNameFor(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.input.getNameFor(this.getListQueryNameFor(name));
    }

    @JsonIgnore
    public final String getQueryInputParameterNameFor(@NonNull BrAPIType type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return this.getQueryInputParameterNameFor(type.getName());
    }

    @JsonIgnore
    public final String getQueryInputTypeNameFor(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.input.getTypeNameForQuery(this.getListQueryNameFor(name));
    }

    @JsonIgnore
    public final String getQueryInputTypeNameFor(@NonNull BrAPIType type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return this.getQueryInputTypeNameFor(type.getName());
    }

    public String getSingleQueryNameFor(String name) {
        return this.getNameFor(this.queryType.getSingleQuery(), name);
    }

    public String getListQueryNameFor(String name) {
        return this.getNameFor(this.queryType.getListQuery(), name);
    }

    public String getSearchQueryNameFor(String name) {
        return this.getNameFor(this.queryType.getSearchQuery(), name);
    }

    public String getCreateMutationNameFor(String name) {
        return this.getNameFor(this.mutationType.getCreateMutation(), name);
    }

    public String getUpdateMutationNameFor(String name) {
        return this.getNameFor(this.mutationType.getUpdateMutation(), name);
    }

    public String getDeleteMutationNameFor(String name) {
        return this.getNameFor(this.mutationType.getDeleteMutation(), name);
    }

    private String getNameFor(AbstractGraphQLOptions options, String name) {
        String newName = options.isPluralisingName() ? this.getPluralFor(name) : name;
        return options.getNameFor(newName);
    }

    public boolean isMergingOneOfType(BrAPIClass type) {
        return this.mergingOneOfTypeFor.getOrDefault(type.getName(), this.mergeOneOfType);
    }

    @JsonIgnore
    public final GraphQLGeneratorOptions setMergeOneOfType(String name, boolean isMergingOneOfType) {
        this.mergingOneOfTypeFor.put(name, isMergingOneOfType);
        return this;
    }

    public InputOptions getInput() {
        return this.input;
    }

    public QueryTypeOptions getQueryType() {
        return this.queryType;
    }

    public MutationTypeOptions getMutationType() {
        return this.mutationType;
    }

    public PropertiesOptions getProperties() {
        return this.properties;
    }

    public Boolean getMergeOneOfType() {
        return this.mergeOneOfType;
    }

    private GraphQLGeneratorOptions setInput(InputOptions input) {
        this.input = input;
        return this;
    }

    private GraphQLGeneratorOptions setQueryType(QueryTypeOptions queryType) {
        this.queryType = queryType;
        return this;
    }

    private GraphQLGeneratorOptions setMutationType(MutationTypeOptions mutationType) {
        this.mutationType = mutationType;
        return this;
    }

    private GraphQLGeneratorOptions setProperties(PropertiesOptions properties) {
        this.properties = properties;
        return this;
    }

    private GraphQLGeneratorOptions setMergeOneOfType(Boolean mergeOneOfType) {
        this.mergeOneOfType = mergeOneOfType;
        return this;
    }

    private GraphQLGeneratorOptions() {
    }

    private GraphQLGeneratorOptions(InputOptions input, QueryTypeOptions queryType, MutationTypeOptions mutationType, PropertiesOptions properties, Boolean mergeOneOfType, Map<String, Boolean> mergingOneOfTypeFor) {
        this.input = input;
        this.queryType = queryType;
        this.mutationType = mutationType;
        this.properties = properties;
        this.mergeOneOfType = mergeOneOfType;
        this.mergingOneOfTypeFor = mergingOneOfTypeFor;
    }

    private GraphQLGeneratorOptions setMergingOneOfTypeFor(Map<String, Boolean> mergingOneOfTypeFor) {
        this.mergingOneOfTypeFor = mergingOneOfTypeFor;
        return this;
    }
}

