/*
 * Decompiled with CFR 0.152.
 */
package org.brapi.schematools.core.graphql.options;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;
import org.brapi.schematools.core.model.BrAPIObjectProperty;
import org.brapi.schematools.core.model.BrAPIType;
import org.brapi.schematools.core.options.Options;
import org.brapi.schematools.core.utils.StringUtils;
import org.brapi.schematools.core.validiation.Validation;

public class IdsOptions
implements Options {
    private String nameFormat;
    private Boolean useIDType;
    private Map<String, String> fieldFor = new HashMap<String, String>();

    @Override
    public Validation validate() {
        return Validation.valid().assertNotNull(this.nameFormat, "'analyse' option on %s is null", this.getClass().getSimpleName()).assertNotNull(this.useIDType, "'useIDType' option on %s is null", this.getClass().getSimpleName()).assertNotNull(this.fieldFor, "'fieldFor' option on %s is null", this.getClass().getSimpleName());
    }

    public void override(IdsOptions overrideOptions) {
        if (overrideOptions.nameFormat != null) {
            this.setNameFormat(overrideOptions.nameFormat);
        }
        if (overrideOptions.useIDType != null) {
            this.setUseIDType(overrideOptions.useIDType);
        }
        this.fieldFor.putAll(overrideOptions.fieldFor);
    }

    public boolean isUsingIDType() {
        return this.useIDType;
    }

    @JsonIgnore
    public final String getNameFor(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return String.format(this.nameFormat, StringUtils.toParameterCase(name));
    }

    @JsonIgnore
    public final String getNameFor(@NonNull BrAPIType type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return this.getNameFor(type.getName());
    }

    @JsonIgnore
    public String getIDFieldFor(String name) {
        return this.fieldFor.getOrDefault(name, String.format(this.nameFormat, StringUtils.toParameterCase(name)));
    }

    @JsonIgnore
    public String getIDFieldFor(@NonNull BrAPIType type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return this.getIDFieldFor(type.getName());
    }

    @JsonIgnore
    public IdsOptions setIDFieldFor(String name, String idField) {
        this.fieldFor.put(name, idField);
        return this;
    }

    public String getIdFieldFor(BrAPIObjectProperty property) {
        return String.format("%sDbId", StringUtils.toSingular(property.getName()));
    }

    public String getIdsFieldFor(BrAPIObjectProperty property) {
        return String.format("%sDbIds", StringUtils.toSingular(property.getName()));
    }

    public Boolean getUseIDType() {
        return this.useIDType;
    }

    public void setNameFormat(String nameFormat) {
        this.nameFormat = nameFormat;
    }

    public void setUseIDType(Boolean useIDType) {
        this.useIDType = useIDType;
    }

    private IdsOptions() {
    }

    private IdsOptions(String nameFormat, Boolean useIDType, Map<String, String> fieldFor) {
        this.nameFormat = nameFormat;
        this.useIDType = useIDType;
        this.fieldFor = fieldFor;
    }

    private String getNameFormat() {
        return this.nameFormat;
    }

    private void setFieldFor(Map<String, String> fieldFor) {
        this.fieldFor = fieldFor;
    }
}

